import { GLShader } from "../../glCore";

//着色器变量统一驼峰
const skyboxVert = [
    "attribute vec3 aPosition;",//顶点位置信息
    "attribute vec3 aColor;",//顶点颜色数据
    "attribute vec2 aTextureCoord;",//纹理坐标，
    // "attribute vec2 aNormal;",//纹理坐标，

    "uniform mat4 uViewMatrix;",//视图矩阵，camera的worldMatrixInverse  //外部传入的12，13，14分量置0
    "uniform mat4 uProjectionMatrix;",//投影矩阵，camera的projectionMatrix
    "uniform mat4 uModelMatrix;",//模型矩阵
    // "uniform mat4 uNormalMatrix;",//

    "varying vec3 vColor;",//只有颜色数据需要传，或者考虑是否放材质里
    "varying vec2 vTextureCoord;",//传到着色器的纹理坐标

    "void main() {",
    "gl_Position = uProjectionMatrix * uViewMatrix * uModelMatrix *vec4(aPosition,1.0);",
    "gl_Position.z = 1.0;",//深度值最大
    "vColor = aColor;",
    "vTextureCoord = aTextureCoord;",
    "}"
].join("\n")


const skyboxFrag = [
    "precision mediump float;",//片元得加精度

    'uniform sampler2D uMap;',//纹理
    "uniform vec3 uMatColor;", //材质上的颜色，以后区分发散颜色等等
    "uniform float uMatAlpha;", //材质上的透明度


    "varying vec3 vColor;",//考虑颜色谁传
    "varying vec2 vTextureCoord;",

    "void main() {",
    //计算纹理颜色
    "vec4 mapColor = texture2D(uMap, vTextureCoord);",
    //计算顶点颜色
    "vec4 color = mapColor *vec4(vColor,1.0);",//叠加顶点颜色和纹理颜色
    //计算材质颜色
    "vec4 matColor = vec4( uMatColor, uMatAlpha );",
    //总颜色
    "color *=matColor;",

    "gl_FragColor = color;",
    "}"
].join("\n")


/**
 * 着色器程序根据渲染器的uid和着色器的字符或者自己的id缓存，
 * 以后按照材质参数拼着色器
 * 纯色的，不带光照的，带贴图的着色器，
 */
export class SkyboxShader extends GLShader {
    /**
     * 作为该着色器的标识
     */
    _glShaderKey: string;
    constructor(gl: WebGLRenderingContext) {
        super(gl, skyboxVert, skyboxFrag)
        this._glShaderKey = "SkyboxShader";
    }
}