import { loadArrayBuffer, loadImage } from "../2d/loader";
import { ArrayBufferToBase64, decodeText } from "../2d/utils";
import { createTexturesByAtlas } from "./loadAtlas";
import { BaseTexture } from "../2d/texture";
import { ISkeletonData, Spine } from "./Spine";


/**
 * 加载spi文件，直接返回显示对象吧，数据不暴露了，spine有clone方法，用原数据生成，以后有需求单独加载数据再说
 * @param url 
 * @param onLoad 到底怎么返回，只返回数据吧，对象自己new，还是直接返回对象，其实数据没必要暴露，svga是因为解析不带任何显示对象，只能返回数据
 * @param onError 
 */
export function loadSpine(
    url: string,
    onLoad: (spineData: ISkeletonData) => void,
    onError?: (err: any) => void,
) {
    loadArrayBuffer(
        url,
        (res) => {
            try {
                parseSpineData(res, onLoad);
            } catch (e) {
                onError && onError(e);
            }
        },
        onError
    )
}
/**
 * 解析spi后缀文件加载的数据
 * @param binary spi后缀的二进制数据
 * @param onComplete 
 */
export function parseSpineData(
    binary: ArrayBuffer,
    onComplete: (spineData: ISkeletonData) => void
) {
    var headerView = new DataView(binary, 0, 12);
    var imgLen = headerView.getUint32(0, true),
        atlasLen = headerView.getUint32(4, true),
        jsonLen = headerView.getUint32(8, true)

    var base64String = `data:image/png;base64,${ArrayBufferToBase64(binary.slice(12, imgLen + 12))}`;
    var atlas = decodeText(new Uint8Array(binary, 12 + imgLen, atlasLen));
    var json = JSON.parse(decodeText(new Uint8Array(binary, 12 + imgLen + atlasLen, jsonLen)));

    loadImage(base64String, (image) => {
        json.textures = createTexturesByAtlas(BaseTexture.fromImage(image), atlas);
        onComplete && onComplete(json);
    })
}