
import { Geometry3D } from "..";
import { Sprite3dMaterial } from "../materials";
import { Mesh3D } from "../core/Mesh3D";
import { InterleavedData, InterleavedDataAttribute } from "../../2d/renderers/webgl/InterleavedDataAttribute";

//所有sprite公用一个几何
let geometrySpirte3D: Geometry3D;
export class Sprite3D extends Mesh3D {
    constructor(material: Sprite3dMaterial) {
        if (!geometrySpirte3D) {
            // var vertices = [
            //     - 0.5, - 0.5, 0,// 0, 0,
            //     0.5, - 0.5, 0,// 1, 0,
            //     0.5, 0.5, 0, //1, 1,
            //     - 0.5, 0.5, 0,// 0, 1
            // ];
            // var uvs = [
            //     0, 1,
            //     1, 1,
            //     1, 0,
            //     0, 0
            // ];
            const float32Array = new Float32Array( [//uv不一样，是因为纹理翻转问题，TODO
				- 0.5, - 0.5, 0, 0, 0,
				0.5, - 0.5, 0, 1, 0,
				0.5, 0.5, 0, 1, 1,
				- 0.5, 0.5, 0, 0, 1
			] );

			const interleavedData = new InterleavedData( float32Array, 5 );
            geometrySpirte3D = new Geometry3D();
            geometrySpirte3D.addAttribute( 'aPosition', new InterleavedDataAttribute( interleavedData, 3, 0, false ) );
			geometrySpirte3D.addAttribute( 'aTextureCoord', new InterleavedDataAttribute( interleavedData, 2, 3, false ) );
            geometrySpirte3D.index = [0, 1, 2, 0, 2, 3];
        }
        super(geometrySpirte3D, material);
    }

 //TODO
	// raycast( raycaster, intersects ) {

	// 	if ( raycaster.camera === null ) {

	// 		console.error( 'THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.' );

	// 	}

	// 	_worldScale.setFromMatrixScale( this.matrixWorld );

	// 	_viewWorldMatrix.copy( raycaster.camera.matrixWorld );
	// 	this.modelViewMatrix.multiplyMatrices( raycaster.camera.matrixWorldInverse, this.matrixWorld );

	// 	_mvPosition.setFromMatrixPosition( this.modelViewMatrix );

	// 	if ( raycaster.camera.isPerspectiveCamera && this.material.sizeAttenuation === false ) {

	// 		_worldScale.multiplyScalar( - _mvPosition.z );

	// 	}

	// 	const rotation = this.material.rotation;
	// 	let sin, cos;

	// 	if ( rotation !== 0 ) {

	// 		cos = Math.cos( rotation );
	// 		sin = Math.sin( rotation );

	// 	}

	// 	const center = this.center;

	// 	transformVertex( _vA.set( - 0.5, - 0.5, 0 ), _mvPosition, center, _worldScale, sin, cos );
	// 	transformVertex( _vB.set( 0.5, - 0.5, 0 ), _mvPosition, center, _worldScale, sin, cos );
	// 	transformVertex( _vC.set( 0.5, 0.5, 0 ), _mvPosition, center, _worldScale, sin, cos );

	// 	_uvA.set( 0, 0 );
	// 	_uvB.set( 1, 0 );
	// 	_uvC.set( 1, 1 );

	// 	// check first triangle
	// 	let intersect = raycaster.ray.intersectTriangle( _vA, _vB, _vC, false, _intersectPoint );

	// 	if ( intersect === null ) {

	// 		// check second triangle
	// 		transformVertex( _vB.set( - 0.5, 0.5, 0 ), _mvPosition, center, _worldScale, sin, cos );
	// 		_uvB.set( 0, 1 );

	// 		intersect = raycaster.ray.intersectTriangle( _vA, _vC, _vB, false, _intersectPoint );
	// 		if ( intersect === null ) {

	// 			return;

	// 		}

	// 	}

	// 	const distance = raycaster.ray.origin.distanceTo( _intersectPoint );

	// 	if ( distance < raycaster.near || distance > raycaster.far ) return;

	// 	intersects.push( {

	// 		distance: distance,
	// 		point: _intersectPoint.clone(),
	// 		uv: Triangle.getUV( _intersectPoint, _vA, _vB, _vC, _uvA, _uvB, _uvC, new Vector2() ),
	// 		face: null,
	// 		object: this

	// 	} );

	// }

}