import { Dict } from "../../../utils";
import { defaultValue } from "./defaultValue";
import { mapType } from "./mapType";
import { UniformType } from "./UniformType";

//为了给uniform赋值用的属性
export interface IGlShaderUniformData {
	//float,vec2,mat4等等，用于set函数的标记获取
	type: UniformType,
	size?: number,
	location?: number,
	value: any
}
/**
 * 获取uniforms
 * @param gl 
 * @param program 
 * @param removeBracketUnifroms 需要移除中括号的uniform，比如["morphTargetInfluences","uBoneMatrices","uSamplers"]
 * @returns 
 */
export function extractUniforms(gl: WebGLRenderingContext, program: WebGLProgram, removeBracketUnifroms?: string[]): Dict<IGlShaderUniformData> {
	var uniforms = {};

	var totalUniforms = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);

	for (var i = 0; i < totalUniforms; i++) {//morphTargetInfluences
		var uniformData: WebGLActiveInfo = gl.getActiveUniform(program, i);

		var name = uniformData.name;
		//初略判断,
		if (removeBracketUnifroms && removeBracketUnifroms.length) {
			for (let j = 0; j < removeBracketUnifroms.length; j++) {
				//name在列表内，去掉中括号
				if (name.indexOf(removeBracketUnifroms[j]) == 0) {
					name = name.replace(/\[.*?\]/, "");
					break;
				}
			}
		}
		var type = mapType(gl, uniformData.type);
		// console.log(name)
		uniforms[name] = {
			type: type,
			size: uniformData.size,
			location: gl.getUniformLocation(program, name),
			value: defaultValue(type, uniformData.size)
		};
	}

	return uniforms;
};