
import { mapType } from './mapType';
import { mapSize } from './mapSize';
import { Dict } from '../../../utils';


export interface IShaderAttribute {
    //float,vec2,mat4等等，暂时好像没怎么用到
    type: string,
    size: number,
    location: number,
}
/**
 * 获取attributes属性
 * @param gl 
 * @param program 
 * @return attributes
 */
export function extractAttributes(gl: WebGLRenderingContext, program: WebGLProgram):Dict<IShaderAttribute> {
    var attributes = {};

    //所有激活的ATTRIBUTES
    var totalAttributes = gl.getProgramParameter(program, gl.ACTIVE_ATTRIBUTES);

    for (var i = 0; i < totalAttributes; i++) {
        var attribData = gl.getActiveAttrib(program, i);
        var type = mapType(gl, attribData.type);

        attributes[attribData.name] = {
            type: type,
            size: mapSize(type),
            location: gl.getAttribLocation(program, attribData.name),
        };
    }

    return attributes;
};
