//外部可以使用的uniform类型
export enum UniformType {
    /**
     * 对应value，number
     */
    float = "float",
    /**
     * 纹理对象
     * 对应value，Texture
     */
    texture = "sampler2D",
    /**
     * v2对象
     * 对应value，Vector2｜[number,number]
     */
    vector2 = "vec2",
    /**
     * v3对象
     * 对应value，Vector3｜[number,number,number]
     */
    vector3 = "vec3",
    /**
     * v4对象
     * 对应value，Vector4｜[number,number,number,number]
     */
    vector4 = "vec4",
    /**
     * m4对象
     * 对应value，Matrix4｜number[]
     */
    matrix4 = "mat4",
    /**
     * m3对象
     * 对应value，Matrix｜number[]
     */
    matrix3 = "mat3",
    /**
     * 给十六进制吧，这种只可能手动加的uniform
     * color不会是着色器解析出来的，都是自己加的
     * 对应value，number|string|array<number>
     */
    color = "color",
    /**
     * 其他类型，不转换，直接赋值
     * any不会是着色器解析出来的，都是自己加的
     */
    any = "any"
}
/**
 * 自行设定的uniform数据，用于同步真正的uniform
 */
export interface IShaderUniformData {
    type: UniformType,
    value: any
}