


/**
 * 创建webgl上下文
 * @param {HTMLCanvasElement}canvas 
 * @param options 参考文档https://developer.mozilla.org/en/docs/Web/API/HTMLCanvasElement/getContext
 * @return {WebGLRenderingContext} 
 */
export function createWebglContext(canvas: HTMLCanvasElement, options?: any): WebGLRenderingContext {
    //兼容下
    var gl = (canvas.getContext('webgl', options) ||
        canvas.getContext('experimental-webgl', options)) as WebGLRenderingContext;
    return gl;
};