import { DisplayObject } from "../../display/DisplayObject";
import { WebglRenderer } from "../WebglRenderer";

/**
 * 所有webgl渲染插件都继承这个
 */
export default class ObjectRenderer {
    constructor(protected renderer: WebglRenderer) {
        //监听
        this.renderer.addEventListener('onContextChange', this.onContextChange, this);
    }
    onContextChange() {
        // do some codes init!
    }
    /**
     * Starts the renderer and sets the shader
     *
     */
    start() {
        // set the shader..
    }

    /**
     * Stops the renderer
     *
     */
    stop() {
        this.flush();
    }

    /**
     * Stub method for rendering content and emptying the current batch.
     *
     */
    flush() {
        // flush!
    }

    /**
     * Renders an object
     *
     */
    render(object: any) {
        // render the object
    }
    /**
     * Generic destroy methods to be overridden by the subclass
     */
    destroy() {
        this.renderer.removeEventListener('onContextChange', this.onContextChange, this);
        this.renderer = null;
    }
}
