import Texture from "../texture/Texture";
import { Event } from "../events/Event";
import Sprite from "../display/Sprite";
import { Container } from "../display";

/**
 * 直接通过替换texture替换图片的动画帧
 * 暂时这些动画帧只播放一次，所以简化,要循环时再修改
 * 默认按时间间隔播放
 * 图片都以素材为中心为原点
 */
export class FrameAni extends Container {
    private showImage: Sprite
    /**
     * 所有的纹理
     */
    private texturesAll: Texture[];
    /**
     * 从0开始 锁步会跳帧
     * 每一帧就是一张图片，从0开始
     */
    // private _currentFrame: number;//暂时只有不锁步时才需要，但是已经注释，需要时加get方法

    private set currentFrame(value: number) {
        if (this.texturesAll[value]) {
            this.showImage.texture = this.texturesAll[value];
        } else {
            this.showImage.texture = null;
        }
    }
    /**
     * 不开放currentFrame的get方法，因为权限要一致的话set也要变public，
     * 但其实外部set赋值是无效的，用reset才有效，所以这里同步给一个方法
     * 返回0到totalFrames-1
     */
    getCurrentFrame(): number {
        return this.texturesAll.indexOf(this.showImage.texture)
    }
    /**
     * 所有帧数
     */
    get totalFrames(): number {
        return this.texturesAll.length
    };
    /**
     * 是否运行中
     */
    private isPlay: boolean;
    /**
     * 循环次数
     */
    private loop: number = 1;
    /**
     * 开始时间
     */
    private startTime: number
    /**
     * 所有时间,播完所用时间
     */
    private allTime: number
    /**
     * 播放完的回调
     */
    private callback: Function;
    /**
     * 每秒的帧数，默认30帧
     */
    private _frameRate: number;
    get frameRate() {
        return this._frameRate
    }
    set frameRate(value: number) {
        // if (value == this._frameRate) return//注释掉吧，否则frameRate修改相同，但是texturesAll变了就执行不到了
        this._frameRate = value;
        this.allTime = this.texturesAll.length / this._frameRate * 1000;
    }
    /**
     * 
     * @param texturesAll 所有的资源数组
     */
    constructor(texturesAll: Texture[]) {
        super()
        this.showImage = new Sprite();
        this.showImage.anchorTexture.set(0.5, 0.5);
        this.addChild(this.showImage);
        this.texturesAll = texturesAll;
        this.currentFrame = 0;
        this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this)
        this.frameRate = 30;
    }
    //需要做锁步
    private count = 0;
    private onEnterFrame() {
        if (!this.isPlay) {
            // this.count = 0
            return
        }
        // this.count++;
        // if (this.count % 2 == 0) {
        //     this.currentFrame++;
        //     if (this.currentFrame == this.totalFrames/*-1*/) {
        //         this.currentFrame = 0;
        //         this.isPlay = false
        //         this.callback && this.callback();
        //     }
        //     this.texture = RES.getRes(this.sourceAll[this.currentFrame])
        //     this.x = -this.texture.textureWidth / 2;
        //     this.y = -this.texture.textureHeight / 2;
        // }
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.loop--;
            if (this.loop == 0) {
                this.isPlay = false
                this.callback && this.callback();
            } else {
                this.startTime = Date.now()
                this.currentFrame = 0;
            }
        } else {
            this.currentFrame = (scale * this.texturesAll.length) >> 0;
        }
    }
    /**
     * 从0开始播放
     */
    play(loop: number = 1, callback?: Function) {
        this.startTime = Date.now();
        this.isPlay = true;
        this.currentFrame = 0;
        this.loop = loop;
        this.callback = callback;
    }
    /**
     * 重置为frame，不播放
     */
    reset(frame: number = 0) {
        this.isPlay = false;
        this.currentFrame = frame;
    }


    /**
     * 重置所有贴图，会置0停止，不设置播放，否则原先的play里的startTime及loop不好维护
     * @param texturesAll 
     */
    resetTexturesAll(texturesAll: Texture[]) {
        this.texturesAll = texturesAll;
        this.currentFrame = 0;
        this.frameRate = 30;
    }
}