import { RES } from "../../../module/RES";

//只是为了魔力鸟背后的
export class VerticalBgAni extends FYGE.Container {
    upArrow: FYGE.Sprite;
    downArrow: FYGE.Sprite;
    outSpeed: number = 0.25;
    inSpeed: number = 1;
    direction: boolean = true;
    count: number = 0;
    constructor() {
        super()
        //不交互
        this.mouseEnable = false;
        this.mouseChildren = false;

        var textureL: FYGE.Texture = RES.getRes("leftArrow.png")
        this.upArrow = new FYGE.Sprite(textureL);
        this.upArrow.rotation = 90;
        this.upArrow.x = textureL.height / 2;
        this.upArrow.y = -50;
        this.addChild(this.upArrow);

        var textureR: FYGE.Texture = RES.getRes("rightArrow.png")
        this.downArrow = new FYGE.Sprite(textureR);
        this.downArrow.rotation = 90;
        this.downArrow.x = textureR.height / 2;
        var oriY = 50 - textureR.width;
        this.downArrow.y = oriY;
        this.addChild(this.downArrow);


        this.addTweens()
    }
    /**
     * 重置
     */
    reset() {
        FYGE.Tween.removeTweens(this.upArrow);
        FYGE.Tween.removeTweens(this.downArrow);
        this.addTweens();
    }

    private addTweens() {
        FYGE.Tween.get(this.upArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700)
        FYGE.Tween.get(this.upArrow, { loop: true })
            .set({ y: -50 })
            .to({ y: -50 - 6 }, 1000)

        var textureR: FYGE.Texture = RES.getRes("rightArrow.png");
        var oriY = 50 - textureR.width;
        FYGE.Tween.get(this.downArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700)
        FYGE.Tween.get(this.downArrow, { loop: true })
            .set({ y: oriY })
            .to({ y: oriY + 6 }, 1000)
    }
}