import { RES } from "../../../module/RES";



export const doorBgImages = [
    "redDoorBg.png",
    "yellowDoorBg.png",
    "blueDoorBg.png",
]

export const doorImages = [
    "doorClosed.png",
    "doorOpen.png"
]


/**
 * 石门类
 * 在格子上
 * 加在map上，冰块下面
 * 
 */
export class Door extends FYGE.Container {
    /**
     * 颜色背景，切换texture，blueDoorBg,yellowDoorBg,redDoorBg
     */
    private bg: FYGE.Sprite;
    /**
     * 显示图，切换texture,  doorClosed,doorOpen
     */
    private showImage: FYGE.Sprite;
    /**
     * 是否要执行翻转
     */
    isActive: boolean;
    /**
     * 状态2 1 0 
     */
    private _statusNum: number;
    get statusNum() {
        return this._statusNum
    }
    set statusNum(value: number) {
        if (value >= 0 && value <= 2) {
            this._statusNum = value;
            //修改背景图片
            this.bg.texture = RES.getRes(doorBgImages[this._statusNum]);
        } else {
            this._statusNum = 2;
            //激活，要翻转
            this.isActive = true;
        }
    }
    private _closed: boolean
    get closed() {
        return this._closed
    }
    set closed(value) {
        this._closed = value;
        //showImage修改
        this.showImage.texture = RES.getRes(doorImages[value ? 0 : 1]);
    }
    constructor(closed: boolean = false) {
        super();
        //先用蓝色的吧，三张图尺寸得一致
        var textureBg: FYGE.Texture = RES.getRes(doorBgImages[0]);
        this.bg = new FYGE.Sprite(textureBg);
        this.bg.x = - textureBg.width / 2;
        this.bg.y = - textureBg.height / 2;
        this.addChild(this.bg);
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.bgAni, this)
        //先用开门的，
        var textureDoor: FYGE.Texture = RES.getRes(doorImages[1]);
        this.showImage = new FYGE.Sprite(textureDoor);
        this.showImage.x = - textureDoor.width / 2;
        this.showImage.y = - textureDoor.height / 2;
        this.addChild(this.showImage);
        //状态重置
        this.statusNum = 2;
        this.closed = closed;
    }
    /**
     * 貌似没有地方回收，预留吧
     * @param closed 
     */
    reset(closed: boolean = false) {
        this.statusNum = 2;
        this.closed = closed;
    }

    private bgDirection
    private bgAni() {
        if (!this.stage) return
        if (this.bgDirection) {
            this.bg.alpha += 0.05;
        } else {
            this.bg.alpha -= 0.05;
        }
        if (this.bg.alpha < 0) {
            this.bgDirection = true;
        }
        else if (this.bg.alpha > 1) {
            this.bgDirection = false;
        }
    }
}