import { Element } from "../class/Element";
import { doorBgImages, doorImages, Door } from "../class/Door";
import { ElementType } from "../enum/ElementType";
import { Lattice } from "../class/Lattice";
import { Ice } from "../class/Ice";
import { Tool } from "../Tool";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";



/**
 * 动画，基本思路是，clone一个元素（有的话），
 */
export class DoorChangeAni extends FYGE.Container {
    //颜色背景
    doorBg: FYGE.Sprite
    //门
    door: FYGE.Sprite;
    //冰块图片
    ice: FYGE.Sprite;
    //元素
    ele: Element;
    constructor(lat: Lattice) {
        super();
        var door: Door = lat.door;
        //应该不会出现door不存在的情况
        if (!door) { }
        //
        var textureBg: FYGE.Texture = RES.getRes(doorBgImages[door.statusNum]);
        this.doorBg = new FYGE.Sprite(textureBg);
        this.doorBg.x = - textureBg.width / 2;
        this.doorBg.y = - textureBg.height / 2;
        this.addChild(this.doorBg);
        //
        var textureDoor: FYGE.Texture = RES.getRes(doorImages[door.closed ? 0 : 1]);
        this.door = new FYGE.Sprite(textureDoor);
        this.door.x = - textureDoor.width / 2;
        this.door.y = - textureDoor.height / 2;
        this.addChild(this.door);
        //加冰
        this.addIce(lat.ice)
        //加元素
        this.addEle(lat.element)

    }

    reset(lat: Lattice) {
        this.resetDoor(lat.door);
        this.addIce(lat.ice);
        this.addEle(lat.element);

    }

    //动画
    play(lat: Lattice, callback: Function) {
        //最终状态
        let isClosed = lat.door.closed;
        this.reset(lat);
        var p = Tool.getPositionByIndex(lat.index)
        //位置
        this.x = p[0];
        this.y = p[1];
        if (this.ice) this.ice.visible = isClosed ? false : true;
        if (this.ele) this.ele.visible = isClosed ? false : true;
        FYGE.Tween.get(this)
            .to({ scaleX: 0 }, 300)
            .call(() => {
                //修改门图
                this.door.texture = RES.getRes(doorImages[isClosed ? 1 : 0]);
                //元素透明度修改
                if (this.ice) this.ice.visible = isClosed ? true : false;
                if (this.ele) this.ele.visible = isClosed ? true : false;
                FYGE.Tween.get(this)
                    .to({ scaleX: 1 }, 300)
                    .call(() => {
                        callback();
                        if (this.parent) {
                            this.parent.removeChild(this)
                        };
                        Pool.recover(RecoverName.DOORCHANGE_ANI, this)
                    })
            })
    }

    private resetDoor(door: Door) {
        this.doorBg.texture = RES.getRes(doorBgImages[door.statusNum]);
        this.door.texture = RES.getRes(doorImages[door.closed ? 0 : 1]);
    }

    private addIce(ice: Ice) {
        if (ice) {
            //原先没有就加上
            if (!this.ice) {
                var textureIce: FYGE.Texture = RES.getRes("ele" + ElementType.ICE + ".png");
                this.ice = new FYGE.Sprite(textureIce);
                this.ice.x = - textureIce.width / 2;
                this.ice.y = -textureIce.height / 2;
                this.addChildAt(this.ice, 2);
            }
            this.ice.alpha = ice.countNum == 2 ? 1 : 0.6
        }
        //ice没有，原先有去掉
        else if (this.ice) {
            this.removeChild(this.ice)
            this.ice = null;
        }
    }

    private addEle(ele: Element) {
        if (ele) {
            //原先没加过，要新建
            if (!this.ele) {
                this.ele = Tool.getElement(ele.type)
                //从pool取得位置都有问题
                this.ele.x = 0;
                this.ele.y = 0;
                this.addChild(this.ele);
            }
            this.ele.copy(ele)
        }
        else if (this.ele) {
            this.removeChild(this.ele)
            Pool.recover(RecoverName.ELEMENT, this.ele)
            this.ele = null;
        }
    }
}