
import { RecoverName } from "../enum/RecoverName";
import { Pool } from "../Pool";
import { Element } from "../class/Element";
import { Ice } from "../class/Ice";
import { ElementType } from "../enum/ElementType";
import { Tool } from "../Tool";
import { BitmapRecycle } from "../class/BitmapRecycle";
import { RES } from "../../../module/RES";
import { PlayScene } from "../../scene/PlayScene";

/**
 * 孵蛋的动效
 */
export function HatchAni(startIndex: number, endIndexs: number[], thisObj: PlayScene, callback: Function) {
    let countAll = endIndexs.length;
    let count = 0;
    var startP = Tool.getPositionByIndex(startIndex);
    for (let i = 0; i < endIndexs.length; i++) {
        let endIndex = endIndexs[i];
        let endP = Tool.getPositionByIndex(endIndex);
        var texture: FYGE.Texture = RES.getRes("ele" + ElementType.CHICKEN + ".png");
        let eleC: BitmapRecycle = Pool.takeOut(RecoverName.BITMAPRECYCLE);
        if (!eleC) {
            eleC = new BitmapRecycle(texture);
        } else {
            eleC.reset(texture);
        }
        eleC.x = startP[0];
        eleC.y = startP[1];

        eleC.scaleX = eleC.scaleY = 0.7;
        thisObj.addChild(eleC);
        paraCurveAni(eleC, startP, endP, () => {
            //回收
            thisObj.removeChild(eleC);
            Pool.recover(RecoverName.BITMAPRECYCLE, eleC);
            //对应的索引的类型变成鸡，抛物线动画时间都一致，其实可以在统一回调里执行数据更新，这里的数据更新迟早改掉
            thisObj.lattices[endIndex].element.reset(ElementType.CHICKEN);
            //动画，和bonusTime的效果一样，暂时没加

            if (++count == countAll) callback();
        })
    }
}


const deltaTime = 500;
const gravity = 0.003
/**
 * 抛物线路径
 * @param startP 
 * @param endP 
 * @param callback 
 */
function paraCurveAni(ele: BitmapRecycle, startP: number[], endP: number[], callback: Function) {
    //x方向匀速，线性
    var deltaX = endP[0] - startP[0]
    //y方向，自由落体，y向下为正，加速度向下为正，初速度根据情况而定
    var deltaY = endP[1] - startP[1];
    var vy0 = deltaY / deltaTime - gravity * deltaTime / 2;
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            ele.x = deltaX * a.t / deltaTime + startP[0];
            ele.y = vy0 * a.t + gravity * a.t * a.t / 2 + startP[1];

        }
    })
        .to({ t: deltaTime }, deltaTime)
        .call(() => {
            callback();
        })
    var rotation;
    if (deltaX > 0) {
        rotation = 360;
    }
    else if (deltaX < 0) {
        rotation = -360;
    } else {
        rotation = 0
    }

    //旋转
    FYGE.Tween.get(ele)
        .set({ scaleX: 0.3, scaleY: 0.3, rotation: 0 })
        .to({ scaleX: 1, scaleY: 1, rotation: rotation }, deltaTime)


}