import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { Tool } from "../Tool";
import { RES } from "../../../module/RES";


const offsetX = 80 / 2;
const offsetY = 80 / 2;

/**
 * 分裂的动画，待写
 * 71*62
 */
export class HairballBrownDivideAni extends FYGE.Container {
    startHairball: Hairball;
    endHairball: Hairball;
    constructor() {
        super()
        //起点处的
        this.startHairball = new Hairball();
        this.startHairball.brownFace.visible = false;
        this.startHairball.x = -offsetX;
        this.startHairball.y = -offsetY;
        this.addChild(this.startHairball);
        //移动的
        this.endHairball = new Hairball();
        this.endHairball.x = -offsetX;
        this.endHairball.y = -offsetY;
        this.addChild(this.endHairball);
    }
    reset() {
        this.startHairball.eyesDown.scaleY = 1.5;
        this.startHairball.visible = false;
        this.endHairball.x = -offsetX;
        this.endHairball.y = -offsetY;
        this.endHairball.brownFace.visible = true;
        this.endHairball.greyFace.alpha = 0;
    }
    play(startP: number[], endP: number[], callback: Function) {
        this.reset();
        var oriEyeX = 23;
        var oriEyeY = 33;
        //判断上下左右，
        var obj = { x: -offsetX, y: -offsetY };//整体的位置跳动
        var eyeObj = { x: oriEyeX, y: oriEyeY };//眼睛的移动
        //一个位置不能移动，都相等
        if (Math.abs(endP[0] - startP[0]) <= 0.001 && Math.abs(endP[1] - startP[1]) <= 0.001) {

        }
        //x相等 上下
        else if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            //下
            if (endP[1] - startP[1] > 0) {
                obj.y += Tool.height;
                eyeObj.y += 4;
            }
            //上
            else {
                obj.y -= Tool.height;
                eyeObj.y -= 4;
            }
        }
        //y相等 左右
        else {
            //左
            if (endP[0] - startP[0] > 0) {
                obj.x += Tool.width;
                eyeObj.x += 4;
            }
            //右
            else {
                obj.x -= Tool.width;
                eyeObj.x -= 4;
            }
        }

        //自己的
        this.x = startP[0];
        this.y = startP[1];


        //整体的移动
        let tweenPosAll = FYGE.Tween.get(this.endHairball);
        for (var i = 0; i < 5; i++) {
            tweenPosAll.to({ x: -offsetX - 1 }, 20)
                .to({ x: -offsetX + 2 }, 20)
                .to({ x: -offsetX }, 20)
        }
        tweenPosAll.call(() => {
            this.startHairball.visible = true;
        })
        tweenPosAll.to(obj, 200)


        //褐色变灰色,灰色透明度到1
        FYGE.Tween.get(this.endHairball.greyFace)
            .wait(100)
            .to({ alpha: 1 }, 100)
            .call(() => {
                this.endHairball.brownFace.visible = false;
            })

        //endHairball的眼白
        FYGE.Tween.get(this.endHairball.eyesDown)
            .wait(50)
            .to({ scaleY: 1.5 }, 50)
            .wait(420)
            .to({ scaleY: 1 }, 30)
        //startHairball的眼白
        FYGE.Tween.get(this.startHairball.eyesDown)
            .wait(520)
            .to({ scaleY: 1 }, 30)

        //endHairball的眼珠的移动
        FYGE.Tween.get(this.endHairball.eyes)
            .wait(200)
            .to(eyeObj, 30)
            .wait(290)
            .to({ x: oriEyeX, y: oriEyeY }, 30)
            .call(() => {
                //回收元素
                if (this.parent) this.parent.removeChild(this);
                Pool.recover(RecoverName.HAIRBALLBROWNDIVIDE_ANI, this)
                //回调
                callback();
            })
    }
}

/**
 * 整个球
 */
class Hairball extends FYGE.Container {
    brownFace: FYGE.Sprite;
    greyFace: FYGE.Sprite;
    eyesDown: EyesDown;
    eyes: Eyes;
    constructor() {
        super();
        this.brownFace = new FYGE.Sprite(RES.getRes("brownBallFace.png"));
        this.addChild(this.brownFace);
        this.greyFace = new FYGE.Sprite(RES.getRes("greyBallFace.png"));
        this.addChild(this.greyFace);
        this.eyesDown = new EyesDown();
        this.eyesDown.x = 16;
        this.eyesDown.y = 29 + 29 / 2;
        this.addChild(this.eyesDown);
        this.eyes = new Eyes();
        this.eyes.x = 23;
        this.eyes.y = 33;
        this.addChild(this.eyes);

    }
}

/**
 * 眼睛的,整体位置10.99，24.66
 */
class Eyes extends FYGE.Container {
    left: FYGE.Sprite;
    right: FYGE.Sprite;
    constructor() {
        super();
        var texture: FYGE.Texture = RES.getRes("eyeSingle.png")
        this.left = new FYGE.Sprite(texture);
        this.addChild(this.left);
        this.right = new FYGE.Sprite(texture);
        this.right.x = 23;
        this.addChild(this.right)
    }
}

/**
 * 整体位置是10，32.66
 */
class EyesDown extends FYGE.Container {
    left: FYGE.Sprite;
    right: FYGE.Sprite;
    constructor() {
        super();
        this.left = new FYGE.Sprite(RES.getRes("eyeDownLeft.png"));
        this.left.y = -29 / 2;
        this.addChild(this.left);
        this.right = new FYGE.Sprite(RES.getRes("eyeDownRight.png"));
        this.right.x = 45 - 16;
        this.right.y = -29 / 2;
        this.addChild(this.right)
    }
}

