import Container = FYGE.Container;
import Button = FYGE.Button;
import TextField = FYGE.TextField;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";
import MouseEvent = FYGE.MouseEvent;
import { showPanel, changeScene, showToast } from "../../../module/ctrls";
import { RulePanel } from "../../panels/RulePanel";
import { BuyPowerPanel } from "../../panels/BuyPowerPanel";
import { TaskPanel } from "../../panels/TaskPanel";
import { getTbData, sendTbNet, TbNetName } from "../../TaoBaoNet";
import Texture = FYGE.Texture;
import { LotteryScene } from "../LotteryScene";
import { GDispatcher } from "../../Main";
import { G_EVENT } from "../../common/G_EVENT";
import Tween = FYGE.Tween;

export default class MapUI extends Container {
    public energyBox: EnergyBox = null;
    public creditsBox: CreditsBox = null;
    private prizeBox: PrizeBox = null;

    private myPrizeBtn: Button = null;
    private ruleBtn: Button = null;
    private taskBtn: Button = null;

    constructor() {
        super();

        this.initUi();
        this.initEvent();

    }

    private initEvent() {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.prizeBox.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private removeEvent() {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.prizeBox.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private clickBtn(e) {
        switch (e.target) {
            case this.ruleBtn:
                console.log('规则');
                showPanel(RulePanel);
                break;
            case this.myPrizeBtn:
                console.log('我的奖品');
                sendTbNet(
                    TbNetName.navigateTo,
                    {url: '/pages/myPrize/myPrize'},
                    () => {
                    },
                    true
                );
                break;

            case this.prizeBox:
                /// TODO 奖励盒子，有条件的吧，放在类里了prizeBox
                console.log('奖励盒子');
                break;

            case this.taskBtn:
                console.log('任务');
                showPanel(TaskPanel);
                break;
        }
    }

    public destroy() {
        super.destroy();
        this.removeEvent();
    }

    private initUi() {
        // 我的奖品
        this.myPrizeBtn = this.addChild(new Button(RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(0, 185);
        this.myPrizeBtn.anchorX = 0;

        // 规则按钮
        this.ruleBtn = this.addChild(new Button(RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(0, 104);
        this.ruleBtn.anchorX = 0;

        // 任务按钮
        this.taskBtn = this.addChild(new Button(RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(19, 280);

        this.energyBox = this.addChild(new EnergyBox({}));
        this.creditsBox = this.addChild(new CreditsBox({}));
        this.prizeBox = this.addChild(new PrizeBox({}));
    }

    public updateUI() {
        this.creditsBox.updateCredits();
        this.energyBox.count = Tools.gameData.power;
    }
}

/**
 * 能量
 */
class EnergyBox extends Container {

    private addBtn: Button = null;
    private countLabel: TextField = null;

    private _count = 0;
    public set count(count: number) {
        this._count = count;
        this.countLabel.text = '' + count;
    }

    constructor(data) {
        super();

        this.initUi(data);

        this.addBtn.addEventListener(MouseEvent.CLICK, this.clickAdd, this);
    }

    private clickAdd() {
        console.log('增加按钮');
        showPanel(BuyPowerPanel);
    }

    private initUi(data) {
        this.position.set(544, 105);

        this.addChild(Tools.getSprite('map_energyBg.png'));
        this.addBtn = this.addChild(new Button(RES.getRes('map_energyAdd.png')));
        this.addBtn.position.set(135, 14);

        this.countLabel = this.addChild(Tools.getText(
            '0', 20, '#ffffff',
            TEXT_ALIGN.CENTER, 80, 54, 21
        ));

    }

    public destroy() {
        super.destroy();
        this.addBtn.removeEventListener(MouseEvent.CLICK, this.clickAdd, this);
    }
}

/**
 * 积分
 */
class CreditsBox extends Container {

    private countLabel: TextField = null;

    private _count = 0;
    public set count(count: number) {
        this._count = count;
        this.countLabel.text = `积分:${count}`;
    }

    constructor(data) {
        super();

        this.initUi(data);
    }

    private async initUi(data) {
        this.position.set(544, 184);

        this.addChild(Tools.getSprite('map_creditsBg.png'));

        this.countLabel = this.addChild(Tools.getText(
            '积分:0', 20, '#ffffff',
            TEXT_ALIGN.CENTER, 105, 58, 21
        ));

        await this.updateCredits();
        GDispatcher.addEventListener(G_EVENT.ON_SHOW, this.updateCredits, this);
    }

    public async updateCredits() {
        const creditsData = await sendTbNet(TbNetName.queryCredits, {}, () => {
        }, true);
        let jfLabel = '积分:0';
        if (creditsData.success && creditsData.data && creditsData.data.credits) {
            jfLabel = `积分:${creditsData.data.credits}`;
        }
        this.countLabel.text = jfLabel;
    }

    public destroy() {
        super.destroy();
        GDispatcher.removeEventListener(G_EVENT.ON_SHOW, this.updateCredits, this);
    }
}

/**
 * 连续闯关礼盒
 */
// @ts-ignore
class PrizeBox extends Button {

    private checkTip: TextField = null;
    private tip: TextField = null;

    private prizeImg: Sprite = null;

    public initButton() {
        let s: any = this;
        s.mouseChildren = false;
        s.addEventListener("onMouseDown", s._mouseEvent, s);
        s.addEventListener("onMouseUp", s._mouseEvent, s);
        s.addEventListener("onMouseOut", s._mouseEvent, s);
        s.texture = s.textureUp;
    }

    /**
     * @method  _mouseEvent
     * @param e
     * @private
     */
    protected _mouseEvent(e: any): void {
        let s = this;
        // @ts-ignore
        if (!s._clicked) {
            if (e.type == MouseEvent.MOUSE_DOWN) {
                //如果是点下
                // @ts-ignore
                if (s.textureDown) {
                    // @ts-ignore
                    s.texture = s.textureDown
                } else {
                    this["frames"] = null
                    // s.scale.x = s.scale.y = 0.9
                    Tween.removeTweens(this);
                    Tween.get(this).to({scaleX: 1, scaleY: 1}, 50);
                }
            } else {
                // @ts-ignore
                if (s.textureDown) {
                    // @ts-ignore
                    s.texture = s.textureUp
                } else {
                    this["frames"] = this["framesOri"]
                    // s.scale.x = s.scale.y = 1
                    Tween.removeTweens(this);
                    Tween.get(this).to({scaleX: 1.2, scaleY: 1.2}, 50);
                }
            }
        }
    };

    constructor(data) {
        super(RES.getRes('map_prizeBox.png'));
        this.initUi(data);
        this.initEvent();
    }

    private initUi(data) {
        this.position.set(553, 289);
        // this.position.set(503, 289);
        this.scale.set(1.2, 1.2);

        this.checkTip = this.addChild(Tools.getText(
            '再闯XXX关', 18,
            '#ffffff', TEXT_ALIGN.CENTER,
            158, 0, 68
        ));

        this.tip = this.addChild(Tools.getText(
            '参与红包抽奖\n赢XXX优惠券', 17,
            '#ec5a5a', TEXT_ALIGN.CENTER,
            158, 0, 116
        ));
        this.tip.lineSpacing = 0;

        this.prizeImg = this.addChild(Tools.getSprite('map_star_enable.png', 39, 150));
        // 490*180
        this.prizeImg.y -= 40;
        this.prizeImg.width = 204;
        this.prizeImg.height = 80;
        this.prizeImg.x = (this.width - 98) / 2 - 70;

        const prizes = Tools.gameData.prizes;
        if (prizes.length <= 0) {
            const curLevel: number = Tools.gameData.currentLevel;
            let upLevel: number = 120;
            let dLevel: number = 120;
            Tools.baseInfo.prizeLevels.forEach((value, index) => {
                const d: number = value - curLevel;
                if (curLevel <= value && d >= 0 && d <= dLevel) {
                    upLevel = value;
                    dLevel = d + 1;
                }
            });
            console.log(upLevel, dLevel);
            this.checkTip.text = `再闯${dLevel}关可抽`;
            // this.tip.text = '有机会获得';
            this.tip.text = '';
            this.prizeImg.texture = Texture.fromUrl(Tools.baseInfo.levelPrize[`level_${upLevel}`]);
            this.addEventListener(FYGE.MouseEvent.CLICK, () => {
                //有需要，到时再改
                Tools.btnDelay(this);
                showToast(`再闯${dLevel}关才可以抽奖哦`);
            }, this)
        } else if (prizes.length == 1 && +prizes[0].level == 120) {
            // this.checkTip.text = `等待开奖`;
            const index = getTbData(TbNetName.getIndex).data

            this.checkTip.text = index.topAward.openPrizeStatus
                ? '已开奖' : '8月31日9点开奖';
            this.checkTip.size = 18;
            // ? '已开奖' : '等待开奖';
            // this.tip.text = `8月31日10点`;
            this.tip.text = ``;

            this.prizeImg.texture = Texture.fromUrl(Tools.baseInfo.levelPrize['level_120']);
            this.addEventListener(FYGE.MouseEvent.CLICK, () => {
                //有需要，到时再改
                Tools.btnDelay(this);
                showToast(index.topAward.openPrizeStatus
                    ? '已开奖' : '8月31日9点开奖')
            }, this)
        } else {
            let lowerLevel = 120;
            prizes.forEach((value) => {
                if (value.level < lowerLevel) {
                    lowerLevel = value.level;
                }
            });
            this.checkTip.text = `点击抽奖`;
            // this.tip.text = `抽取${lowerLevel}关奖励`;
            this.tip.text = ``;
            this.prizeImg.texture = Texture.fromUrl(Tools.baseInfo.levelPrize[`level_${lowerLevel}`]);
            this.addEventListener(FYGE.MouseEvent.CLICK, () => {
                Tools.btnDelay(this);
                changeScene(LotteryScene, {level: lowerLevel})
            }, this)
        }
    }

    initEvent() {
    }
}
