import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;
import Sprite = FYGE.Sprite;
import { Tools } from "../../Tools";
import Tween = FYGE.Tween;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;

export default class MapMid extends MapPart {

    public static HEIGHT = 1635;

    protected totalCount = 10;

    private balloon: Sprite = null;
    private water: Sprite = null;
    private water1: Texture = null;
    private water2: Texture = null;
    private whaleAni: FrameAni = null;
    private owlAni: FrameAni = null;

    protected btnPos = [
        [267, 1519],
        [211, 1325],
        [338, 1154],
        [237, 911],
        [145, 755],
        [225, 591],
        [349, 480],
        [214, 342],
        [193, 188],
        [392, 8],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg2.jpg');

        // 流水
        this.water1 = RES.getRes('water1.png');
        this.water2 = RES.getRes('water2.png');

        this.initIcon();
        this.initEffect();
    }

    private initEffect() {
        // 热气球
        this.balloon = this.addChild(Tools.getSprite('map_狐狸气球.png', -216, 750));
        Tween.get(this.balloon, {loop: true})
            .set({x: -216, y: 1170})
            .to({x: 750 + 100, y: 765}, 20006);
        this.balloon.mouseEnable = this.balloon.mouseChildren = false;

        // 流水
        this.water = this.addChild(new Sprite(this.water1));
        this.water.position.set(544, 687);

        // 鲸鱼
        const whaleTextures: Texture[] = new Array(25);
        for (let i = 0; i < 13; i++) {
            whaleTextures[25 - i] = whaleTextures[i] = RES.getRes(`map_whale_${i}.png`);
        }
        this.whaleAni = this.addChild(new FrameAni(whaleTextures));
        this.whaleAni.position.set(645, 575);
        this.whaleAni.play(-1);

        // 猫头鹰
        const owlTextures: Texture[] = new Array(31);
        for (let i = 0; i < 16; i++) {
            owlTextures[31 - i] = owlTextures[i] = RES.getRes(`map_owl_${i}.png`);
        }

        this.owlAni = this.addChild(new FrameAni(owlTextures));
        this.owlAni.position.set(538, 1548);
        this.owlAni.play(-1);

    }

    private waterIndex1: boolean = true;
    private waterIndex: number = 0;

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);

        // 流水动画
        if (this.waterIndex++ > 6) {
            this.waterIndex1 = !this.waterIndex1;
            this.water.texture = this.waterIndex1 ? this.water1 : this.water2;
            this.waterIndex = 0;
        }

    }


    public destroy() {
        super.destroy();
    }

}
