import Button = FYGE.Button;
import { RES } from "../../../module/RES";
import Container = FYGE.Container;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import TextField = FYGE.TextField;
import { Tools } from "../../Tools";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import Point = FYGE.Point;
import FrameAni = FYGE.FrameAni;
import Tween = FYGE.Tween;
import { Panel } from "../../../module/views/Panel";
import { showPanel } from "../../../module/ctrls";
import { StartPanel } from "../../panels/StartPanel";
import { StartPanelPrize } from "../../panels/StartPanelPrize";

export enum CHECK_TYPE {
    COM,   // 普通
    CUR,    // 当前
}

export default class CheckBtn extends Container {

    public checkData: {
        level: number,
        scores: number,
        stars: number,
        isPrizeLevel: boolean,
        isVisitSuccess: boolean
        isPlayed: boolean,
    } = {
        level: 1,
        scores: 0,
        stars: 0,
        isPrizeLevel: false,
        isVisitSuccess: false,
        isPlayed: false,
    };

    private _sendAwardType: any;

    private btn: Button = null;
    private checkLabel: TextField = null;

    private star: CheckStar[] = null;

    private prizeAnim: FrameAni = null;
    private curAnim: FrameAni = null;

    private checkNum: number = null;
    private checkCurEffect: CheckCurEffect = null;

    private _data: any = null;
    public set data(data) {
        this._data = data;
        this.checkData.isPlayed = true;
        if (!data) return;
        if (!data.isVisitSuccess) return;
        this.enabled = data.isVisitSuccess;
        this.starCount = data.stars;

        this.checkData = data;
        this.checkData.isPlayed = true;

        this._sendAwardType = data.sendAwardType;
    }

    public get sendAwardType() {
        return this._sendAwardType;
    }

    private _starCount = 0;
    public set starCount(count: number) {
        if (count > 3) {
            count = 3;
        } else if (count < 1) {
            count = 1;
        }
        if (this._starCount == count) return;
        this._starCount = count;
        this.star.forEach((value, index) => {
            value.enabled = (index < count);
        });
    }

    public get starCount(): number {
        return this._starCount;
    }

    private _enabled: boolean = true;
    public set enabled(enabled: boolean) {
        if (this._enabled == enabled) return;
        this._enabled = enabled;

        this.btn.enabled = enabled;
        this.star.forEach(v => v.visible = enabled);
        this.checkLabel.visible = enabled;
        if (!enabled && this._isPrize) {
            !this.prizeAnim.parent && this.addChild(this.prizeAnim);
        }
    }

    // 是不是奖励关卡
    private _isPrize: boolean = false;
    public set isPrize(isPrize: boolean) {
        if (isPrize == this._isPrize) return;
        this._isPrize = isPrize;
        if (this._isPrize && !this._enabled) {
            !this.prizeAnim.parent && this.addChild(this.prizeAnim);
        } else {
            this.prizeAnim.parent && this.prizeAnim.parent.removeChild(this.prizeAnim);
        }
    }

    // 按钮类型
    private _type: CHECK_TYPE = CHECK_TYPE.COM;
    public set type(type: CHECK_TYPE) {
        if (this._type == type) return;
        this._type = type;

        switch (type) {
            case CHECK_TYPE.COM:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_disable.png'));
                this.checkLabel.strokeColor = '#316ec6';

                this.checkCurEffect.visible = false;
                this.checkCurEffect.stop();
                break;

            case CHECK_TYPE.CUR:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_disable.png'));
                this.checkLabel.strokeColor = '#a55507';

                this.checkCurEffect.visible = true;
                this.checkCurEffect.play();
                break;
        }
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(), new Point());
        let bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp);
    }

    constructor(data) {
        super();
        this.initUi(data);
        this.initEffect();
    }

    private initEffect() {
        const textures: Texture[] = [];
        for (let i = 0; i < 17; i++) {
            textures.push(RES.getRes(`prize_check_${i}.png`));
        }
        for (let i = 17; i < 60; i++) {
            textures.push(RES.getRes('prize_check_0.png'));
        }
        this.prizeAnim = new FrameAni(textures);
        this.prizeAnim.play(-1);
        this.prizeAnim.position.set(54, 54);
    }

    protected initUi(data) {
        this.btn = this.addChild(new Button(
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_disable.png')
        ));

        // 三个星星
        const star1 = this.addChild(new CheckStar());
        star1.position.set(16.5, 83);
        const star2 = this.addChild(new CheckStar());
        star2.position.set(42.5, 90);
        const star3 = this.addChild(new CheckStar());
        star3.position.set(67.5, 83);
        this.star = [star1, star2, star3];

        // 关卡文字
        this.checkNum = data.check;
        this.checkData.level = data.check;
        this.checkLabel = this.btn.addChild(Tools.getText(
            data.check, 30, '#ffffff',
            TEXT_ALIGN.CENTER, 90, 8, 33
        ));
        this.checkLabel.stroke = 2;
        this.checkLabel.strokeColor = '#316ec6';

        // 当前关卡动画
        this.checkCurEffect = this.addChild(new CheckCurEffect());
        this.checkCurEffect.visible = false;

        this.enabled = false;   // 先设置成关闭

        // 点击事件
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);

    }

    public clickStart() {
        console.log(`关卡:${this.checkNum}`);
        console.log(this.checkData);
        this._isPrize
            ? showPanel(StartPanelPrize, this.checkData)
            : showPanel(StartPanel, this.checkData);
    }
}

/**
 * 关卡按钮star
 */
class CheckStar extends Sprite {

    private static starEnableTexture: Texture = null;
    private static starDisableTexture: Texture = null;

    private _enabled: boolean = false;

    public set enabled(enabled: boolean) {
        this._enabled = enabled;
        this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
    }

    constructor() {
        super(RES.getRes('map_star_disable.png'));
        CheckStar.starDisableTexture = RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES.getRes('map_star_enable.png');
    }

}

/**
 * 当前关卡的动画
 */
class CheckCurEffect extends Container {

    private light1: Sprite = null;
    private light2: Sprite = null;

    constructor() {
        super();

        this.light1 = this.addChild(Tools.getSprite('cur_light_1.png'));
        this.light2 = this.addChild(Tools.getSprite('cur_light_2.png'));
        this.light1.anchorTexture.set(0.5, 0.5);
        this.light2.anchorTexture.set(0.5, 0.5);

        this.position.set(55, 50);

        this.mouseEnable = this.mouseChildren = false;
    }

    public play() {

        Tween.get(this.light1, {loop: true})
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1.5, scaleY: 1.5}, 1300)
            .wait(700);

        Tween.get(this.light1, {loop: true})
            .set({alpha: 1})
            .wait(700)
            // .to({alpha: 1}, 700)
            .to({alpha: 0}, 600)
            .wait(700)

        Tween.get(this.light2, {loop: true})
            .set({scaleX: 0.8, scaleY: 0.8})
            .to({scaleX: 1.3, scaleY: 1.3}, 1000)
            .wait(1000);

        Tween.get(this.light2, {loop: true})
            .set({alpha: 0})
            .to({alpha: 1}, 400)
            .to({alpha: 0}, 600)
            .wait(1000);

        return this;

    }

    public stop() {
        Tween.removeTweens(this.light1);
        Tween.removeTweens(this.light2);

        return this;
    }

}
