import { Scene } from "../../module/views/Scene";
import { RES } from "../../module/RES";
import { layers } from "../../module/views/layers";
import { Tools } from "../Tools";
import { showWaiting, wait, changeScene, hideWaiting, showPanel } from "../../module/ctrls";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { GTool } from "../../module/tools/GTool";
import { MapScene } from "./map/MapScene";
import { PrizePanel } from "../panels/PrizePanel";
import { NoPrizePanel } from "../panels/NoPrizePanel";

/**
 * 摇奖机弹框
 */
export class LotteryScene extends Scene {
    get groupNames() { return ["lotteryScene"] }

    lotScroll: LotteryScroll;
    data: {
        level: number,
    }
    initUi() {
        //适配
        this.y = -layers.stageOffsetY;
        //背景
        this.addChild(new FYGE.Sprite(RES.getRes("lotteryMachineBg.jpg")))
        //计算下一关的关数
        // let upLevel: number = 120;
        // let dLevel: number = 120;
        // Tools.baseInfo.prizeLevels.forEach((value, index) => {
        //     const d: number = value - this.data.level;
        //     if (this.data.level <= value && d >= 0 && d <= dLevel) {
        //         upLevel = value;
        //         dLevel = d + 1;
        //     }
        // });
        Tools.baseInfo.prizeLevels.sort((a, b) => {
            return a - b
        })
        var index = Tools.baseInfo.prizeLevels.indexOf(this.data.level);
        let upLevel = Tools.baseInfo.prizeLevels[index + 1]
        //标题文案
        this.addChild(Tools.getText(
            this.data.level + "关抽奖奖励",
            53.19,
            "#ffffff",
            FYGE.TEXT_ALIGN.CENTER,
            488,
            (750 - 488) / 2,
            360
        )).bold = true;
        //下一次抽奖文案
        this.addChild(Tools.getText(
            upLevel ? "下一奖励关卡：" + upLevel + "关" : "",
            32.54,
            "#ffffff",
            FYGE.TEXT_ALIGN.CENTER,
            488,
            (750 - 488) / 2,
            420
        ))
        //抽奖按钮
        this.addChild(new FYGE.Button(RES.getRes("lotteryBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.lottery, this)
            .position.set((750 - RES.getRes("lotteryBtn.png").width) / 2, 797);
        //返回按钮，回到地图页
        this.addChild(new FYGE.Button(RES.getRes("lotteryReturnBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, () => { changeScene(MapScene) }, this)
            .position.set(0, 300)
        //刷新奖品列表和摇奖列表
        this.updatePrizes();
    }
    async updatePrizes() {
        showWaiting();
        const { data: prizeList } = await sendTbNet(TbNetName.getPrizesByLevel, { level: this.data.level });
        //去掉type为5的谢谢参与
        var list = prizeList.slice().filter((e) => { return e.type != 5 });
        //滚动列表
        var scroll = this.addChild(new FYGE.ScrollList(PrizeItem, 122, 140, 345, 152, false))
        scroll.position.set(195, 1013);
        scroll.updateData(list || [])
        //摇奖部分
        var p = [201, 620]
        this.lotScroll = this.addChild(new LotteryScroll(list))
        this.lotScroll.position.set(p[0], p[1]);
    }
    lottery() {
        showWaiting()
        sendTbNet(TbNetName.luckyDraw, { level: this.data.level })
            .then((res) => {
                hideWaiting();
                //如果是失败
                if (!res.success) return;
                let id;//待考虑，谢谢参与要进哪？是否进列表，下面id不存在时当作无奖励，（如果谢谢参与不进列表）
                if (res.data && res.data.prizeId) id = res.data.prizeId;
                this.enableMouseEvt(false);
                console.log(id)
                this.lotScroll.lot(id, () => {
                    this.enableMouseEvt(true)
                    //无奖
                    if (!id || res.data.type == 5) {
                        showPanel(NoPrizePanel);
                    } else {
                        showPanel(PrizePanel, res.data)
                    }
                    // showPanel(id ? PrizePanel : NoPrizePanel, id ? res.data : null)
                })
            })
    }
}
interface PrizeInt {
    image: string,
    name: string,
    _id: string
}
class PrizeItem extends FYGE.Container implements FYGE.IScrollListItem {
    private prizeImage: FYGE.Sprite;
    private nameTxt: FYGE.TextField;
    constructor() {
        super();
        this.addChild(new FYGE.Sprite(RES.getRes("prizeItemBg.png")))
        this.prizeImage = this.addChild(new FYGE.Sprite());
        this.prizeImage.width = this.prizeImage.height = 101;
        this.prizeImage.position.set(4, 4);
        //考虑需不需要加，如果到时性能不行再去掉
        var mask = this.addChild(new FYGE.Shape())
        mask.beginFill(0);
        mask.drawRoundedRect(4, 4, 101, 101, 10);
        mask.endFill();
        this.prizeImage.mask = mask
        //名字
        this.nameTxt = this.addChild(Tools.getText(
            "",
            19.23,
            "#317f7f",
            FYGE.TEXT_ALIGN.CENTER,
            109,
            0, 112
        ))
    }
    initData(id: number, data: PrizeInt) {
        if (id < 0 || !data) return;
        if (data.image) this.prizeImage.texture = FYGE.Texture.from(data.image);
        this.nameTxt.text = data.name;
    }
    id;
    data: number;
}
class LotteryItem extends FYGE.Container {
    private showImage: FYGE.Sprite;
    id: string
    constructor(data: PrizeInt) {
        super();
        this.id = data._id;
        this.addChild(new FYGE.Sprite(RES.getRes("lotteryItemBg.png")));
        this.showImage = this.addChild(new FYGE.Sprite(FYGE.Texture.from(data.image)));
        this.showImage.width = this.showImage.height = 88;
        this.showImage.position.set((103 - 88) / 2, 6);
        var mask = this.addChild(new FYGE.Shape())
        mask.beginFill(0);
        mask.drawRoundedRect((103 - 88) / 2, 6, 88, 88, 10);
        mask.endFill();
        this.showImage.mask = mask
    }
    reset(data: PrizeInt) {
        this.showImage.texture = FYGE.Texture.from(data.image);
        this.id = data._id;
    }
}
const HEIGHT = 123;
/**
 * 滚动条
 * 功能可以滚动到指定的图
 */
class LotteryScrollItem extends FYGE.Container {
    /**
     * 当前childre的中位索引
     */
    get currentIndex(): number {
        var a = 1 - this.cusP;
        var l = this.children.length
        return a < 0 ? a % l + l : a % l
    };

    private cusP: number
    constructor(datas: PrizeInt[]) {
        super();
        datas.forEach((d) => {
            this.addChild(new LotteryItem(d))
        })
        this.cusP = 0;
        this.updatePosition();
        //修改位置
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.updatePosition, this)
    }


    scrollTo(id: string, callback: () => void) {
        //找出目标图
        let child, curIndex;
        for (var i = 0; i < this.children.length; i++) {
            if (this.children[i].id == id) {
                child = this.children[i];
                curIndex = i;
                break
            }
        }
        var delta = this.currentIndex - curIndex;
        if (delta < 0) delta += this.children.length;
        //目标图的位置必须是，多加几圈
        var cusP = this.cusP + delta + 10 * this.children.length;
        FYGE.Tween.get(this)
            .to({ cusP }, 5000, FYGE.Ease.quadInOut)
            .call(() => {
                callback && callback();
            })
    }
    reset() {

    }

    updatePosition() {
        this.children.forEach((c: LotteryItem, j) => {
            c.y = ((this.cusP + j) % this.children.length) * HEIGHT - HEIGHT;
            //超过一定距离，移到上面
            if (c.y > HEIGHT * 1.5) {
                c.y = c.y - this.children.length * HEIGHT
            }
        })
    }

    // 0   0-  10 21  1
    // 1   00  11 2-  0
    // 2   01  1- 20  2
    // 3   0-  10 21  1
    destroy() {
        FYGE.Tween.removeTweens(this);
        super.destroy()
    }
}
/**
 * 暂时固定3列，宽高
 */
class LotteryScroll extends FYGE.Container {
    ids: string[]
    scrollItems: LotteryScrollItem[];
    constructor(datas: PrizeInt[]) {
        super();
        this.scrollItems = []
        for (var i = 0; i < 3; i++) {
            var s = this.addChild(new LotteryScrollItem(GTool.disturbArr(datas.slice())))
            s.position.set(116 * i, 0);
            this.scrollItems.push(s)
        }
        this.ids = [];
        datas.forEach((d) => { this.ids.push(d._id) });

        var h = -50
        //遮罩
        var mask = this.addChild(new FYGE.Shape())
        mask.beginFill(0)
        mask.drawRect(0, h + 3, 350, 195 - 5)
        mask.endFill();
        this.mask = mask;
        //蒙层
        this.addChild(new FYGE.Sprite(RES.getRes("shadowMask.png")))
            .position.set(0, h)
    }
    lot(id?: string, callback?: () => void) {
        //有id且在中奖列表里
        if (id && this.ids.indexOf(id) != -1) {
            //确保得是ids里的id。否则无效
            // if (this.ids.indexOf(id) == -1) {
            //     console.error("中奖id不存在")
            //     return;
            // }
            let count = 0;
            let countAll = this.scrollItems.length;
            this.scrollItems.forEach((c: LotteryScrollItem, i) => {
                wait(() => {
                    c.scrollTo(id, () => {
                        if (++count == countAll && callback) callback();
                    })
                }, 400 * i)

            })
        } else {
            //保证几个id不能一致
            var ids = [
                GTool.randomT(this.ids),
                GTool.randomT(this.ids),
            ];
            //如果都相同
            // if(!ids.some(function (value, index) { return value !== ids[0];})){
            //     ids.push()
            // }
            //才两个，直接判断
            ids[0] === ids[1] ? ids.push(
                GTool.randomT((() => {
                    var arr = this.ids.slice();
                    arr.splice(this.ids.indexOf(ids[0]), 1)
                    return arr
                })())
            ) : ids.push(GTool.randomT(this.ids));
            // console.log(ids)
            let count = 0;
            let countAll = this.scrollItems.length;
            this.scrollItems.forEach((c: LotteryScrollItem, i) => {
                wait(() => {
                    c.scrollTo(ids[i], () => {
                        if (++count == countAll && callback) callback();
                    })
                }, 400 * i)
            })
        }
    }
}