import { Panel } from "../../module/views/Panel";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import { SuccessStarGroup } from "./SuccessNoPrizePanel";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import Container = FYGE.Container;
import { PropType } from "../something/enum/PropType";
import { RES } from "../../module/RES";
import TextField = FYGE.TextField;
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";
import MouseEvent = FYGE.MouseEvent;
import { LotteryScene } from "../scene/LotteryScene";

export class SuccessPrizePanel extends Panel {
    get groupNames() {
        return ['SuccessPanel', 'starLight']
    }

    get skinName() {
        return "SuccessPrizePanel"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    tipsTex: FYGE.TextField;
    checkTex: FYGE.TextField;
    againBtn: FYGE.Button;
    noPrizeAgainBtn: FYGE.Button;
    goPrizeBtn: FYGE.Button;
    prizeImg: Sprite;
    prop: Container;
    light1: Sprite;
    light2: Sprite;

    private starGroup: SuccessStarGroup = null;

    initUi() {
        this.checkTex.text = `第\t${this.data.level}\t关`;
        this.checkTex.textWidth = 750;
        this.checkTex.x = 0;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;

        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;

        this.starGroup = this.addChild(new SuccessStarGroup());
        this.starGroup.position.set(373, 678);

        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 375;

        this.lightEffect();

        this.starGroup.play(this.data.stars);

        const propImg: Sprite = this.prop.getChildByName('img');
        const propLabel: TextField = this.prop.getChildByName('label');

        if (this.data.tool && this.data.tool.type) {
            this.againBtn.visible = false;
            this.goPrizeBtn.visible = false;
            this.prizeImg.visible = false;
            this.tipsTex.text = '\t\t满星过关！';
            switch (this.data.tool.type) {
                case PropType.BOOMS:
                    propImg.texture = RES.getRes('boomBtn.png');
                    propImg.y += 5;
                    propImg.x += 15;
                    propLabel.text = '炸弹道具\tx1';
                    break;

                case PropType.HAMMERS:
                    propImg.texture = RES.getRes('hammerBtn.png');
                    propImg.x += 10;
                    propLabel.text = '锤子道具\tx1';
                    break;

                case PropType.STEPS:
                    propImg.texture = RES.getRes('stepBtn.png');
                    propLabel.text = '步数道具\tx1';
                    break;
            }
        } else if (this.data.prize && this.data.prize.image) {
            if (this.data.level == 120) {//120关不显示闯关按钮，换图
                this.againBtn.visible = false;
                this.goPrizeBtn.visible = false;
                this.noPrizeAgainBtn.changeTexture(RES.getRes("开奖按钮120.png"))
            } else {
                this.noPrizeAgainBtn.visible = false;
            }

            this.prop.visible = false;
            this.prizeImg.texture = Texture.fromUrl(this.data.prize.image);
            // this.tipsTex.text = '\t\t闯关成功！获得抽大奖机会！';
            this.tipsTex.text = '\t闯关成功！有机会抽取如下奖品';
        }
    }

    private lightEffect() {
        Tween.get(this.light1, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: 360 }, 12000);

        Tween.get(this.light2, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: -360 }, 12000);
    }

    start(data) {
        super.start();
    }

    /**
     * 挑战满星
     */
    private again() {
        changeScene(MapScene, { level: this.data.level });
        super.hidePanel();
    }

    /**
     * 继续闯关
     */
    private continue() {
        if (this.data.level == 120) {
            changeScene(MapScene);
        } else {
            changeScene(MapScene, { level: this.data.level + 1 });
        }
        super.hidePanel();
    }


    public goPrize() {
        // 去抽奖
        changeScene(LotteryScene, { level: this.data.level })
        super.hidePanel();
    }


    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    initEvents() {
        super.initEvents();
        this.againBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.noPrizeAgainBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.goPrizeBtn.addEventListener(MouseEvent.CLICK, this.goPrize, this);
    }

    removeEvents() {
        super.removeEvents();
    }
}
