import { Panel } from "../../module/views/Panel";
import MouseEvent = FYGE.MouseEvent;
import { changeScene, showPanel } from "../../module/ctrls";
import { PlayScene } from "../scene/PlayScene";
import { StartTarget } from "./StartPanel";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import { Tools } from "../Tools";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { NoEnergyPanel } from "./NoEnergyPanel";

export class StartPanelPrize extends Panel {
    get groupNames() {
        return ["StartPanelPrize"]
    }

    get skinName() {
        return "StartPanelPrize"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    startBtn: FYGE.Button;
    startBtn2: FYGE.Button;
    tipsTex: FYGE.TextField;
    checkTex: FYGE.TextField;
    prizeImg: Sprite;

    initUi() {
        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = `第\t${this.data.level}\t关`;

        this.startBtn.visible = !this.data.isPlayed;
        this.startBtn2.visible = this.data.isPlayed;

        this.addChild(new StartTarget(this.data.level))
            .position.set(0, 682);

        this.prizeImg.texture = Texture.fromUrl(Tools.baseInfo.levelPrize[`level_${this.data.level}`]);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 750 / 2;
    }

    start(data) {
        super.start();
    }

    private startGame() {
        this.enableMouseEvt(false);
        if (!this.data.isPlayed && Tools.gameData.power <= 0) {// 体力不足
            showPanel(NoEnergyPanel);
            this.enableMouseEvt(true);
            return;
        }
        sendTbNet(TbNetName.dojoin, {level: this.data.level},
            (success, res) => {
                this.enableMouseEvt(true);
                if (!success) return;

                // 访问页面埋点
                sendTbNet(TbNetName.reportAnalytics, {logkey: 'join'});

                Tools.gameData.power = res.data.power;
                changeScene(PlayScene, {chapter: this.data.level});
                this.hidePanel();
            }
        );
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    }
}
