import { Panel } from "../../module/views/Panel";
import { getChapterData } from "../something/chapters/getChapter";
import { Tools } from "../Tools";
import { ElementTargetData } from "../something/interface/ElementTargetData";
import Container = FYGE.Container;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import { changeScene, showPanel } from "../../module/ctrls";
import { PlayScene } from "../scene/PlayScene";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { NoEnergyPanel } from "./NoEnergyPanel";

export class StartPanel extends Panel {
    get groupNames() {
        return ["StartPanel"]
    }

    get skinName() {
        return "StartPanel"
    }

    closeBtn: FYGE.Button;
    checkTex: FYGE.TextField;
    tipsTex: FYGE.TextField;
    startBtn2: FYGE.Button;
    startBtn: FYGE.Button;

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    initUi() {
        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = `第\t${this.data.level}\t关`;

        this.startBtn.visible = !this.data.isPlayed;
        this.startBtn2.visible = this.data.isPlayed;
        this.tipsTex.visible = !this.data.isPlayed;

        this.addChild(new StartTarget(this.data.level))
            .position.set(0, 682);

        // console.log(this.data);
    }

    start(data) {
        super.start();
    }

    private startGame() {
        this.enableMouseEvt(false);
        if (!this.data.isPlayed && Tools.gameData.power <= 0) {// 体力不足
            showPanel(NoEnergyPanel);
            this.enableMouseEvt(true);
            return;
        }
        sendTbNet(TbNetName.dojoin, {level: this.data.level},
            (success, res) => {
                this.enableMouseEvt(true);
                if (!success) return;
                Tools.gameData.power = res.data.power;

                // 访问页面埋点
                sendTbNet(TbNetName.reportAnalytics, {logkey: 'join'});

                changeScene(PlayScene, {chapter: this.data.level});
                this.hidePanel();
            }
        );
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    }
}

const pos = [
    [325],
    [240, 410],
    [180, 325, 470],
]

export class StartTarget extends Container {
    constructor(checkNum: number) {
        super();

        const passTarget = getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) { // 分数

        } else if (passTarget.type == 1) {  // 消除元素个数
            passTarget.elements.forEach((v, i) => {
                const targetItem = this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(() => {
                    targetItem.playEffect();
                }, i * 200);
            });
        }

    }
}

export class StartTargetItem extends Container {

    constructor(data: ElementTargetData) {
        super();

        const targetImg = this.addChild(Tools.getSprite(`ele${data.type}.png`));
        targetImg.width = targetImg.height = 100;

        const targetTex = this.addChild(Tools.getText(
            `${data.count}`, 30, '#ffffff',
            TEXT_ALIGN.CENTER, 100, 0, 108
        ));
        targetTex.strokeColor = '#eb5b57';
        targetTex.stroke = 3;

        this.anchor.set(50, 79);
        this.scale.set(0, 0);

    }

    // 变大的动效
    public playEffect() {
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 500, Ease.backOut)
    }
}
