import { Panel } from "../../module/views/Panel";
import TextField = FYGE.TextField;
import Button = FYGE.Button;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Texture = FYGE.Texture;
import MouseEvent = FYGE.MouseEvent;
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { showToast } from "../../module/ctrls";
import { Tool } from "../something/Tool";
import { Tools } from "../Tools";

export class PrizePanel extends Panel {
    get groupNames() {
        return ["PrizePanel"]
    }

    get skinName() {
        return "PrizePanel"
    }

    closeBtn: Button;
    prizeTxt: TextField;
    prizeImg: Sprite;
    prizeBtn: Button;

    initUi() {
        this.prizeTxt.textAlign = TEXT_ALIGN.CENTER;
        this.prizeTxt.textWidth = 750;
        this.prizeTxt.x = 0;
        this.prizeTxt.text = `恭喜获得${this.data.name}`;

        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 375;
        this.prizeImg.texture = Texture.fromUrl(this.data.image);
    }

    start(data) {
        super.start();
    }

    private clickPrizeBtn(){
        this.btnDelay(this.prizeBtn);
        switch (this.data.type) {
            case 1: // 权益
                sendTbNet(TbNetName.receiveEnamePrize, {_id: this.data._id},
                    (success, res) => {
                        if (!success || !res) {
                            showToast('奖品发放失败\n请前往我的奖品处进行处理');
                            this.hidePanel();
                            return;
                        }
                        if (res.data && res.data.drawStatus == 3) {
                            showToast('奖品发放成功\n请前往我的奖品处查看');
                        } else {
                            showToast('奖品发放失败\n请前往我的奖品处进行处理');
                        }
                        this.hidePanel();
                    }, true
                );
                break;
            case 3: // 实物
                sendTbNet(TbNetName.getUserAddress, {prizeId: this.data._id},
                    (success, res) => {
                        if (!success) {
                            // showToast('奖品发放失败\n请前往我的奖品处进行处理');
                            return;
                        }
                        showToast('奖品发放成功\n请前往我的奖品处查看');
                        this.hidePanel();
                    }, true
                );
                break;

            case 2: // 积分
            case 5: // 谢谢参与
                this.hidePanel();
                break;
        }
    }

    initEvents() {
        super.initEvents();
        this.prizeBtn.addEventListener(MouseEvent.CLICK, this.clickPrizeBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        this.prizeBtn.removeEventListener(MouseEvent.CLICK, this.clickPrizeBtn, this);
    }
}
