import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";

export class FailedPanel extends Panel {
    get groupNames() {
        return ["FailedPanel"]
    }

    get skinName() {
        return "FailedPanel"
    }

    againBtn: FYGE.Button;
    closeBtn: FYGE.Button;
    tipsTex: FYGE.TextField;
    checkTex: FYGE.TextField;

    initUi() {
        this.checkTex.text = `第\t${this.data.level}\t关`;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 2;
        this.checkTex.textWidth = 750;

        const curLevel: number = Tools.gameData.currentLevel;
        let upLevel: number = 120;
        let dLevel: number = 120;
        Tools.baseInfo.prizeLevels.forEach((value, index) => {
            const d: number = value - curLevel;
            if (curLevel <= value && d >= 0 && d <= dLevel) {
                upLevel = value;
                dLevel = d + 1;
            }
        });
        this.tipsTex.text = `\t\t\t再接再厉！\n再解锁${dLevel}关可参与抽奖`;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;

        if (Tools.gameData.currentLevel == 120
            && MapScene.checkArr && MapScene.checkArr[120]
            && MapScene.checkArr[120].checkData.isVisitSuccess) {
            this.tipsTex.text = '';
        }
    }

    start(data) {
        super.start();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    public again() {
        changeScene(MapScene, {level: this.data.level});
        super.hidePanel();
    }

    initEvents() {
        super.initEvents();
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
    }

    removeEvents() {
        super.removeEvents();
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
    }
}
