import { sendTbNet, TbNetName } from "./TaoBaoNet";

/**
 * 曝光埋点
 * @param elemType
 */
// export function showLog(elemType: string) {
//     sendTbNet(TbNetName.trackingReport, { params: { elemType }, type: "exposure" }, () => { }, true)
//     //淘宝自定义埋点
//     sendTbNet(TbNetName.reportAnalytics, { logkey: elemType }, () => { }, true)
// }

export enum LogEnum {
    AD = "ad",
    TASK_ICON = 'taskIcon',
    FOLLOW_SHOP = 'followShop',
    INVITE_FRIEND = 'inviteFriend',
    BROWSE_PRODUCT = 'browseProduct',
    COLLECTION_PRODUCT = 'collectionProduct',
    BUY_PRODUCT = 'buyProduct',
    IMPROVE_INFORMATION = 'improveInformation',
    SECRET_ORDER = 'secretOrder',
    SIGN_ICON = 'signIcon',
    BAG_ICON = 'bagIcon',
}

/**
 * 点击埋点，自定义字段，
 * @param elemType
 */
export function clickLog(elemType: LogEnum) {
    sendTbNet(TbNetName.trackingReport, { params: { elemType }, type: "click" }, () => { }, true)
    //淘宝自定义埋点
    sendTbNet(TbNetName.reportAnalytics, { logkey: elemType }, () => { }, true)
}

