(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                if (groupName && type != "jpg") {
                    var group = getGroupByName(groupName);
                    if (group && group.atlas) {
                        var json = groupName + ".json";
                        if (singleResPromiseHash[json]) {
                            return singleResPromiseHash[json].then(function (r) {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                        else {
                            return getResAsync(json)
                                .then(function () {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                    }
                }
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "svga") {
            if (videoEntityHash[str]) {
                comFun && comFun.call(thisObj, videoEntityHash[str], str);
                return new Promise(function (r) {
                    r(videoEntityHash[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadSvga(function (s, v) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            if (s)
                                videoEntityHash[str] = v;
                            comFun && comFun.call(thisObj, v, str);
                            resolve(v);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "json") {
            if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    var jsonData = getGroupByName(groupName).atlas;
                    FYGE.GlobalLoader.loadImage(function (s, data) {
                        if (s) {
                            var t = FYGE.createTextureSheet(new FYGE.BaseTexture(data), jsonData);
                            comFun && comFun.call(thisObj, t, str);
                            resolve(t);
                        }
                        else {
                            delete singleResPromiseHash[str];
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src.replace("json", "png"));
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
        else if (type == "svga") {
            return videoEntityHash[str] || null;
        }
        else if (type == "mp3") {
            return soundHash[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "skin")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "skin"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
exports.showToast = toastCtrl_2.showToast;
__export(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"));
exports.showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        _this.bg = new FYGE.Sprite(toastBgTexture);
        _this.addChild(_this.bg);
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture.height;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = (this.bg.width - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        var rectBg = new FYGE.Sprite(rectBgTexture);
        _this.addChild(rectBg);
        var rotTexture = RES_1.RES.getRes("waitingRot.png");
        var rot = new FYGE.Sprite(rotTexture);
        rot.x = (rectBgTexture.width - rotTexture.width) / 2;
        rot.y = 47;
        rot.anchorX = rotTexture.width / 2;
        rot.anchorY = rotTexture.height / 2;
        _this.addChild(rot);
        var count = 0;
        rot.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            count++;
            if (count % 30 == 0)
                rot.rotation += 45;
        }, _this);
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture.width;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/tools/GTool.ts":
/*!*******************************!*\
  !*** ./module/tools/GTool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var GTool = (function () {
    function GTool() {
    }
    GTool.changeURLArg = function (url, arg, arg_val) {
        var pattern = arg + '=([^&]*)';
        var replaceText = arg + '=' + arg_val;
        if (url.match(pattern)) {
            var tmp = '/(' + arg + '=)([^&]*)/gi';
            tmp = url.replace(new RegExp(tmp), replaceText);
            return tmp;
        }
        else {
            if (url.match('[\?]')) {
                return url + '&' + replaceText;
            }
            else {
                return url + '?' + replaceText;
            }
        }
    };
    GTool.readCache = function (key) {
        return my ? my.getStorageSync({ key: key }).data : localStorage.getItem(key);
    };
    GTool.writeCache = function (key, value) {
        if (value === void 0) { value = 'true'; }
        my ? my.setStorageSync({ key: key, data: value }) : localStorage.setItem(key, value);
    };
    GTool.returnTodayTimes = function (cacheKey) {
        var year1 = this.readCache("year" + cacheKey);
        var month1 = this.readCache("month" + cacheKey);
        var day1 = this.readCache("day" + cacheKey);
        var date = new Date();
        var year2 = date.getFullYear().toString();
        var month2 = date.getMonth().toString();
        var day2 = date.getDate().toString();
        if (this.int(year2) <= this.int(year1)) {
            if (this.int(month2) <= this.int(month1)) {
                if (this.int(day2) <= this.int(day1)) {
                    return this.int(this.readCache(cacheKey));
                }
            }
        }
        var today = "0";
        this.writeCache("year" + cacheKey, year2);
        this.writeCache("month" + cacheKey, month2);
        this.writeCache("day" + cacheKey, day2);
        this.writeCache(cacheKey, today);
        return 0;
    };
    GTool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    GTool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    GTool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    GTool.getRandomNumber = function (start, end, n) {
        var arr = [];
        for (var i = 0; i < n; i++) {
            var number = Math.floor(Math.random() * (end - start + 1) + start);
            if (arr.indexOf(number) < 0) {
                arr.push(number);
            }
            else {
                i--;
            }
        }
        return arr;
    };
    GTool.disturbNumberArr = function (arr) {
        arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.disturbArr = function (arr) {
        return arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        if (count <= 0)
            return [];
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    GTool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    GTool.int = function (n) {
        return n >> 0;
    };
    ;
    GTool.addSpaceInString = function (str) {
        if (!str.length || str.length == 1)
            return str;
        var txt = "";
        for (var i = 0; i < str.length - 1; i++) {
            txt = txt + str[i] + " ";
        }
        txt = txt + str[str.length - 1];
        return txt;
    };
    GTool.getShiFenMiaoByTimeStamp = function (timeStamp) {
        var hours = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((timeStamp % (1000 * 60)) / 1000);
        hours = hours < 10 ? ('0' + hours) : hours;
        minutes = minutes < 10 ? ('0' + minutes) : minutes;
        seconds = seconds < 10 && seconds >= 1 ? ('0' + seconds) : seconds;
        return hours + "小时" + minutes + "分" + seconds + "秒";
    };
    GTool.emojiReg = /[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF][\u200D|\uFE0F]|[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF]|[0-9|*|#]\uFE0F\u20E3|[0-9|#]\u20E3|[\u203C-\u3299]\uFE0F\u200D|[\u203C-\u3299]\uFE0F|[\u2122-\u2B55]|\u303D|[\A9|\AE]\u3030|\uA9|\uAE|\u3030/ig;
    return GTool;
}());
exports.GTool = GTool;


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Panel.ts":
/*!*******************************!*\
  !*** ./module/views/Panel.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Panel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({ y: oriY }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.addEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.removeEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () {
            return [this['closeBtn']];
        },
        enumerable: true,
        configurable: true
    });
    Panel.prototype.hidePanel = function () {
        this.destroy();
    };
    return Panel;
}(Module_1.Module));
exports.Panel = Panel;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.sceneLayer.y = this.stageOffsetY;
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: true,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./src/Lottie.ts":
/*!***********************!*\
  !*** ./src/Lottie.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var Lottie = (function (_super) {
    __extends(Lottie, _super);
    function Lottie(data) {
        var _this = _super.call(this) || this;
        _this.deltaFrame = 1;
        _this._instanceType = "MovieClip";
        if (data) {
            _this.init(data);
        }
        else {
            _this.totalFrames = 0;
        }
        return _this;
    }
    Object.defineProperty(Lottie.prototype, "videoWidth", {
        get: function () {
            return this.rawData && this.rawData.w;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(Lottie.prototype, "videoHeight", {
        get: function () {
            return this.rawData && this.rawData.h;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Lottie.prototype.init = function (data) {
        if (!data)
            return;
        this.rawData = data;
        this.timeInterval = 1000 / data.fr;
        this.totalFrames = data.op - data.ip;
        this.deltaFrame = 60 / data.fr;
        this.name = data.nm;
        this.initChildren();
    };
    Lottie.prototype.initChildren = function () {
        var hash = {};
        var layers = this.rawData.layers.slice();
        for (var i = layers.length - 1; i >= 0; i--) {
            var layer = layers[i];
            if (!layer.parent) {
                var c = this.addChild(new FYGE.Container());
                c.addChild(new FYGE.Sprite(RES_1.RES.getRes(layer.nm) || RES_1.RES.getRes(layer.refId + ".png")));
                c.name = layer.nm;
                c["layerData"] = layer;
                hash[layer.ind] = c;
                layers.splice(i, 1);
            }
        }
        while (layers.length) {
            for (var j = layers.length - 1; j >= 0; j--) {
                var layer = layers[j];
                if (hash[layer.parent]) {
                    var c = hash[layer.parent].addChildAt(new FYGE.Sprite(RES_1.RES.getRes(layer.nm) || RES_1.RES.getRes(layer.refId + ".png")), layer["td"] || 999);
                    c.name = layer.nm;
                    c["layerData"] = layer;
                    hash[layer.ind] = c;
                    layers.splice(j, 1);
                }
            }
        }
        this.initState();
    };
    Lottie.prototype.initState = function (con) {
        if (con === void 0) { con = this.children; }
        for (var i = 0; i < con.length; i++) {
            var c = con[i];
            if (c["layerData"]) {
                var data = c["layerData"];
                c.alpha = data.ks.o.k[0] ? data.ks.o.k[0].s[0] / 100 : data.ks.o.k / 100;
                c.rotation = data.ks.r.k[0] ? data.ks.r.k[0].s[0] : data.ks.r.k;
                var ad = typeof data.ks.a.k[0] == "number" ? data.ks.a.k : data.ks.a.k[0].s;
                c.anchor.set(ad[0], ad[1]);
                var ad = typeof data.ks.p.k[0] == "number" ? data.ks.p.k : data.ks.p.k[0].s;
                c.position.set(ad[0] - c.anchorX, ad[1] - c.anchorY);
                var ad = typeof data.ks.s.k[0] == "number" ? data.ks.s.k : data.ks.s.k[0].s;
                c.scale.set(ad[0] / 100, ad[1] / 100);
                if (data.ip != 0)
                    c.visible = false;
            }
            if (c.children.length)
                this.initState(c.children);
        }
    };
    Lottie.prototype.play = function (loop, callback) {
        if (loop === void 0) { loop = 1; }
        this.initState();
        this.loops = loop;
        this.callback = callback;
        this.addTweens();
    };
    Lottie.prototype.stop = function () {
        ctrls_1.removeTweens(this);
        this.initState();
    };
    Lottie.prototype.addTweens = function (con) {
        if (con === void 0) { con = this.children; }
        for (var i = 0; i < con.length; i++) {
            var c = con[i];
            if (c["layerData"]) {
                var data = c["layerData"];
                if (data.ks.o.k.length)
                    this.addTween(c, "o");
                if (data.ks.r.k.length)
                    this.addTween(c, "r");
                if (typeof data.ks.p.k[0] != "number")
                    this.addTween(c, "p");
                if (typeof data.ks.s.k[0] != "number")
                    this.addTween(c, "s");
            }
            if (c.children.length)
                this.addTweens(c.children);
        }
    };
    Lottie.prototype.addTween = function (dis, type) {
        var _this = this;
        var data = dis["layerData"].ks[type].k;
        var tween = FYGE.Tween.get(dis, { loop: true });
        var countTime = 0;
        var objArr = [];
        for (var i = 0; i < data.length; i++) {
            var d = data[i];
            var deltaTime = d.t * this.timeInterval - countTime;
            countTime += deltaTime;
            var obj = void 0;
            switch (type) {
                case "r":
                    obj = { rotation: d.s[0] };
                    break;
                case "o":
                    obj = { alpha: d.s[0] / 100 };
                    break;
                case "s":
                    obj = { scaleX: d.s[0] / 100, scaleY: d.s[1] / 100 };
                    break;
                case "p":
                    obj = { x: d.s[0] - dis.anchorX, y: d.s[1] - dis.anchorY };
                    break;
            }
            if (i == 0 && d.t != 0) {
                tween.wait(deltaTime)
                    .call(function () { dis.visible = true; });
                continue;
            }
            else if (i == 0 && d.t == 0) {
                objArr.push({ obj: obj, deltaTime: deltaTime });
                continue;
            }
            tween.to(obj, deltaTime);
            objArr.push({ obj: obj, deltaTime: deltaTime });
        }
        if (dis["layerData"].ks[type].x) {
            var xs = dis["layerData"].ks[type].x;
            if (xs.indexOf("loopOut") >= 0) {
                if (xs.indexOf("pingpong") >= 0 && data[data.length - 1].t < this.rawData.op) {
                    var round = Math.round(this.rawData.op / data[data.length - 1].t);
                    var dir = false;
                    while (--round) {
                        if (dir) {
                            for (var o = 0; o < objArr.length; o++) {
                                tween.to(objArr[o].obj, objArr[o].deltaTime);
                            }
                        }
                        else {
                            for (var o = objArr.length - 1; o >= 1; o--) {
                                tween.to(objArr[o - 1].obj, objArr[o].deltaTime);
                            }
                        }
                        dir = !dir;
                    }
                }
                else if (xs.indexOf("cycle") >= 0 && data[data.length - 1].t < this.rawData.op) {
                    var rr = xs.replace(/[^0-9]/ig, "");
                    var num = Math.round((this.rawData.op - data[data.length - 1 - rr].t) / (data[data.length - 1].t - data[data.length - 1 - rr].t));
                    objArr = objArr.slice(-rr);
                    while (--num) {
                        for (var o = 0; o < objArr.length; o++) {
                            tween.to(objArr[o].obj, objArr[o].deltaTime);
                        }
                    }
                }
            }
        }
        if (dis["layerData"].ip != 0) {
            tween.call(function () {
                dis.visible = false;
            });
        }
        if (!dis["layerData"].ks[type].x) {
            if (data[data.length - 1].t < this.rawData.op) {
                tween.wait(this.rawData.op * this.timeInterval - countTime);
            }
        }
        tween.call(function () {
            if (--_this.loops == 0) {
                _this.stop();
                _this.callback && _this.callback();
            }
        });
    };
    Lottie.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        _super.prototype.destroy.call(this);
    };
    return Lottie;
}(FYGE.Container));
exports.Lottie = Lottie;


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var ResJson_1 = __webpack_require__(/*! ./ResJson */ "./src/ResJson.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var SkinJson_1 = __webpack_require__(/*! ./SkinJson */ "./src/SkinJson.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var LoadingScene_1 = __webpack_require__(/*! ./scene/LoadingScene */ "./src/scene/LoadingScene.ts");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.CANVAS);
        this.stage = stage;
        this.canvas = canvas;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            my ? self.requestID = canvas.requestAnimationFrame(loop) :
                self.requestID = window.requestAnimationFrame(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        RES_1.RES.loadConfig(ResJson_1.ResJson);
                        console.log("初始化资源配置完成");
                        RES_1.RES.loadSkinConfig(SkinJson_1.SkinJson);
                        return [4, RES_1.RES.loadGroup("common")];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        ctrls_1.changeScene(LoadingScene_1.LoadingScene);
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
        FYGE.Tween._lastTime = null;
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_SHOW });
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_HIDE });
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        my ? this.canvas.cancelAnimationFrame(this.requestID) :
            window.cancelAnimationFrame(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;
function createNineTextures(imageUrl) {
    return new Promise(function (resolve, reject) {
        var image = new Image();
        image.setAttribute("crossOrigin", "anonymous");
        image.onload = function () {
            var obj = {};
            var name = "lalala";
            var row = 4, col = 3;
            var w = image.width / col;
            var h = image.height / row;
            for (var i = 0; i < col * row; i++)
                obj[name + i] = {
                    "x": i % col * w,
                    "y": ~~(i / col) * h,
                    w: w, h: h, sw: w, sh: h, ox: 0, oy: 0, ro: false
                };
            FYGE.createTextureSheet(new FYGE.BaseTexture(image), obj);
            var arr = [];
            for (var i = 0; i < col * row; i++)
                arr.push(FYGE.TextureCache[name + i]);
            resolve(arr);
        };
        image.onerror = function (err) {
            reject(err);
        };
        image.src = imageUrl;
    });
}


/***/ }),

/***/ "./src/ResJson.ts":
/*!************************!*\
  !*** ./src/ResJson.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ResJson = {
    "groups": [
        {
            "keys": "amazing.png,great.png,img_0.png,img_1.png,img_10.png,img_11.png,img_12.png,img_13.png,img_14.png,img_15.png,img_16.png,img_17.png,img_18.png,img_19.png,img_2.png,img_3.png,img_4.png,img_5.png,img_6.png,img_7.png,img_8.png,img_9.png,wonderful.png",
            "name": "bonusTime",
            "atlas": {
                "amazing.png": {
                    "x": 2,
                    "y": 567,
                    "w": 427,
                    "h": 132,
                    "ox": 16,
                    "oy": 5,
                    "sw": 459,
                    "sh": 142,
                    "ro": true
                },
                "great.png": {
                    "x": 652,
                    "y": 125,
                    "w": 365,
                    "h": 142,
                    "ox": 47,
                    "oy": 0,
                    "sw": 459,
                    "sh": 142,
                    "ro": false
                },
                "img_0.png": {
                    "x": 136,
                    "y": 660,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": false
                },
                "img_1.png": {
                    "x": 136,
                    "y": 567,
                    "w": 491,
                    "h": 91,
                    "ox": 0,
                    "oy": 0,
                    "sw": 491,
                    "sh": 91,
                    "ro": false
                },
                "img_10.png": {
                    "x": 50,
                    "y": 996,
                    "w": 22,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 20,
                    "ro": true
                },
                "img_11.png": {
                    "x": 864,
                    "y": 701,
                    "w": 142,
                    "h": 86,
                    "ox": 0,
                    "oy": 0,
                    "sw": 142,
                    "sh": 86,
                    "ro": false
                },
                "img_12.png": {
                    "x": 963,
                    "y": 506,
                    "w": 68,
                    "h": 43,
                    "ox": 0,
                    "oy": 0,
                    "sw": 68,
                    "sh": 43,
                    "ro": true
                },
                "img_13.png": {
                    "x": 312,
                    "y": 789,
                    "w": 159,
                    "h": 217,
                    "ox": 0,
                    "oy": 0,
                    "sw": 159,
                    "sh": 217,
                    "ro": false
                },
                "img_14.png": {
                    "x": 652,
                    "y": 269,
                    "w": 299,
                    "h": 309,
                    "ox": 0,
                    "oy": 0,
                    "sw": 299,
                    "sh": 309,
                    "ro": true
                },
                "img_15.png": {
                    "x": 136,
                    "y": 789,
                    "w": 174,
                    "h": 218,
                    "ox": 0,
                    "oy": 0,
                    "sw": 174,
                    "sh": 218,
                    "ro": false
                },
                "img_16.png": {
                    "x": 963,
                    "y": 269,
                    "w": 143,
                    "h": 59,
                    "ox": 0,
                    "oy": 0,
                    "sw": 143,
                    "sh": 59,
                    "ro": true
                },
                "img_17.png": {
                    "x": 629,
                    "y": 570,
                    "w": 199,
                    "h": 233,
                    "ox": 0,
                    "oy": 0,
                    "sw": 199,
                    "sh": 233,
                    "ro": true
                },
                "img_18.png": {
                    "x": 2,
                    "y": 2,
                    "w": 648,
                    "h": 563,
                    "ox": 0,
                    "oy": 0,
                    "sw": 648,
                    "sh": 563,
                    "ro": false
                },
                "img_19.png": {
                    "x": 652,
                    "y": 2,
                    "w": 121,
                    "h": 369,
                    "ox": 0,
                    "oy": 0,
                    "sw": 121,
                    "sh": 369,
                    "ro": true
                },
                "img_2.png": {
                    "x": 2,
                    "y": 996,
                    "w": 23,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 22,
                    "ro": true
                },
                "img_3.png": {
                    "x": 109,
                    "y": 996,
                    "w": 14,
                    "h": 9,
                    "ox": 0,
                    "oy": 0,
                    "sw": 14,
                    "sh": 9,
                    "ro": true
                },
                "img_4.png": {
                    "x": 26,
                    "y": 996,
                    "w": 22,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 22,
                    "ro": false
                },
                "img_5.png": {
                    "x": 864,
                    "y": 570,
                    "w": 129,
                    "h": 94,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 94,
                    "ro": true
                },
                "img_6.png": {
                    "x": 72,
                    "y": 996,
                    "w": 18,
                    "h": 17,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 17,
                    "ro": true
                },
                "img_7.png": {
                    "x": 91,
                    "y": 996,
                    "w": 18,
                    "h": 16,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 16,
                    "ro": true
                },
                "img_8.png": {
                    "x": 963,
                    "y": 460,
                    "w": 44,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 44,
                    "sh": 56,
                    "ro": true
                },
                "img_9.png": {
                    "x": 963,
                    "y": 414,
                    "w": 44,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 44,
                    "sh": 56,
                    "ro": true
                },
                "wonderful.png": {
                    "x": 473,
                    "y": 789,
                    "w": 459,
                    "h": 132,
                    "ox": 0,
                    "oy": 5,
                    "sw": 459,
                    "sh": 142,
                    "ro": false
                }
            }
        },
        {
            "keys": "增加体力背景.png,无字按钮底.png",
            "name": "BuyPowerPanel",
            "atlas": {
                "增加体力背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 477,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 477,
                    "ro": true
                },
                "无字按钮底.png": {
                    "x": 2,
                    "y": 644,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "boomBtn.png,comCloseBtn.png,comm_light.png,ele0.png,ele1.png,ele10.png,ele11.png,ele12.png,ele13.png,ele14.png,ele2.png,ele3.png,ele4.png,ele5.png,ele6.png,ele7.png,ele8.png,ele9.png,hammerBtn.png,stepBtn.png,toastBg.png,waitingBg.png,waitingRot.png,关闭按钮.png,再想想.png,开始闯关不要能量.png,开始闯关要能量.png,确定.png,继续闯关大.png,继续闯关小.png",
            "name": "common",
            "atlas": {
                "boomBtn.png": {
                    "x": 108,
                    "y": 874,
                    "w": 101,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 101,
                    "sh": 109,
                    "ro": false
                },
                "comCloseBtn.png": {
                    "x": 347,
                    "y": 908,
                    "w": 48,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 48,
                    "ro": false
                },
                "comm_light.png": {
                    "x": 464,
                    "y": 2,
                    "w": 439,
                    "h": 439,
                    "ox": 0,
                    "oy": 0,
                    "sw": 439,
                    "sh": 439,
                    "ro": false
                },
                "ele0.png": {
                    "x": 188,
                    "y": 762,
                    "w": 80,
                    "h": 66,
                    "ox": 0,
                    "oy": 13,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele1.png": {
                    "x": 279,
                    "y": 922,
                    "w": 66,
                    "h": 72,
                    "ox": 7,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele10.png": {
                    "x": 256,
                    "y": 761,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele11.png": {
                    "x": 211,
                    "y": 844,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele12.png": {
                    "x": 211,
                    "y": 844,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele13.png": {
                    "x": 287,
                    "y": 839,
                    "w": 67,
                    "h": 67,
                    "ox": 0,
                    "oy": 0,
                    "sw": 67,
                    "sh": 67,
                    "ro": false
                },
                "ele14.png": {
                    "x": 332,
                    "y": 754,
                    "w": 61,
                    "h": 66,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 66,
                    "ro": false
                },
                "ele2.png": {
                    "x": 118,
                    "y": 762,
                    "w": 80,
                    "h": 68,
                    "ox": 0,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele3.png": {
                    "x": 280,
                    "y": 598,
                    "w": 72,
                    "h": 70,
                    "ox": 4,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele4.png": {
                    "x": 279,
                    "y": 678,
                    "w": 74,
                    "h": 64,
                    "ox": 6,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele5.png": {
                    "x": 118,
                    "y": 598,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele6.png": {
                    "x": 211,
                    "y": 922,
                    "w": 66,
                    "h": 72,
                    "ox": 7,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele7.png": {
                    "x": 278,
                    "y": 528,
                    "w": 72,
                    "h": 68,
                    "ox": 4,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele8.png": {
                    "x": 118,
                    "y": 680,
                    "w": 78,
                    "h": 80,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele9.png": {
                    "x": 200,
                    "y": 598,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hammerBtn.png": {
                    "x": 2,
                    "y": 874,
                    "w": 104,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 104,
                    "sh": 114,
                    "ro": false
                },
                "stepBtn.png": {
                    "x": 905,
                    "y": 2,
                    "w": 124,
                    "h": 117,
                    "ox": 0,
                    "oy": 0,
                    "sw": 124,
                    "sh": 117,
                    "ro": true
                },
                "toastBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 460,
                    "h": 130,
                    "ox": 0,
                    "oy": 0,
                    "sw": 460,
                    "sh": 130,
                    "ro": false
                },
                "waitingBg.png": {
                    "x": 278,
                    "y": 366,
                    "w": 160,
                    "h": 180,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 180,
                    "ro": true
                },
                "waitingRot.png": {
                    "x": 345,
                    "y": 672,
                    "w": 56,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 56,
                    "ro": false
                },
                "关闭按钮.png": {
                    "x": 198,
                    "y": 680,
                    "w": 79,
                    "h": 79,
                    "ox": 0,
                    "oy": 0,
                    "sw": 79,
                    "sh": 79,
                    "ro": false
                },
                "再想想.png": {
                    "x": 2,
                    "y": 598,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": true
                },
                "开始闯关不要能量.png": {
                    "x": 2,
                    "y": 250,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                },
                "开始闯关要能量.png": {
                    "x": 2,
                    "y": 134,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                },
                "确定.png": {
                    "x": 2,
                    "y": 482,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                },
                "继续闯关大.png": {
                    "x": 905,
                    "y": 128,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": true
                },
                "继续闯关小.png": {
                    "x": 2,
                    "y": 366,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "积分不足背景.png,赚取积分.png",
            "name": "CreditsOutPanel",
            "atlas": {
                "积分不足背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 437,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 437,
                    "ro": true
                },
                "赚取积分.png": {
                    "x": 2,
                    "y": 644,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "兑换成功背景.png,知道啦.png",
            "name": "ExchangeSucPanel",
            "atlas": {
                "兑换成功背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 599,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 599,
                    "ro": false
                },
                "知道啦.png": {
                    "x": 644,
                    "y": 2,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": true
                }
            }
        },
        {
            "keys": "失败Bg.png,失败重新闯关.png",
            "name": "FailedPanel",
            "atlas": {
                "失败Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 839,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 839,
                    "ro": false
                },
                "失败重新闯关.png": {
                    "x": 2,
                    "y": 843,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "fesEleSmallDis1.png,fesEleSmallDis10.png,fesEleSmallDis2.png,fesEleSmallDis3.png,fesEleSmallDis4.png,fesEleSmallDis5.png,fesEleSmallDis6.png,fesEleSmallDis7.png,fesEleSmallDis8.png,fesEleSmallDis9.png,fesRedBigLight.png,fesRedBombSta1.png,fesRedCap.png,fesRedDown.png,fesRedSmallLight.png,fesRedUp.png,festivalTargetBg.png,lineLight1.png,lineLight10.png,lineLight11.png,lineLight12.png,lineLight13.png,lineLight2.png,lineLight3.png,lineLight4.png,lineLight5.png,lineLight6.png,lineLight7.png,lineLight8.png,lineLight9.png,xingxingbi.png",
            "name": "festival",
            "atlas": {
                "fesEleSmallDis1.png": {
                    "x": 241,
                    "y": 615,
                    "w": 102,
                    "h": 106,
                    "ox": 23,
                    "oy": 24,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis10.png": {
                    "x": 421,
                    "y": 461,
                    "w": 146,
                    "h": 144,
                    "ox": 1,
                    "oy": 6,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis2.png": {
                    "x": 241,
                    "y": 819,
                    "w": 96,
                    "h": 100,
                    "ox": 27,
                    "oy": 27,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis3.png": {
                    "x": 932,
                    "y": 424,
                    "w": 90,
                    "h": 92,
                    "ox": 29,
                    "oy": 31,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis4.png": {
                    "x": 934,
                    "y": 340,
                    "w": 82,
                    "h": 86,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis5.png": {
                    "x": 932,
                    "y": 518,
                    "w": 80,
                    "h": 84,
                    "ox": 34,
                    "oy": 37,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis6.png": {
                    "x": 241,
                    "y": 719,
                    "w": 98,
                    "h": 102,
                    "ox": 25,
                    "oy": 28,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis7.png": {
                    "x": 569,
                    "y": 591,
                    "w": 110,
                    "h": 116,
                    "ox": 19,
                    "oy": 21,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis8.png": {
                    "x": 569,
                    "y": 461,
                    "w": 122,
                    "h": 128,
                    "ox": 13,
                    "oy": 15,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis9.png": {
                    "x": 421,
                    "y": 607,
                    "w": 134,
                    "h": 140,
                    "ox": 7,
                    "oy": 9,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesRedBigLight.png": {
                    "x": 2,
                    "y": 2,
                    "w": 438,
                    "h": 431,
                    "ox": 0,
                    "oy": 0,
                    "sw": 438,
                    "sh": 431,
                    "ro": false
                },
                "fesRedBombSta1.png": {
                    "x": 2,
                    "y": 700,
                    "w": 237,
                    "h": 237,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 237,
                    "ro": false
                },
                "fesRedCap.png": {
                    "x": 737,
                    "y": 120,
                    "w": 251,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 251,
                    "sh": 104,
                    "ro": false
                },
                "fesRedDown.png": {
                    "x": 693,
                    "y": 400,
                    "w": 237,
                    "h": 237,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 237,
                    "ro": false
                },
                "fesRedSmallLight.png": {
                    "x": 442,
                    "y": 300,
                    "w": 249,
                    "h": 159,
                    "ox": 0,
                    "oy": 0,
                    "sw": 249,
                    "sh": 159,
                    "ro": false
                },
                "fesRedUp.png": {
                    "x": 2,
                    "y": 461,
                    "w": 237,
                    "h": 185,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 185,
                    "ro": true
                },
                "festivalTargetBg.png": {
                    "x": 932,
                    "y": 600,
                    "w": 77,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 77,
                    "sh": 98,
                    "ro": false
                },
                "lineLight1.png": {
                    "x": 442,
                    "y": 122,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight10.png": {
                    "x": 737,
                    "y": 2,
                    "w": 285,
                    "h": 56,
                    "ox": 1,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight11.png": {
                    "x": 735,
                    "y": 286,
                    "w": 287,
                    "h": 52,
                    "ox": 1,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight12.png": {
                    "x": 693,
                    "y": 340,
                    "w": 239,
                    "h": 58,
                    "ox": 15,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight13.png": {
                    "x": 442,
                    "y": 122,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight2.png": {
                    "x": 442,
                    "y": 122,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight3.png": {
                    "x": 442,
                    "y": 62,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight4.png": {
                    "x": 735,
                    "y": 226,
                    "w": 287,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight5.png": {
                    "x": 442,
                    "y": 242,
                    "w": 291,
                    "h": 56,
                    "ox": 2,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight6.png": {
                    "x": 442,
                    "y": 182,
                    "w": 291,
                    "h": 58,
                    "ox": 2,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight7.png": {
                    "x": 442,
                    "y": 2,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight8.png": {
                    "x": 442,
                    "y": 2,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight9.png": {
                    "x": 737,
                    "y": 60,
                    "w": 273,
                    "h": 58,
                    "ox": 16,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "xingxingbi.png": {
                    "x": 241,
                    "y": 435,
                    "w": 178,
                    "h": 178,
                    "ox": 0,
                    "oy": 0,
                    "sw": 178,
                    "sh": 178,
                    "ro": false
                }
            }
        },
        {
            "keys": "dis_ele0_0.png,dis_ele0_1.png,dis_ele0_10.png,dis_ele0_11.png,dis_ele0_12.png,dis_ele0_13.png,dis_ele0_14.png,dis_ele0_2.png,dis_ele0_3.png,dis_ele0_4.png,dis_ele0_5.png,dis_ele0_6.png,dis_ele0_7.png,dis_ele0_8.png,dis_ele0_9.png,dis_ele1_0.png,dis_ele1_1.png,dis_ele1_10.png,dis_ele1_11.png,dis_ele1_12.png,dis_ele1_13.png,dis_ele1_14.png,dis_ele1_2.png,dis_ele1_3.png,dis_ele1_4.png,dis_ele1_5.png,dis_ele1_6.png,dis_ele1_7.png,dis_ele1_8.png,dis_ele1_9.png,dis_ele2_0.png,dis_ele2_1.png,dis_ele2_10.png,dis_ele2_11.png,dis_ele2_12.png,dis_ele2_13.png,dis_ele2_14.png,dis_ele2_2.png,dis_ele2_3.png,dis_ele2_4.png,dis_ele2_5.png,dis_ele2_6.png,dis_ele2_7.png,dis_ele2_8.png,dis_ele2_9.png,dis_ele3_.png,dis_ele3_0.png,dis_ele3_1.png,dis_ele3_10.png,dis_ele3_11.png,dis_ele3_12.png,dis_ele3_13.png,dis_ele3_14.png,dis_ele3_2.png,dis_ele3_3.png,dis_ele3_4.png,dis_ele3_6.png,dis_ele3_7.png,dis_ele3_8.png,dis_ele3_9.png,dis_ele4_0.png,dis_ele4_1.png,dis_ele4_10.png,dis_ele4_11.png,dis_ele4_12.png,dis_ele4_13.png,dis_ele4_14.png,dis_ele4_2.png,dis_ele4_3.png,dis_ele4_4.png,dis_ele4_5.png,dis_ele4_6.png,dis_ele4_7.png,dis_ele4_8.png,dis_ele4_9.png,hor_ele0_0.png,hor_ele0_1.png,hor_ele0_10.png,hor_ele0_11.png,hor_ele0_12.png,hor_ele0_13.png,hor_ele0_14.png,hor_ele0_15.png,hor_ele0_2.png,hor_ele0_3.png,hor_ele0_4.png,hor_ele0_5.png,hor_ele0_6.png,hor_ele0_7.png,hor_ele0_8.png,hor_ele0_9.png,hor_ele1_0.png,hor_ele1_1.png,hor_ele1_10.png,hor_ele1_11.png,hor_ele1_12.png,hor_ele1_13.png,hor_ele1_14.png,hor_ele1_15.png,hor_ele1_2.png,hor_ele1_3.png,hor_ele1_4.png,hor_ele1_5.png,hor_ele1_6.png,hor_ele1_7.png,hor_ele1_8.png,hor_ele1_9.png,hor_ele2_0.png,hor_ele2_1.png,hor_ele2_10.png,hor_ele2_11.png,hor_ele2_12.png,hor_ele2_13.png,hor_ele2_14.png,hor_ele2_15.png,hor_ele2_2.png,hor_ele2_3.png,hor_ele2_4.png,hor_ele2_5.png,hor_ele2_6.png,hor_ele2_7.png,hor_ele2_8.png,hor_ele2_9.png,hor_ele3_0.png,hor_ele3_1.png,hor_ele3_10.png,hor_ele3_11.png,hor_ele3_12.png,hor_ele3_13.png,hor_ele3_14.png,hor_ele3_15.png,hor_ele3_2.png,hor_ele3_3.png,hor_ele3_4.png,hor_ele3_5.png,hor_ele3_6.png,hor_ele3_7.png,hor_ele3_8.png,hor_ele3_9.png,hor_ele4_0.png,hor_ele4_1.png,hor_ele4_10.png,hor_ele4_11.png,hor_ele4_12.png,hor_ele4_13.png,hor_ele4_14.png,hor_ele4_15.png,hor_ele4_2.png,hor_ele4_3.png,hor_ele4_4.png,hor_ele4_5.png,hor_ele4_6.png,hor_ele4_7.png,hor_ele4_8.png,hor_ele4_9.png,ver_ele0_0.png,ver_ele0_1.png,ver_ele0_10.png,ver_ele0_11.png,ver_ele0_12.png,ver_ele0_13.png,ver_ele0_14.png,ver_ele0_15.png,ver_ele0_2.png,ver_ele0_3.png,ver_ele0_4.png,ver_ele0_5.png,ver_ele0_6.png,ver_ele0_7.png,ver_ele0_8.png,ver_ele0_9.png,ver_ele1_0.png,ver_ele1_1.png,ver_ele1_10.png,ver_ele1_11.png,ver_ele1_12.png,ver_ele1_13.png,ver_ele1_14.png,ver_ele1_15.png,ver_ele1_2.png,ver_ele1_3.png,ver_ele1_4.png,ver_ele1_5.png,ver_ele1_6.png,ver_ele1_7.png,ver_ele1_8.png,ver_ele1_9.png,ver_ele2_0.png,ver_ele2_1.png,ver_ele2_10.png,ver_ele2_11.png,ver_ele2_12.png,ver_ele2_13.png,ver_ele2_14.png,ver_ele2_15.png,ver_ele2_2.png,ver_ele2_3.png,ver_ele2_4.png,ver_ele2_5.png,ver_ele2_6.png,ver_ele2_7.png,ver_ele2_8.png,ver_ele2_9.png,ver_ele3_0.png,ver_ele3_1.png,ver_ele3_10.png,ver_ele3_11.png,ver_ele3_12.png,ver_ele3_13.png,ver_ele3_14.png,ver_ele3_15.png,ver_ele3_2.png,ver_ele3_3.png,ver_ele3_4.png,ver_ele3_5.png,ver_ele3_6.png,ver_ele3_7.png,ver_ele3_8.png,ver_ele3_9.png,ver_ele4_0.png,ver_ele4_1.png,ver_ele4_10.png,ver_ele4_11.png,ver_ele4_12.png,ver_ele4_13.png,ver_ele4_14.png,ver_ele4_15.png,ver_ele4_2.png,ver_ele4_3.png,ver_ele4_4.png,ver_ele4_5.png,ver_ele4_6.png,ver_ele4_7.png,ver_ele4_8.png,ver_ele4_9.png",
            "name": "fiveVerHorDis",
            "atlas": {
                "dis_ele0_0.png": {
                    "x": 378,
                    "y": 498,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_1.png": {
                    "x": 284,
                    "y": 498,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_10.png": {
                    "x": 920,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_11.png": {
                    "x": 912,
                    "y": 402,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_12.png": {
                    "x": 278,
                    "y": 592,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_13.png": {
                    "x": 186,
                    "y": 592,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_14.png": {
                    "x": 92,
                    "y": 684,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_2.png": {
                    "x": 394,
                    "y": 404,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele0_3.png": {
                    "x": 920,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_4.png": {
                    "x": 818,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_5.png": {
                    "x": 716,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_6.png": {
                    "x": 614,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_7.png": {
                    "x": 512,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_8.png": {
                    "x": 410,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_9.png": {
                    "x": 410,
                    "y": 308,
                    "w": 100,
                    "h": 94,
                    "ox": 0,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_0.png": {
                    "x": 190,
                    "y": 498,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_1.png": {
                    "x": 96,
                    "y": 498,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_10.png": {
                    "x": 818,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_11.png": {
                    "x": 812,
                    "y": 402,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_12.png": {
                    "x": 94,
                    "y": 592,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_13.png": {
                    "x": 2,
                    "y": 592,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_14.png": {
                    "x": 2,
                    "y": 684,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_2.png": {
                    "x": 296,
                    "y": 404,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele1_3.png": {
                    "x": 308,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_4.png": {
                    "x": 206,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_5.png": {
                    "x": 104,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_6.png": {
                    "x": 2,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_7.png": {
                    "x": 920,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_8.png": {
                    "x": 818,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_9.png": {
                    "x": 308,
                    "y": 308,
                    "w": 100,
                    "h": 94,
                    "ox": 0,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_0.png": {
                    "x": 2,
                    "y": 498,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_1.png": {
                    "x": 868,
                    "y": 494,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_10.png": {
                    "x": 716,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_11.png": {
                    "x": 712,
                    "y": 402,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_12.png": {
                    "x": 932,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_13.png": {
                    "x": 840,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_14.png": {
                    "x": 370,
                    "y": 682,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_2.png": {
                    "x": 198,
                    "y": 404,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele2_3.png": {
                    "x": 716,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_4.png": {
                    "x": 614,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_5.png": {
                    "x": 512,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_6.png": {
                    "x": 410,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_7.png": {
                    "x": 308,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_8.png": {
                    "x": 206,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_9.png": {
                    "x": 206,
                    "y": 308,
                    "w": 100,
                    "h": 94,
                    "ox": 0,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_.png": {
                    "x": 104,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_0.png": {
                    "x": 774,
                    "y": 494,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_1.png": {
                    "x": 680,
                    "y": 494,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_10.png": {
                    "x": 614,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_11.png": {
                    "x": 612,
                    "y": 402,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_12.png": {
                    "x": 748,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_13.png": {
                    "x": 656,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_14.png": {
                    "x": 460,
                    "y": 680,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_2.png": {
                    "x": 100,
                    "y": 404,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele3_3.png": {
                    "x": 2,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_4.png": {
                    "x": 920,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_6.png": {
                    "x": 818,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_7.png": {
                    "x": 716,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_8.png": {
                    "x": 614,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_9.png": {
                    "x": 104,
                    "y": 308,
                    "w": 100,
                    "h": 94,
                    "ox": 0,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_0.png": {
                    "x": 586,
                    "y": 494,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_1.png": {
                    "x": 492,
                    "y": 494,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_10.png": {
                    "x": 512,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_11.png": {
                    "x": 512,
                    "y": 402,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_12.png": {
                    "x": 564,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_13.png": {
                    "x": 472,
                    "y": 588,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_14.png": {
                    "x": 370,
                    "y": 592,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_2.png": {
                    "x": 2,
                    "y": 404,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele4_3.png": {
                    "x": 512,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_4.png": {
                    "x": 410,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_5.png": {
                    "x": 308,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_6.png": {
                    "x": 206,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_7.png": {
                    "x": 104,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_8.png": {
                    "x": 2,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_9.png": {
                    "x": 2,
                    "y": 308,
                    "w": 100,
                    "h": 94,
                    "ox": 0,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "hor_ele0_0.png": {
                    "x": 674,
                    "y": 984,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_1.png": {
                    "x": 84,
                    "y": 1078,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_10.png": {
                    "x": 796,
                    "y": 680,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_11.png": {
                    "x": 714,
                    "y": 680,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_12.png": {
                    "x": 632,
                    "y": 680,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_13.png": {
                    "x": 550,
                    "y": 680,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_14.png": {
                    "x": 84,
                    "y": 774,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_15.png": {
                    "x": 2,
                    "y": 774,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_2.png": {
                    "x": 2,
                    "y": 1078,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_3.png": {
                    "x": 248,
                    "y": 1066,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_4.png": {
                    "x": 166,
                    "y": 1066,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_5.png": {
                    "x": 330,
                    "y": 924,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_6.png": {
                    "x": 412,
                    "y": 922,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_7.png": {
                    "x": 510,
                    "y": 910,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_8.png": {
                    "x": 870,
                    "y": 908,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele0_9.png": {
                    "x": 788,
                    "y": 834,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele1_0.png": {
                    "x": 166,
                    "y": 1288,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_1.png": {
                    "x": 330,
                    "y": 1222,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_10.png": {
                    "x": 412,
                    "y": 1220,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_11.png": {
                    "x": 494,
                    "y": 1208,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_12.png": {
                    "x": 576,
                    "y": 1206,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_13.png": {
                    "x": 904,
                    "y": 1138,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_14.png": {
                    "x": 822,
                    "y": 1132,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_15.png": {
                    "x": 740,
                    "y": 1132,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_2.png": {
                    "x": 658,
                    "y": 1132,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_3.png": {
                    "x": 84,
                    "y": 1226,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_4.png": {
                    "x": 2,
                    "y": 1226,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_5.png": {
                    "x": 248,
                    "y": 1214,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_6.png": {
                    "x": 166,
                    "y": 1214,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_7.png": {
                    "x": 330,
                    "y": 1148,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_8.png": {
                    "x": 412,
                    "y": 1146,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele1_9.png": {
                    "x": 494,
                    "y": 1134,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele2_0.png": {
                    "x": 706,
                    "y": 834,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_1.png": {
                    "x": 624,
                    "y": 834,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_10.png": {
                    "x": 84,
                    "y": 928,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_11.png": {
                    "x": 2,
                    "y": 928,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_12.png": {
                    "x": 248,
                    "y": 916,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_13.png": {
                    "x": 166,
                    "y": 916,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_14.png": {
                    "x": 330,
                    "y": 848,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_15.png": {
                    "x": 428,
                    "y": 846,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_2.png": {
                    "x": 542,
                    "y": 834,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_3.png": {
                    "x": 878,
                    "y": 832,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_4.png": {
                    "x": 796,
                    "y": 758,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_5.png": {
                    "x": 714,
                    "y": 758,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_6.png": {
                    "x": 632,
                    "y": 758,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_7.png": {
                    "x": 84,
                    "y": 852,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_8.png": {
                    "x": 2,
                    "y": 852,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele2_9.png": {
                    "x": 248,
                    "y": 840,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_0.png": {
                    "x": 738,
                    "y": 1358,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_1.png": {
                    "x": 82,
                    "y": 1452,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_10.png": {
                    "x": 2,
                    "y": 1452,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_11.png": {
                    "x": 900,
                    "y": 1282,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_12.png": {
                    "x": 820,
                    "y": 1278,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_13.png": {
                    "x": 162,
                    "y": 1442,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_14.png": {
                    "x": 246,
                    "y": 1440,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_15.png": {
                    "x": 328,
                    "y": 1376,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_2.png": {
                    "x": 410,
                    "y": 1374,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_3.png": {
                    "x": 492,
                    "y": 1352,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_4.png": {
                    "x": 576,
                    "y": 1350,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_5.png": {
                    "x": 658,
                    "y": 1348,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_6.png": {
                    "x": 740,
                    "y": 1278,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_7.png": {
                    "x": 82,
                    "y": 1372,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_8.png": {
                    "x": 2,
                    "y": 1372,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele3_9.png": {
                    "x": 166,
                    "y": 1362,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_0.png": {
                    "x": 2,
                    "y": 1676,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_1.png": {
                    "x": 236,
                    "y": 1672,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_10.png": {
                    "x": 158,
                    "y": 1672,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_11.png": {
                    "x": 952,
                    "y": 1798,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "hor_ele4_12.png": {
                    "x": 874,
                    "y": 1798,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_13.png": {
                    "x": 796,
                    "y": 1728,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_14.png": {
                    "x": 718,
                    "y": 1658,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_15.png": {
                    "x": 640,
                    "y": 1654,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_2.png": {
                    "x": 562,
                    "y": 1584,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_3.png": {
                    "x": 320,
                    "y": 1608,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_4.png": {
                    "x": 400,
                    "y": 1606,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_5.png": {
                    "x": 484,
                    "y": 1584,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_6.png": {
                    "x": 80,
                    "y": 1604,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_7.png": {
                    "x": 2,
                    "y": 1604,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_8.png": {
                    "x": 158,
                    "y": 1600,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hor_ele4_9.png": {
                    "x": 80,
                    "y": 1532,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_0.png": {
                    "x": 494,
                    "y": 1282,
                    "w": 80,
                    "h": 68,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_1.png": {
                    "x": 576,
                    "y": 1280,
                    "w": 80,
                    "h": 68,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_10.png": {
                    "x": 166,
                    "y": 840,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_11.png": {
                    "x": 346,
                    "y": 772,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_12.png": {
                    "x": 264,
                    "y": 762,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_13.png": {
                    "x": 182,
                    "y": 762,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_14.png": {
                    "x": 264,
                    "y": 684,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_15.png": {
                    "x": 182,
                    "y": 684,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_2.png": {
                    "x": 658,
                    "y": 1278,
                    "w": 80,
                    "h": 68,
                    "ox": 0,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_3.png": {
                    "x": 904,
                    "y": 1212,
                    "w": 80,
                    "h": 68,
                    "ox": 0,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_4.png": {
                    "x": 822,
                    "y": 1206,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_5.png": {
                    "x": 740,
                    "y": 1206,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_6.png": {
                    "x": 658,
                    "y": 1206,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_7.png": {
                    "x": 84,
                    "y": 1300,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_8.png": {
                    "x": 330,
                    "y": 1000,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele0_9.png": {
                    "x": 412,
                    "y": 998,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele1_0.png": {
                    "x": 576,
                    "y": 1132,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_1.png": {
                    "x": 904,
                    "y": 1064,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_10.png": {
                    "x": 822,
                    "y": 1058,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_11.png": {
                    "x": 740,
                    "y": 1058,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_12.png": {
                    "x": 658,
                    "y": 1058,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_13.png": {
                    "x": 84,
                    "y": 1152,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_14.png": {
                    "x": 2,
                    "y": 1152,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_15.png": {
                    "x": 248,
                    "y": 1140,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_2.png": {
                    "x": 166,
                    "y": 1140,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_3.png": {
                    "x": 330,
                    "y": 1074,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_4.png": {
                    "x": 412,
                    "y": 1072,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_5.png": {
                    "x": 494,
                    "y": 1060,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_6.png": {
                    "x": 576,
                    "y": 1058,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_7.png": {
                    "x": 920,
                    "y": 990,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_8.png": {
                    "x": 838,
                    "y": 984,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele1_9.png": {
                    "x": 756,
                    "y": 984,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele2_0.png": {
                    "x": 2,
                    "y": 1300,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_1.png": {
                    "x": 248,
                    "y": 1288,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_10.png": {
                    "x": 460,
                    "y": 770,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_11.png": {
                    "x": 494,
                    "y": 986,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_12.png": {
                    "x": 592,
                    "y": 984,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_13.png": {
                    "x": 756,
                    "y": 910,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_14.png": {
                    "x": 674,
                    "y": 910,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_15.png": {
                    "x": 592,
                    "y": 910,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_2.png": {
                    "x": 952,
                    "y": 908,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ver_ele2_3.png": {
                    "x": 84,
                    "y": 1004,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_4.png": {
                    "x": 2,
                    "y": 1004,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_5.png": {
                    "x": 248,
                    "y": 992,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_6.png": {
                    "x": 166,
                    "y": 992,
                    "w": 80,
                    "h": 72,
                    "ox": 0,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_7.png": {
                    "x": 550,
                    "y": 758,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_8.png": {
                    "x": 878,
                    "y": 756,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele2_9.png": {
                    "x": 878,
                    "y": 680,
                    "w": 80,
                    "h": 74,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_0.png": {
                    "x": 570,
                    "y": 1508,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_1.png": {
                    "x": 652,
                    "y": 1506,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_10.png": {
                    "x": 162,
                    "y": 1522,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_11.png": {
                    "x": 242,
                    "y": 1520,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_12.png": {
                    "x": 326,
                    "y": 1456,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_13.png": {
                    "x": 408,
                    "y": 1454,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_14.png": {
                    "x": 490,
                    "y": 1432,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_15.png": {
                    "x": 572,
                    "y": 1430,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_2.png": {
                    "x": 736,
                    "y": 1438,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_3.png": {
                    "x": 818,
                    "y": 1436,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_4.png": {
                    "x": 898,
                    "y": 1362,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_5.png": {
                    "x": 818,
                    "y": 1358,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_6.png": {
                    "x": 656,
                    "y": 1428,
                    "w": 78,
                    "h": 76,
                    "ox": 1,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_7.png": {
                    "x": 248,
                    "y": 1360,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_8.png": {
                    "x": 330,
                    "y": 1296,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele3_9.png": {
                    "x": 412,
                    "y": 1294,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_0.png": {
                    "x": 242,
                    "y": 1598,
                    "w": 76,
                    "h": 72,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_1.png": {
                    "x": 322,
                    "y": 1534,
                    "w": 76,
                    "h": 72,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_10.png": {
                    "x": 2,
                    "y": 1532,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_11.png": {
                    "x": 884,
                    "y": 1726,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_12.png": {
                    "x": 806,
                    "y": 1656,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_13.png": {
                    "x": 888,
                    "y": 1654,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_14.png": {
                    "x": 728,
                    "y": 1586,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_15.png": {
                    "x": 810,
                    "y": 1584,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_2.png": {
                    "x": 406,
                    "y": 1532,
                    "w": 76,
                    "h": 72,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_3.png": {
                    "x": 488,
                    "y": 1510,
                    "w": 76,
                    "h": 72,
                    "ox": 4,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_4.png": {
                    "x": 894,
                    "y": 1582,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_5.png": {
                    "x": 650,
                    "y": 1582,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_6.png": {
                    "x": 732,
                    "y": 1514,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_7.png": {
                    "x": 816,
                    "y": 1512,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_8.png": {
                    "x": 898,
                    "y": 1510,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ver_ele4_9.png": {
                    "x": 898,
                    "y": 1438,
                    "w": 76,
                    "h": 70,
                    "ox": 4,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                }
            }
        },
        {
            "keys": "圆圈.png,开心收下.png",
            "name": "FreePowerPanel",
            "atlas": {
                "圆圈.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 799,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 799,
                    "ro": false
                },
                "开心收下.png": {
                    "x": 2,
                    "y": 803,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "joinBg.png,joinBtn.png",
            "name": "JoinPanel",
            "atlas": {
                "joinBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 438,
                    "ox": 55,
                    "oy": 497,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "joinBtn.png": {
                    "x": 2,
                    "y": 644,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "carb_arm.png,carb_body.png,carb_hand_l.png,carb_hand_r.png,fox_arm_l.png,fox_body.png,fox_head.png,fox_tail0.png,fox_tail1.png,fox_tail10.png,fox_tail11.png,fox_tail12.png,fox_tail13.png,fox_tail14.png,fox_tail2.png,fox_tail3.png,fox_tail4.png,fox_tail5.png,fox_tail6.png,fox_tail7.png,fox_tail8.png,fox_tail9.png,hommer.png,img_line1.png,img_line2.png,img_line3.png,img_line4.png,img_line5.png,img_owl.png,img_tree.png,lighting_1.png,lighting_2.png,loadingBg.jpg,loadingBg2.png,loadingPro0.png,loadingPro1.png,loadingPro10.png,loadingPro11.png,loadingPro2.png,loadingPro3.png,loadingPro4.png,loadingPro5.png,loadingPro6.png,loadingPro7.png,loadingPro8.png,loadingPro9.png,loadingTitle.png,owl_sleep.png,proDown.png,wheel.png",
            "name": "loadingScene",
            "atlas": {
                "carb_arm.png": {
                    "x": 1875,
                    "y": 350,
                    "w": 18,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 24,
                    "ro": false
                },
                "carb_body.png": {
                    "x": 1904,
                    "y": 62,
                    "w": 129,
                    "h": 101,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 101,
                    "ro": false
                },
                "carb_hand_l.png": {
                    "x": 1250,
                    "y": 262,
                    "w": 43,
                    "h": 54,
                    "ox": 0,
                    "oy": 0,
                    "sw": 43,
                    "sh": 54,
                    "ro": true
                },
                "carb_hand_r.png": {
                    "x": 1250,
                    "y": 307,
                    "w": 42,
                    "h": 54,
                    "ox": 0,
                    "oy": 0,
                    "sw": 42,
                    "sh": 54,
                    "ro": true
                },
                "fox_arm_l.png": {
                    "x": 1904,
                    "y": 2,
                    "w": 133,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 133,
                    "sh": 58,
                    "ro": false
                },
                "fox_body.png": {
                    "x": 454,
                    "y": 958,
                    "w": 170,
                    "h": 216,
                    "ox": 0,
                    "oy": 0,
                    "sw": 170,
                    "sh": 216,
                    "ro": true
                },
                "fox_head.png": {
                    "x": 1573,
                    "y": 494,
                    "w": 289,
                    "h": 289,
                    "ox": 0,
                    "oy": 0,
                    "sw": 289,
                    "sh": 289,
                    "ro": false
                },
                "fox_tail0.png": {
                    "x": 1279,
                    "y": 653,
                    "w": 188,
                    "h": 236,
                    "ox": 2,
                    "oy": 3,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail1.png": {
                    "x": 1637,
                    "y": 296,
                    "w": 196,
                    "h": 236,
                    "ox": 1,
                    "oy": 5,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail10.png": {
                    "x": 896,
                    "y": 947,
                    "w": 206,
                    "h": 208,
                    "ox": 0,
                    "oy": 33,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail11.png": {
                    "x": 1110,
                    "y": 843,
                    "w": 198,
                    "h": 210,
                    "ox": 1,
                    "oy": 30,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail12.png": {
                    "x": 2,
                    "y": 1156,
                    "w": 190,
                    "h": 212,
                    "ox": 1,
                    "oy": 27,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail13.png": {
                    "x": 676,
                    "y": 785,
                    "w": 190,
                    "h": 218,
                    "ox": 1,
                    "oy": 21,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail14.png": {
                    "x": 2,
                    "y": 746,
                    "w": 188,
                    "h": 226,
                    "ox": 2,
                    "oy": 13,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail2.png": {
                    "x": 1751,
                    "y": 813,
                    "w": 204,
                    "h": 232,
                    "ox": 0,
                    "oy": 11,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail3.png": {
                    "x": 1517,
                    "y": 785,
                    "w": 210,
                    "h": 232,
                    "ox": 0,
                    "oy": 14,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail4.png": {
                    "x": 754,
                    "y": 569,
                    "w": 214,
                    "h": 228,
                    "ox": 0,
                    "oy": 19,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail5.png": {
                    "x": 2,
                    "y": 936,
                    "w": 218,
                    "h": 222,
                    "ox": 0,
                    "oy": 26,
                    "sw": 230,
                    "sh": 260,
                    "ro": true
                },
                "fox_tail6.png": {
                    "x": 230,
                    "y": 746,
                    "w": 222,
                    "h": 218,
                    "ox": 0,
                    "oy": 32,
                    "sw": 230,
                    "sh": 260,
                    "ro": false
                },
                "fox_tail7.png": {
                    "x": 984,
                    "y": 569,
                    "w": 226,
                    "h": 216,
                    "ox": 0,
                    "oy": 34,
                    "sw": 230,
                    "sh": 260,
                    "ro": false
                },
                "fox_tail8.png": {
                    "x": 454,
                    "y": 746,
                    "w": 220,
                    "h": 210,
                    "ox": 1,
                    "oy": 36,
                    "sw": 230,
                    "sh": 260,
                    "ro": false
                },
                "fox_tail9.png": {
                    "x": 226,
                    "y": 966,
                    "w": 214,
                    "h": 208,
                    "ox": 0,
                    "oy": 35,
                    "sw": 230,
                    "sh": 260,
                    "ro": false
                },
                "hommer.png": {
                    "x": 896,
                    "y": 787,
                    "w": 158,
                    "h": 212,
                    "ox": 0,
                    "oy": 0,
                    "sw": 158,
                    "sh": 212,
                    "ro": true
                },
                "img_line1.png": {
                    "x": 1306,
                    "y": 296,
                    "w": 32,
                    "h": 329,
                    "ox": 0,
                    "oy": 0,
                    "sw": 32,
                    "sh": 329,
                    "ro": true
                },
                "img_line2.png": {
                    "x": 1250,
                    "y": 351,
                    "w": 27,
                    "h": 309,
                    "ox": 0,
                    "oy": 0,
                    "sw": 27,
                    "sh": 309,
                    "ro": false
                },
                "img_line3.png": {
                    "x": 2010,
                    "y": 165,
                    "w": 36,
                    "h": 355,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 355,
                    "ro": false
                },
                "img_line4.png": {
                    "x": 1985,
                    "y": 522,
                    "w": 26,
                    "h": 309,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 309,
                    "ro": false
                },
                "img_line5.png": {
                    "x": 1306,
                    "y": 330,
                    "w": 31,
                    "h": 329,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 329,
                    "ro": true
                },
                "img_owl.png": {
                    "x": 1895,
                    "y": 360,
                    "w": 96,
                    "h": 112,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 112,
                    "ro": true
                },
                "img_tree.png": {
                    "x": 1864,
                    "y": 647,
                    "w": 164,
                    "h": 104,
                    "ox": 0,
                    "oy": 6,
                    "sw": 164,
                    "sh": 110,
                    "ro": true
                },
                "lighting_1.png": {
                    "x": 1875,
                    "y": 458,
                    "w": 187,
                    "h": 108,
                    "ox": 20,
                    "oy": 11,
                    "sw": 207,
                    "sh": 122,
                    "ro": true
                },
                "lighting_2.png": {
                    "x": 1896,
                    "y": 165,
                    "w": 193,
                    "h": 112,
                    "ox": 0,
                    "oy": 8,
                    "sw": 207,
                    "sh": 122,
                    "ro": true
                },
                "loadingBg2.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 742,
                    "ox": 0,
                    "oy": 848,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "loadingPro0.png": {
                    "x": 1325,
                    "y": 254,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro1.png": {
                    "x": 754,
                    "y": 220,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro10.png": {
                    "x": 1325,
                    "y": 212,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro11.png": {
                    "x": 754,
                    "y": 178,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro2.png": {
                    "x": 1325,
                    "y": 170,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro3.png": {
                    "x": 754,
                    "y": 136,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro4.png": {
                    "x": 1325,
                    "y": 128,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro5.png": {
                    "x": 754,
                    "y": 94,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro6.png": {
                    "x": 1325,
                    "y": 86,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro7.png": {
                    "x": 754,
                    "y": 52,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro8.png": {
                    "x": 1333,
                    "y": 44,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro9.png": {
                    "x": 1333,
                    "y": 2,
                    "w": 569,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 569,
                    "sh": 40,
                    "ro": false
                },
                "loadingTitle.png": {
                    "x": 754,
                    "y": 262,
                    "w": 494,
                    "h": 305,
                    "ox": 0,
                    "oy": 0,
                    "sw": 494,
                    "sh": 305,
                    "ro": false
                },
                "owl_sleep.png": {
                    "x": 1875,
                    "y": 296,
                    "w": 52,
                    "h": 19,
                    "ox": 0,
                    "oy": 0,
                    "sw": 52,
                    "sh": 19,
                    "ro": true
                },
                "proDown.png": {
                    "x": 754,
                    "y": 2,
                    "w": 577,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 577,
                    "sh": 48,
                    "ro": false
                },
                "wheel.png": {
                    "x": 1279,
                    "y": 363,
                    "w": 288,
                    "h": 292,
                    "ox": 10,
                    "oy": 4,
                    "sw": 300,
                    "sh": 300,
                    "ro": true
                }
            }
        },
        {
            "keys": "lotteryBtn.png,lotteryItemBg.png,lotteryMachineBg.jpg,lotteryReturnBtn.png,prizeItemBg.png,shadowMask.png",
            "name": "lotteryScene",
            "atlas": {
                "lotteryBtn.png": {
                    "x": 2,
                    "y": 2,
                    "w": 350,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 350,
                    "sh": 80,
                    "ro": false
                },
                "lotteryItemBg.png": {
                    "x": 199,
                    "y": 84,
                    "w": 103,
                    "h": 108,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 108,
                    "ro": true
                },
                "lotteryReturnBtn.png": {
                    "x": 354,
                    "y": 2,
                    "w": 124,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 124,
                    "sh": 56,
                    "ro": false
                },
                "prizeItemBg.png": {
                    "x": 354,
                    "y": 60,
                    "w": 109,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 109,
                    "ro": false
                },
                "shadowMask.png": {
                    "x": 2,
                    "y": 171,
                    "w": 338,
                    "h": 195,
                    "ox": 0,
                    "oy": 0,
                    "sw": 338,
                    "sh": 195,
                    "ro": true
                }
            }
        },
        {
            "keys": "cur_light_1.png,cur_light_2.png,guide_fox.png,guide_hand.png,guide_light.png,guide_tip.png,map_avatar_bg.png,map_bg1.jpg,map_bg2.jpg,map_bg3.jpg,map_check_disable.png,map_check_disable_prize.png,map_check_enable.png,map_check_enable_cur.png,map_creditsBg.png,map_energyAdd.png,map_energyBg.png,map_prizeBox.png,map_prizeBtn.png,map_ruleBtn.png,map_star_disable.png,map_star_enable.png,map_taskBtn.png,map_推车.png,map_狐狸气球.png,water1.png,water2.png",
            "name": "map",
            "atlas": {
                "cur_light_1.png": {
                    "x": 220,
                    "y": 206,
                    "w": 187,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 197,
                    "sh": 123,
                    "ro": true
                },
                "cur_light_2.png": {
                    "x": 132,
                    "y": 880,
                    "w": 127,
                    "h": 101,
                    "ox": 36,
                    "oy": 9,
                    "sw": 197,
                    "sh": 123,
                    "ro": true
                },
                "guide_fox.png": {
                    "x": 275,
                    "y": 793,
                    "w": 202,
                    "h": 219,
                    "ox": 0,
                    "oy": 0,
                    "sw": 202,
                    "sh": 219,
                    "ro": false
                },
                "guide_hand.png": {
                    "x": 573,
                    "y": 113,
                    "w": 90,
                    "h": 91,
                    "ox": 0,
                    "oy": 0,
                    "sw": 90,
                    "sh": 91,
                    "ro": false
                },
                "guide_light.png": {
                    "x": 380,
                    "y": 156,
                    "w": 40,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 40,
                    "ro": false
                },
                "guide_tip.png": {
                    "x": 2,
                    "y": 484,
                    "w": 394,
                    "h": 166,
                    "ox": 0,
                    "oy": 0,
                    "sw": 394,
                    "sh": 166,
                    "ro": true
                },
                "map_avatar_bg.png": {
                    "x": 481,
                    "y": 289,
                    "w": 95,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 104,
                    "ro": false
                },
                "map_check_disable.png": {
                    "x": 481,
                    "y": 178,
                    "w": 109,
                    "h": 90,
                    "ox": 0,
                    "oy": 14,
                    "sw": 109,
                    "sh": 104,
                    "ro": true
                },
                "map_check_disable_prize.png": {
                    "x": 511,
                    "y": 2,
                    "w": 109,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 104,
                    "ro": true
                },
                "map_check_enable.png": {
                    "x": 220,
                    "y": 395,
                    "w": 103,
                    "h": 82,
                    "ox": 1,
                    "oy": 16,
                    "sw": 109,
                    "sh": 104,
                    "ro": false
                },
                "map_check_enable_cur.png": {
                    "x": 170,
                    "y": 793,
                    "w": 103,
                    "h": 82,
                    "ox": 2,
                    "oy": 15,
                    "sw": 109,
                    "sh": 104,
                    "ro": false
                },
                "map_creditsBg.png": {
                    "x": 325,
                    "y": 395,
                    "w": 185,
                    "h": 71,
                    "ox": 0,
                    "oy": 0,
                    "sw": 185,
                    "sh": 71,
                    "ro": false
                },
                "map_energyAdd.png": {
                    "x": 235,
                    "y": 877,
                    "w": 35,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 33,
                    "ro": false
                },
                "map_energyBg.png": {
                    "x": 337,
                    "y": 206,
                    "w": 185,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 185,
                    "sh": 70,
                    "ro": true
                },
                "map_prizeBox.png": {
                    "x": 220,
                    "y": 2,
                    "w": 158,
                    "h": 202,
                    "ox": 0,
                    "oy": 0,
                    "sw": 158,
                    "sh": 202,
                    "ro": false
                },
                "map_prizeBtn.png": {
                    "x": 409,
                    "y": 198,
                    "w": 152,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 70,
                    "ro": true
                },
                "map_ruleBtn.png": {
                    "x": 380,
                    "y": 2,
                    "w": 152,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 70,
                    "ro": true
                },
                "map_star_disable.png": {
                    "x": 235,
                    "y": 939,
                    "w": 25,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 24,
                    "ro": false
                },
                "map_star_enable.png": {
                    "x": 235,
                    "y": 912,
                    "w": 26,
                    "h": 25,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 25,
                    "ro": false
                },
                "map_taskBtn.png": {
                    "x": 2,
                    "y": 880,
                    "w": 133,
                    "h": 128,
                    "ox": 0,
                    "oy": 0,
                    "sw": 133,
                    "sh": 128,
                    "ro": true
                },
                "map_推车.png": {
                    "x": 170,
                    "y": 484,
                    "w": 247,
                    "h": 307,
                    "ox": 0,
                    "oy": 0,
                    "sw": 247,
                    "sh": 307,
                    "ro": false
                },
                "map_狐狸气球.png": {
                    "x": 2,
                    "y": 2,
                    "w": 216,
                    "h": 480,
                    "ox": 0,
                    "oy": 0,
                    "sw": 216,
                    "sh": 480,
                    "ro": false
                },
                "water1.png": {
                    "x": 452,
                    "y": 119,
                    "w": 57,
                    "h": 101,
                    "ox": 0,
                    "oy": 0,
                    "sw": 57,
                    "sh": 115,
                    "ro": true
                },
                "water2.png": {
                    "x": 452,
                    "y": 2,
                    "w": 57,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 57,
                    "sh": 115,
                    "ro": false
                }
            }
        },
        {
            "keys": "prize_check_0.png,prize_check_1.png,prize_check_10.png,prize_check_11.png,prize_check_12.png,prize_check_13.png,prize_check_14.png,prize_check_15.png,prize_check_16.png,prize_check_2.png,prize_check_3.png,prize_check_4.png,prize_check_5.png,prize_check_6.png,prize_check_7.png,prize_check_8.png,prize_check_9.png",
            "name": "mapCheckPrizeEffect",
            "atlas": {
                "prize_check_0.png": {
                    "x": 214,
                    "y": 218,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_1.png": {
                    "x": 108,
                    "y": 322,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_10.png": {
                    "x": 214,
                    "y": 218,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_11.png": {
                    "x": 2,
                    "y": 322,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_12.png": {
                    "x": 338,
                    "y": 216,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_13.png": {
                    "x": 226,
                    "y": 110,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_14.png": {
                    "x": 2,
                    "y": 112,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_15.png": {
                    "x": 114,
                    "y": 110,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_16.png": {
                    "x": 338,
                    "y": 2,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_2.png": {
                    "x": 338,
                    "y": 110,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_3.png": {
                    "x": 2,
                    "y": 322,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_4.png": {
                    "x": 214,
                    "y": 218,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_5.png": {
                    "x": 226,
                    "y": 2,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_6.png": {
                    "x": 114,
                    "y": 2,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_7.png": {
                    "x": 2,
                    "y": 2,
                    "w": 110,
                    "h": 108,
                    "ox": 5,
                    "oy": 2,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_8.png": {
                    "x": 114,
                    "y": 2,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_9.png": {
                    "x": 226,
                    "y": 2,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                }
            }
        },
        {
            "keys": "map_crab_0.png,map_crab_1.png,map_crab_10.png,map_crab_11.png,map_crab_12.png,map_crab_13.png,map_crab_14.png,map_crab_15.png,map_crab_16.png,map_crab_17.png,map_crab_18.png,map_crab_19.png,map_crab_2.png,map_crab_20.png,map_crab_21.png,map_crab_22.png,map_crab_23.png,map_crab_24.png,map_crab_25.png,map_crab_26.png,map_crab_27.png,map_crab_28.png,map_crab_29.png,map_crab_3.png,map_crab_30.png,map_crab_4.png,map_crab_5.png,map_crab_6.png,map_crab_7.png,map_crab_8.png,map_crab_9.png",
            "name": "mapCrabEffect",
            "atlas": {
                "map_crab_0.png": {
                    "x": 106,
                    "y": 500,
                    "w": 102,
                    "h": 82,
                    "ox": 2,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_1.png": {
                    "x": 320,
                    "y": 496,
                    "w": 104,
                    "h": 82,
                    "ox": 2,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_10.png": {
                    "x": 326,
                    "y": 330,
                    "w": 106,
                    "h": 80,
                    "ox": 16,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_11.png": {
                    "x": 218,
                    "y": 330,
                    "w": 106,
                    "h": 80,
                    "ox": 17,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_12.png": {
                    "x": 214,
                    "y": 496,
                    "w": 104,
                    "h": 82,
                    "ox": 20,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_13.png": {
                    "x": 108,
                    "y": 416,
                    "w": 104,
                    "h": 82,
                    "ox": 21,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_14.png": {
                    "x": 2,
                    "y": 500,
                    "w": 102,
                    "h": 82,
                    "ox": 24,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_15.png": {
                    "x": 2,
                    "y": 416,
                    "w": 104,
                    "h": 82,
                    "ox": 24,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_16.png": {
                    "x": 426,
                    "y": 518,
                    "w": 102,
                    "h": 82,
                    "ox": 27,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": true
                },
                "map_crab_17.png": {
                    "x": 426,
                    "y": 412,
                    "w": 104,
                    "h": 82,
                    "ox": 28,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": true
                },
                "map_crab_18.png": {
                    "x": 110,
                    "y": 248,
                    "w": 106,
                    "h": 82,
                    "ox": 28,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_19.png": {
                    "x": 326,
                    "y": 248,
                    "w": 106,
                    "h": 80,
                    "ox": 30,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_2.png": {
                    "x": 320,
                    "y": 412,
                    "w": 104,
                    "h": 82,
                    "ox": 4,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_20.png": {
                    "x": 332,
                    "y": 166,
                    "w": 108,
                    "h": 80,
                    "ox": 31,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_21.png": {
                    "x": 114,
                    "y": 84,
                    "w": 110,
                    "h": 80,
                    "ox": 31,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_22.png": {
                    "x": 2,
                    "y": 84,
                    "w": 110,
                    "h": 80,
                    "ox": 32,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_23.png": {
                    "x": 338,
                    "y": 2,
                    "w": 110,
                    "h": 80,
                    "ox": 34,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_24.png": {
                    "x": 222,
                    "y": 166,
                    "w": 108,
                    "h": 80,
                    "ox": 37,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_25.png": {
                    "x": 112,
                    "y": 166,
                    "w": 108,
                    "h": 80,
                    "ox": 38,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_26.png": {
                    "x": 218,
                    "y": 248,
                    "w": 106,
                    "h": 80,
                    "ox": 41,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_27.png": {
                    "x": 2,
                    "y": 248,
                    "w": 106,
                    "h": 82,
                    "ox": 42,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_28.png": {
                    "x": 214,
                    "y": 412,
                    "w": 104,
                    "h": 82,
                    "ox": 45,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_29.png": {
                    "x": 108,
                    "y": 332,
                    "w": 104,
                    "h": 82,
                    "ox": 46,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_3.png": {
                    "x": 2,
                    "y": 332,
                    "w": 104,
                    "h": 82,
                    "ox": 6,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_30.png": {
                    "x": 106,
                    "y": 500,
                    "w": 102,
                    "h": 82,
                    "ox": 49,
                    "oy": 35,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_4.png": {
                    "x": 2,
                    "y": 166,
                    "w": 108,
                    "h": 80,
                    "ox": 5,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_5.png": {
                    "x": 336,
                    "y": 84,
                    "w": 108,
                    "h": 80,
                    "ox": 7,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_6.png": {
                    "x": 226,
                    "y": 2,
                    "w": 110,
                    "h": 80,
                    "ox": 7,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_7.png": {
                    "x": 114,
                    "y": 2,
                    "w": 110,
                    "h": 80,
                    "ox": 9,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_8.png": {
                    "x": 2,
                    "y": 2,
                    "w": 110,
                    "h": 80,
                    "ox": 10,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                },
                "map_crab_9.png": {
                    "x": 226,
                    "y": 84,
                    "w": 108,
                    "h": 80,
                    "ox": 13,
                    "oy": 37,
                    "sw": 160,
                    "sh": 120,
                    "ro": false
                }
            }
        },
        {
            "keys": "map_owl_0.png,map_owl_1.png,map_owl_10.png,map_owl_11.png,map_owl_12.png,map_owl_13.png,map_owl_14.png,map_owl_15.png,map_owl_2.png,map_owl_3.png,map_owl_4.png,map_owl_5.png,map_owl_6.png,map_owl_7.png,map_owl_8.png,map_owl_9.png",
            "name": "mapOwlEffect",
            "atlas": {
                "map_owl_0.png": {
                    "x": 174,
                    "y": 2,
                    "w": 74,
                    "h": 84,
                    "ox": 17,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "map_owl_1.png": {
                    "x": 88,
                    "y": 2,
                    "w": 74,
                    "h": 84,
                    "ox": 17,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_10.png": {
                    "x": 88,
                    "y": 370,
                    "w": 70,
                    "h": 84,
                    "ox": 25,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_11.png": {
                    "x": 2,
                    "y": 226,
                    "w": 72,
                    "h": 84,
                    "ox": 24,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_12.png": {
                    "x": 174,
                    "y": 346,
                    "w": 70,
                    "h": 84,
                    "ox": 26,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "map_owl_13.png": {
                    "x": 174,
                    "y": 174,
                    "w": 72,
                    "h": 84,
                    "ox": 25,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "map_owl_14.png": {
                    "x": 88,
                    "y": 152,
                    "w": 72,
                    "h": 84,
                    "ox": 25,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_15.png": {
                    "x": 2,
                    "y": 152,
                    "w": 72,
                    "h": 84,
                    "ox": 25,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_2.png": {
                    "x": 2,
                    "y": 2,
                    "w": 74,
                    "h": 84,
                    "ox": 17,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_3.png": {
                    "x": 174,
                    "y": 88,
                    "w": 72,
                    "h": 84,
                    "ox": 19,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "map_owl_4.png": {
                    "x": 88,
                    "y": 78,
                    "w": 72,
                    "h": 84,
                    "ox": 20,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_5.png": {
                    "x": 2,
                    "y": 78,
                    "w": 72,
                    "h": 84,
                    "ox": 20,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_6.png": {
                    "x": 2,
                    "y": 300,
                    "w": 70,
                    "h": 84,
                    "ox": 22,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_7.png": {
                    "x": 88,
                    "y": 298,
                    "w": 70,
                    "h": 84,
                    "ox": 23,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                },
                "map_owl_8.png": {
                    "x": 174,
                    "y": 260,
                    "w": 70,
                    "h": 84,
                    "ox": 24,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "map_owl_9.png": {
                    "x": 88,
                    "y": 226,
                    "w": 70,
                    "h": 84,
                    "ox": 24,
                    "oy": 25,
                    "sw": 120,
                    "sh": 120,
                    "ro": true
                }
            }
        },
        {
            "keys": "map_whale_0.png,map_whale_1.png,map_whale_10.png,map_whale_11.png,map_whale_12.png,map_whale_2.png,map_whale_3.png,map_whale_4.png,map_whale_5.png,map_whale_6.png,map_whale_7.png,map_whale_8.png,map_whale_9.png",
            "name": "mapWhaleEffect",
            "atlas": {
                "map_whale_0.png": {
                    "x": 2,
                    "y": 158,
                    "w": 154,
                    "h": 122,
                    "ox": 5,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_1.png": {
                    "x": 2,
                    "y": 2,
                    "w": 154,
                    "h": 122,
                    "ox": 5,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_10.png": {
                    "x": 2,
                    "y": 1828,
                    "w": 148,
                    "h": 122,
                    "ox": 6,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_11.png": {
                    "x": 2,
                    "y": 1678,
                    "w": 148,
                    "h": 122,
                    "ox": 5,
                    "oy": 17,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_12.png": {
                    "x": 2,
                    "y": 1528,
                    "w": 148,
                    "h": 122,
                    "ox": 5,
                    "oy": 17,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_2.png": {
                    "x": 2,
                    "y": 314,
                    "w": 152,
                    "h": 122,
                    "ox": 6,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_3.png": {
                    "x": 2,
                    "y": 1076,
                    "w": 150,
                    "h": 122,
                    "ox": 7,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_4.png": {
                    "x": 2,
                    "y": 924,
                    "w": 150,
                    "h": 122,
                    "ox": 7,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_5.png": {
                    "x": 2,
                    "y": 772,
                    "w": 150,
                    "h": 122,
                    "ox": 6,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_6.png": {
                    "x": 2,
                    "y": 620,
                    "w": 150,
                    "h": 122,
                    "ox": 6,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_7.png": {
                    "x": 2,
                    "y": 1378,
                    "w": 148,
                    "h": 122,
                    "ox": 7,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_8.png": {
                    "x": 2,
                    "y": 468,
                    "w": 150,
                    "h": 122,
                    "ox": 5,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                },
                "map_whale_9.png": {
                    "x": 2,
                    "y": 1228,
                    "w": 148,
                    "h": 122,
                    "ox": 6,
                    "oy": 16,
                    "sw": 160,
                    "sh": 160,
                    "ro": true
                }
            }
        },
        {
            "keys": "体力不足Bg.png,体力不足按钮.png",
            "name": "NoEnergyPanel",
            "atlas": {
                "体力不足Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 567,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 567,
                    "ro": false
                },
                "体力不足按钮.png": {
                    "x": 2,
                    "y": 571,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": true
                }
            }
        },
        {
            "keys": "noPrizeBg.png,知道了.png",
            "name": "NoPrizePanel",
            "atlas": {
                "noPrizeBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 438,
                    "ox": 55,
                    "oy": 497,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "知道了.png": {
                    "x": 2,
                    "y": 644,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "步数耗尽Bg.png,步数耗尽复活.png,步数耗尽结束按钮.png",
            "name": "NoStepPanel",
            "atlas": {
                "步数耗尽Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 527,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 527,
                    "ro": false
                },
                "步数耗尽复活.png": {
                    "x": 644,
                    "y": 118,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                },
                "步数耗尽结束按钮.png": {
                    "x": 644,
                    "y": 2,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "blueDoorBg.png,bonusFra0.png,bonusFra1.png,bonusFra10.png,bonusFra11.png,bonusFra2.png,bonusFra3.png,bonusFra4.png,bonusFra5.png,bonusFra6.png,bonusFra7.png,bonusFra8.png,bonusFra9.png,bonusShoot.png,boom0.png,boom1.png,boom10.png,boom11.png,boom12.png,boom13.png,boom14.png,boom15.png,boom16.png,boom17.png,boom18.png,boom19.png,boom2.png,boom20.png,boom3.png,boom4.png,boom5.png,boom6.png,boom7.png,boom8.png,boom9.png,brownBallFace.png,bubbleStar1.png,bubbleStar10.png,bubbleStar11.png,bubbleStar12.png,bubbleStar13.png,bubbleStar14.png,bubbleStar15.png,bubbleStar16.png,bubbleStar17.png,bubbleStar18.png,bubbleStar19.png,bubbleStar2.png,bubbleStar3.png,bubbleStar4.png,bubbleStar5.png,bubbleStar6.png,bubbleStar7.png,bubbleStar8.png,bubbleStar9.png,bubleEle0.png,bubleEle1.png,bubleEle2.png,bubleEle3.png,bubleEle4.png,chapterNum0.png,chapterNum1.png,chapterNum2.png,chapterNum3.png,chapterNum4.png,chapterNum5.png,chapterNum6.png,chapterNum7.png,chapterNum8.png,chapterNum9.png,chapterNum关.png,chapterNum第.png,chooseRect.png,doorClosed.png,doorOpen.png,eggPiece1.png,eggPiece2.png,eggPiece3.png,eggPiece4.png,eggPiece5.png,eggStatus0.png,eggStatus1.png,eggStatus2.png,ele0Exp.png,ele1Exp.png,ele2Exp.png,ele3Exp.png,ele4Exp.png,exLighting0.png,exLighting10.png,exLighting13.png,exLighting15.png,exLighting17.png,exLighting18.png,exLighting2.png,exLighting20.png,exLighting22.png,exLighting24.png,exLighting26.png,exLighting28.png,exLighting31.png,exLighting33.png,exLighting4.png,exLighting6.png,exLighting8.png,eyeDownLeft.png,eyeDownRight.png,eyeSingle.png,gameGuideBoard.png,greenCircleDown.png,greenCircleUp.png,greyBallFace.png,guidePropBoom.png,guidePropCow.png,guidePropHammer.png,guidePropHand.png,guidePropMsgPanel.png,guidePropShoe.png,hairballDisBg.png,hairballPiece1.png,hairballPiece2.png,hairballPiece3.png,hairballPiece4.png,hairballPiece5.png,hairballPiece6.png,hairballPiece7.png,hairballPiece8.png,hairballPiece9.png,ice2.png,ice3.png,ice4.png,ice5.png,ice6.png,jellyArrow.png,leftArrow.png,lightedStar.png,lineLight.png,lockVine.png,magicLion.png,magicLionBg.png,main_mapbottom.png,musicOff.png,musicOn.png,playBg.jpg,propNum0.png,propNum1.png,propNum2.png,propNum3.png,propNum4.png,propNum5.png,propNum6.png,propNum7.png,propNum8.png,propNum9.png,rectLat.png,rectLatWhite.png,redDoorBg.png,rightArrow.png,rightMark.png,rock2.png,rock3.png,rock4.png,rock5.png,rock6.png,scoreNum0.png,scoreNum1.png,scoreNum2.png,scoreNum3.png,scoreNum4.png,scoreNum5.png,scoreNum6.png,scoreNum7.png,scoreNum8.png,scoreNum9.png,scoreNum关.png,scoreNum冒号.png,scoreNum分.png,scoreNum数.png,scoreNum通.png,settingBg.png,settingBtn.png,starProgress.png,stepAni1.png,stepAni10.png,stepAni11.png,stepAni2.png,stepAni3.png,stepAni4.png,stepAni5.png,stepAni6.png,stepAni7.png,stepAni8.png,stepAni9.png,stepNum0.png,stepNum1.png,stepNum2.png,stepNum3.png,stepNum4.png,stepNum5.png,stepNum6.png,stepNum7.png,stepNum8.png,stepNum9.png,table.png,tarNum0.png,tarNum1.png,tarNum2.png,tarNum3.png,tarNum4.png,tarNum5.png,tarNum6.png,tarNum7.png,tarNum8.png,tarNum9.png,topBg.png,unlightedStar.png,yellowCircleDown.png,yellowCircleUp.png,yellowDoorBg.png",
            "name": "playScene",
            "atlas": {
                "blueDoorBg.png": {
                    "x": 776,
                    "y": 1655,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": false
                },
                "bonusFra0.png": {
                    "x": 707,
                    "y": 286,
                    "w": 42,
                    "h": 42,
                    "ox": 38,
                    "oy": 38,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra1.png": {
                    "x": 1978,
                    "y": 128,
                    "w": 60,
                    "h": 60,
                    "ox": 30,
                    "oy": 30,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra10.png": {
                    "x": 502,
                    "y": 1909,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra11.png": {
                    "x": 550,
                    "y": 1665,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra2.png": {
                    "x": 1197,
                    "y": 1490,
                    "w": 80,
                    "h": 80,
                    "ox": 20,
                    "oy": 20,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra3.png": {
                    "x": 1404,
                    "y": 60,
                    "w": 98,
                    "h": 98,
                    "ox": 11,
                    "oy": 11,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra4.png": {
                    "x": 637,
                    "y": 1787,
                    "w": 112,
                    "h": 112,
                    "ox": 4,
                    "oy": 4,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra5.png": {
                    "x": 442,
                    "y": 1787,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra6.png": {
                    "x": 428,
                    "y": 1665,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra7.png": {
                    "x": 306,
                    "y": 1718,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra8.png": {
                    "x": 184,
                    "y": 1718,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra9.png": {
                    "x": 614,
                    "y": 1436,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusShoot.png": {
                    "x": 1871,
                    "y": 196,
                    "w": 95,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 37,
                    "ro": false
                },
                "boom0.png": {
                    "x": 1978,
                    "y": 190,
                    "w": 54,
                    "h": 54,
                    "ox": 102,
                    "oy": 102,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom1.png": {
                    "x": 859,
                    "y": 1752,
                    "w": 92,
                    "h": 92,
                    "ox": 83,
                    "oy": 83,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom10.png": {
                    "x": 1145,
                    "y": 836,
                    "w": 252,
                    "h": 252,
                    "ox": 4,
                    "oy": 4,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom11.png": {
                    "x": 1153,
                    "y": 586,
                    "w": 248,
                    "h": 248,
                    "ox": 5,
                    "oy": 5,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom12.png": {
                    "x": 968,
                    "y": 1248,
                    "w": 158,
                    "h": 172,
                    "ox": 53,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom13.png": {
                    "x": 968,
                    "y": 1086,
                    "w": 160,
                    "h": 172,
                    "ox": 51,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom14.png": {
                    "x": 2,
                    "y": 1678,
                    "w": 168,
                    "h": 180,
                    "ox": 47,
                    "oy": 41,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom15.png": {
                    "x": 400,
                    "y": 1487,
                    "w": 176,
                    "h": 190,
                    "ox": 43,
                    "oy": 36,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom16.png": {
                    "x": 1805,
                    "y": 669,
                    "w": 184,
                    "h": 200,
                    "ox": 39,
                    "oy": 31,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom17.png": {
                    "x": 404,
                    "y": 1297,
                    "w": 188,
                    "h": 208,
                    "ox": 37,
                    "oy": 27,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom18.png": {
                    "x": 742,
                    "y": 1312,
                    "w": 190,
                    "h": 206,
                    "ox": 36,
                    "oy": 28,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom19.png": {
                    "x": 1805,
                    "y": 479,
                    "w": 188,
                    "h": 200,
                    "ox": 37,
                    "oy": 31,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom2.png": {
                    "x": 310,
                    "y": 1840,
                    "w": 130,
                    "h": 130,
                    "ox": 64,
                    "oy": 64,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom20.png": {
                    "x": 2,
                    "y": 1500,
                    "w": 176,
                    "h": 190,
                    "ox": 42,
                    "oy": 36,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom3.png": {
                    "x": 2,
                    "y": 1848,
                    "w": 164,
                    "h": 164,
                    "ox": 48,
                    "oy": 48,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom4.png": {
                    "x": 204,
                    "y": 1344,
                    "w": 194,
                    "h": 194,
                    "ox": 33,
                    "oy": 33,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom5.png": {
                    "x": 1142,
                    "y": 1090,
                    "w": 216,
                    "h": 216,
                    "ox": 22,
                    "oy": 22,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom6.png": {
                    "x": 742,
                    "y": 1086,
                    "w": 224,
                    "h": 224,
                    "ox": 18,
                    "oy": 18,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom7.png": {
                    "x": 1801,
                    "y": 1099,
                    "w": 234,
                    "h": 234,
                    "ox": 13,
                    "oy": 13,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom8.png": {
                    "x": 1801,
                    "y": 855,
                    "w": 242,
                    "h": 242,
                    "ox": 9,
                    "oy": 9,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom9.png": {
                    "x": 1153,
                    "y": 336,
                    "w": 248,
                    "h": 248,
                    "ox": 6,
                    "oy": 6,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "brownBallFace.png": {
                    "x": 1518,
                    "y": 1215,
                    "w": 76,
                    "h": 72,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "bubbleStar1.png": {
                    "x": 1527,
                    "y": 246,
                    "w": 18,
                    "h": 10,
                    "ox": 32,
                    "oy": 67,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar10.png": {
                    "x": 1636,
                    "y": 196,
                    "w": 46,
                    "h": 42,
                    "ox": 18,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar11.png": {
                    "x": 1590,
                    "y": 196,
                    "w": 46,
                    "h": 44,
                    "ox": 19,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar12.png": {
                    "x": 1542,
                    "y": 196,
                    "w": 46,
                    "h": 46,
                    "ox": 19,
                    "oy": 13,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar13.png": {
                    "x": 707,
                    "y": 360,
                    "w": 42,
                    "h": 28,
                    "ox": 21,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar14.png": {
                    "x": 704,
                    "y": 655,
                    "w": 38,
                    "h": 30,
                    "ox": 24,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar15.png": {
                    "x": 2007,
                    "y": 753,
                    "w": 32,
                    "h": 30,
                    "ox": 27,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar16.png": {
                    "x": 690,
                    "y": 1228,
                    "w": 24,
                    "h": 16,
                    "ox": 33,
                    "oy": 26,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar17.png": {
                    "x": 690,
                    "y": 1262,
                    "w": 18,
                    "h": 16,
                    "ox": 32,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar18.png": {
                    "x": 1360,
                    "y": 1139,
                    "w": 14,
                    "h": 14,
                    "ox": 32,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar19.png": {
                    "x": 2040,
                    "y": 128,
                    "w": 6,
                    "h": 6,
                    "ox": 34,
                    "oy": 19,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar2.png": {
                    "x": 2034,
                    "y": 190,
                    "w": 24,
                    "h": 12,
                    "ox": 30,
                    "oy": 62,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar3.png": {
                    "x": 2007,
                    "y": 811,
                    "w": 32,
                    "h": 20,
                    "ox": 25,
                    "oy": 59,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar4.png": {
                    "x": 704,
                    "y": 687,
                    "w": 38,
                    "h": 24,
                    "ox": 22,
                    "oy": 53,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar5.png": {
                    "x": 707,
                    "y": 330,
                    "w": 42,
                    "h": 28,
                    "ox": 21,
                    "oy": 49,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar6.png": {
                    "x": 707,
                    "y": 206,
                    "w": 44,
                    "h": 28,
                    "ox": 20,
                    "oy": 46,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar7.png": {
                    "x": 2007,
                    "y": 705,
                    "w": 46,
                    "h": 32,
                    "ox": 19,
                    "oy": 44,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar8.png": {
                    "x": 1720,
                    "y": 196,
                    "w": 46,
                    "h": 38,
                    "ox": 19,
                    "oy": 39,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar9.png": {
                    "x": 707,
                    "y": 164,
                    "w": 44,
                    "h": 40,
                    "ox": 19,
                    "oy": 33,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubleEle0.png": {
                    "x": 1359,
                    "y": 1470,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle1.png": {
                    "x": 1355,
                    "y": 1552,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle2.png": {
                    "x": 1280,
                    "y": 1652,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle3.png": {
                    "x": 1235,
                    "y": 1738,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle4.png": {
                    "x": 1231,
                    "y": 1831,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "chapterNum0.png": {
                    "x": 690,
                    "y": 1122,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum1.png": {
                    "x": 690,
                    "y": 1146,
                    "w": 18,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 18,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum2.png": {
                    "x": 690,
                    "y": 1098,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum3.png": {
                    "x": 690,
                    "y": 1074,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum4.png": {
                    "x": 696,
                    "y": 928,
                    "w": 24,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 24,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum5.png": {
                    "x": 690,
                    "y": 1050,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum6.png": {
                    "x": 690,
                    "y": 1026,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum7.png": {
                    "x": 696,
                    "y": 1002,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum8.png": {
                    "x": 696,
                    "y": 978,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum9.png": {
                    "x": 696,
                    "y": 954,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum关.png": {
                    "x": 2007,
                    "y": 670,
                    "w": 33,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum第.png": {
                    "x": 2007,
                    "y": 599,
                    "w": 34,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 34,
                    "ro": false
                },
                "chooseRect.png": {
                    "x": 1026,
                    "y": 1593,
                    "w": 86,
                    "h": 83,
                    "ox": 0,
                    "oy": 0,
                    "sw": 86,
                    "sh": 83,
                    "ro": true
                },
                "doorClosed.png": {
                    "x": 1233,
                    "y": 1911,
                    "w": 74,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 75,
                    "ro": false
                },
                "doorOpen.png": {
                    "x": 1440,
                    "y": 1215,
                    "w": 76,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 76,
                    "ro": false
                },
                "eggPiece1.png": {
                    "x": 1380,
                    "y": 1108,
                    "w": 13,
                    "h": 16,
                    "ox": 0,
                    "oy": 0,
                    "sw": 13,
                    "sh": 16,
                    "ro": true
                },
                "eggPiece2.png": {
                    "x": 1360,
                    "y": 1124,
                    "w": 18,
                    "h": 13,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 13,
                    "ro": false
                },
                "eggPiece3.png": {
                    "x": 2007,
                    "y": 635,
                    "w": 34,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 33,
                    "ro": false
                },
                "eggPiece4.png": {
                    "x": 1380,
                    "y": 1090,
                    "w": 16,
                    "h": 17,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 17,
                    "ro": true
                },
                "eggPiece5.png": {
                    "x": 690,
                    "y": 1166,
                    "w": 22,
                    "h": 27,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 27,
                    "ro": true
                },
                "eggStatus0.png": {
                    "x": 1384,
                    "y": 1295,
                    "w": 78,
                    "h": 74,
                    "ox": 1,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "eggStatus1.png": {
                    "x": 993,
                    "y": 1946,
                    "w": 78,
                    "h": 80,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "eggStatus2.png": {
                    "x": 1153,
                    "y": 1929,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele0Exp.png": {
                    "x": 1153,
                    "y": 1847,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele1Exp.png": {
                    "x": 1075,
                    "y": 1847,
                    "w": 76,
                    "h": 80,
                    "ox": 2,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele2Exp.png": {
                    "x": 1073,
                    "y": 1946,
                    "w": 80,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele3Exp.png": {
                    "x": 1193,
                    "y": 1576,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele4Exp.png": {
                    "x": 1362,
                    "y": 1388,
                    "w": 78,
                    "h": 74,
                    "ox": 2,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "exLighting0.png": {
                    "x": 1042,
                    "y": 1408,
                    "w": 76,
                    "h": 84,
                    "ox": 7,
                    "oy": 7,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting10.png": {
                    "x": 883,
                    "y": 1504,
                    "w": 92,
                    "h": 74,
                    "ox": 4,
                    "oy": 10,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting13.png": {
                    "x": 959,
                    "y": 1501,
                    "w": 90,
                    "h": 76,
                    "ox": 2,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting15.png": {
                    "x": 1040,
                    "y": 1681,
                    "w": 82,
                    "h": 76,
                    "ox": 4,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting17.png": {
                    "x": 993,
                    "y": 1780,
                    "w": 78,
                    "h": 82,
                    "ox": 7,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting18.png": {
                    "x": 1037,
                    "y": 1501,
                    "w": 76,
                    "h": 84,
                    "ox": 7,
                    "oy": 7,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting2.png": {
                    "x": 1224,
                    "y": 1308,
                    "w": 78,
                    "h": 80,
                    "ox": 2,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting20.png": {
                    "x": 1202,
                    "y": 1390,
                    "w": 78,
                    "h": 80,
                    "ox": 2,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting22.png": {
                    "x": 843,
                    "y": 1884,
                    "w": 94,
                    "h": 76,
                    "ox": 0,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting24.png": {
                    "x": 406,
                    "y": 1972,
                    "w": 94,
                    "h": 74,
                    "ox": 0,
                    "oy": 14,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting26.png": {
                    "x": 921,
                    "y": 1938,
                    "w": 90,
                    "h": 70,
                    "ox": 4,
                    "oy": 17,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting28.png": {
                    "x": 872,
                    "y": 1600,
                    "w": 92,
                    "h": 74,
                    "ox": 4,
                    "oy": 10,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting31.png": {
                    "x": 948,
                    "y": 1598,
                    "w": 90,
                    "h": 76,
                    "ox": 2,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting33.png": {
                    "x": 1040,
                    "y": 1681,
                    "w": 82,
                    "h": 76,
                    "ox": 4,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting4.png": {
                    "x": 805,
                    "y": 1504,
                    "w": 94,
                    "h": 76,
                    "ox": 0,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting6.png": {
                    "x": 310,
                    "y": 1972,
                    "w": 94,
                    "h": 74,
                    "ox": 0,
                    "oy": 14,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting8.png": {
                    "x": 921,
                    "y": 1846,
                    "w": 90,
                    "h": 70,
                    "ox": 4,
                    "oy": 17,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "eyeDownLeft.png": {
                    "x": 1951,
                    "y": 235,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eyeDownRight.png": {
                    "x": 1927,
                    "y": 235,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eyeSingle.png": {
                    "x": 2034,
                    "y": 241,
                    "w": 12,
                    "h": 11,
                    "ox": 0,
                    "oy": 0,
                    "sw": 12,
                    "sh": 11,
                    "ro": false
                },
                "gameGuideBoard.png": {
                    "x": 1404,
                    "y": 258,
                    "w": 604,
                    "h": 219,
                    "ox": 0,
                    "oy": 0,
                    "sw": 604,
                    "sh": 219,
                    "ro": false
                },
                "greenCircleDown.png": {
                    "x": 751,
                    "y": 1774,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 1,
                    "sw": 108,
                    "sh": 108,
                    "ro": true
                },
                "greenCircleUp.png": {
                    "x": 614,
                    "y": 1305,
                    "w": 129,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 126,
                    "ro": true
                },
                "greyBallFace.png": {
                    "x": 1460,
                    "y": 1293,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "guidePropBoom.png": {
                    "x": 592,
                    "y": 1558,
                    "w": 103,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 115,
                    "ro": true
                },
                "guidePropCow.png": {
                    "x": 406,
                    "y": 164,
                    "w": 253,
                    "h": 299,
                    "ox": 0,
                    "oy": 0,
                    "sw": 253,
                    "sh": 299,
                    "ro": true
                },
                "guidePropHammer.png": {
                    "x": 624,
                    "y": 1909,
                    "w": 109,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 115,
                    "ro": false
                },
                "guidePropHand.png": {
                    "x": 950,
                    "y": 1408,
                    "w": 90,
                    "h": 91,
                    "ox": 0,
                    "oy": 0,
                    "sw": 90,
                    "sh": 91,
                    "ro": false
                },
                "guidePropMsgPanel.png": {
                    "x": 1506,
                    "y": 2,
                    "w": 470,
                    "h": 192,
                    "ox": 0,
                    "oy": 0,
                    "sw": 470,
                    "sh": 192,
                    "ro": false
                },
                "guidePropShoe.png": {
                    "x": 672,
                    "y": 1663,
                    "w": 102,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 102,
                    "sh": 109,
                    "ro": false
                },
                "hairballDisBg.png": {
                    "x": 1438,
                    "y": 1375,
                    "w": 76,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 75,
                    "ro": true
                },
                "hairballPiece1.png": {
                    "x": 704,
                    "y": 625,
                    "w": 39,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 28,
                    "ro": false
                },
                "hairballPiece2.png": {
                    "x": 704,
                    "y": 505,
                    "w": 40,
                    "h": 30,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 30,
                    "ro": false
                },
                "hairballPiece3.png": {
                    "x": 2007,
                    "y": 486,
                    "w": 37,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 28,
                    "ro": false
                },
                "hairballPiece4.png": {
                    "x": 707,
                    "y": 261,
                    "w": 43,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 43,
                    "sh": 23,
                    "ro": false
                },
                "hairballPiece5.png": {
                    "x": 690,
                    "y": 1208,
                    "w": 25,
                    "h": 18,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 18,
                    "ro": false
                },
                "hairballPiece6.png": {
                    "x": 704,
                    "y": 597,
                    "w": 40,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 26,
                    "ro": false
                },
                "hairballPiece7.png": {
                    "x": 2007,
                    "y": 785,
                    "w": 32,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 32,
                    "sh": 24,
                    "ro": false
                },
                "hairballPiece8.png": {
                    "x": 2010,
                    "y": 398,
                    "w": 38,
                    "h": 36,
                    "ox": 0,
                    "oy": 0,
                    "sw": 38,
                    "sh": 36,
                    "ro": true
                },
                "hairballPiece9.png": {
                    "x": 704,
                    "y": 472,
                    "w": 41,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 41,
                    "sh": 31,
                    "ro": false
                },
                "ice2.png": {
                    "x": 1360,
                    "y": 1215,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice3.png": {
                    "x": 1304,
                    "y": 1308,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice4.png": {
                    "x": 1282,
                    "y": 1390,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice5.png": {
                    "x": 1279,
                    "y": 1472,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice6.png": {
                    "x": 1275,
                    "y": 1572,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "jellyArrow.png": {
                    "x": 707,
                    "y": 236,
                    "w": 43,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 43,
                    "sh": 23,
                    "ro": false
                },
                "leftArrow.png": {
                    "x": 704,
                    "y": 567,
                    "w": 28,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 40,
                    "ro": true
                },
                "lightedStar.png": {
                    "x": 2007,
                    "y": 564,
                    "w": 35,
                    "h": 33,
                    "ox": 0,
                    "oy": 1,
                    "sw": 37,
                    "sh": 37,
                    "ro": false
                },
                "lineLight.png": {
                    "x": 754,
                    "y": 2,
                    "w": 56,
                    "h": 750,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 750,
                    "ro": true
                },
                "lockVine.png": {
                    "x": 1118,
                    "y": 1669,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "magicLion.png": {
                    "x": 1073,
                    "y": 1765,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "magicLionBg.png": {
                    "x": 194,
                    "y": 1540,
                    "w": 180,
                    "h": 176,
                    "ox": 0,
                    "oy": 2,
                    "sw": 180,
                    "sh": 180,
                    "ro": false
                },
                "main_mapbottom.png": {
                    "x": 707,
                    "y": 390,
                    "w": 80,
                    "h": 41,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 41,
                    "ro": true
                },
                "musicOff.png": {
                    "x": 1978,
                    "y": 65,
                    "w": 61,
                    "h": 65,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 65,
                    "ro": true
                },
                "musicOn.png": {
                    "x": 1978,
                    "y": 2,
                    "w": 61,
                    "h": 65,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 65,
                    "ro": true
                },
                "propNum0.png": {
                    "x": 726,
                    "y": 952,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": false
                },
                "propNum1.png": {
                    "x": 1503,
                    "y": 246,
                    "w": 10,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 10,
                    "sh": 30,
                    "ro": true
                },
                "propNum2.png": {
                    "x": 714,
                    "y": 1254,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum3.png": {
                    "x": 726,
                    "y": 928,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": false
                },
                "propNum4.png": {
                    "x": 718,
                    "y": 1204,
                    "w": 16,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 16,
                    "sh": 30,
                    "ro": true
                },
                "propNum5.png": {
                    "x": 690,
                    "y": 1246,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum6.png": {
                    "x": 726,
                    "y": 904,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": false
                },
                "propNum7.png": {
                    "x": 716,
                    "y": 1238,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum8.png": {
                    "x": 726,
                    "y": 880,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": false
                },
                "propNum9.png": {
                    "x": 717,
                    "y": 1222,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "rectLat.png": {
                    "x": 1200,
                    "y": 1658,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "rectLatWhite.png": {
                    "x": 1155,
                    "y": 1751,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "redDoorBg.png": {
                    "x": 1404,
                    "y": 160,
                    "w": 96,
                    "h": 97,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 97,
                    "ro": true
                },
                "rightArrow.png": {
                    "x": 704,
                    "y": 537,
                    "w": 28,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 40,
                    "ro": true
                },
                "rightMark.png": {
                    "x": 1503,
                    "y": 196,
                    "w": 48,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 37,
                    "ro": true
                },
                "rock2.png": {
                    "x": 993,
                    "y": 1864,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock3.png": {
                    "x": 1142,
                    "y": 1308,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock4.png": {
                    "x": 1120,
                    "y": 1408,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock5.png": {
                    "x": 1115,
                    "y": 1494,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock6.png": {
                    "x": 1111,
                    "y": 1587,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "scoreNum0.png": {
                    "x": 719,
                    "y": 1176,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum1.png": {
                    "x": 690,
                    "y": 1190,
                    "w": 16,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 28,
                    "ro": true
                },
                "scoreNum2.png": {
                    "x": 720,
                    "y": 1148,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum3.png": {
                    "x": 720,
                    "y": 1120,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum4.png": {
                    "x": 1899,
                    "y": 235,
                    "w": 21,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 28,
                    "ro": true
                },
                "scoreNum5.png": {
                    "x": 720,
                    "y": 1092,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum6.png": {
                    "x": 720,
                    "y": 1064,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum7.png": {
                    "x": 720,
                    "y": 1036,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum8.png": {
                    "x": 2007,
                    "y": 833,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": true
                },
                "scoreNum9.png": {
                    "x": 1871,
                    "y": 235,
                    "w": 21,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 28,
                    "ro": true
                },
                "scoreNum关.png": {
                    "x": 696,
                    "y": 849,
                    "w": 31,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum冒号.png": {
                    "x": 2034,
                    "y": 216,
                    "w": 12,
                    "h": 23,
                    "ox": 0,
                    "oy": 3,
                    "sw": 20,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum分.png": {
                    "x": 696,
                    "y": 785,
                    "w": 31,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum数.png": {
                    "x": 704,
                    "y": 752,
                    "w": 31,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum通.png": {
                    "x": 696,
                    "y": 818,
                    "w": 31,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "settingBg.png": {
                    "x": 564,
                    "y": 1787,
                    "w": 71,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 71,
                    "sh": 120,
                    "ro": false
                },
                "settingBtn.png": {
                    "x": 953,
                    "y": 1690,
                    "w": 88,
                    "h": 85,
                    "ox": 0,
                    "oy": 0,
                    "sw": 88,
                    "sh": 85,
                    "ro": true
                },
                "starProgress.png": {
                    "x": 2,
                    "y": 164,
                    "w": 402,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 402,
                    "sh": 32,
                    "ro": false
                },
                "stepAni1.png": {
                    "x": 404,
                    "y": 769,
                    "w": 250,
                    "h": 290,
                    "ox": 0,
                    "oy": 110,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni10.png": {
                    "x": 404,
                    "y": 1021,
                    "w": 284,
                    "h": 274,
                    "ox": 116,
                    "oy": 65,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni11.png": {
                    "x": 2,
                    "y": 1344,
                    "w": 154,
                    "h": 200,
                    "ox": 225,
                    "oy": 78,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni2.png": {
                    "x": 2,
                    "y": 980,
                    "w": 362,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni3.png": {
                    "x": 2,
                    "y": 198,
                    "w": 400,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni4.png": {
                    "x": 751,
                    "y": 336,
                    "w": 400,
                    "h": 382,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni5.png": {
                    "x": 2,
                    "y": 600,
                    "w": 400,
                    "h": 378,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni6.png": {
                    "x": 1399,
                    "y": 849,
                    "w": 400,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni7.png": {
                    "x": 1403,
                    "y": 479,
                    "w": 400,
                    "h": 368,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni8.png": {
                    "x": 743,
                    "y": 720,
                    "w": 400,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni9.png": {
                    "x": 404,
                    "y": 419,
                    "w": 298,
                    "h": 348,
                    "ox": 102,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepNum0.png": {
                    "x": 2007,
                    "y": 516,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum1.png": {
                    "x": 696,
                    "y": 880,
                    "w": 28,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 28,
                    "sh": 50,
                    "ro": false
                },
                "stepNum2.png": {
                    "x": 1834,
                    "y": 196,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum3.png": {
                    "x": 1797,
                    "y": 196,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum4.png": {
                    "x": 1680,
                    "y": 196,
                    "w": 38,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 38,
                    "sh": 50,
                    "ro": false
                },
                "stepNum5.png": {
                    "x": 2010,
                    "y": 350,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "stepNum6.png": {
                    "x": 2010,
                    "y": 302,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "stepNum7.png": {
                    "x": 1760,
                    "y": 196,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum8.png": {
                    "x": 2010,
                    "y": 438,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum9.png": {
                    "x": 2010,
                    "y": 254,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "table.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 160,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 160,
                    "ro": false
                },
                "tarNum0.png": {
                    "x": 1380,
                    "y": 1123,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum1.png": {
                    "x": 1547,
                    "y": 244,
                    "w": 11,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 11,
                    "sh": 20,
                    "ro": true
                },
                "tarNum2.png": {
                    "x": 1360,
                    "y": 1107,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": true
                },
                "tarNum3.png": {
                    "x": 1360,
                    "y": 1090,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": true
                },
                "tarNum4.png": {
                    "x": 710,
                    "y": 1270,
                    "w": 16,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 16,
                    "sh": 20,
                    "ro": true
                },
                "tarNum5.png": {
                    "x": 710,
                    "y": 1288,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": true
                },
                "tarNum6.png": {
                    "x": 690,
                    "y": 1280,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": true
                },
                "tarNum7.png": {
                    "x": 726,
                    "y": 1016,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum8.png": {
                    "x": 726,
                    "y": 996,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum9.png": {
                    "x": 726,
                    "y": 976,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "topBg.png": {
                    "x": 754,
                    "y": 60,
                    "w": 648,
                    "h": 274,
                    "ox": 50,
                    "oy": 0,
                    "sw": 750,
                    "sh": 274,
                    "ro": false
                },
                "unlightedStar.png": {
                    "x": 704,
                    "y": 713,
                    "w": 37,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 37,
                    "ro": false
                },
                "yellowCircleDown.png": {
                    "x": 735,
                    "y": 1901,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 0,
                    "sw": 108,
                    "sh": 106,
                    "ro": true
                },
                "yellowCircleUp.png": {
                    "x": 168,
                    "y": 1848,
                    "w": 144,
                    "h": 140,
                    "ox": 0,
                    "oy": 0,
                    "sw": 144,
                    "sh": 140,
                    "ro": true
                },
                "yellowDoorBg.png": {
                    "x": 709,
                    "y": 1558,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": false
                }
            }
        },
        {
            "keys": "prizePanel.png,prizePanelBtn.png",
            "name": "PrizePanel",
            "atlas": {
                "prizePanel.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 789,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 789,
                    "ro": false
                },
                "prizePanelBtn.png": {
                    "x": 2,
                    "y": 793,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "活动规则背景.png",
            "name": "RulePanel",
            "atlas": {
                "活动规则背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 747,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 747,
                    "ro": false
                }
            }
        },
        {
            "keys": "star_light_0.png,star_light_1.png,star_light_10.png,star_light_11.png,star_light_12.png,star_light_13.png,star_light_14.png,star_light_15.png,star_light_2.png,star_light_3.png,star_light_4.png,star_light_5.png,star_light_6.png,star_light_7.png,star_light_8.png,star_light_9.png",
            "name": "starLight",
            "atlas": {
                "star_light_0.png": {
                    "x": 328,
                    "y": 322,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_1.png": {
                    "x": 982,
                    "y": 328,
                    "w": 326,
                    "h": 326,
                    "ox": 87,
                    "oy": 87,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_10.png": {
                    "x": 4,
                    "y": 2,
                    "w": 386,
                    "h": 318,
                    "ox": 31,
                    "oy": 91,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_11.png": {
                    "x": 768,
                    "y": 2,
                    "w": 396,
                    "h": 320,
                    "ox": 25,
                    "oy": 89,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_12.png": {
                    "x": 1492,
                    "y": 2,
                    "w": 410,
                    "h": 324,
                    "ox": 16,
                    "oy": 86,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_13.png": {
                    "x": 340,
                    "y": 652,
                    "w": 416,
                    "h": 330,
                    "ox": 13,
                    "oy": 84,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_14.png": {
                    "x": 1310,
                    "y": 328,
                    "w": 414,
                    "h": 328,
                    "ox": 13,
                    "oy": 85,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_15.png": {
                    "x": 2,
                    "y": 2,
                    "w": 0,
                    "h": 0,
                    "ox": 0,
                    "oy": 0,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_2.png": {
                    "x": 654,
                    "y": 324,
                    "w": 326,
                    "h": 326,
                    "ox": 87,
                    "oy": 87,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_3.png": {
                    "x": 2,
                    "y": 322,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_4.png": {
                    "x": 1166,
                    "y": 2,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_5.png": {
                    "x": 2,
                    "y": 648,
                    "w": 336,
                    "h": 328,
                    "ox": 78,
                    "oy": 86,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_6.png": {
                    "x": 758,
                    "y": 656,
                    "w": 346,
                    "h": 332,
                    "ox": 70,
                    "oy": 84,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_7.png": {
                    "x": 1106,
                    "y": 658,
                    "w": 358,
                    "h": 336,
                    "ox": 60,
                    "oy": 82,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_8.png": {
                    "x": 1466,
                    "y": 658,
                    "w": 368,
                    "h": 336,
                    "ox": 50,
                    "oy": 82,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_9.png": {
                    "x": 392,
                    "y": 2,
                    "w": 374,
                    "h": 318,
                    "ox": 38,
                    "oy": 90,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                }
            }
        },
        {
            "keys": "开始闯关Bg.png",
            "name": "StartPanel",
            "atlas": {
                "开始闯关Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 799,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 799,
                    "ro": false
                }
            }
        },
        {
            "keys": "关卡弹窗Bg.png",
            "name": "StartPanelPrize",
            "atlas": {
                "关卡弹窗Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 1019,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 1019,
                    "ro": false
                }
            }
        },
        {
            "keys": "star_dis.png,star_en.png,去抽奖.png,圆角矩形 648.png,开奖按钮120.png,道具圆圈.png,闯关成功.png,闯关成功Bg.png,闯关成功不满星按钮.png",
            "name": "SuccessPanel",
            "atlas": {
                "star_dis.png": {
                    "x": 835,
                    "y": 957,
                    "w": 150,
                    "h": 144,
                    "ox": 0,
                    "oy": 0,
                    "sw": 150,
                    "sh": 144,
                    "ro": false
                },
                "star_en.png": {
                    "x": 835,
                    "y": 644,
                    "w": 164,
                    "h": 157,
                    "ox": 0,
                    "oy": 0,
                    "sw": 164,
                    "sh": 157,
                    "ro": false
                },
                "去抽奖.png": {
                    "x": 2,
                    "y": 1402,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                },
                "圆角矩形 648.png": {
                    "x": 2,
                    "y": 1529,
                    "w": 502,
                    "h": 196,
                    "ox": 0,
                    "oy": 2,
                    "sw": 504,
                    "sh": 200,
                    "ro": true
                },
                "开奖按钮120.png": {
                    "x": 835,
                    "y": 1103,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": true
                },
                "道具圆圈.png": {
                    "x": 835,
                    "y": 803,
                    "w": 152,
                    "h": 152,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 152,
                    "ro": false
                },
                "闯关成功.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 971,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 971,
                    "ro": true
                },
                "闯关成功Bg.png": {
                    "x": 2,
                    "y": 644,
                    "w": 640,
                    "h": 831,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 831,
                    "ro": true
                },
                "闯关成功不满星按钮.png": {
                    "x": 2,
                    "y": 1286,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "任务背景.png,去完成.png,去完成灰.png,待领取.png",
            "name": "TaskPanel",
            "atlas": {
                "任务背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 1046,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1046,
                    "ro": false
                },
                "去完成.png": {
                    "x": 754,
                    "y": 84,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "去完成灰.png": {
                    "x": 939,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": true
                },
                "待领取.png": {
                    "x": 754,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                }
            }
        },
        {
            "keys": "道具不足背景.png",
            "name": "ToolsOutPanel",
            "atlas": {
                "道具不足背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 437,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 437,
                    "ro": true
                }
            }
        },
        {
            "keys": "使用道具背景.png",
            "name": "UseToolPanel",
            "atlas": {
                "使用道具背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 437,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 437,
                    "ro": true
                }
            }
        }
    ],
    "path": "https://yun.duiba.com.cn/db_games/activity/babycare_xiaoxiao/1596439435/resource/"
};


/***/ }),

/***/ "./src/SkinJson.ts":
/*!*************************!*\
  !*** ./src/SkinJson.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SkinJson = {
    "x": 0,
    "y": 0,
    "type": "container",
    "children": [
        {
            "name": "SuccessNoPrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "light1",
                    "x": 155,
                    "y": 280,
                    "alpha": 0.8,
                    "type": "sprite",
                    "props": {
                        "source": "comm_light.png"
                    },
                    "id": "light1"
                },
                {
                    "name": "light2",
                    "x": 155,
                    "y": 280,
                    "alpha": 0.8,
                    "type": "sprite",
                    "props": {
                        "source": "comm_light.png"
                    },
                    "id": "light2"
                },
                {
                    "name": "闯关成功Bg",
                    "x": 55,
                    "y": 266,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "闯关成功Bg.png"
                    }
                },
                {
                    "name": "继续闯关大",
                    "x": 163,
                    "y": 935,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关大.png"
                    },
                    "id": "totalContinueBtn"
                },
                {
                    "name": "继续闯关小",
                    "x": 381,
                    "y": 935,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关小.png"
                    },
                    "id": "continueBtn"
                },
                {
                    "name": "闯关成功不满星按钮",
                    "x": 91,
                    "y": 935,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "闯关成功不满星按钮.png"
                    },
                    "id": "againBtn"
                },
                {
                    "name": "关卡文字",
                    "x": 300,
                    "y": 501,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 24 关",
                        "size": 40,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "提示文案",
                    "x": 210,
                    "y": 815,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "太厉害了！\n再闯6关就即可抽奖！",
                        "size": 36,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "SuccessPrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "light1",
                    "x": 155,
                    "y": 280,
                    "alpha": 0.8,
                    "type": "sprite",
                    "props": {
                        "source": "comm_light.png"
                    },
                    "id": "light1"
                },
                {
                    "name": "light2",
                    "x": 155,
                    "y": 280,
                    "alpha": 0.8,
                    "type": "sprite",
                    "props": {
                        "source": "comm_light.png"
                    },
                    "id": "light2"
                },
                {
                    "name": "闯关成功",
                    "x": 55,
                    "y": 266,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "闯关成功.png"
                    }
                },
                {
                    "name": "继续闯关大",
                    "x": 163,
                    "y": 1086,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关大.png"
                    },
                    "id": "noPrizeAgainBtn"
                },
                {
                    "name": "继续闯关小",
                    "x": 93,
                    "y": 1086,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关小.png"
                    },
                    "id": "againBtn"
                },
                {
                    "name": "去抽奖",
                    "x": 383,
                    "y": 1086,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "去抽奖.png"
                    },
                    "id": "goPrizeBtn"
                },
                {
                    "name": "关卡文字",
                    "x": 300,
                    "y": 501,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 24 关",
                        "size": 40,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "提示文案",
                    "x": 182,
                    "y": 810,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "太厉害了！获得抽奖资格！",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "红包奖励",
                    "x": 130,
                    "y": 870,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": ""
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "道具",
                    "x": 124,
                    "y": 858,
                    "type": "container",
                    "children": [
                        {
                            "name": "bg",
                            "x": 0,
                            "y": 0,
                            "alpha": 1,
                            "type": "sprite",
                            "props": {
                                "source": "圆角矩形 648.png"
                            }
                        },
                        {
                            "name": "label",
                            "x": 265,
                            "y": 85,
                            "alpha": 1,
                            "type": "text",
                            "props": {
                                "text": "步数道具 x1",
                                "size": 30,
                                "fillColor": "#df5942",
                                "textAlpha": 1
                            }
                        },
                        {
                            "name": "img",
                            "x": 86,
                            "y": 45,
                            "alpha": 1,
                            "type": "sprite",
                            "props": {
                                "source": "道具.png"
                            }
                        },
                        {
                            "name": "quanquan",
                            "x": 76,
                            "y": 24,
                            "alpha": 1,
                            "type": "sprite",
                            "props": {
                                "source": "道具圆圈.png"
                            }
                        }
                    ],
                    "id": "prop"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "NoStepPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "步数耗尽Bg",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "步数耗尽Bg.png"
                    }
                },
                {
                    "name": "提示文案",
                    "x": 163,
                    "y": 661,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "消耗20积分可复活 ，步数+5\n确认复活吗？",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "步数耗尽复活",
                    "x": 383,
                    "y": 845,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "步数耗尽复活.png"
                    },
                    "id": "liveBtn"
                },
                {
                    "name": "步数耗尽结束按钮",
                    "x": 93,
                    "y": 845,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "步数耗尽结束按钮.png"
                    },
                    "id": "overBtn"
                }
            ]
        },
        {
            "name": "FailedPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "失败Bg",
                    "x": 55,
                    "y": 276,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "失败Bg.png"
                    }
                },
                {
                    "name": "关卡文字",
                    "x": 300,
                    "y": 521,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 24 关",
                        "size": 40,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "提示文案",
                    "x": 224,
                    "y": 611,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "再接再厉！\n再闯3关可参与抽奖！",
                        "size": 36,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "失败重新闯关",
                    "x": 163,
                    "y": 957,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "失败重新闯关.png"
                    },
                    "id": "againBtn"
                }
            ]
        },
        {
            "name": "StartPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "开始闯关Bg",
                    "x": 55,
                    "y": 266,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "开始闯关Bg.png"
                    }
                },
                {
                    "name": "开始闯关要能量",
                    "x": 163,
                    "y": 899,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关要能量.png"
                    },
                    "id": "startBtn"
                },
                {
                    "name": "开始闯关不要能量",
                    "x": 163,
                    "y": 899,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关不要能量.png"
                    },
                    "id": "startBtn2"
                },
                {
                    "name": "提示文案",
                    "x": 221,
                    "y": 847,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "本关满星可获得随机道具",
                        "size": 28,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关卡文字",
                    "x": 317,
                    "y": 521,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 6 关",
                        "size": 40,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "StartPanelPrize",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "关卡弹窗Bg",
                    "x": 55,
                    "y": 266,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "关卡弹窗Bg.png"
                    }
                },
                {
                    "name": "关卡数",
                    "x": 312,
                    "y": 521,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 6 关",
                        "size": 40,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "提示文案",
                    "x": 206,
                    "y": 849,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "通关参与抽奖，最高可赢得",
                        "size": 28,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "开始闯关要能量",
                    "x": 163,
                    "y": 1120,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关要能量.png"
                    },
                    "id": "startBtn"
                },
                {
                    "name": "开始闯关不要能量",
                    "x": 163,
                    "y": 1120,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关不要能量.png"
                    },
                    "id": "startBtn2"
                },
                {
                    "name": "prize",
                    "x": 130,
                    "y": 903,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "prize.png"
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "NoEnergyPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "体力不足Bg",
                    "x": 55,
                    "y": 497,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "体力不足Bg.png"
                    }
                },
                {
                    "name": "体力不足按钮",
                    "x": 163,
                    "y": 880,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "体力不足按钮.png"
                    },
                    "id": "okBtn"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "BuyPowerPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "增加体力背景",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "增加体力背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "无字按钮底",
                    "x": 163,
                    "y": 805,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "无字按钮底.png"
                    },
                    "id": "exchangeBtn"
                },
                {
                    "name": "文案",
                    "x": 426,
                    "y": 682,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "+\t1",
                        "size": 36,
                        "fillColor": "#ffffff",
                        "textAlpha": 1
                    },
                    "id": "msgTxt"
                }
            ]
        },
        {
            "name": "RulePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "活动规则背景",
                    "x": 55,
                    "y": 438,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "活动规则背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 410,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "PrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "背景",
                    "x": 55,
                    "y": 376,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "prizePanel.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 500,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "文案",
                    "x": 203,
                    "y": 650,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "恭喜获得XX奖品",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "prizeTxt"
                },
                {
                    "name": "prizeImg",
                    "x": 250,
                    "y": 732,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": ""
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "立即领取",
                    "x": 163,
                    "y": 1002,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "prizePanelBtn.png"
                    },
                    "id": "prizeBtn"
                }
            ]
        },
        {
            "name": "TaskPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "任务背景",
                    "x": 0,
                    "y": 579,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "任务背景.png"
                    }
                },
                {
                    "name": "按钮4",
                    "x": 525,
                    "y": 1462,
                    "type": "button",
                    "props": {
                        "tUp": "去完成.png",
                        "tDisable": "去完成灰.png"
                    },
                    "id": "taskBtn4"
                },
                {
                    "name": "按钮3",
                    "x": 526,
                    "y": 1282,
                    "type": "button",
                    "props": {
                        "tUp": "去完成.png",
                        "tDisable": "去完成灰.png"
                    },
                    "id": "taskBtn3"
                },
                {
                    "name": "按钮2",
                    "x": 526,
                    "y": 1102,
                    "type": "button",
                    "props": {
                        "tUp": "去完成.png",
                        "tDisable": "去完成灰.png"
                    },
                    "id": "taskBtn2"
                },
                {
                    "name": "按钮1",
                    "x": 526,
                    "y": 923,
                    "type": "button",
                    "props": {
                        "tUp": "去完成.png",
                        "tDisable": "去完成灰.png"
                    },
                    "id": "taskBtn1"
                },
                {
                    "name": "关闭按钮",
                    "x": 671,
                    "y": 708,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "ToolsOutPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "道具不足背景",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "道具不足背景.png"
                    }
                },
                {
                    "name": "文案",
                    "x": 203,
                    "y": 650,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "要消耗200积分兑换码？",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "msgTxt"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "确定",
                    "x": 383,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "确定.png"
                    },
                    "id": "sureBtn"
                },
                {
                    "name": "再想想",
                    "x": 93,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "再想想.png"
                    },
                    "id": "consideBtn"
                }
            ]
        },
        {
            "name": "ExchangeSucPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "兑换成功背景",
                    "x": 55,
                    "y": 337,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "兑换成功背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "知道啦",
                    "x": 163,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "知道啦.png"
                    },
                    "id": "knowBtn"
                }
            ]
        },
        {
            "name": "CreditsOutPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "积分不足背景",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "积分不足背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "赚取积分",
                    "x": 163,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "赚取积分.png"
                    },
                    "id": "earnBtn"
                }
            ]
        },
        {
            "name": "FreePowerPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "圆圈",
                    "x": 55,
                    "y": 267,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "圆圈.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "开心收下",
                    "x": 163,
                    "y": 900,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开心收下.png"
                    },
                    "id": "acceptBtn"
                }
            ]
        },
        {
            "name": "UseToolPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "使用道具背景",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "使用道具背景.png"
                    }
                },
                {
                    "name": "文案",
                    "x": 168,
                    "y": 619,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "确认使用步数道具+10步吗？",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "msgTxt"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "确定",
                    "x": 383,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "确定.png"
                    },
                    "id": "sureBtn"
                },
                {
                    "name": "再想想",
                    "x": 93,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "再想想.png"
                    },
                    "id": "consideBtn"
                }
            ]
        }
    ]
};


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["trackingReport"] = "squirrelsAdoptRest2c.trackingReport";
    TbNetName["getIndex"] = "babycare.getIndex";
    TbNetName["receiveEnamePrize"] = "babycare.receiveEnamePrize";
    TbNetName["getActivityBaseInfoById"] = "babycare.getActivityBaseInfoById";
    TbNetName["getGameInfo"] = "babycare.getGameInfo";
    TbNetName["consumerTools"] = "babycare.consumerTools";
    TbNetName["gameOver"] = "babycare.gameOver";
    TbNetName["receiveTaskRewards"] = "babycare.receiveTaskRewards";
    TbNetName["exchange"] = "babycare.exchange";
    TbNetName["getPrizesByLevel"] = "babycare.getPrizesByLevel";
    TbNetName["queryCredits"] = "babycare.queryCredits";
    TbNetName["dojoin"] = "babycare.dojoin";
    TbNetName["completeTask"] = "babycare.completeTask";
    TbNetName["getTaskList"] = "babycare.getTaskList";
    TbNetName["luckyDraw"] = "babycare.luckyDraw";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
    TbNetName["openMusic"] = "mine.openMusic";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        if (!my) {
            var url = "../../mock/miniTb/" + netName + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
            });
            return;
        }
        var fun = function (e) {
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
            console.log("\n%c[ request ]\n"
                + ("NAME  : " + netName + " \n")
                + "STATE : %o \n"
                + "PARAM : %o \n"
                + "%cDATA  : %o \n", "" + (d.success ? 'color:green' : 'color:red'), d.success, parameter, "" + (d.success ? 'color:green' : 'color:red'), d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/Tools.ts":
/*!**********************!*\
  !*** ./src/Tools.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var ctrls_2 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var FailedPanel_1 = __webpack_require__(/*! ./panels/FailedPanel */ "./src/panels/FailedPanel.ts");
var SuccessPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessPrizePanel */ "./src/panels/SuccessPrizePanel.ts");
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var CreditsOutPanel_1 = __webpack_require__(/*! ./panels/CreditsOutPanel */ "./src/panels/CreditsOutPanel.ts");
var Tools = (function () {
    function Tools() {
    }
    Tools.getIndex = function () {
        var _this = this;
        return new Promise(function (r) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getIndex, {
                userNick: _this.globalData.nickName,
                avatar: _this.globalData.avatar,
                follow: _this.globalData.isFollow,
                inviteId: _this.globalData.inviteId,
            }, function (s, res) {
                if (s)
                    _this.gameData = res.data;
                r(s);
            });
        });
    };
    Tools.getGameInfo = function () {
        var _this = this;
        return new Promise(function (r) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getGameInfo, {}, function (s, res) {
                if (s)
                    _this.gameData = res.data;
                r(s);
            });
        });
    };
    Tools.consumerTools = function (type) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.consumerTools, { type: type }, function (s, res) {
                if (s) {
                    _this.gameData.tools = res.data.tools;
                    resolve(true);
                }
                else {
                    resolve(false);
                }
            });
        });
    };
    Tools.gameOver = function (data) {
        if (!data.isVisitSuccess) {
            ctrls_2.showPanel(FailedPanel_1.FailedPanel, data);
        }
        else if ((data.prize && data.prize.image) || (data.tool && data.tool.type) || data.level == 120) {
            if (data.level == 120 && (!data.prize || !data.prize.image)) {
                data.prize = data.prize || {};
                data.prize.image = Tools.baseInfo.levelPrize['level_120'];
            }
            ctrls_2.showPanel(SuccessPrizePanel_1.SuccessPrizePanel, data);
        }
        else {
            ctrls_2.showPanel(SuccessNoPrizePanel_1.SuccessNoPrizePanel, data);
        }
    };
    Tools.exchange = function (type) {
        return __awaiter(this, void 0, void 0, function () {
            var creditsData, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.queryCredits, null, null, true)];
                    case 1:
                        creditsData = _a.sent();
                        if (!creditsData || !creditsData.data) {
                            ctrls_1.showToast("网络异常，请重试");
                            return [2, false];
                        }
                        if (creditsData && !creditsData.success && !creditsData.data.isvip) {
                            return [2, creditsData.data.url];
                        }
                        if (!creditsData.data.credits ||
                            creditsData.data.credits < TaoBaoNet_1.getTbData(TaoBaoNet_1.TbNetName.getActivityBaseInfoById).data.buyCredits[type]) {
                            ctrls_2.showPanel(CreditsOutPanel_1.CreditsOutPanel);
                            return [2, false];
                        }
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.exchange, { type: type, credits: creditsData.data.credits }, null, true)];
                    case 2:
                        res = _a.sent();
                        if (res.success) {
                            this.gameData.power = res.data.power;
                            this.gameData.tools = res.data.tools;
                            return [2, true];
                        }
                        else {
                            if (res.code == "730005") {
                                ctrls_2.showPanel(CreditsOutPanel_1.CreditsOutPanel);
                            }
                            else {
                                ctrls_1.showToast(res.message || "网络开小差了，请重试");
                            }
                            return [2, false];
                        }
                        return [2];
                }
            });
        });
    };
    Tools.checkPermission = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tbMy, cloud, url, urls;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tbMy = my;
                        if (!tbMy)
                            return [2];
                        cloud = getApp().cloud;
                        url = "cloud://B4F0300E5148F478B506DEDC26EA4C6C//butterfly0.svga";
                        return [4, cloud.file.getTempFileURL({ fileId: [url] })];
                    case 1:
                        urls = _a.sent();
                        url = urls[0].url.replace('-internal', '');
                        tbMy.downloadFile({
                            url: url,
                            success: function (res) {
                                var i = res.apFilePath;
                                tbMy.getFileSystemManager().readFile({
                                    filePath: i,
                                    success: function (r) {
                                    },
                                    fail: function (res) {
                                    }
                                });
                            },
                            fail: function (res) {
                            },
                        });
                        return [2];
                }
            });
        });
    };
    Tools.getSprite = function (imageName, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var sprite = new FYGE.Sprite(RES_1.RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite;
    };
    Tools.getText = function (txt, size, color, align, textWidth, x, y) {
        if (color === void 0) { color = "#000000"; }
        if (align === void 0) { align = FYGE.TEXT_ALIGN.LEFT; }
        if (textWidth === void 0) { textWidth = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var text = new FYGE.TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.x = x;
        text.y = y;
        text.text = txt;
        return text;
    };
    Tools.getRect = function (width, height, color, alpha, radius, x, y) {
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (radius === void 0) { radius = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        if (!radius) {
            g.drawRect(0, 0, width, height);
        }
        else {
            g.drawRoundedRect(0, 0, width, height, radius);
        }
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getCircle = function (radius, color, alpha, x, y) {
        if (radius === void 0) { radius = 10; }
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        g.drawCircle(0, 0, radius);
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getAdjustHeight = function (maxDis, minDis, type) {
        if (type === void 0) { type = "bot"; }
        var offsetY = (function () {
            if (type == "top")
                return 0;
            if (type == "bot")
                return layers_1.layers.stageOffsetY * 2;
            return layers_1.layers.stageOffsetY;
        })();
        if (layers_1.layers.stageHeight <= 1206)
            return minDis + offsetY;
        return (layers_1.layers.stageHeight - 1206) / (1624 - 1206) * (maxDis - minDis) + minDis + offsetY;
    };
    Tools.changeTextAlign = function (text, align, textWidth) {
        if (align == FYGE.TEXT_ALIGN.LEFT)
            return;
        text.textAlign = align;
        if (!textWidth)
            return;
        if (align == FYGE.TEXT_ALIGN.CENTER)
            text.x -= (textWidth - text.textWidth) / 2;
        if (align == FYGE.TEXT_ALIGN.RIGHT)
            text.x -= textWidth - text.textWidth;
        text.textWidth = textWidth;
    };
    Tools.customToast = function (target, call, time, showTime) {
        if (call === void 0) { call = function () { return 0; }; }
        if (time === void 0) { time = 2000; }
        if (showTime === void 0) { showTime = 300; }
        Tween.get(target)
            .set({ alpha: 0, visible: true })
            .to({ alpha: 1 }, showTime, Ease.quadIn)
            .wait(time)
            .to({ alpha: 0 }, showTime, Ease.quadOut)
            .set({ alpha: 0, visible: false })
            .call(function () {
            call();
        });
    };
    Tools.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Tools.getNumTextures = function (name) {
        var arr = {};
        for (var i = 0; i <= 9; i++)
            arr[i] = RES_1.RES.getRes(name + i + ".png");
        return arr;
    };
    Tools.cacheKey = "guideThreeSquirrels";
    return Tools;
}());
exports.Tools = Tools;


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "UpdateTask";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/common/ProgressBarS.ts":
/*!************************************!*\
  !*** ./src/common/ProgressBarS.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ProgressBarS = (function () {
    function ProgressBarS(upImage, txt) {
        this._value = 0;
        this.maxLength = upImage.width;
        this.upImage = upImage;
        this.progressTxt = txt;
        this.oriX = upImage.x;
        var delta = 0;
        if (upImage instanceof FYGE.FrameAni)
            delta = 0.5;
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(upImage.x - upImage.width * delta, upImage.y - upImage.height * delta, upImage.width, upImage.height, 111)
            .endFill();
        this.value = 0;
    }
    Object.defineProperty(ProgressBarS.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (v) {
            if (v < 0)
                v = 0;
            if (v > 1)
                v = 1;
            this._value = v;
            if (this.progressTxt)
                this.progressTxt.text = ((v * 100) >> 0) + "%";
            this.upImage.x = this.oriX - (1 - this._value) * this.maxLength;
        },
        enumerable: true,
        configurable: true
    });
    return ProgressBarS;
}());
exports.ProgressBarS = ProgressBarS;


/***/ }),

/***/ "./src/lotties/bonus_lottie.ts":
/*!*************************************!*\
  !*** ./src/lotties/bonus_lottie.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.bonus_lottie = {
    "v": "5.6.10",
    "fr": 30,
    "ip": 0,
    "op": 57,
    "w": 650,
    "h": 524,
    "nm": "bonus_lottie",
    "layers": [
        {
            "ind": 2,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                318.109,
                                440.532,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                333.561,
                                428.127,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                369.427,
                                399.332,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                413.619,
                                363.852,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                456.581,
                                329.36,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                489.472,
                                302.953,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                502.837,
                                292.223,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                509.312,
                                287.025,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                515.799,
                                281.816,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                522.28,
                                276.614,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        182.574,
                        182.574,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                338.516,
                                436.817,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                322.161,
                                434.618,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                284.199,
                                429.515,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                237.424,
                                423.228,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                191.952,
                                417.115,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                157.139,
                                412.435,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                142.993,
                                410.534,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                136.14,
                                409.612,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                129.273,
                                408.689,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                122.414,
                                407.767,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        159.746,
                        159.746,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                322.78,
                                453.3,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                325.789,
                                428.495,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                332.775,
                                370.917,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                341.382,
                                299.974,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                349.75,
                                231.006,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                356.156,
                                178.205,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                358.76,
                                156.75,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                360.021,
                                146.355,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                361.284,
                                135.941,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                362.547,
                                125.537,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        129.528,
                        129.528,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                331.047,
                                422.312,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                339.421,
                                404.74,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                358.86,
                                363.953,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                382.81,
                                313.698,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                406.094,
                                264.841,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                423.92,
                                227.438,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                431.163,
                                212.239,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                434.673,
                                204.876,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                438.189,
                                197.498,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                441.701,
                                190.128,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        138.809,
                        138.809,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                328.336,
                                430.832,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                338.298,
                                418.387,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                361.421,
                                389.499,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                389.913,
                                353.905,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                417.611,
                                319.301,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                438.816,
                                292.81,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                447.432,
                                282.045,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                451.607,
                                276.83,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                455.789,
                                271.605,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                459.967,
                                266.385,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        197.973,
                        197.973,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                333.908,
                                451.664,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                322.578,
                                430.469,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                296.277,
                                381.269,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                263.871,
                                320.648,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                232.368,
                                261.714,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                208.249,
                                216.596,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                198.449,
                                198.263,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                193.701,
                                189.381,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                188.943,
                                180.482,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                184.191,
                                171.592,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        148.369,
                        148.369,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                320.866,
                                434.132,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                302.855,
                                430.35,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                261.049,
                                421.571,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                209.538,
                                410.755,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                159.461,
                                400.239,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                121.123,
                                392.189,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                105.545,
                                388.918,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                97.998,
                                387.333,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                90.436,
                                385.745,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                82.882,
                                384.159,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        89.231,
                        89.231,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "img_0",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                340.512,
                                423.873,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                355.414,
                                413.184,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                390.005,
                                388.371,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                432.626,
                                357.799,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                474.06,
                                328.077,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                505.782,
                                305.323,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                518.671,
                                296.077,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                524.916,
                                291.597,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                531.173,
                                287.109,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                537.423,
                                282.626,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        199.16,
                        199.16,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "img_label.png",
            "refId": "img_1",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 54,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        422,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        245.5,
                        45.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                128,
                                120,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                90,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 54,
                            "s": [
                                128,
                                0,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 120
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "head.png",
            "parent": 12,
            "refId": "img_2",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        6.958,
                        -35.75,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11.5,
                        11,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "mouth.png",
            "parent": 15,
            "refId": "img_3",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        45.412,
                        65.667,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        7,
                        4.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "eyes.png",
            "parent": 12,
            "refId": "img_4",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        -16.75,
                        -6,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11,
                        11,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "eyes.png",
            "parent": 12,
            "refId": "img_4",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        30.25,
                        -6,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11,
                        11,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "body.png",
            "refId": "img_5",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 12
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                478,
                                453.75,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                498,
                                386.25,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                494,
                                402.75,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                494,
                                402.75,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                495,
                                398,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                494,
                                402.75,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        65.125,
                        91.478,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                70,
                                60,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                110,
                                110,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                110,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                110,
                                110,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                108,
                                112,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                110,
                                110,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "hand_r.png",
            "parent": 15,
            "refId": "img_6",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                24
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        85.889,
                        91.186,
                        0
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        5.25,
                        5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 17,
            "ty": 2,
            "nm": "hand_l.png",
            "parent": 15,
            "refId": "img_7",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                -24
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        15.012,
                        90.503,
                        0
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        12.375,
                        4.25,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 18,
            "ty": 2,
            "nm": "hand_l.png",
            "parent": 23,
            "refId": "img_8",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                -12
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        28.212,
                        20.782,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        31.212,
                        44.782,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 19,
            "ty": 2,
            "nm": "hand_r.png",
            "parent": 23,
            "refId": "img_9",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        111.233,
                        18.58,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11.233,
                        42.58,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 20,
            "ty": 2,
            "nm": "eye.png",
            "parent": 22,
            "refId": "img_10",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        20.25,
                        -13,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11,
                        10,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 21,
            "ty": 2,
            "nm": "eye.png",
            "parent": 22,
            "refId": "img_10",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        -5.5,
                        -13,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11,
                        10,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 22,
            "ty": 2,
            "nm": "mouth.png",
            "parent": 23,
            "refId": "img_3",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                70.5,
                                14.25,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                70.5,
                                11.25,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                70.5,
                                14.25,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        7,
                        4.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100,
                                90,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 23,
            "ty": 2,
            "nm": "body.png",
            "parent": 25,
            "td": 1,
            "refId": "img_11",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        71,
                        43,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        71,
                        43,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 24,
            "ty": 2,
            "nm": "tummy.png",
            "parent": 25,
            "tt": 1,
            "refId": "img_12",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                70.214,
                                65.101,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                70,
                                62.5,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                70.214,
                                65.101,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        34,
                        21.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 25,
            "ty": 2,
            "nm": "body.png",
            "refId": "img_11",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": -12
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                192.5,
                                440.75,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                180.5,
                                374.75,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                182.5,
                                385.75,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        71.194,
                        75.756,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                80,
                                70,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100,
                                95,
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 26,
            "ty": 2,
            "nm": "fox_hand_hammer.png",
            "parent": 29,
            "refId": "img_13",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        153.147,
                        34.691,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        33.5,
                        215.25,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 27,
            "ty": 2,
            "nm": "fox_head1.png",
            "parent": 29,
            "refId": "img_14",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0,
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        108.324,
                        20.765,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        225.235,
                        303.765,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 29,
            "ty": 2,
            "nm": "fox_body1.png",
            "tt": 2,
            "refId": "img_15",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                328,
                                475,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                328,
                                326,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                328,
                                374,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                328,
                                364,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        87,
                        109,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                60,
                                56,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                68,
                                68,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 30,
            "ty": 2,
            "nm": "fox_hand_l.png",
            "parent": 29,
            "refId": "img_16",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                16
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                16
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        46.147,
                        40.941,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        119.5,
                        21,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 32,
            "ty": 2,
            "nm": "fox_tail.png",
            "parent": 29,
            "tt": 2,
            "refId": "img_17",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        159.794,
                        94.294,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        18.618,
                        197.382,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 33,
            "ty": 2,
            "nm": "bg_light.png",
            "refId": "img_18",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        327,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        324,
                        405.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                40,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0,
                                30,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 84
        },
        {
            "ind": 34,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                -47
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                -12
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                70,
                                70,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                70,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 35,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                -25
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                -6
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                120,
                                110,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                110,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 36,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 37,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                22
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                6
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                80,
                                80,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                80,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 38,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                44
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                12
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                110,
                                105,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                105,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 39,
            "ty": 2,
            "nm": "bonus_light_11.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": -47
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                70,
                                25,
                                100
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                70,
                                70,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 40,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": -25
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                120,
                                40,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                120,
                                110,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 41,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 42,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 22
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                80,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                80,
                                80,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 43,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "img_19",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 44
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                110,
                                40,
                                100
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                110,
                                105,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        }
    ]
};


/***/ }),

/***/ "./src/lotties/loading_animal.ts":
/*!***************************************!*\
  !*** ./src/lotties/loading_animal.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.loading_animal = {
    "v": "5.6.10",
    "fr": 30,
    "ip": 0,
    "op": 60,
    "w": 750,
    "h": 1624,
    "nm": "loading_animal",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "owl_sleep.png",
            "parent": 2,
            "refId": "image_0",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        {
                            "t": 15,
                            "s": [
                                41.002,
                                21.5,
                                0
                            ]
                        },
                        {
                            "t": 42,
                            "s": [
                                41.115,
                                27.521,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        26,
                        9.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 15,
            "op": 42
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "img_owl.png",
            "refId": "image_1",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 42,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                6
                            ]
                        },
                        {
                            "t": 54,
                            "s": [
                                -2
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 42,
                            "s": [
                                679.5,
                                559,
                                0
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                679.5,
                                547,
                                0
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                679.5,
                                559,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        48,
                        110.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "img_tree.png",
            "refId": "image_2",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 42,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                -2
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        739,
                        566.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        150,
                        29.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "fox_head.png",
            "parent": 6,
            "refId": "image_3",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        87.5,
                        -4,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        206,
                        250.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "hommer.png",
            "parent": 6,
            "refId": "image_4",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 40,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                6
                            ]
                        },
                        {
                            "t": 50,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 55,
                            "s": [
                                6
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                -6
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        143,
                        32,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        29.5,
                        201.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "fox_body.png",
            "refId": "image_5",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -1
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                1
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        356,
                        992,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        85,
                        206,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "fox_arm_l.png",
            "parent": 6,
            "refId": "image_6",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                2
                            ]
                        },
                        {
                            "t": 40,
                            "s": [
                                2
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 50,
                            "s": [
                                2
                            ]
                        },
                        {
                            "t": 55,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                2
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        45,
                        44,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        116,
                        32,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "carb_hand_r.png",
            "parent": 10,
            "refId": "image_8",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                8.75,
                                18,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                4.25,
                                8,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        17.5,
                        42.25,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                -95,
                                95,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "carb_arm.png",
            "parent": 13,
            "refId": "image_9",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                107,
                                46.75,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                101,
                                32.25,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        12.75,
                        18,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        -100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "carb_hand_l.png",
            "parent": 12,
            "refId": "image_10",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                5.75,
                                3.5,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                10.75,
                                16,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        26.5,
                        39.25,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "carb_arm.png",
            "parent": 13,
            "refId": "image_9",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                28,
                                31.75,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                23,
                                45.75,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "a": {
                    "a": 0,
                    "k": [
                        12.5,
                        17.75,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "carb_body.png",
            "refId": "image_11",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                -2
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('pingpong', 0);"
                },
                "p": {
                    "a": 0,
                    "k": [
                        566.5,
                        1031,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        64.5,
                        93,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/panels/BuyPowerPanel.ts":
/*!*************************************!*\
  !*** ./src/panels/BuyPowerPanel.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var JoinPanel_1 = __webpack_require__(/*! ./JoinPanel */ "./src/panels/JoinPanel.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var BuyPowerPanel = (function (_super) {
    __extends(BuyPowerPanel, _super);
    function BuyPowerPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(BuyPowerPanel.prototype, "groupNames", {
        get: function () {
            return ["BuyPowerPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BuyPowerPanel.prototype, "skinName", {
        get: function () {
            return "BuyPowerPanel";
        },
        enumerable: true,
        configurable: true
    });
    BuyPowerPanel.prototype.initUi = function () {
        var _this = this;
        var btnTxt = this.exchangeBtn.addChild(Tools_1.Tools.getText('1店铺积分', 36, '#ffffff', TEXT_ALIGN.CENTER, this.exchangeBtn.width, 0, -6));
        btnTxt.textHeight = this.exchangeBtn.height;
        btnTxt.verticalAlign = VERTICAL_ALIGN.MIDDLE;
        btnTxt.bold = true;
        btnTxt.stroke = 3;
        btnTxt.strokeColor = '#21926e';
        this.msgTxt.bold = true;
        this.msgTxt.stroke = 3;
        this.msgTxt.strokeColor = '#21926e';
        this.exchangeBtn.addEventListener(FYGE.MouseEvent.CLICK, function () { return __awaiter(_this, void 0, void 0, function () {
            var res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.exchange(PropType_1.PropType.POWER)];
                    case 1:
                        res = _a.sent();
                        ctrls_1.hideWaiting();
                        if (typeof res == "string") {
                            ctrls_1.showPanel(JoinPanel_1.JoinPanel, { url: res });
                        }
                        else if (res) {
                            ctrls_1.showToast("兑换成功");
                            this.hidePanel();
                            ctrls_1.getCurrentScene().updateScene();
                        }
                        return [2];
                }
            });
        }); }, this);
    };
    BuyPowerPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    BuyPowerPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    BuyPowerPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return BuyPowerPanel;
}(Panel_1.Panel));
exports.BuyPowerPanel = BuyPowerPanel;


/***/ }),

/***/ "./src/panels/CreditsOutPanel.ts":
/*!***************************************!*\
  !*** ./src/panels/CreditsOutPanel.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var CreditsOutPanel = (function (_super) {
    __extends(CreditsOutPanel, _super);
    function CreditsOutPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(CreditsOutPanel.prototype, "groupNames", {
        get: function () { return ["CreditsOutPanel"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CreditsOutPanel.prototype, "skinName", {
        get: function () { return "CreditsOutPanel"; },
        enumerable: true,
        configurable: true
    });
    CreditsOutPanel.prototype.initUi = function () {
    };
    CreditsOutPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    CreditsOutPanel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        this.earnBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            Tools_1.Tools.btnDelay(_this);
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, {
                url: "https://market.m.taobao.com/app/tb-source-app/shopact/pages/index?wh_weex=true&pathInfo=shop/activity&userId=2275046294&shopId=114637892&pageId=187145736&alisite=true"
            });
        }, this);
    };
    CreditsOutPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return CreditsOutPanel;
}(Panel_1.Panel));
exports.CreditsOutPanel = CreditsOutPanel;


/***/ }),

/***/ "./src/panels/ExchangeSucPanel.ts":
/*!****************************************!*\
  !*** ./src/panels/ExchangeSucPanel.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var ExchangeSucPanel = (function (_super) {
    __extends(ExchangeSucPanel, _super);
    function ExchangeSucPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ExchangeSucPanel.prototype, "groupNames", {
        get: function () { return ["ExchangeSucPanel"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ExchangeSucPanel.prototype, "skinName", {
        get: function () { return "ExchangeSucPanel"; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ExchangeSucPanel.prototype, "closeBtns", {
        get: function () {
            return [this.knowBtn, this.closeBtn];
        },
        enumerable: true,
        configurable: true
    });
    return ExchangeSucPanel;
}(Panel_1.Panel));
exports.ExchangeSucPanel = ExchangeSucPanel;


/***/ }),

/***/ "./src/panels/FailedPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/FailedPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var FailedPanel = (function (_super) {
    __extends(FailedPanel, _super);
    function FailedPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FailedPanel.prototype, "groupNames", {
        get: function () {
            return ["FailedPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FailedPanel.prototype, "skinName", {
        get: function () {
            return "FailedPanel";
        },
        enumerable: true,
        configurable: true
    });
    FailedPanel.prototype.initUi = function () {
        this.checkTex.text = "\u7B2C\t" + this.data.level + "\t\u5173";
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 2;
        this.checkTex.textWidth = 750;
        var curLevel = Tools_1.Tools.gameData.currentLevel;
        var upLevel = 120;
        var dLevel = 120;
        Tools_1.Tools.baseInfo.prizeLevels.forEach(function (value, index) {
            var d = value - curLevel;
            if (curLevel <= value && d >= 0 && d <= dLevel) {
                upLevel = value;
                dLevel = d + 1;
            }
        });
        this.tipsTex.text = "\t\t\t\u518D\u63A5\u518D\u5389\uFF01\n\u518D\u89E3\u9501" + dLevel + "\u5173\u53EF\u53C2\u4E0E\u62BD\u5956";
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        if (Tools_1.Tools.gameData.currentLevel == 120
            && MapScene_1.MapScene.checkArr && MapScene_1.MapScene.checkArr[120]
            && MapScene_1.MapScene.checkArr[120].checkData.isVisitSuccess) {
            this.tipsTex.text = '';
        }
    };
    FailedPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    FailedPanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    FailedPanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    FailedPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
    };
    FailedPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
    };
    return FailedPanel;
}(Panel_1.Panel));
exports.FailedPanel = FailedPanel;


/***/ }),

/***/ "./src/panels/FreePowerPanel.ts":
/*!**************************************!*\
  !*** ./src/panels/FreePowerPanel.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var FreePowerPanel = (function (_super) {
    __extends(FreePowerPanel, _super);
    function FreePowerPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FreePowerPanel.prototype, "groupNames", {
        get: function () { return ["FreePowerPanel"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreePowerPanel.prototype, "skinName", {
        get: function () { return "FreePowerPanel"; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreePowerPanel.prototype, "closeBtns", {
        get: function () {
            return [this.closeBtn, this.acceptBtn];
        },
        enumerable: true,
        configurable: true
    });
    return FreePowerPanel;
}(Panel_1.Panel));
exports.FreePowerPanel = FreePowerPanel;


/***/ }),

/***/ "./src/panels/JoinPanel.ts":
/*!*********************************!*\
  !*** ./src/panels/JoinPanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var JoinPanel = (function (_super) {
    __extends(JoinPanel, _super);
    function JoinPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(JoinPanel.prototype, "groupNames", {
        get: function () {
            return ["JoinPanel"];
        },
        enumerable: true,
        configurable: true
    });
    JoinPanel.prototype.initUi = function () {
        var _this = this;
        this.addChild(FYGE.Sprite.fromFrame("joinBg.png"));
        this.addChild(new FYGE.Button(RES_1.RES.getRes("关闭按钮.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, function () { _this.hidePanel(); }, this)
            .position.set(634, 472);
        this.addChild(new FYGE.Button(RES_1.RES.getRes("joinBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, function () {
            _this.enableMouseEvt(false);
            ctrls_1.wait(function () { _this.enableMouseEvt(true); }, 2000);
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: _this.data.url });
            Main_1.GDispatcher.once(G_EVENT_1.G_EVENT.ON_SHOW, function () {
                _this.hidePanel();
            }, _this);
        }, this)
            .position.set(166, 744);
    };
    return JoinPanel;
}(Panel_1.Panel));
exports.JoinPanel = JoinPanel;


/***/ }),

/***/ "./src/panels/NoEnergyPanel.ts":
/*!*************************************!*\
  !*** ./src/panels/NoEnergyPanel.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var BuyPowerPanel_1 = __webpack_require__(/*! ./BuyPowerPanel */ "./src/panels/BuyPowerPanel.ts");
var NoEnergyPanel = (function (_super) {
    __extends(NoEnergyPanel, _super);
    function NoEnergyPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoEnergyPanel.prototype, "groupNames", {
        get: function () {
            return ["NoEnergyPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NoEnergyPanel.prototype, "skinName", {
        get: function () {
            return "NoEnergyPanel";
        },
        enumerable: true,
        configurable: true
    });
    NoEnergyPanel.prototype.initUi = function () {
    };
    NoEnergyPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    NoEnergyPanel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        this.okBtn.addEventListener(MouseEvent.CLICK, function () {
            ctrls_1.showPanel(BuyPowerPanel_1.BuyPowerPanel);
            _this.hidePanel();
        }, this);
    };
    NoEnergyPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return NoEnergyPanel;
}(Panel_1.Panel));
exports.NoEnergyPanel = NoEnergyPanel;


/***/ }),

/***/ "./src/panels/NoPrizePanel.ts":
/*!************************************!*\
  !*** ./src/panels/NoPrizePanel.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var NoPrizePanel = (function (_super) {
    __extends(NoPrizePanel, _super);
    function NoPrizePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoPrizePanel.prototype, "groupNames", {
        get: function () { return ["NoPrizePanel"]; },
        enumerable: true,
        configurable: true
    });
    NoPrizePanel.prototype.initUi = function () {
        this.addChild(new FYGE.Sprite(RES_1.RES.getRes("noPrizeBg.png")));
        this.addChild(new FYGE.Button(RES_1.RES.getRes("关闭按钮.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.hidePanel, this)
            .position.set(633, 468);
        this.addChild(new FYGE.Button(RES_1.RES.getRes("知道了.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.hidePanel, this)
            .position.set(165, 759);
    };
    return NoPrizePanel;
}(Panel_1.Panel));
exports.NoPrizePanel = NoPrizePanel;


/***/ }),

/***/ "./src/panels/NoStepPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/NoStepPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var ToolsOutPanel_1 = __webpack_require__(/*! ./ToolsOutPanel */ "./src/panels/ToolsOutPanel.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var NoStepPanel = (function (_super) {
    __extends(NoStepPanel, _super);
    function NoStepPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoStepPanel.prototype, "groupNames", {
        get: function () { return ["NoStepPanel"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NoStepPanel.prototype, "skinName", {
        get: function () { return "NoStepPanel"; },
        enumerable: true,
        configurable: true
    });
    NoStepPanel.prototype.initUi = function () {
        this.tipsTex.textAlign = FYGE.TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 500;
        this.tipsTex.x = (750 - 500) / 2;
        this.tipsTex.text = "是否使用步数道具\n增加5次步数";
    };
    NoStepPanel.prototype.initEvents = function () {
        var _this = this;
        [this.closeBtn, this.overBtn].forEach(function (e) {
            e.addEventListener(FYGE.MouseEvent.CLICK, function () {
                ctrls_1.getCurrentScene().submit(false);
                _this.hidePanel();
            }, _this);
        });
        this.liveBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            if (!Tools_1.Tools.gameData.tools.STEPS) {
                ctrls_1.showPanel(ToolsOutPanel_1.ToolsOutPanel, { type: PropType_1.PropType.STEPS, showSucPanel: false });
            }
            else {
                _this.data.reviveFun();
                _this.hidePanel();
            }
        }, this);
    };
    NoStepPanel.prototype.removeEvents = function () {
    };
    return NoStepPanel;
}(Panel_1.Panel));
exports.NoStepPanel = NoStepPanel;


/***/ }),

/***/ "./src/panels/PrizePanel.ts":
/*!**********************************!*\
  !*** ./src/panels/PrizePanel.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Texture = FYGE.Texture;
var MouseEvent = FYGE.MouseEvent;
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var PrizePanel = (function (_super) {
    __extends(PrizePanel, _super);
    function PrizePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PrizePanel.prototype, "groupNames", {
        get: function () {
            return ["PrizePanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PrizePanel.prototype, "skinName", {
        get: function () {
            return "PrizePanel";
        },
        enumerable: true,
        configurable: true
    });
    PrizePanel.prototype.initUi = function () {
        this.prizeTxt.textAlign = TEXT_ALIGN.CENTER;
        this.prizeTxt.textWidth = 750;
        this.prizeTxt.x = 0;
        this.prizeTxt.text = "\u606D\u559C\u83B7\u5F97" + this.data.name;
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 375;
        this.prizeImg.texture = Texture.fromUrl(this.data.image);
    };
    PrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    PrizePanel.prototype.clickPrizeBtn = function () {
        var _this = this;
        this.btnDelay(this.prizeBtn);
        switch (this.data.type) {
            case 1:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveEnamePrize, { _id: this.data._id }, function (success, res) {
                    if (!success || !res) {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                        _this.hidePanel();
                        return;
                    }
                    if (res.data && res.data.drawStatus == 3) {
                        ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    }
                    else {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                    }
                    _this.hidePanel();
                }, true);
                break;
            case 3:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUserAddress, { prizeId: this.data._id }, function (success, res) {
                    if (!success) {
                        return;
                    }
                    ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    _this.hidePanel();
                }, true);
                break;
            case 2:
            case 5:
                this.hidePanel();
                break;
        }
    };
    PrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.prizeBtn.addEventListener(MouseEvent.CLICK, this.clickPrizeBtn, this);
    };
    PrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.prizeBtn.removeEventListener(MouseEvent.CLICK, this.clickPrizeBtn, this);
    };
    return PrizePanel;
}(Panel_1.Panel));
exports.PrizePanel = PrizePanel;


/***/ }),

/***/ "./src/panels/RulePanel.ts":
/*!*********************************!*\
  !*** ./src/panels/RulePanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
var ScrollPage = FYGE.ScrollPage;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RulePanel = (function (_super) {
    __extends(RulePanel, _super);
    function RulePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RulePanel.prototype, "groupNames", {
        get: function () {
            return ["RulePanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RulePanel.prototype, "skinName", {
        get: function () {
            return "RulePanel";
        },
        enumerable: true,
        configurable: true
    });
    RulePanel.prototype.initUi = function () {
    };
    RulePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
        var rule = Tools_1.Tools.baseInfo.rule;
        this.ruleTex = this.addChild(Tools_1.Tools.getText(rule, 26, '#892a1a', FYGE.TEXT_ALIGN.LEFT, 570));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;
        this.scroll = this.addChild(new ScrollPage(570, 600, this.ruleTex.textHeight + 30));
        this.scroll.position.set(96, 549);
        this.scroll.view.addChild(this.ruleTex);
    };
    RulePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    RulePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return RulePanel;
}(Panel_1.Panel));
exports.RulePanel = RulePanel;


/***/ }),

/***/ "./src/panels/StartPanel.ts":
/*!**********************************!*\
  !*** ./src/panels/StartPanel.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Container = FYGE.Container;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var PlayScene_1 = __webpack_require__(/*! ../scene/PlayScene */ "./src/scene/PlayScene.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var NoEnergyPanel_1 = __webpack_require__(/*! ./NoEnergyPanel */ "./src/panels/NoEnergyPanel.ts");
var StartPanel = (function (_super) {
    __extends(StartPanel, _super);
    function StartPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartPanel.prototype, "groupNames", {
        get: function () {
            return ["StartPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(StartPanel.prototype, "skinName", {
        get: function () {
            return "StartPanel";
        },
        enumerable: true,
        configurable: true
    });
    StartPanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    StartPanel.prototype.initUi = function () {
        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = "\u7B2C\t" + this.data.level + "\t\u5173";
        this.startBtn.visible = !this.data.isPlayed;
        this.startBtn2.visible = this.data.isPlayed;
        this.tipsTex.visible = !this.data.isPlayed;
        this.addChild(new StartTarget(this.data.level))
            .position.set(0, 682);
    };
    StartPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    StartPanel.prototype.startGame = function () {
        var _this = this;
        this.enableMouseEvt(false);
        if (!this.data.isPlayed && Tools_1.Tools.gameData.power <= 0) {
            ctrls_1.showPanel(NoEnergyPanel_1.NoEnergyPanel);
            this.enableMouseEvt(true);
            return;
        }
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.dojoin, { level: this.data.level }, function (success, res) {
            _this.enableMouseEvt(true);
            if (!success)
                return;
            Tools_1.Tools.gameData.power = res.data.power;
            ctrls_1.changeScene(PlayScene_1.PlayScene, { chapter: _this.data.level });
            _this.hidePanel();
        });
    };
    StartPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    StartPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    return StartPanel;
}(Panel_1.Panel));
exports.StartPanel = StartPanel;
var pos = [
    [325],
    [240, 410],
    [180, 325, 470],
];
var StartTarget = (function (_super) {
    __extends(StartTarget, _super);
    function StartTarget(checkNum) {
        var _this = _super.call(this) || this;
        var passTarget = getChapter_1.getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) {
        }
        else if (passTarget.type == 1) {
            passTarget.elements.forEach(function (v, i) {
                var targetItem = _this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(function () {
                    targetItem.playEffect();
                }, i * 200);
            });
        }
        return _this;
    }
    return StartTarget;
}(Container));
exports.StartTarget = StartTarget;
var StartTargetItem = (function (_super) {
    __extends(StartTargetItem, _super);
    function StartTargetItem(data) {
        var _this = _super.call(this) || this;
        var targetImg = _this.addChild(Tools_1.Tools.getSprite("ele" + data.type + ".png"));
        targetImg.width = targetImg.height = 100;
        var targetTex = _this.addChild(Tools_1.Tools.getText("" + data.count, 30, '#ffffff', TEXT_ALIGN.CENTER, 100, 0, 108));
        targetTex.strokeColor = '#eb5b57';
        targetTex.stroke = 3;
        _this.anchor.set(50, 79);
        _this.scale.set(0, 0);
        return _this;
    }
    StartTargetItem.prototype.playEffect = function () {
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 500, Ease.backOut);
    };
    return StartTargetItem;
}(Container));
exports.StartTargetItem = StartTargetItem;


/***/ }),

/***/ "./src/panels/StartPanelPrize.ts":
/*!***************************************!*\
  !*** ./src/panels/StartPanelPrize.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var PlayScene_1 = __webpack_require__(/*! ../scene/PlayScene */ "./src/scene/PlayScene.ts");
var StartPanel_1 = __webpack_require__(/*! ./StartPanel */ "./src/panels/StartPanel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Texture = FYGE.Texture;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var NoEnergyPanel_1 = __webpack_require__(/*! ./NoEnergyPanel */ "./src/panels/NoEnergyPanel.ts");
var StartPanelPrize = (function (_super) {
    __extends(StartPanelPrize, _super);
    function StartPanelPrize() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartPanelPrize.prototype, "groupNames", {
        get: function () {
            return ["StartPanelPrize"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(StartPanelPrize.prototype, "skinName", {
        get: function () {
            return "StartPanelPrize";
        },
        enumerable: true,
        configurable: true
    });
    StartPanelPrize.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    StartPanelPrize.prototype.initUi = function () {
        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = "\u7B2C\t" + this.data.level + "\t\u5173";
        this.startBtn.visible = !this.data.isPlayed;
        this.startBtn2.visible = this.data.isPlayed;
        this.addChild(new StartPanel_1.StartTarget(this.data.level))
            .position.set(0, 682);
        this.prizeImg.texture = Texture.fromUrl(Tools_1.Tools.baseInfo.levelPrize["level_" + this.data.level]);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 750 / 2;
    };
    StartPanelPrize.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    StartPanelPrize.prototype.startGame = function () {
        var _this = this;
        this.enableMouseEvt(false);
        if (!this.data.isPlayed && Tools_1.Tools.gameData.power <= 0) {
            ctrls_1.showPanel(NoEnergyPanel_1.NoEnergyPanel);
            this.enableMouseEvt(true);
            return;
        }
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.dojoin, { level: this.data.level }, function (success, res) {
            _this.enableMouseEvt(true);
            if (!success)
                return;
            Tools_1.Tools.gameData.power = res.data.power;
            ctrls_1.changeScene(PlayScene_1.PlayScene, { chapter: _this.data.level });
            _this.hidePanel();
        });
    };
    StartPanelPrize.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    StartPanelPrize.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    return StartPanelPrize;
}(Panel_1.Panel));
exports.StartPanelPrize = StartPanelPrize;


/***/ }),

/***/ "./src/panels/SuccessNoPrizePanel.ts":
/*!*******************************************!*\
  !*** ./src/panels/SuccessNoPrizePanel.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Container = FYGE.Container;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var FrameAni = FYGE.FrameAni;
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var SuccessNoPrizePanel = (function (_super) {
    __extends(SuccessNoPrizePanel, _super);
    function SuccessNoPrizePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.starGroup = null;
        return _this;
    }
    Object.defineProperty(SuccessNoPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel', 'starLight'];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SuccessNoPrizePanel.prototype, "skinName", {
        get: function () {
            return "SuccessNoPrizePanel";
        },
        enumerable: true,
        configurable: true
    });
    SuccessNoPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessNoPrizePanel.prototype.initUi = function () {
        var _this = this;
        this.checkTex.text = "\u7B2C\t" + this.data.level + "\t\u5173";
        this.checkTex.textWidth = 750;
        this.checkTex.x = 0;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.starGroup = this.addChild(new SuccessStarGroup());
        this.starGroup.position.set(373, 680);
        this.lightEffect();
        this.starGroup.play(this.data.stars);
        if (this.data.stars >= 3) {
            this.againBtn.visible = false;
            this.continueBtn.visible = false;
        }
        else {
            this.totalContinueBtn.visible = false;
        }
        if (Tools_1.Tools.gameData.currentLevel == 120
            && MapScene_1.MapScene.checkArr && MapScene_1.MapScene.checkArr[120]
            && MapScene_1.MapScene.checkArr[120].checkData.isVisitSuccess) {
            this.tipsTex.text = '';
        }
        else if (MapScene_1.MapScene.checkArr && MapScene_1.MapScene.checkArr[this.data.level] && MapScene_1.MapScene.checkArr[this.data.level].sendAwardType) {
            var curLevel_1 = Tools_1.Tools.gameData.currentLevel;
            var upLevel_1 = 120;
            var dLevel_1 = 120;
            Tools_1.Tools.baseInfo.prizeLevels.forEach(function (value, index) {
                var d = value - curLevel_1;
                if (curLevel_1 <= value && d >= 0 && d <= dLevel_1) {
                    upLevel_1 = value;
                    if (curLevel_1 == _this.data.level) {
                        dLevel_1 = d;
                    }
                    else {
                        dLevel_1 = d + 1;
                    }
                }
            });
            this.tipsTex.text = "\t\t\t\u592A\u5389\u5BB3\u4E86\uFF01\n\u518D\u89E3\u9501" + dLevel_1 + "\u5173\u53EF\u4EE5\u62BD\u5956\u4E86";
            this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
            this.tipsTex.textWidth = 750;
            this.tipsTex.x = 0;
        }
        else {
            if (this.data.isPrizeLevel) {
                this.tipsTex.text = '闯关成功！挑战满星通关\n获得抽大奖机会！';
            }
            else {
                this.tipsTex.text = '闯关成功！挑战满星通关\n有概率获得随机道具一个';
            }
        }
    };
    SuccessNoPrizePanel.prototype.lightEffect = function () {
        Tween.get(this.light1, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: 360 }, 12000);
        Tween.get(this.light2, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: -360 }, 12000);
    };
    SuccessNoPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessNoPrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
    };
    SuccessNoPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.continue = function () {
        if (this.data.level == 120) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
    };
    return SuccessNoPrizePanel;
}(Panel_1.Panel));
exports.SuccessNoPrizePanel = SuccessNoPrizePanel;
var SuccessStarGroup = (function (_super) {
    __extends(SuccessStarGroup, _super);
    function SuccessStarGroup() {
        var _this = _super.call(this) || this;
        _this.leftStarDis = null;
        _this.midStarDis = null;
        _this.rightStarDis = null;
        _this.leftStarEn = null;
        _this.midStarEn = null;
        _this.rightStarEn = null;
        _this.leftStarAni = null;
        _this.midStarAni = null;
        _this.rightStarAni = null;
        _this.leftStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.midStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.rightStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.leftStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.midStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.rightStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.leftStarDis.anchorTexture.set(0.5, 0.5);
        _this.midStarDis.anchorTexture.set(0.5, 0.5);
        _this.rightStarDis.anchorTexture.set(0.5, 0.5);
        _this.leftStarEn.anchorTexture.set(0.5, 0.5);
        _this.midStarEn.anchorTexture.set(0.5, 0.5);
        _this.rightStarEn.anchorTexture.set(0.5, 0.5);
        _this.leftStarDis.position.set(-158, 36);
        _this.leftStarDis.rotation = -25;
        _this.leftStarDis.scale.set(0.81, 0.81);
        _this.leftStarEn.position.set(-157, 41);
        _this.leftStarEn.rotation = -25;
        _this.leftStarEn.scale.set(0.81, 0.81);
        _this.midStarEn.y = 5;
        _this.rightStarDis.position.set(157, 37);
        _this.rightStarDis.rotation = 25;
        _this.rightStarDis.scale.set(0.81, 0.81);
        _this.rightStarEn.position.set(156, 41);
        _this.rightStarEn.rotation = 25;
        _this.rightStarEn.scale.set(0.81, 0.81);
        _this.leftStarEn.scale.set(0, 0);
        _this.midStarEn.scale.set(0, 0);
        _this.rightStarEn.scale.set(0, 0);
        var starAniFrame = new Array(16);
        for (var i = 0; i < 15; i++) {
            starAniFrame[i] = RES_1.RES.getRes("star_light_" + i + ".png");
        }
        starAniFrame[15] = null;
        _this.leftStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.leftStarAni.visible = false;
        _this.leftStarAni.position.set(-158, 44);
        _this.midStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.midStarAni.visible = false;
        _this.midStarAni.y = 8;
        _this.rightStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.rightStarAni.visible = false;
        _this.rightStarAni.position.set(158, 42);
        return _this;
    }
    SuccessStarGroup.prototype.play = function (count, wait) {
        var _this = this;
        if (wait === void 0) { wait = 600; }
        var time1 = 200;
        var time2 = 100;
        var max = 3;
        var interval = 100;
        Tween.get(this.leftStarEn)
            .wait(wait)
            .set({ scaleX: max, scaleY: max })
            .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
            .call(function () {
            _this.leftStarAni.visible = true;
            _this.leftStarAni.play(1);
        })
            .to({ scaleX: 0.81, scaleY: 0.81 }, time2, Ease.quadOut)
            .wait(interval)
            .call(function () {
            if (count <= 1)
                return;
            Tween.get(_this.midStarEn)
                .set({ scaleX: max, scaleY: max })
                .to({ scaleX: 0.8, scaleY: 0.8 }, time1, Ease.quadOut)
                .call(function () {
                _this.midStarAni.visible = true;
                _this.midStarAni.play(1);
            })
                .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
                .wait(interval)
                .call(function () {
                if (count <= 2)
                    return;
                Tween.get(_this.rightStarEn)
                    .set({ scaleX: max, scaleY: max })
                    .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
                    .call(function () {
                    _this.rightStarAni.visible = true;
                    _this.rightStarAni.play(1);
                })
                    .to({ scaleX: 0.81, scaleY: 0.81 }, time2, Ease.quadOut);
            });
        });
    };
    return SuccessStarGroup;
}(Container));
exports.SuccessStarGroup = SuccessStarGroup;


/***/ }),

/***/ "./src/panels/SuccessPrizePanel.ts":
/*!*****************************************!*\
  !*** ./src/panels/SuccessPrizePanel.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Texture = FYGE.Texture;
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var MouseEvent = FYGE.MouseEvent;
var LotteryScene_1 = __webpack_require__(/*! ../scene/LotteryScene */ "./src/scene/LotteryScene.ts");
var SuccessPrizePanel = (function (_super) {
    __extends(SuccessPrizePanel, _super);
    function SuccessPrizePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.starGroup = null;
        return _this;
    }
    Object.defineProperty(SuccessPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel', 'starLight'];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SuccessPrizePanel.prototype, "skinName", {
        get: function () {
            return "SuccessPrizePanel";
        },
        enumerable: true,
        configurable: true
    });
    SuccessPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessPrizePanel.prototype.initUi = function () {
        this.checkTex.text = "\u7B2C\t" + this.data.level + "\t\u5173";
        this.checkTex.textWidth = 750;
        this.checkTex.x = 0;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.starGroup = this.addChild(new SuccessNoPrizePanel_1.SuccessStarGroup());
        this.starGroup.position.set(373, 678);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 375;
        this.lightEffect();
        this.starGroup.play(this.data.stars);
        var propImg = this.prop.getChildByName('img');
        var propLabel = this.prop.getChildByName('label');
        if (this.data.tool && this.data.tool.type) {
            this.againBtn.visible = false;
            this.goPrizeBtn.visible = false;
            this.prizeImg.visible = false;
            this.tipsTex.text = '\t\t满星过关！';
            switch (this.data.tool.type) {
                case PropType_1.PropType.BOOMS:
                    propImg.texture = RES_1.RES.getRes('boomBtn.png');
                    propImg.y += 5;
                    propImg.x += 15;
                    propLabel.text = '炸弹道具\tx1';
                    break;
                case PropType_1.PropType.HAMMERS:
                    propImg.texture = RES_1.RES.getRes('hammerBtn.png');
                    propImg.x += 10;
                    propLabel.text = '锤子道具\tx1';
                    break;
                case PropType_1.PropType.STEPS:
                    propImg.texture = RES_1.RES.getRes('stepBtn.png');
                    propLabel.text = '步数道具\tx1';
                    break;
            }
        }
        else if (this.data.prize && this.data.prize.image) {
            if (this.data.level == 120) {
                this.againBtn.visible = false;
                this.goPrizeBtn.visible = false;
                this.noPrizeAgainBtn.changeTexture(RES_1.RES.getRes("开奖按钮120.png"));
            }
            else {
                this.noPrizeAgainBtn.visible = false;
            }
            this.prop.visible = false;
            this.prizeImg.texture = Texture.fromUrl(this.data.prize.image);
            this.tipsTex.text = '\t闯关成功！有机会抽取如下奖品';
        }
    };
    SuccessPrizePanel.prototype.lightEffect = function () {
        Tween.get(this.light1, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: 360 }, 12000);
        Tween.get(this.light2, { loop: true })
            .set({ anchorX: 219.5, anchorY: 219.5 })
            .to({ rotation: -360 }, 12000);
    };
    SuccessPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.continue = function () {
        if (this.data.level == 120) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.goPrize = function () {
        ctrls_1.changeScene(LotteryScene_1.LotteryScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.againBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.noPrizeAgainBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.goPrizeBtn.addEventListener(MouseEvent.CLICK, this.goPrize, this);
    };
    SuccessPrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return SuccessPrizePanel;
}(Panel_1.Panel));
exports.SuccessPrizePanel = SuccessPrizePanel;


/***/ }),

/***/ "./src/panels/TaskPanel.ts":
/*!*********************************!*\
  !*** ./src/panels/TaskPanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var TaskType;
(function (TaskType) {
    TaskType["member"] = "member";
    TaskType["invites"] = "invites";
    TaskType["browseGoods"] = "browseGoods";
    TaskType["follow"] = "follow";
})(TaskType = exports.TaskType || (exports.TaskType = {}));
var TaskPanel = (function (_super) {
    __extends(TaskPanel, _super);
    function TaskPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(TaskPanel.prototype, "groupNames", {
        get: function () {
            return ["TaskPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TaskPanel.prototype, "skinName", {
        get: function () {
            return "TaskPanel";
        },
        enumerable: true,
        configurable: true
    });
    TaskPanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = 1624 - this.height - layers_1.layers.stageOffsetY - 580;
        this.y = layers_1.layers.stageHeight + this.height;
        Tween.get(this)
            .to({ y: oriY }, 500, Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    TaskPanel.prototype.initUi = function () {
        var _this = this;
        this.removeChild(this.taskBtn1);
        this.removeChild(this.taskBtn2);
        this.removeChild(this.taskBtn3);
        this.removeChild(this.taskBtn4);
        var ps = [this.taskBtn1, this.taskBtn2, this.taskBtn3, this.taskBtn4];
        [TaskType.browseGoods, TaskType.invites, TaskType.follow, TaskType.member].forEach(function (e, i) {
            _this[e] = _this.addChild(new CusButton(e));
            _this[e].position.copy(ps[i].position);
            _this[e].visible = false;
        });
    };
    TaskPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
        this.updateTask();
    };
    TaskPanel.prototype.updateTask = function () {
        var _this = this;
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getTaskList, null, function (success, res) {
            ctrls_1.hideWaiting();
            if (!success)
                return;
            var data = res.data;
            data.forEach(function (d) {
                _this[d.taskType].visible = true;
                if (d.value)
                    _this[d.taskType].memberUrl = d.value;
                if (d.waitReceive) {
                    _this[d.taskType].canGetStatus = true;
                    _this[d.taskType].enabled = true;
                }
                else if (d.todayCompleteTimes == d.times) {
                    _this[d.taskType].canGetStatus = false;
                    _this[d.taskType].enabled = false;
                }
                else {
                    _this[d.taskType].canGetStatus = false;
                    _this[d.taskType].enabled = true;
                }
            });
        });
    };
    TaskPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateTask, this);
    };
    TaskPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateTask, this);
    };
    return TaskPanel;
}(Panel_1.Panel));
TaskType.browseGoods, TaskType.invites, TaskType.follow, TaskType.member;
exports.TaskPanel = TaskPanel;
var CusButton = (function (_super) {
    __extends(CusButton, _super);
    function CusButton(type) {
        var _this = this;
        var t = [
            RES_1.RES.getRes("去完成.png"),
            RES_1.RES.getRes("去完成灰.png"),
        ];
        _this = _super.call(this, t[0], t[0], t[1]) || this;
        _this.type = type;
        _this.addEventListener(MouseEvent.CLICK, _this.onClick, _this);
        return _this;
    }
    Object.defineProperty(CusButton.prototype, "canGetStatus", {
        get: function () {
            return this._canGetStatus;
        },
        set: function (value) {
            this._canGetStatus = value;
            var t;
            if (value) {
                t = [
                    RES_1.RES.getRes("待领取.png"),
                    RES_1.RES.getRes("待领取.png"),
                ];
            }
            else {
                t = [
                    RES_1.RES.getRes("去完成.png"),
                    RES_1.RES.getRes("去完成灰.png"),
                ];
            }
            this.changeTexture(t[0], t[0], t[1]);
        },
        enumerable: true,
        configurable: true
    });
    CusButton.prototype.onClick = function () {
        if (this.canGetStatus) {
            ctrls_1.showWaiting();
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveTaskRewards, { taskType: this.type }, function (s, res) {
                ctrls_1.hideWaiting();
                if (s) {
                    ctrls_1.showToast("领取成功");
                    Main_1.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.UPDATE_TASK);
                    Tools_1.Tools.gameData.power = res.data.power;
                    ctrls_1.getCurrentScene().updateScene();
                }
            });
        }
        else {
            Tools_1.Tools.btnDelay(this);
            switch (this.type) {
                case TaskType.follow:
                    Main_1.GDispatcher.removeAllEventListenerByType(TaoBaoNet_1.TbNetName.favorShop);
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.favorShop, {}, function (success, res) {
                        if (!success)
                            return;
                        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.completeTask, { taskType: TaskType.follow }, function (success, res) {
                            if (!success)
                                return;
                            Main_1.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.UPDATE_TASK);
                        });
                    }, true);
                    break;
                case TaskType.browseGoods:
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, { url: '/pages/browseProductList/browseProductList' }, function () { }, true);
                    break;
                case TaskType.invites:
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.showSharePanel, { openId: Tools_1.Tools.globalData.openId }, function () { }, true);
                    break;
                case TaskType.member:
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: this.memberUrl }, function () { }, true);
                    break;
            }
            if (this.type == TaskType.browseGoods || this.type == TaskType.member) {
                Main_1.GDispatcher.once(G_EVENT_1.G_EVENT.ON_SHOW, function () {
                    Main_1.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.UPDATE_TASK);
                }, this);
            }
        }
    };
    return CusButton;
}(Button));


/***/ }),

/***/ "./src/panels/ToolsOutPanel.ts":
/*!*************************************!*\
  !*** ./src/panels/ToolsOutPanel.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var JoinPanel_1 = __webpack_require__(/*! ./JoinPanel */ "./src/panels/JoinPanel.ts");
var ExchangeSucPanel_1 = __webpack_require__(/*! ./ExchangeSucPanel */ "./src/panels/ExchangeSucPanel.ts");
var ToolsOutPanel = (function (_super) {
    __extends(ToolsOutPanel, _super);
    function ToolsOutPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ToolsOutPanel.prototype, "groupNames", {
        get: function () {
            return ["ToolsOutPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ToolsOutPanel.prototype, "skinName", {
        get: function () {
            return "ToolsOutPanel";
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ToolsOutPanel.prototype, "closeBtns", {
        get: function () {
            return [this.consideBtn, this.closeBtn];
        },
        enumerable: true,
        configurable: true
    });
    ToolsOutPanel.prototype.initUi = function () {
        Tools_1.Tools.changeTextAlign(this.msgTxt, FYGE.TEXT_ALIGN.CENTER, 500);
    };
    ToolsOutPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
        this.msgTxt.text = "要消耗" +
            TaoBaoNet_1.getTbData(TaoBaoNet_1.TbNetName.getActivityBaseInfoById).data.buyCredits[data.type] +
            "积分兑换吗？";
    };
    ToolsOutPanel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        this.sureBtn.addEventListener(FYGE.MouseEvent.CLICK, function () { return __awaiter(_this, void 0, void 0, function () {
            var res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.exchange(this.data.type)];
                    case 1:
                        res = _a.sent();
                        ctrls_1.hideWaiting();
                        if (typeof res == "string") {
                            ctrls_1.showPanel(JoinPanel_1.JoinPanel, { url: res });
                        }
                        else if (res) {
                            if (this.data.showSucPanel)
                                ctrls_1.showPanel(ExchangeSucPanel_1.ExchangeSucPanel);
                            this.hidePanel();
                            ctrls_1.getCurrentScene().updateScene();
                        }
                        return [2];
                }
            });
        }); }, this);
    };
    ToolsOutPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return ToolsOutPanel;
}(Panel_1.Panel));
exports.ToolsOutPanel = ToolsOutPanel;


/***/ }),

/***/ "./src/scene/LoadingScene.ts":
/*!***********************************!*\
  !*** ./src/scene/LoadingScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ProgressBarS_1 = __webpack_require__(/*! ../common/ProgressBarS */ "./src/common/ProgressBarS.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Lottie_1 = __webpack_require__(/*! ../Lottie */ "./src/Lottie.ts");
var loading_animal_1 = __webpack_require__(/*! ../lotties/loading_animal */ "./src/lotties/loading_animal.ts");
var LoadingScene = (function (_super) {
    __extends(LoadingScene, _super);
    function LoadingScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LoadingScene.prototype, "groupNames", {
        get: function () {
            return ["loadingScene"];
        },
        enumerable: true,
        configurable: true
    });
    LoadingScene.prototype.initUi = function () {
        this.y = -layers_1.layers.stageOffsetY;
        this.addChild(FYGE.Sprite.fromFrame("loadingBg.jpg"));
        var l1 = this.addChild(FYGE.Sprite.fromFrame("lighting_1.png"));
        l1.position.set(543, 765);
        var l2 = this.addChild(FYGE.Sprite.fromFrame("lighting_2.png"));
        l2.position.set(545, 765);
        l2.visible = false;
        FYGE.Tween.get(l1, { loop: true })
            .wait(500)
            .call(function () { l1.visible = !l1.visible; });
        FYGE.Tween.get(l2, { loop: true })
            .wait(500)
            .call(function () { l2.visible = !l2.visible; });
        var wheel = this.addChild(FYGE.Sprite.fromFrame("wheel.png"))
            .addEventListener(FYGE.Event.ENTER_FRAME, function () {
            wheel.rotation += 0.3;
        });
        wheel.anchorTexture.set(0.5, 0.5);
        wheel.position.set(50, 780);
        wheel.alpha = 0.3;
        this.addChild(FYGE.Sprite.fromFrame("loadingBg2.png"));
        this.addChild(FYGE.Sprite.fromFrame("proDown.png"))
            .position.set((750 - 577) / 2, 1288 - 24);
        var arr = [];
        for (var i = 0; i <= 11; i++)
            arr.push(RES_1.RES.getRes("loadingPro" + i + ".png"));
        var pro = this.addChild(new FYGE.FrameAni(arr));
        pro.play(0);
        pro.position.set(375, 1288);
        this.progressBar = new ProgressBarS_1.ProgressBarS(pro);
        var l = this.addChild(new Lottie_1.Lottie(loading_animal_1.loading_animal));
        l.play(0);
        var foxTail = new FYGE.FrameAni((function () {
            var arrFox = [];
            var count = -1;
            while (++count <= 14)
                arrFox.push(RES_1.RES.getRes("fox_tail" + count + ".png"));
            return arrFox;
        })());
        foxTail.play(0);
        l.getChildByName("fox_body.png", true, true)
            .addChildAt(foxTail, 0)
            .position.set(250, 0);
        this.addChild(new Title());
        this.addChild(Tools_1.Tools.getText(GTool_1.GTool.randomT([
            "提示：固定关卡可抽取通关奖励哟！",
            "开心趣消消，烦恼全抛掉！",
            "解锁120关，最高可得TF彩妆礼盒、\nDyson吹风机！"
        ]), 28, "#ae3830", FYGE.TEXT_ALIGN.CENTER, 500, (750 - 500) / 2, 1288 - 24 + 18 + 48));
    };
    LoadingScene.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            var data, getIndexSuccesss, baseInfo, k;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.start.call(this);
                        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2);
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getAppData)];
                    case 1:
                        data = (_a.sent()).data;
                        Tools_1.Tools.globalData = data;
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
                        Tools_1.Tools.checkPermission();
                        return [4, Tools_1.Tools.getIndex()];
                    case 2:
                        getIndexSuccesss = _a.sent();
                        if (!getIndexSuccesss)
                            return [2];
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
                        Tools_1.Tools.globalData.openId = TaoBaoNet_1.getTbData(TaoBaoNet_1.TbNetName.getIndex).data.openId;
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getActivityBaseInfoById)];
                    case 3:
                        baseInfo = _a.sent();
                        Tools_1.Tools.baseInfo = baseInfo.data;
                        Tools_1.Tools.baseInfo.prizeLevels = [];
                        for (k in Tools_1.Tools.baseInfo.levelPrize) {
                            Tools_1.Tools.baseInfo.prizeLevels.push(+k.split('_')[1]);
                        }
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);
                        return [4, RES_1.RES.loadGroup("map")];
                    case 4:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
                        return [4, RES_1.RES.loadGroup("mapCrabEffect")];
                    case 5:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
                        return [4, RES_1.RES.loadGroup("mapOwlEffect")];
                    case 6:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
                        return [4, RES_1.RES.loadGroup("mapWhaleEffect")];
                    case 7:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.9);
                        return [4, RES_1.RES.loadGroup("mapCheckPrizeEffect")];
                    case 8:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
                        return [2];
                }
            });
        });
    };
    LoadingScene.prototype.progressEvent = function (e) {
        var _this = this;
        var pro = e.data;
        FYGE.Tween.get(this.progressBar, null, null, true)
            .to({ value: pro }, 2000)
            .call(function () {
            if (pro >= 1) {
                _this.removeEventListener(FYGE.Event.PROGRESS, _this.progressEvent, _this);
                ctrls_1.changeScene(MapScene_1.MapScene, { from: "loading" });
            }
        });
    };
    LoadingScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return LoadingScene;
}(Scene_1.Scene));
exports.LoadingScene = LoadingScene;
var lingConfig = [
    {
        "name": "img_line1",
        "x": 0,
        "y": 70,
    },
    {
        "name": "img_line2",
        "x": 85,
        "y": 50,
    },
    {
        "name": "img_line3",
        "x": 195,
        "y": 0,
    },
    {
        "name": "img_line4",
        "x": 322,
        "y": 50,
    },
    {
        "name": "img_line5",
        "x": 402,
        "y": 70,
    }
];
var Title = (function (_super) {
    __extends(Title, _super);
    function Title() {
        var _this = _super.call(this) || this;
        var line = _this.addChild(new FYGE.Container());
        for (var i = 0; i < lingConfig.length; i++) {
            var c = lingConfig[i];
            line.addChild(FYGE.Sprite.fromFrame(c.name + ".png"))
                .position.set(c.x, c.y);
        }
        line.anchor.set(433 / 2, 0);
        line.scaleY = 0.18;
        var title = line.addChild(FYGE.Sprite.fromFrame("loadingTitle.png"));
        title.position.set(-33, 313);
        title.anchor.set(494 / 2, 40);
        _this.x = 160;
        var targetY = -80;
        _this.y = -560;
        FYGE.Tween.get(_this)
            .to({ y: targetY + 25 }, 300)
            .to({ y: targetY - 30 }, 100)
            .to({ y: targetY }, 100);
        [line, title].forEach(function (e) {
            FYGE.Tween.get(e)
                .to({ rotation: 1.5 }, 300)
                .to({ rotation: -0.5 }, 100)
                .to({ rotation: 0 }, 100);
            if (e === line) {
                FYGE.Tween.get(e)
                    .to({ scaleY: 1.05 }, 300)
                    .to({ scaleY: 0.96 }, 100)
                    .to({ scaleY: 1 }, 100);
            }
        });
        return _this;
    }
    return Title;
}(FYGE.Container));


/***/ }),

/***/ "./src/scene/LotteryScene.ts":
/*!***********************************!*\
  !*** ./src/scene/LotteryScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var PrizePanel_1 = __webpack_require__(/*! ../panels/PrizePanel */ "./src/panels/PrizePanel.ts");
var NoPrizePanel_1 = __webpack_require__(/*! ../panels/NoPrizePanel */ "./src/panels/NoPrizePanel.ts");
var LotteryScene = (function (_super) {
    __extends(LotteryScene, _super);
    function LotteryScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LotteryScene.prototype, "groupNames", {
        get: function () { return ["lotteryScene"]; },
        enumerable: true,
        configurable: true
    });
    LotteryScene.prototype.initUi = function () {
        this.y = -layers_1.layers.stageOffsetY;
        this.addChild(new FYGE.Sprite(RES_1.RES.getRes("lotteryMachineBg.jpg")));
        Tools_1.Tools.baseInfo.prizeLevels.sort(function (a, b) {
            return a - b;
        });
        var index = Tools_1.Tools.baseInfo.prizeLevels.indexOf(this.data.level);
        var upLevel = Tools_1.Tools.baseInfo.prizeLevels[index + 1];
        this.addChild(Tools_1.Tools.getText(this.data.level + "关抽奖奖励", 53.19, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 488, (750 - 488) / 2, 360)).bold = true;
        this.addChild(Tools_1.Tools.getText(upLevel ? "下一奖励关卡：" + upLevel + "关" : "", 32.54, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 488, (750 - 488) / 2, 420));
        this.addChild(new FYGE.Button(RES_1.RES.getRes("lotteryBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.lottery, this)
            .position.set((750 - RES_1.RES.getRes("lotteryBtn.png").width) / 2, 797);
        this.addChild(new FYGE.Button(RES_1.RES.getRes("lotteryReturnBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, function () { ctrls_1.changeScene(MapScene_1.MapScene); }, this)
            .position.set(0, 300);
        this.updatePrizes();
    };
    LotteryScene.prototype.updatePrizes = function () {
        return __awaiter(this, void 0, void 0, function () {
            var prizeList, list, scroll, p;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctrls_1.showWaiting();
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getPrizesByLevel, { level: this.data.level })];
                    case 1:
                        prizeList = (_a.sent()).data;
                        list = prizeList.slice().filter(function (e) { return e.type != 5; });
                        scroll = this.addChild(new FYGE.ScrollList(PrizeItem, 122, 140, 345, 152, false));
                        scroll.position.set(195, 1013);
                        scroll.updateData(list || []);
                        p = [201, 620];
                        this.lotScroll = this.addChild(new LotteryScroll(list));
                        this.lotScroll.position.set(p[0], p[1]);
                        return [2];
                }
            });
        });
    };
    LotteryScene.prototype.lottery = function () {
        var _this = this;
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.luckyDraw, { level: this.data.level })
            .then(function (res) {
            ctrls_1.hideWaiting();
            if (!res.success)
                return;
            var id;
            if (res.data && res.data.prizeId)
                id = res.data.prizeId;
            _this.enableMouseEvt(false);
            console.log(id);
            _this.lotScroll.lot(id, function () {
                _this.enableMouseEvt(true);
                if (!id || res.data.type == 5) {
                    ctrls_1.showPanel(NoPrizePanel_1.NoPrizePanel);
                }
                else {
                    ctrls_1.showPanel(PrizePanel_1.PrizePanel, res.data);
                }
            });
        });
    };
    return LotteryScene;
}(Scene_1.Scene));
exports.LotteryScene = LotteryScene;
var PrizeItem = (function (_super) {
    __extends(PrizeItem, _super);
    function PrizeItem() {
        var _this = _super.call(this) || this;
        _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("prizeItemBg.png")));
        _this.prizeImage = _this.addChild(new FYGE.Sprite());
        _this.prizeImage.width = _this.prizeImage.height = 101;
        _this.prizeImage.position.set(4, 4);
        var mask = _this.addChild(new FYGE.Shape());
        mask.beginFill(0);
        mask.drawRoundedRect(4, 4, 101, 101, 10);
        mask.endFill();
        _this.prizeImage.mask = mask;
        _this.nameTxt = _this.addChild(Tools_1.Tools.getText("", 19.23, "#317f7f", FYGE.TEXT_ALIGN.CENTER, 109, 0, 112));
        return _this;
    }
    PrizeItem.prototype.initData = function (id, data) {
        if (id < 0 || !data)
            return;
        if (data.image)
            this.prizeImage.texture = FYGE.Texture.from(data.image);
        this.nameTxt.text = data.name;
    };
    return PrizeItem;
}(FYGE.Container));
var LotteryItem = (function (_super) {
    __extends(LotteryItem, _super);
    function LotteryItem(data) {
        var _this = _super.call(this) || this;
        _this.id = data._id;
        _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("lotteryItemBg.png")));
        _this.showImage = _this.addChild(new FYGE.Sprite(FYGE.Texture.from(data.image)));
        _this.showImage.width = _this.showImage.height = 88;
        _this.showImage.position.set((103 - 88) / 2, 6);
        var mask = _this.addChild(new FYGE.Shape());
        mask.beginFill(0);
        mask.drawRoundedRect((103 - 88) / 2, 6, 88, 88, 10);
        mask.endFill();
        _this.showImage.mask = mask;
        return _this;
    }
    LotteryItem.prototype.reset = function (data) {
        this.showImage.texture = FYGE.Texture.from(data.image);
        this.id = data._id;
    };
    return LotteryItem;
}(FYGE.Container));
var HEIGHT = 123;
var LotteryScrollItem = (function (_super) {
    __extends(LotteryScrollItem, _super);
    function LotteryScrollItem(datas) {
        var _this = _super.call(this) || this;
        datas.forEach(function (d) {
            _this.addChild(new LotteryItem(d));
        });
        _this.cusP = 0;
        _this.updatePosition();
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.updatePosition, _this);
        return _this;
    }
    Object.defineProperty(LotteryScrollItem.prototype, "currentIndex", {
        get: function () {
            var a = 1 - this.cusP;
            var l = this.children.length;
            return a < 0 ? a % l + l : a % l;
        },
        enumerable: true,
        configurable: true
    });
    ;
    LotteryScrollItem.prototype.scrollTo = function (id, callback) {
        var child, curIndex;
        for (var i = 0; i < this.children.length; i++) {
            if (this.children[i].id == id) {
                child = this.children[i];
                curIndex = i;
                break;
            }
        }
        var delta = this.currentIndex - curIndex;
        if (delta < 0)
            delta += this.children.length;
        var cusP = this.cusP + delta + 10 * this.children.length;
        FYGE.Tween.get(this)
            .to({ cusP: cusP }, 5000, FYGE.Ease.quadInOut)
            .call(function () {
            callback && callback();
        });
    };
    LotteryScrollItem.prototype.reset = function () {
    };
    LotteryScrollItem.prototype.updatePosition = function () {
        var _this = this;
        this.children.forEach(function (c, j) {
            c.y = ((_this.cusP + j) % _this.children.length) * HEIGHT - HEIGHT;
            if (c.y > HEIGHT * 1.5) {
                c.y = c.y - _this.children.length * HEIGHT;
            }
        });
    };
    LotteryScrollItem.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
    };
    return LotteryScrollItem;
}(FYGE.Container));
var LotteryScroll = (function (_super) {
    __extends(LotteryScroll, _super);
    function LotteryScroll(datas) {
        var _this = _super.call(this) || this;
        _this.scrollItems = [];
        for (var i = 0; i < 3; i++) {
            var s = _this.addChild(new LotteryScrollItem(GTool_1.GTool.disturbArr(datas.slice())));
            s.position.set(116 * i, 0);
            _this.scrollItems.push(s);
        }
        _this.ids = [];
        datas.forEach(function (d) { _this.ids.push(d._id); });
        var h = -50;
        var mask = _this.addChild(new FYGE.Shape());
        mask.beginFill(0);
        mask.drawRect(0, h + 3, 350, 195 - 5);
        mask.endFill();
        _this.mask = mask;
        _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("shadowMask.png")))
            .position.set(0, h);
        return _this;
    }
    LotteryScroll.prototype.lot = function (id, callback) {
        var _this = this;
        if (id && this.ids.indexOf(id) != -1) {
            var count_1 = 0;
            var countAll_1 = this.scrollItems.length;
            this.scrollItems.forEach(function (c, i) {
                ctrls_1.wait(function () {
                    c.scrollTo(id, function () {
                        if (++count_1 == countAll_1 && callback)
                            callback();
                    });
                }, 400 * i);
            });
        }
        else {
            var ids = [
                GTool_1.GTool.randomT(this.ids),
                GTool_1.GTool.randomT(this.ids),
            ];
            ids[0] === ids[1] ? ids.push(GTool_1.GTool.randomT((function () {
                var arr = _this.ids.slice();
                arr.splice(_this.ids.indexOf(ids[0]), 1);
                return arr;
            })())) : ids.push(GTool_1.GTool.randomT(this.ids));
            var count_2 = 0;
            var countAll_2 = this.scrollItems.length;
            this.scrollItems.forEach(function (c, i) {
                ctrls_1.wait(function () {
                    c.scrollTo(ids[i], function () {
                        if (++count_2 == countAll_2 && callback)
                            callback();
                    });
                }, 400 * i);
            });
        }
    };
    return LotteryScroll;
}(FYGE.Container));


/***/ }),

/***/ "./src/scene/PlayScene.ts":
/*!********************************!*\
  !*** ./src/scene/PlayScene.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var BonusShootAni_1 = __webpack_require__(/*! ../something/anis/BonusShootAni */ "./src/something/anis/BonusShootAni.ts");
var BoomAni_1 = __webpack_require__(/*! ../something/anis/BoomAni */ "./src/something/anis/BoomAni.ts");
var CrossAni_1 = __webpack_require__(/*! ../something/anis/CrossAni */ "./src/something/anis/CrossAni.ts");
var EleDisAni_1 = __webpack_require__(/*! ../something/anis/EleDisAni */ "./src/something/anis/EleDisAni.ts");
var FlyTargetAni_1 = __webpack_require__(/*! ../something/anis/FlyTargetAni */ "./src/something/anis/FlyTargetAni.ts");
var HorizontalAni_1 = __webpack_require__(/*! ../something/anis/HorizontalAni */ "./src/something/anis/HorizontalAni.ts");
var IceAni_1 = __webpack_require__(/*! ../something/anis/IceAni */ "./src/something/anis/IceAni.ts");
var MagicLionAni_1 = __webpack_require__(/*! ../something/anis/MagicLionAni */ "./src/something/anis/MagicLionAni.ts");
var MagicRotateAni_1 = __webpack_require__(/*! ../something/anis/MagicRotateAni */ "./src/something/anis/MagicRotateAni.ts");
var RockAni_1 = __webpack_require__(/*! ../something/anis/RockAni */ "./src/something/anis/RockAni.ts");
var ScoreAni_1 = __webpack_require__(/*! ../something/anis/ScoreAni */ "./src/something/anis/ScoreAni.ts");
var ThreeCrossAni_1 = __webpack_require__(/*! ../something/anis/ThreeCrossAni */ "./src/something/anis/ThreeCrossAni.ts");
var VerticalAni_1 = __webpack_require__(/*! ../something/anis/VerticalAni */ "./src/something/anis/VerticalAni.ts");
var Element_1 = __webpack_require__(/*! ../something/class/Element */ "./src/something/class/Element.ts");
var Ice_1 = __webpack_require__(/*! ../something/class/Ice */ "./src/something/class/Ice.ts");
var Lattice_1 = __webpack_require__(/*! ../something/class/Lattice */ "./src/something/class/Lattice.ts");
var EffectType_1 = __webpack_require__(/*! ../something/enum/EffectType */ "./src/something/enum/EffectType.ts");
var ElementType_1 = __webpack_require__(/*! ../something/enum/ElementType */ "./src/something/enum/ElementType.ts");
var PassType_1 = __webpack_require__(/*! ../something/enum/PassType */ "./src/something/enum/PassType.ts");
var RecoverName_1 = __webpack_require__(/*! ../something/enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var aaa_1 = __webpack_require__(/*! ../something/logic/aaa */ "./src/something/logic/aaa.ts");
var Pool_1 = __webpack_require__(/*! ../something/Pool */ "./src/something/Pool.ts");
var Tool_1 = __webpack_require__(/*! ../something/Tool */ "./src/something/Tool.ts");
var ElementTargets_1 = __webpack_require__(/*! ../something/uis/ElementTargets */ "./src/something/uis/ElementTargets.ts");
var PropGuide_1 = __webpack_require__(/*! ../something/uis/PropGuide */ "./src/something/uis/PropGuide.ts");
var ScoreProgress_1 = __webpack_require__(/*! ../something/uis/ScoreProgress */ "./src/something/uis/ScoreProgress.ts");
var StepAni_1 = __webpack_require__(/*! ../something/anis/StepAni */ "./src/something/anis/StepAni.ts");
var AiControl_1 = __webpack_require__(/*! ../something/logic/AiControl */ "./src/something/logic/AiControl.ts");
var JellyDisAni_1 = __webpack_require__(/*! ../something/anis/JellyDisAni */ "./src/something/anis/JellyDisAni.ts");
var EggBrokenAni_1 = __webpack_require__(/*! ../something/anis/EggBrokenAni */ "./src/something/anis/EggBrokenAni.ts");
var FallAniData_1 = __webpack_require__(/*! ../something/interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var EleMaskAni_1 = __webpack_require__(/*! ../something/anis/EleMaskAni */ "./src/something/anis/EleMaskAni.ts");
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var StateType_1 = __webpack_require__(/*! ../something/enum/StateType */ "./src/something/enum/StateType.ts");
var HairballGreyDisAni_1 = __webpack_require__(/*! ../something/anis/HairballGreyDisAni */ "./src/something/anis/HairballGreyDisAni.ts");
var EleDownAni_1 = __webpack_require__(/*! ../something/anis/EleDownAni */ "./src/something/anis/EleDownAni.ts");
var GameGuide_1 = __webpack_require__(/*! ../something/uis/GameGuide */ "./src/something/uis/GameGuide.ts");
var PropBtnCon_1 = __webpack_require__(/*! ../something/uis/PropBtnCon */ "./src/something/uis/PropBtnCon.ts");
var FestivalTarget_1 = __webpack_require__(/*! ../something/uis/FestivalTarget */ "./src/something/uis/FestivalTarget.ts");
var FesRedBombShowAni_1 = __webpack_require__(/*! ../something/anisCall/FesRedBombShowAni */ "./src/something/anisCall/FesRedBombShowAni.ts");
var RectsWaveAni_1 = __webpack_require__(/*! ../something/anisCall/RectsWaveAni */ "./src/something/anisCall/RectsWaveAni.ts");
var Door_1 = __webpack_require__(/*! ../something/class/Door */ "./src/something/class/Door.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var ToolsOutPanel_1 = __webpack_require__(/*! ../panels/ToolsOutPanel */ "./src/panels/ToolsOutPanel.ts");
var Lottie_1 = __webpack_require__(/*! ../Lottie */ "./src/Lottie.ts");
var GameToast_1 = __webpack_require__(/*! ../something/uis/GameToast */ "./src/something/uis/GameToast.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var NoStepPanel_1 = __webpack_require__(/*! ../panels/NoStepPanel */ "./src/panels/NoStepPanel.ts");
var FirstPropGift_1 = __webpack_require__(/*! ../something/uis/FirstPropGift */ "./src/something/uis/FirstPropGift.ts");
var bonus_lottie_1 = __webpack_require__(/*! ../lotties/bonus_lottie */ "./src/lotties/bonus_lottie.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var aniClass = {
    "BoomAni": BoomAni_1.BoomAni,
    "IceAni": IceAni_1.IceAni,
    "RockAni": RockAni_1.RockAni,
    "HorizontalAni": HorizontalAni_1.HorizontalAni,
    "VerticalAni": VerticalAni_1.VerticalAni,
    "CrossAni": CrossAni_1.CrossAni,
    "ThreeCrossAni": ThreeCrossAni_1.ThreeCrossAni,
    "MagicLionAni": MagicLionAni_1.MagicLionAni,
    "StepAni": StepAni_1.StepAni,
    "JellyDisAni": JellyDisAni_1.JellyDisAni,
    "EggBrokenAni": EggBrokenAni_1.EggBrokenAni,
    "HairballGreyDisAni": HairballGreyDisAni_1.HairballGreyDisAni,
};
exports.baseScore = 20;
exports.effectBaseTimes = {
    0: 2.5,
    1: 2.5,
    2: 5,
    3: 15,
    LL: 10,
    EL: 20,
    EE: 25,
    MM: 50
};
var svgaParser;
var movieClips = {
    wonderful: null,
    amazing: null,
    great: null,
    bonusTime: null
};
var redBombPanelName = "RedBombAlert";
var fesChapterData = [];
var festivalIndex = 40;
var PlayScene = (function (_super) {
    __extends(PlayScene, _super);
    function PlayScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.emptys = [];
        _this.eliminatedElements = [];
        _this.noActionCount = 0;
        _this.isShowWarning = false;
        _this.magicRotateData = [];
        _this.commonContinuityTimes = 0;
        _this.effectContinuityTimes = 0;
        _this.lollipopCount = 0;
        _this.hasPassed = false;
        _this.isCountingTime = false;
        _this.festivalTargetNum = AiControl_1.fesELeSmallNum;
        _this.scoreAnis = [];
        _this.connectState = 2;
        _this.addedStepWarning = false;
        _this.recordOnce = {
            boom: false,
            hammer: false,
            step: false,
            failStep: false
        };
        return _this;
    }
    Object.defineProperty(PlayScene.prototype, "groupNames", {
        get: function () {
            return ["playScene", "fiveVerHorDis"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "steps", {
        get: function () {
            return this._steps;
        },
        set: function (value) {
            if (value == this._steps)
                return;
            this._steps = value;
            this.stepNumber.text = "" + value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (value == this._score)
                return;
            this._score = value;
            FYGE.Tween.removeTweens(this.scoreProgress);
            FYGE.Tween.get(this.scoreProgress, {}, null, true)
                .to({ score: value }, 300);
        },
        enumerable: true,
        configurable: true
    });
    PlayScene.prototype.initUi = function () {
        this.addChild(FYGE.Sprite.fromFrame("playBg.jpg")).position.set(0, -layers_1.layers.stageOffsetY);
        this.addChild(FYGE.Sprite.fromFrame("topBg.png")).position.set(0, 10);
        var commonTextArr = {};
        for (var i = 0; i < 10; i++)
            commonTextArr[i] = RES_1.RES.getRes("scoreNum" + i + ".png");
        ["通", "关", "分", "数"].forEach(function (e) { commonTextArr[e] = RES_1.RES.getRes("scoreNum" + e + ".png"); });
        commonTextArr["："] = RES_1.RES.getRes("scoreNum冒号.png");
        this.targetScoreTxt = this.addChild(new FYGE.BitmapText(commonTextArr));
        this.targetScoreTxt.position.set(375, 193);
        this.settingBtn = this.addChild(new SettingBtn());
        this.settingBtn.position.set(618, 16);
    };
    PlayScene.prototype.start = function (data) {
        var _this = this;
        _super.prototype.start.call(this);
        this.chapter = (data && data.chapter) ? data.chapter : 1;
        this.chapterData = getChapter_1.getChapterData(this.chapter);
        this.initTarget();
        Tool_1.Tool.init(Tool_1.Tool.getColOddEven(this.chapterData.map.lattices), !!(this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]));
        this.initScene();
        this.enableMouseEvt(false);
        this.initLattices();
        this.initRecycle();
        this.initElement();
        this.initBaseElement();
        if (!this.initFestivalEle()) {
            if (this.threeMatch()) {
                this.eliminate();
            }
            else {
                this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
                if (!this.warningCop) {
                    this.upsetElement();
                }
                else {
                    this.enableMouseEvt(true);
                    if (this.chapter == 1 && Tools_1.Tools.gameData.isFristLogin) {
                        this.addChild(new FirstPropGift_1.FirstPropGift())
                            .once(FYGE.MouseEvent.CLICK, function (e) {
                            Tools_1.Tools.gameData.isFristLogin = false;
                            _this.removeChild(e.target);
                            _this.initGuide();
                        }, this);
                    }
                    else {
                        this.initGuide();
                    }
                }
            }
        }
        this.initSvgas();
        AiControl_1.AiControl.ins.init(this.lattices);
    };
    PlayScene.prototype.initSvgas = function () {
        return __awaiter(this, void 0, void 0, function () {
            var bonusTime;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, RES_1.RES.loadGroup("bonusTime")];
                    case 1:
                        _a.sent();
                        bonusTime = new Lottie_1.Lottie(bonus_lottie_1.bonus_lottie);
                        bonusTime.position.set((750 - bonusTime.videoWidth) / 2, (1624 - bonusTime.videoHeight) / 2 - layers_1.layers.stageOffsetY);
                        movieClips.bonusTime = bonusTime;
                        ["great", "wonderful", "amazing"].forEach(function (e) {
                            var g = new GameToast_1.GameToast(e + ".png");
                            g.position.set(375, 1624 / 2 - layers_1.layers.stageOffsetY);
                            movieClips[e] = g;
                        });
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.initScene = function () {
        var chapterTex = Tools_1.Tools.getNumTextures("chapterNum");
        ["第", "关"].forEach(function (e) { chapterTex[e] = RES_1.RES.getRes("chapterNum" + e + ".png"); });
        var chapterTxt = this.addChild(new FYGE.BitmapText(chapterTex));
        chapterTxt.text = "第" + (this.chapter >> 0) + "关";
        chapterTxt.position.set(535, 58);
        this.stepNumber = this.addChild(new FYGE.BitmapText(Tools_1.Tools.getNumTextures("stepNum")));
        this.stepNumber.position.set(375, 20);
        this.steps = this.chapterData.stepCount;
        this.scoreProgress = this.addChild(new ScoreProgress_1.ScoreProgress(this.chapterData.starScores));
        this.scoreProgress.position.set(175, 113);
        this.score = 0;
        var path = aaa_1.generateMapBg(this.chapterData.map.lattices);
        var bg = aaa_1.drawBg(path, this.chapterData.map.lattices);
        this.addChild(bg);
        this.map = bg;
        this.elementContainer = new FYGE.Container();
        this.addChild(this.elementContainer);
        var mask = aaa_1.drawShape(path);
        this.elementContainer.mask = mask;
        mask.updateShape();
        this.addChild(mask);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
        this.propBtnCon = new PropBtnCon_1.PropBtnCon();
        this.propBtnCon.y = 238 + Tool_1.Tool.gameAreaHeight + 10;
        this.addChild(this.propBtnCon);
        this.propBtnCon.boomBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.updateScene();
        var textureChoosed = RES_1.RES.getRes("chooseRect.png");
        this.choosed = new FYGE.Sprite(textureChoosed);
        this.choosed.anchorTexture.set(0.5, 0.5);
        this.propGuide = new PropGuide_1.PropGuide(this.propBtnCon.y - 10);
    };
    PlayScene.prototype.initTarget = function () {
        if (this.chapterData.passTarget.type == PassType_1.PassType.ELEMENT_TARGET) {
            this.hasEliminatedElements = [];
            this.passElements = [];
            for (var m = 0; m < this.chapterData.passTarget.elements.length; m++) {
                var element = this.chapterData.passTarget.elements[m];
                this.passElements[element.type] = element.count;
                this.hasEliminatedElements[element.type] = 0;
            }
            this.elementTargets = new ElementTargets_1.ElementTargets(this.passElements);
            this.elementTargets.x = 375;
            this.elementTargets.y = 180;
            this.addChild(this.elementTargets);
            this.targetScoreTxt.visible = false;
        }
        else {
            this.passElements = null;
            this.targetScoreTxt.visible = true;
            this.targetScoreTxt.text = "目标分数：" + this.chapterData.passTarget.score;
        }
    };
    PlayScene.prototype.initRecycle = function () {
        this.recycleIndexs = [];
        if (this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
            var recycles = this.chapterData.map.recycles;
            if (!recycles || !recycles.length) {
                var endRowNumHash = {}, endRowNum = 0;
                ;
                for (var i = 0; i < this.chapterData.map.lattices.length; i++) {
                    var d = this.chapterData.map.lattices[i];
                    if (!d)
                        continue;
                    var rc = Tool_1.Tool.indexToRc(i);
                    var row = rc[0], col = rc[1];
                    if (!endRowNumHash[col]) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    if (row > endRowNumHash[col].row) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    endRowNum = Math.max(rc[0], endRowNum);
                }
                this.recycleIndexs = [];
                for (var key in endRowNumHash) {
                    var _a = endRowNumHash[key], index = _a.index, row = _a.row;
                    if (endRowNum == row)
                        this.recycleIndexs.push(index);
                }
            }
            else {
                this.recycleIndexs = recycles.slice();
            }
            var texture = RES_1.RES.getRes('main_mapbottom.png');
            var imgs = new FYGE.Container;
            for (var m = 0; m < this.recycleIndexs.length; m++) {
                var p = Tool_1.Tool.getPositionByIndex(this.recycleIndexs[m]);
                var img = new FYGE.Sprite(texture);
                img.x = p[0];
                img.y = p[1];
                imgs.addChild(img);
            }
            imgs.x = -texture.width / 2;
            imgs.y = Tool_1.Tool.height / 2 - 10;
            this.map.addChildAt(imgs, 0);
        }
    };
    PlayScene.prototype.initLattices = function () {
        var latticesD = this.chapterData.map.lattices;
        this.lattices = [];
        for (var i = 0; i < latticesD.length; i++) {
            if (!latticesD[i])
                continue;
            this.lattices[i] = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.LATTICE);
            if (!this.lattices[i]) {
                this.lattices[i] = new Lattice_1.Lattice(i);
            }
            else {
                this.lattices[i].reset(i);
            }
            var p = Tool_1.Tool.getPositionByIndex(i);
            var dooreData = [4, 5, 6, 51, 61];
            if (dooreData.indexOf(latticesD[i]) >= 0) {
                var door = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.DOOR);
                var closed = (latticesD[i] + "").length == 2 ? false : true;
                if (!door) {
                    door = new Door_1.Door(closed);
                }
                else {
                    door.reset(closed);
                }
                this.map.addChild(door);
                this.lattices[i].door = door;
                door.x = p[0];
                door.y = p[1];
            }
            var iceData = [2, 3, 5, 6, 51, 61];
            if (iceData.indexOf(latticesD[i]) >= 0) {
                var iceCount = (function (n) {
                    if (n == 2 || n == 3)
                        return n - 1;
                    if (n == 5 || n == 6)
                        return n - 4;
                    return parseInt((n + "").split("")[0]) - 4;
                })(latticesD[i]);
                var ice = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ICE);
                if (!ice) {
                    ice = new Ice_1.Ice(iceCount);
                }
                else {
                    ice.reset(iceCount);
                }
                this.map.addChild(ice);
                this.lattices[i].ice = ice;
                ice.x = p[0];
                ice.y = p[1];
                if (latticesD[i] != 2 && latticesD[i] != 3 && (latticesD[i] + "").length == 1) {
                    ice.visible = false;
                }
            }
        }
        var genLatDatas = this.chapterData.map.generateLats || [];
        this.generateIndexs = Tool_1.Tool.setGenerateLats(this.lattices, genLatDatas);
        var downMax = 0;
        var upMax = 0;
        var hasSmallToBig;
        var hasBigToSmall;
        var connectedLats = this.chapterData.map.connectedLats || [];
        for (var i = 0; i < connectedLats.length; i++) {
            var connectedLat = connectedLats[i];
            if (!connectedLat || !connectedLat.length)
                continue;
            this.lattices[connectedLat[0]].down = connectedLat[1];
            this.lattices[connectedLat[1]].up = connectedLat[0];
            var colUp = Tool_1.Tool.indexToRc(connectedLat[0])[1];
            var colDown = Tool_1.Tool.indexToRc(connectedLat[1])[1];
            downMax = Math.max(downMax, colDown);
            upMax = Math.max(upMax, colUp);
            if (colUp > colDown)
                hasBigToSmall = true;
            else if (colUp < colDown)
                hasSmallToBig = true;
        }
        if (hasBigToSmall && hasSmallToBig) {
            if (downMax > upMax) {
                this.connectState = 3;
            }
            else {
                this.connectState = 4;
            }
        }
        else if (hasBigToSmall) {
            this.connectState = 2;
        }
        else if (hasSmallToBig) {
            this.connectState = 1;
        }
    };
    PlayScene.prototype.initElement = function () {
        var elements = this.chapterData.map.elements || Tool_1.Tool.setNumber01(this.chapterData.map.lattices.slice());
        for (var i = 0; i < elements.length; i++) {
            if (!this.lattices[i])
                continue;
            var ele = void 0;
            switch (elements[i]) {
                case 0:
                    this.emptys.push(i);
                    break;
                case 1:
                case 4:
                case 7:
                case 8:
                case 9:
                case 10:
                    var type = Tool_1.Tool.returnType(i, this.lattices, this.chapterData.baseElementTypes);
                    ele = Tool_1.Tool.getElement(type);
                    if (elements[i] == 4) {
                        ele.setState(StateType_1.StateType.LOCK, true);
                    }
                    else if (elements[i] == 7) {
                        ele.setState(StateType_1.StateType.BUBBLE, true, type);
                    }
                    else if (elements[i] == 8) {
                        ele.setState(StateType_1.StateType.HAIRBALLGREY, true);
                    }
                    else if (elements[i] == 9) {
                        ele.setState(StateType_1.StateType.HAIRBALLBROWN, true);
                    }
                    else if (elements[i] == 10) {
                        ele.setState(StateType_1.StateType.HAIRBALLBLACK, true);
                    }
                    break;
                case 3:
                    this.lollipopCount++;
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.LOLLIPOP);
                    break;
                case 2:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.ROCK);
                    break;
                case 5:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.JELLY);
                    break;
                case 6:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.CHICKEN_EGG);
                    break;
                default:
                    this.emptys.push(i);
                    break;
            }
            if (ele) {
                var p = Tool_1.Tool.getPositionByIndex(i);
                ele.x = p[0];
                ele.y = p[1];
                this.elementContainer.addChild(ele);
                this.lattices[i].element = ele;
            }
            if (this.lattices[i].doorClosed) {
                if (this.lattices[i].element) {
                    this.lattices[i].element.visible = false;
                }
                else {
                    Tool_1.Tool.removeEle(i, this.emptys);
                }
            }
        }
        if (this.passElements &&
            this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
            !this.lollipopCount) {
            this.lollipopMark = true;
        }
    };
    PlayScene.prototype.initBaseElement = function () {
        var elements = this.chapterData.map.baseElements;
        if (!elements || !elements.length)
            return;
        for (var i = 0; i < elements.length; i++) {
            if (!Tool_1.Tool.judgeBaseEle(this.lattices[i]))
                continue;
            if (!elements[i])
                continue;
            var arr = Tool_1.Tool.returnTO(elements[i]);
            var baseType = arr[1] ? arr[1] - 1 : null;
            if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1 && baseType != null)
                continue;
            var ele = this.lattices[i].element;
            if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) == -1)
                continue;
            if (baseType != null)
                ele.resetType(baseType);
            if (!ele.hasState(StateType_1.StateType.BUBBLE))
                ele.effectType = arr[0] ? arr[0] - 1 : null;
        }
    };
    PlayScene.prototype.initGuide = function () {
        var gameGuideChapterNum = [1, 2, 3, 5, 8, 9, 10, 12, 17, 25, 41, 61, 101, 121];
        if (gameGuideChapterNum.indexOf(this.chapter >> 0) > -1) {
            if (!GTool_1.GTool.readCache(Tools_1.Tools.cacheKey + this.chapter)) {
                this.gameGuide = new GameGuide_1.GameGuide(this);
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
        }
    };
    PlayScene.prototype.initFestivalEle = function () {
        var _this = this;
        if (fesChapterData.indexOf(this.chapter >> 0) > -1 &&
            Math.random() > 0.5 &&
            this.lattices[festivalIndex] &&
            (Tool_1.Tool.judgeSetFesEle(this.lattices[festivalIndex]) || !this.lattices[festivalIndex].element)) {
            var p = Tool_1.Tool.getPositionByIndex(festivalIndex);
            this.festivalTarget = new FestivalTarget_1.FestivalTarget(this.festivalTargetNum);
            this.festivalTarget.x = 580;
            this.festivalTarget.y = 115;
            this.addChildAt(this.festivalTarget, 1);
            if (this.lattices[festivalIndex].element) {
                this.lattices[festivalIndex].element.reset(ElementType_1.ElementType.FESTIVALELE_BIG);
            }
            else {
                var ele = Tool_1.Tool.getElement(ElementType_1.ElementType.FESTIVALELE_BIG);
                ele.x = p[0];
                ele.y = p[1];
                this.elementContainer.addChild(ele);
                this.lattices[festivalIndex].element = ele;
                Tool_1.Tool.removeEle(festivalIndex, this.emptys);
            }
            var ani = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI);
            if (!ani)
                ani = new FesRedBombShowAni_1.FesRedBombShowAni();
            this.addChild(ani);
            this.lattices[festivalIndex].element.visible = false;
            ani.play(p, function () {
                _this.lattices[festivalIndex].element.visible = true;
                RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map);
                if (_this.threeMatch()) {
                    _this.eliminate();
                }
                else {
                    _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                    if (!_this.warningCop) {
                        _this.upsetElement();
                    }
                    else {
                        _this.enableMouseEvt(true);
                    }
                }
            });
            return true;
        }
        return false;
    };
    PlayScene.prototype.updateScene = function () {
        this.propBtnCon.boomCount = Tools_1.Tools.gameData.tools.BOOMS;
        this.propBtnCon.hammerCount = Tools_1.Tools.gameData.tools.HAMMERS;
        this.propBtnCon.stepCount = Tools_1.Tools.gameData.tools.STEPS;
    };
    PlayScene.prototype.initEvents = function () {
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    PlayScene.prototype.removeEvents = function () {
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.propBtnCon.boomBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
    };
    PlayScene.prototype.onEnterFrame = function () {
        if (this.mouseEnable && !this.gameGuide) {
            this.noActionCount++;
        }
        else {
            this.noActionCount = 0;
        }
        if (this.noActionCount >= 6 * 60 && !this.isShowWarning) {
            this.noActionCount = 0;
            this.isShowWarning = true;
            this.warningAni();
        }
    };
    PlayScene.prototype.warningAni = function () {
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var ax = a.x;
        var ay = a.y;
        var bx = b.x;
        var by = b.y;
        FYGE.Tween.get(a, { loop: true })
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(200)
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(400);
        FYGE.Tween.get(b, { loop: true })
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(200)
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(400);
    };
    PlayScene.prototype.resetWarning = function () {
        if (!this.warningCop)
            return;
        FYGE.Tween.removeTweens(this.warningCop[0]);
        FYGE.Tween.removeTweens(this.warningCop[1]);
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var aIndex = a.index;
        var bIndex = b.index;
        var ap = Tool_1.Tool.getPositionByIndex(aIndex);
        var bp = Tool_1.Tool.getPositionByIndex(bIndex);
        a.x = ap[0];
        a.y = ap[1];
        b.x = bp[0];
        b.y = bp[1];
    };
    PlayScene.prototype.onTap_boomBtn = function () {
        this.propBtnCon.boomCount ?
            this.useProp(PropType_1.PropType.BOOMS) :
            ctrls_1.showPanel(ToolsOutPanel_1.ToolsOutPanel, { type: PropType_1.PropType.BOOMS, showSucPanel: true });
    };
    PlayScene.prototype.onTap_hammerBtn = function () {
        this.propBtnCon.hammerCount ?
            this.useProp(PropType_1.PropType.HAMMERS) :
            ctrls_1.showPanel(ToolsOutPanel_1.ToolsOutPanel, { type: PropType_1.PropType.HAMMERS, showSucPanel: true });
    };
    PlayScene.prototype.onTap_stepBtn = function () {
        this.propBtnCon.stepCount ?
            this.useProp(PropType_1.PropType.STEPS) :
            ctrls_1.showPanel(ToolsOutPanel_1.ToolsOutPanel, { type: PropType_1.PropType.STEPS, showSucPanel: true });
    };
    PlayScene.prototype.useProp = function (prop) {
        var _this = this;
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        if (this.isShowWarning) {
            this.isShowWarning = false;
            this.resetWarning();
        }
        this.addChild(this.propGuide);
        this.propGuide.init(prop);
        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
            if (this.SELECTED && this.choosed.parent) {
                this.choosed.parent.removeChild(this.choosed);
            }
            var fun_1;
            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1 = function (e) {
                var ele = e.currentTarget.parent.parent;
                if (ele instanceof Element_1.Element &&
                    ele.type != ElementType_1.ElementType.LOLLIPOP) {
                    this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, this);
                    var index = ele.index;
                    this.sendPropUse(prop, index);
                }
            }, this);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, _this);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, _this.mouseDownE, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, _this.mouseMoveE, _this);
            }, this);
        }
        else {
            if (!this.stepCircle) {
                this.stepCircle = new FYGE.Graphics()
                    .beginFill(0xff0000)
                    .drawCircle(BonusShootAni_1.stepPosition[0], BonusShootAni_1.stepPosition[1], 55)
                    .endFill()
                    .addEventListener(FYGE.MouseEvent.CLICK, function () {
                    _this.sendPropUse(PropType_1.PropType.STEPS);
                }, this);
                this.stepCircle.alpha = 0;
            }
            this.addChild(this.stepCircle);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                if (_this.stepCircle.parent)
                    _this.removeChild(_this.stepCircle);
            }, this);
        }
    };
    PlayScene.prototype.sendPropUse = function (prop, index) {
        return __awaiter(this, void 0, void 0, function () {
            var s, rc, p, i, lat;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.propGuide.removeAllEventListener();
                        this.removeChild(this.propGuide);
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.consumerTools(prop)];
                    case 1:
                        s = _a.sent();
                        ctrls_1.hideWaiting();
                        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
                        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
                            this.enableMouseEvt(false);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
                        }
                        else {
                            this.removeChild(this.stepCircle);
                        }
                        if (s) {
                            switch (prop) {
                                case PropType_1.PropType.BOOMS:
                                    rc = Tool_1.Tool.indexToRc(index);
                                    p = Tool_1.Tool.getPositionByIndex(index);
                                    this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
                                    for (i = 0; i < this.lattices.length; i++) {
                                        lat = this.lattices[i];
                                        if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == rc[0] || lat.column == rc[1])) {
                                            if (this.eliminatedElements.indexOf(i) == -1) {
                                                this.eliminatedElements.push(i);
                                                if (Tool_1.Tool.judgeHasScore(lat.element)) {
                                                    this.pushScoreAni(exports.baseScore * 1 * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                                                }
                                            }
                                        }
                                    }
                                    setTimeout(function () {
                                        _this.eliminate();
                                    }, 200);
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.HAMMERS:
                                    this.eliminatedElements.push(index);
                                    if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                                        this.pushScoreAni(exports.baseScore * 1 * (exports.effectBaseTimes[this.lattices[index].element.effectType] || 1), Tool_1.Tool.getPositionByIndex(index));
                                    }
                                    this.eliminate();
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.STEPS:
                                    this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                    setTimeout(function () {
                                        _this.steps += 5;
                                    }, 333);
                                    break;
                            }
                            this.updateScene();
                        }
                        else {
                            this.enableMouseEvt(true);
                        }
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.mouseDownE = function (e) {
        var ele = e.currentTarget.parent.parent;
        var self = this;
        if (ele && ele instanceof Element_1.Element) {
            this.isShowWarning = false;
            this.noActionCount = 0;
            this.resetWarning();
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (self.SELECTED && Tool_1.Tool.checkNeb(ele, self.SELECTED)) {
                self.exchangeElementAni(self.SELECTED, ele, self.callbackEx);
                self.SELECTED.removeChild(self.choosed);
                self.SELECTED = null;
            }
            else {
                self.SELECTED = ele;
                if (self.SELECTED.effectType == EffectType_1.EffectType.MAGICLION) {
                    self.elementContainer.addChildAt(self.SELECTED, 0);
                }
                else {
                    self.elementContainer.addChild(self.SELECTED);
                }
                self.SELECTED.addChild(self.choosed);
            }
        }
    };
    PlayScene.prototype.mouseMoveE = function (e) {
        if (this.SELECTED && e.currentTarget.parent.parent instanceof Element_1.Element) {
            var ele = e.currentTarget.parent.parent;
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (Tool_1.Tool.checkNeb(ele, this.SELECTED)) {
                this.exchangeElementAni(this.SELECTED, ele, this.callbackEx);
                this.SELECTED.removeChild(this.choosed);
                this.SELECTED = null;
            }
        }
    };
    PlayScene.prototype.callbackEx = function (s, o) {
        this.exchangeData(s, o);
        if (this.simpleMatch(s, o)) {
            this.isMouseAction = true;
            if (this.gameGuide)
                this.gameGuide.hideSelf();
            this.steps--;
            this.oneStepScore = 0;
            this.eliminate();
            var aarr = [s, o];
            for (var i = 0; i < aarr.length; i++) {
                var ele = aarr[i];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && this.recycleIndexs.indexOf(ele.index) > -1) {
                    this.recoverEle(ele.index);
                    this.lollipopCount--;
                    if (this.passElements &&
                        this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        this.lollipopCount < this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        this.lollipopMark = true;
                    }
                }
            }
        }
        else {
            this.exchangeData(s, o);
            this.exchangeElementAni(s, o);
        }
    };
    PlayScene.prototype.exchangeElementAni = function (s, o, callback) {
        var _this = this;
        this.enableMouseEvt(false);
        FYGE.Tween.get(s)
            .to({ x: o.x, y: o.y }, 166)
            .call(function () {
            if (callback) {
                callback.bind(_this)(s, o);
            }
            else {
                _this.enableMouseEvt(true);
            }
        });
        FYGE.Tween.get(o)
            .to({ x: s.x, y: s.y }, 166);
    };
    PlayScene.prototype.exchangeData = function (a, b) {
        var latA = this.lattices[a.index];
        var latB = this.lattices[b.index];
        latA.element = b;
        latB.element = a;
    };
    PlayScene.prototype.fall = function (callback) {
        var _this = this;
        Tool_1.Tool.removeReapty(this.emptys);
        if (Tool_1.Tool.judgeOutOne(this.emptys, this.lattices)) {
            var anis = this.fallVerticalEx();
            if (!anis.length) {
                anis = this.fallSkewEx();
                if (!anis.length) {
                    callback();
                }
                else {
                    this.fallAniSuper(anis, function () {
                        _this.fall(callback);
                    });
                }
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                }, true);
            }
        }
        else {
            var anis = this.fallVertical();
            anis = anis.concat(this.fallSkewEx());
            if (!anis.length) {
                callback();
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                });
            }
        }
    };
    PlayScene.prototype.fallVertical = function () {
        var anis = [];
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var latDown, indexDown, connects = [];
                    if (lat.down != null) {
                        latDown = this.lattices[lat.down];
                        indexDown = lat.down;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
                    }
                    else {
                        latDown = this.lattices[index + Tool_1.Tool.colNum];
                        indexDown = index + Tool_1.Tool.colNum;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                    }
                    var emptyIndex = this.emptys.indexOf(indexDown);
                    if (emptyIndex > -1) {
                        anis.push({ ele: lat.element, indexs: connects });
                        this.emptys.splice(emptyIndex, 1);
                        this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                    if (lat &&
                        !lat.element &&
                        lat.isGenerate &&
                        !Tool_1.Tool.judgeFall(this.lattices[index - Tool_1.Tool.colNum])) {
                        anis.push({ ele: null, indexs: [{ index: index, type: FallAniData_1.FallType.STRIGHT }] });
                        Tool_1.Tool.removeEle(index, this.emptys);
                    }
                }
            }
        }
        return anis;
    };
    PlayScene.prototype.fallVerticalEx = function () {
        var _this = this;
        var anis = [];
        var operation = function (m) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = _this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var indexs = Tool_1.Tool.findBottom(lat, _this.emptys, _this.lattices);
                    if (indexs != null) {
                        var downIndex = indexs[indexs.length - 1].index;
                        anis.push({ ele: lat.element, indexs: indexs });
                        Tool_1.Tool.removeEle(downIndex, _this.emptys);
                        _this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                }
            }
            if (_this.generateIndexs[m]) {
                for (var aaa = 0; aaa < _this.generateIndexs[m].length; aaa++) {
                    var index = _this.generateIndexs[m][aaa].index;
                    var lat = _this.lattices[index];
                    if (lat && !lat.element && lat.isGenerate) {
                        var downIndex_1 = index;
                        var type = FallAniData_1.FallType.STRIGHT;
                        var connects = [];
                        var anisOther = [];
                        while (_this.emptys.indexOf(downIndex_1) > -1) {
                            connects.push({
                                index: downIndex_1,
                                type: type,
                            });
                            anis.push({
                                ele: null,
                                indexs: connects.slice()
                            });
                            Tool_1.Tool.removeEle(downIndex_1, _this.emptys);
                            if (_this.lattices[downIndex_1].down != null) {
                                downIndex_1 = _this.lattices[downIndex_1].down;
                                type = FallAniData_1.FallType.THROUGH;
                            }
                            else {
                                downIndex_1 += Tool_1.Tool.colNum;
                                type = FallAniData_1.FallType.STRIGHT;
                            }
                        }
                        var len = anis.length;
                        for (var i = len - 1; i >= len - connects.length; i--) {
                            anis[i].wait = (len - 1 - i) * Tool_1.Tool.latDeltaTime * 2 / 3;
                        }
                    }
                }
            }
        };
        if (this.connectState == 1) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        else if (this.connectState == 2) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 3) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 4) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        return anis;
    };
    PlayScene.prototype.fallSkewEx = function () {
        var _this = this;
        var anis = [];
        var emptys = this.emptys;
        emptys.sort(function (a, b) {
            return a < b ? 1 : -1;
        });
        var _loop_1 = function () {
            var indexMy = emptys[i];
            lat = this_1.lattices[indexMy];
            var latFall;
            var indexFall;
            var type = FallAniData_1.FallType.STRIGHT;
            if (lat.up) {
                latUnUp = this_1.lattices[lat.up];
                if (Tool_1.Tool.judgeFall(latUnUp)) {
                    latFall = latUnUp;
                    indexFall = lat.up;
                    type = FallAniData_1.FallType.THROUGH;
                }
            }
            if (!latFall && Tool_1.Tool.indexToRc(indexMy)[0] != 0) {
                latUp = this_1.lattices[indexMy - Tool_1.Tool.colNum];
                if (Tool_1.Tool.judgeFall(latUp)) {
                    latFall = latUp;
                    indexFall = indexMy - Tool_1.Tool.colNum;
                }
            }
            var findLeft = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != 0) {
                    var latLeftUp = _this.lattices[indexMy - Tool_1.Tool.colNum - 1];
                    if (Tool_1.Tool.judgeFall(latLeftUp)) {
                        latFall = latLeftUp;
                        indexFall = indexMy - Tool_1.Tool.colNum - 1;
                    }
                }
            };
            var findRight = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != Tool_1.Tool.colNum - 1) {
                    var latRightUp = _this.lattices[indexMy - Tool_1.Tool.colNum + 1];
                    if (Tool_1.Tool.judgeFall(latRightUp)) {
                        latFall = latRightUp;
                        indexFall = indexMy - Tool_1.Tool.colNum + 1;
                    }
                }
            };
            if (Math.random() > 0.5) {
                findLeft();
                findRight();
            }
            else {
                findRight();
                findLeft();
            }
            if (latFall) {
                anis.push({ ele: latFall.element, indexs: [{ index: indexMy, type: type }] });
                emptys.splice(i, 1);
                emptys.splice(i + 1, 0, indexFall);
                latFall.element = null;
                i--;
            }
            else {
                if (lat.isGenerate) {
                    anis.push({ ele: null, indexs: [{ index: indexMy, type: FallAniData_1.FallType.STRIGHT }] });
                    emptys.splice(i, 1);
                    i--;
                    return "continue";
                }
            }
        };
        var this_1 = this, lat, latUnUp, latUp;
        for (var i = 0; i < emptys.length; i++) {
            _loop_1();
        }
        return anis;
    };
    PlayScene.prototype.fallAniSuper = function (anis, callback, isVertical) {
        var _this = this;
        if (isVertical === void 0) { isVertical = false; }
        var deltaTime = Tool_1.Tool.latDeltaTime;
        if (isVertical) {
            deltaTime = Tool_1.Tool.latDeltaTime * 2 / 3;
        }
        var count = 0;
        var countAll = anis.length;
        var _loop_2 = function (i) {
            var ani = anis[i];
            var ele = ani.ele;
            var wait_1 = ani.wait || 0;
            var indexs = ani.indexs;
            var oriRow = void 0;
            var oriCol = void 0;
            var endIndex = indexs[indexs.length - 1].index;
            var tween = void 0;
            if (!ele) {
                var firstIndex = indexs.shift();
                ele = this_2.createELement(firstIndex.index);
                this_2.elementContainer.addChild(ele);
                oriRow = Tool_1.Tool.indexToRc(firstIndex.index)[0];
                var fp = Tool_1.Tool.getPositionByIndex(firstIndex.index);
                ele.x = fp[0];
                ele.y = fp[1] - Tool_1.Tool.height;
                tween = FYGE.Tween.get(ele);
                if (wait_1)
                    tween.wait(wait_1);
                if (this_2.lattices[firstIndex.index - Tool_1.Tool.colNum]) {
                    var mask_1 = Tool_1.Tool.getRectMask();
                    mask_1.x = fp[0];
                    mask_1.y = fp[1];
                    this_2.elementContainer.addChild(mask_1);
                    ele.mask = mask_1;
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime)
                        .call(function () {
                        ele.mask = null;
                        mask_1.recover();
                    });
                }
                else {
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime);
                }
                wait_1 += deltaTime;
            }
            else {
                oriRow = ele.row;
                tween = FYGE.Tween.get(ele);
            }
            var lastX = void 0, lastY = void 0;
            for (var j = 0; j < indexs.length; j++) {
                var index = indexs[j].index;
                var type = indexs[j].type;
                var p = Tool_1.Tool.getPositionByIndex(index);
                if (type == FallAniData_1.FallType.THROUGH) {
                    var indexUp = this_2.lattices[index].up;
                    var downPos = Tool_1.Tool.getPositionByIndex(index);
                    var upPos = Tool_1.Tool.getPositionByIndex(indexUp);
                    if (this_2.lattices[indexUp + Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, upPos, wait_1, this_2.elementContainer, true, deltaTime);
                        tween.set({ alpha: 0 })
                            .wait(deltaTime)
                            .set({ alpha: 1 });
                    }
                    else {
                        tween.to({ x: upPos[0], y: upPos[1] + Tool_1.Tool.height }, deltaTime);
                    }
                    if (this_2.lattices[index - Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    else {
                        EleDownAni_1.EleDownAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    oriRow = Tool_1.Tool.indexToRc(index)[0];
                    lastX = downPos[0];
                    lastY = downPos[1];
                    wait_1 += deltaTime;
                }
                else {
                    delta = Tool_1.Tool.indexToRc(index)[0] - oriRow;
                    if (delta > 0) {
                        oriRow = Tool_1.Tool.indexToRc(index)[0];
                        if (lastX != null) {
                            tween.set({ x: lastX, y: lastY });
                        }
                        tween.to({ x: p[0], y: p[1] }, delta * deltaTime);
                        wait_1 += delta * deltaTime;
                        lastX = null;
                    }
                }
            }
            var showFallAni = (function () {
                return false;
            })();
            lat = this_2.lattices[endIndex];
            lat.element = ele;
            tween.call(function () {
                var endP = Tool_1.Tool.getPositionByIndex(endIndex);
                ele.x = endP[0];
                ele.y = endP[1];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && _this.recycleIndexs.indexOf(endIndex) > -1) {
                    _this.recoverEle(endIndex);
                    _this.lollipopCount--;
                    if (_this.passElements &&
                        _this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        _this.lollipopCount < _this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        _this.lollipopMark = true;
                    }
                }
                else if (showFallAni) {
                    ele.fallAni();
                }
                if (++count == countAll)
                    callback();
            });
        };
        var this_2 = this, delta, lat;
        for (var i = anis.length - 1; i >= 0; i--) {
            _loop_2(i);
        }
    };
    PlayScene.prototype.createELement = function (index) {
        var type;
        var effectType = null;
        if (this.lollipopMark) {
            this.lollipopMark = false;
            type = ElementType_1.ElementType.LOLLIPOP;
            this.lollipopCount++;
        }
        else {
            var baseElementTypes = this.chapterData.baseElementTypes.slice();
            var col = Tool_1.Tool.indexToRc(index)[1];
            var data = this.generateIndexs[col].filter(function (d) {
                return d.index == index;
            })[0];
            if (data) {
                var one = data.cus.shift();
                if (one) {
                    var oneData = Tool_1.Tool.praseEleNumber(one);
                    type = oneData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : oneData[0];
                    effectType = oneData[1];
                }
                else {
                    if (!data.type || !data.type.length) {
                        type = Tool_1.Tool.randomT(baseElementTypes);
                    }
                    else {
                        var code = Tool_1.Tool.randomT(data.type);
                        if (code) {
                            var codeData = Tool_1.Tool.praseEleNumber(code);
                            type = codeData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : codeData[0];
                            effectType = codeData[1];
                        }
                        else {
                            type = Tool_1.Tool.randomT(baseElementTypes);
                        }
                    }
                }
            }
            else {
                type = Tool_1.Tool.randomT(baseElementTypes);
            }
        }
        var ele = Tool_1.Tool.getElement(type);
        if (!this.hasPassed)
            ele.effectType = effectType;
        if (type != ElementType_1.ElementType.LOLLIPOP &&
            effectType == null &&
            this.chapterData.bubbleProbability &&
            Math.random() < this.chapterData.bubbleProbability) {
            ele.setState(StateType_1.StateType.BUBBLE, true, type);
        }
        return ele;
    };
    PlayScene.prototype.simpleMatch = function (s, o) {
        if (s.effectType != null && o.effectType != null) {
            this.isManual = true;
            this.eliminatedElements.push(s.index, o.index);
            this.effectContinuityTimes++;
            return true;
        }
        if (s.effectType == EffectType_1.EffectType.MAGICLION || o.effectType == EffectType_1.EffectType.MAGICLION) {
            if (s.type == ElementType_1.ElementType.LOLLIPOP || o.type == ElementType_1.ElementType.LOLLIPOP) {
                return false;
            }
            else {
                this.isManual = true;
                this.eliminatedElements.push(s.index, o.index);
                this.effectContinuityTimes++;
                return true;
            }
        }
        return this.threeMatch(s, o);
    };
    PlayScene.prototype.threeMatch = function (s, o) {
        for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.colNum; g++) {
                arr.push(i * Tool_1.Tool.colNum + g);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        this.eliminatedElements.push(re[j][k]);
                        if (len >= 5) {
                            if (k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                this.elementContainer.addChildAt(ele, 0);
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                        }
                    }
                }
            }
        }
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.rowNum; g++) {
                arr.push(Tool_1.Tool.colNum * g + m);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        if (len >= 5) {
                            if (k == 2) {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION) {
                                    ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                    this.elementContainer.addChildAt(ele, 0);
                                    if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                        this.eliminatedElements.push(re[j][k]);
                                    }
                                }
                            }
                            else {
                                if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                    this.eliminatedElements.push(re[j][k]);
                                }
                                else {
                                    if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                        ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                                }
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                        else {
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                    }
                }
            }
        }
        if (this.eliminatedElements.length && !this.hasPassed)
            this.commonContinuityTimes++;
        for (var aa = 0; aa < this.eliminatedElements.length; aa++) {
            var index = this.eliminatedElements[aa];
            if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                this.pushScoreAni(exports.baseScore * this.commonContinuityTimes, Tool_1.Tool.getPositionByIndex(index));
            }
        }
        return this.eliminatedElements.length > 0;
    };
    PlayScene.prototype.eliminate = function () {
        var _this = this;
        if (this.isManual) {
            this.isManual = false;
            this.effectCombination();
        }
        else {
            this.rotateEliminate();
            var effectIndexs = this.commonEliminate();
            var scoreAll = 0;
            for (var i = 0; i < this.scoreAnis.length; i++) {
                var scoreAni = this.scoreAnis[i];
                scoreAll += scoreAni.score;
            }
            this.scoreAnis.length = 0;
            this.score += scoreAll;
            this.oneStepScore += scoreAll;
            this.effectEliminate(effectIndexs);
        }
        if (this.eliminatedElements.length) {
            setTimeout(function () {
                _this.eliminate();
            }, 200);
        }
        else {
            setTimeout(function () {
                _this.fall(function () {
                    _this.fallCallback();
                });
            }, 200);
        }
    };
    PlayScene.prototype.fallCallback = function () {
        var _this = this;
        if (this.threeMatch()) {
            this.eliminate();
            return;
        }
        AiControl_1.AiControl.ins.doorMotion(this, function () {
            AiControl_1.AiControl.ins.eggMotion(_this, function () {
                AiControl_1.AiControl.ins.hairballMotion(_this, function () {
                    AiControl_1.AiControl.ins.fesEleMotion(_this, function () {
                        if (_this.hasPassed) {
                            if (!_this.isCountingTime) {
                                _this.terminateSteps();
                            }
                            else {
                                _this.submit();
                            }
                            return;
                        }
                        _this.hasPassed = _this.judgePass();
                        if (_this.hasPassed) {
                            _this.commonContinuityTimes = 1;
                            _this.effectContinuityTimes = 1;
                            _this.addChild(movieClips.bonusTime);
                            movieClips.bonusTime.play(1, function () {
                                _this.removeChild(movieClips.bonusTime);
                                RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map, function () {
                                    _this.terminateSteps();
                                });
                            });
                            return;
                        }
                        _this.oneStepScoreToast();
                        _this.commonContinuityTimes = 0;
                        _this.effectContinuityTimes = 0;
                        if (_this.steps == 0) {
                            if (!_this.addedStepWarning) {
                                _this.addedStepWarning = true;
                                ctrls_1.showPanel(NoStepPanel_1.NoStepPanel, {
                                    reviveFun: function () { return __awaiter(_this, void 0, void 0, function () {
                                        var s, count_1, countAll_1;
                                        var _this = this;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    ctrls_1.showWaiting();
                                                    return [4, Tools_1.Tools.consumerTools(PropType_1.PropType.STEPS)];
                                                case 1:
                                                    s = _a.sent();
                                                    ctrls_1.hideWaiting();
                                                    if (!s) {
                                                        this.submit(false);
                                                    }
                                                    else {
                                                        count_1 = 0;
                                                        countAll_1 = 2;
                                                        AiControl_1.AiControl.ins.jellyMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        AiControl_1.AiControl.ins.bubbleMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                                        setTimeout(function () { _this.steps += 5; }, 333);
                                                        this.updateScene();
                                                    }
                                                    return [2];
                                            }
                                        });
                                    }); }
                                });
                            }
                            else {
                                _this.submit(false);
                            }
                            return;
                        }
                        var count = 0;
                        var countAll = 2;
                        AiControl_1.AiControl.ins.jellyMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                        AiControl_1.AiControl.ins.bubbleMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                    });
                });
            });
        });
    };
    PlayScene.prototype.aiMotionCheckDieMap = function () {
        var _this = this;
        this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
        if (!this.warningCop) {
            if (Tool_1.Tool.alreadyDie(this.lattices)) {
                ctrls_1.showToast("元素已无法消除");
                setTimeout(function () {
                    _this.submit(false);
                }, 1000);
            }
            else {
                ctrls_1.showToast("没有可以消除的元素");
                setTimeout(function () {
                    _this.upsetElement();
                }, 1000);
            }
        }
        else {
            if (this.gameGuide) {
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
            ;
            this.enableMouseEvt(true);
            this.openRedBombPanel();
        }
    };
    PlayScene.prototype.effectCombination = function () {
        var one = this.eliminatedElements[0];
        var two = this.eliminatedElements[1];
        var lat1 = this.lattices[one];
        var lat2 = this.lattices[two];
        var ele1 = this.lattices[one].element;
        var ele2 = this.lattices[two].element;
        this.eliminatedElements = [];
        if (ele1.effectType == EffectType_1.EffectType.MAGICLION &&
            ele2.effectType == EffectType_1.EffectType.MAGICLION) {
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(one));
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(two));
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.MM, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType == EffectType_1.EffectType.MAGICLION || ele2.effectType == EffectType_1.EffectType.MAGICLION)) {
            var magic = void 0, other = void 0;
            var magicIndex;
            if (ele1.effectType == EffectType_1.EffectType.MAGICLION) {
                magic = ele1;
                other = ele2;
                magicIndex = one;
            }
            else {
                magic = ele2;
                other = ele1;
                magicIndex = two;
            }
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(magicIndex));
            this.recoverEle(magicIndex);
            var rotateData = {
                p: Tool_1.Tool.getPositionByIndex(magicIndex),
                elementsIndex: [],
                type: other.type,
            };
            this.magicRotateData = [rotateData];
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeMagicEliminate(lat) &&
                    lat.element.type == other.type) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (other.effectType != null) {
                        if (other.effectType == EffectType_1.EffectType.EXPLOSIVE) {
                            lat.element.effectType = EffectType_1.EffectType.EXPLOSIVE;
                        }
                        else {
                            lat.element.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        }
                    }
                    else {
                        if (Tool_1.Tool.judgeMagicRotate(lat.element)) {
                            rotateData.elementsIndex.push(i);
                        }
                    }
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType < 2 && ele2.effectType < 2) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == lat1.row || lat.column == lat1.column)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType < 2 || ele2.effectType < 2) &&
            (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE || ele2.effectType == EffectType_1.EffectType.EXPLOSIVE)) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.THREECROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 2 || Math.abs(lat.column - lat1.column) < 2)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE && ele2.effectType == EffectType_1.EffectType.EXPLOSIVE) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
            boomAni.scaleX = boomAni.scaleY = 2;
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 3 && Math.abs(lat.column - lat1.column) < 3)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EE, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
    };
    PlayScene.prototype.rotateEliminate = function () {
        for (var m = 0; m < this.magicRotateData.length; m++) {
            var indexs = this.magicRotateData[m].elementsIndex;
            var position = this.magicRotateData[m].p;
            for (var n = 0; n < indexs.length; n++) {
                var roIndex = indexs[n];
                var roEle = this.lattices[roIndex].element;
                if (this.lattices[roIndex].element.temEffectType != null)
                    continue;
                MagicRotateAni_1.MagicRotateAni(roEle, position, this);
                this.recoverEle(roIndex);
                Tool_1.Tool.removeEle(roIndex, this.eliminatedElements);
            }
        }
        this.magicRotateData.length = 0;
    };
    PlayScene.prototype.commonEliminate = function () {
        var effectIndexs = [];
        for (var i = this.eliminatedElements.length - 1; i >= 0; i--) {
            var index = this.eliminatedElements[i];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            if (!ele) {
            }
            else if (ele.hasState(StateType_1.StateType.LOCK)) {
                ele.setState(StateType_1.StateType.LOCK, false);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
                var hairballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBROWN);
                hairballBrownState.isActive = true;
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                this.playAni(RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI, p);
                ele.setState(StateType_1.StateType.HAIRBALLGREY, false);
                this.goElementTarget(ElementType_1.ElementType.HAIRBALLGREY, [ele.x, ele.y]);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var blackballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBLACK);
                if (blackballBrownState.isAwake) {
                    blackballBrownState.isAwake = false;
                }
                else {
                    this.playAni(RecoverName_1.RecoverName.HAIRBALLBLACKDIS_ANI, p);
                    ele.setState(StateType_1.StateType.HAIRBALLBLACK, false);
                    this.goElementTarget(ElementType_1.ElementType.HAIRBALLBLACK, [ele.x, ele.y]);
                }
            }
            else if (ele.effectType != null) {
                effectIndexs.push(index);
            }
            else {
                if (ele.temEffectType != null) {
                    ele.effectType = ele.temEffectType;
                    ele.temEffectType = null;
                    if (ele.hasState(StateType_1.StateType.BUBBLE)) {
                        ele.setState(StateType_1.StateType.BUBBLE, false);
                    }
                    this.goElementTarget(ele.type, [ele.x, ele.y]);
                    this.checkNebAll(this.lattices[index]);
                }
                else {
                    if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) >= 0) {
                        this.addChild(EleDisAni_1.EleDisAni(ele.type)).position.set(ele.x, ele.y);
                        this.recoverEle(index);
                    }
                    else if (ele.type == ElementType_1.ElementType.ROCK) {
                        this.removeRock(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.JELLY) {
                        this.removeJelly(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.CHICKEN_EGG) {
                        ele.chickenEgg.statusNum--;
                        ele.chickenEgg.shakeAni();
                        this.playAni(RecoverName_1.RecoverName.EGGBROKEN_ANI, p);
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_BIG) {
                        ele.festivalEle.statusNum--;
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
                        this.removeFestivalEleSmall(index);
                    }
                }
            }
            this.eliminatedElements.splice(i, 1);
        }
        return effectIndexs;
    };
    PlayScene.prototype.effectEliminate = function (effectIndexs) {
        var _this = this;
        if (effectIndexs.length && !this.hasPassed)
            this.effectContinuityTimes++;
        var judgeExclude = function (i) {
            return _this.eliminatedElements.indexOf(i) < 0 && effectIndexs.indexOf(i) < 0;
        };
        for (var j = 0; j < effectIndexs.length; j++) {
            var index = effectIndexs[j];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            switch (ele.effectType) {
                case EffectType_1.EffectType.MAGICLION:
                    this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, p);
                    this.recoverEle(index);
                    var types = this.chapterData.baseElementTypes.slice();
                    for (var iii = 0; iii < this.magicRotateData.length; iii++) {
                        Tool_1.Tool.removeEle(this.magicRotateData[iii].type, types);
                    }
                    var type = types.length ? Tool_1.Tool.randomT(types) : Tool_1.Tool.randomT(this.chapterData.baseElementTypes);
                    var rotateData = {
                        p: Tool_1.Tool.getPositionByIndex(index),
                        elementsIndex: [],
                        type: type,
                    };
                    this.magicRotateData.push(rotateData);
                    for (var i = 0; i < this.lattices.length; i++) {
                        if (Tool_1.Tool.judgeMagicEliminate(this.lattices[i]) &&
                            this.lattices[i].element.type == type &&
                            judgeExclude(i)) {
                            this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeMagicRotate(this.lattices[i].element)) {
                                rotateData.elementsIndex.push(i);
                            }
                            if (Tool_1.Tool.judgeHasScore(this.lattices[i].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.EXPLOSIVE:
                    var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
                    boomAni.scaleX = boomAni.scaleY = 1;
                    this.recoverEle(index);
                    Tool_1.Tool.getExplosiveIndexes(lat, this.lattices).forEach(function (i) {
                        if (judgeExclude(i)) {
                            _this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeHasScore(_this.lattices[i].element)) {
                                _this.pushScoreAni(exports.baseScore * _this.effectContinuityTimes * exports.effectBaseTimes["2"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    });
                    break;
                case EffectType_1.EffectType.HORIZONTAL:
                    var row = lat.row;
                    this.playAni(RecoverName_1.RecoverName.HORIZONTAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.colNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(row, i);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["0"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.VERTICAL:
                    var col = lat.column;
                    this.playAni(RecoverName_1.RecoverName.VERTICAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(i, col);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["1"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
            }
        }
    };
    PlayScene.prototype.judgePass = function () {
        if (this.passElements) {
            for (var i = 0; i < this.passElements.length; i++) {
                if (this.passElements[i]) {
                    return false;
                }
            }
            return true;
        }
        else {
            if (this.score > this.chapterData.passTarget.score) {
                return true;
            }
            else {
                return false;
            }
        }
    };
    PlayScene.prototype.terminateSteps = function () {
        var _this = this;
        var effectElements = [], elements = [];
        for (var i = Tool_1.Tool.colNum * Tool_1.Tool.rowNum - 1; i >= 0; i--) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeBaseEle(lat)) {
                if (lat.element.effectType != null) {
                    effectElements.push(i);
                }
                else {
                    elements.push(lat.element);
                }
            }
        }
        if (effectElements.length) {
            Array.prototype.push.apply(this.eliminatedElements, effectElements);
            this.eliminate();
        }
        else {
            if (this.steps == 0 || elements.length == 0) {
                this.score += 1000 * this.steps;
                this.steps = 0;
                this.submit();
                return;
            }
            this.isCountingTime = true;
            var countAll_2 = Math.min(this.steps, elements.length);
            var count_2 = 0;
            var deltaCount = 0;
            var _loop_3 = function () {
                rand = Math.floor(Math.random() * elements.length);
                var ele = elements.splice(rand, 1)[0];
                if (!ele)
                    return "break";
                deltaCount++;
                var bonusShootAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BONUSSHOOT_ANI);
                if (!bonusShootAni) {
                    bonusShootAni = new BonusShootAni_1.BonusShootAni();
                }
                setTimeout(function () {
                    _this.steps--;
                    _this.score += 1000;
                    _this.addChild(bonusShootAni);
                    bonusShootAni.play([ele.x, ele.y], function () {
                        ele.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        ele.removeAllState();
                        _this.eliminatedElements.push(ele.index);
                        _this.pushScoreAni(exports.baseScore * 1 * 1.5, [ele.x, ele.y]);
                        if (++count_2 == countAll_2) {
                            _this.eliminate();
                            if (_this.steps) {
                                _this.score += 1000 * _this.steps;
                                _this.steps = 0;
                            }
                        }
                    });
                }, 150 * deltaCount);
            };
            var rand;
            while (deltaCount < countAll_2) {
                var state_1 = _loop_3();
                if (state_1 === "break")
                    break;
            }
        }
    };
    PlayScene.prototype.pushScoreAni = function (score, p) {
        var scoreAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.SCORE_ANI);
        if (!scoreAni) {
            scoreAni = new ScoreAni_1.ScoreAni();
        }
        scoreAni.score = score;
        scoreAni.x = p[0];
        scoreAni.y = p[1];
        this.scoreAnis.push(scoreAni);
    };
    PlayScene.prototype.oneStepScoreToast = function () {
        var _this = this;
        var sv;
        if (this.oneStepScore > 5000) {
            sv = "wonderful";
        }
        else if (this.oneStepScore > 3000) {
            sv = "amazing";
        }
        else if (this.oneStepScore > 1000) {
            sv = "great";
        }
        if (sv && movieClips[sv]) {
            this.addChild(movieClips[sv]);
            movieClips[sv].play(1, function () {
                _this.removeChild(movieClips[sv]);
            });
        }
        this.oneStepScore = 0;
    };
    PlayScene.prototype.upsetElement = function () {
        var _this = this;
        var lats = [];
        var anis = [];
        for (var i = 0; i < this.lattices.length; i++) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeUpsetMove(lat))
                lats.push(lat);
        }
        var latsCopy = lats.slice();
        for (var i = 0; i < lats.length; i++) {
            var ele = lats[i].element;
            var rand = Math.floor(Math.random() * latsCopy.length);
            var lat_1 = latsCopy.splice(rand, 1)[0];
            anis.push([ele, lat_1.index]);
        }
        var count = 0;
        var countAll = anis.length;
        for (var i = 0; i < countAll; i++) {
            var ele = anis[i][0];
            var index = anis[i][1];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var lat = this.lattices[index];
            lat.element = ele;
            FYGE.Tween.get(ele)
                .to({ x: p[0], y: p[1] }, 500)
                .call(function () {
                if (++count == countAll) {
                    if (_this.threeMatch()) {
                        _this.eliminate();
                    }
                    else {
                        _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                        if (!_this.warningCop) {
                            _this.upsetElement();
                        }
                        else {
                            _this.enableMouseEvt(true);
                            _this.openRedBombPanel();
                        }
                    }
                }
            });
        }
    };
    PlayScene.prototype.recoverEle = function (index) {
        var ele = this.removeOperation(index);
        if (ele.type != ElementType_1.ElementType.LOLLIPOP)
            this.checkNebAll(this.lattices[index]);
        this.goElementTarget(ele.type, [ele.x, ele.y]);
    };
    PlayScene.prototype.getSubmitJson = function () {
        var json = {};
        return JSON.stringify(json);
    };
    PlayScene.prototype.submit = function (suc) {
        var _this = this;
        if (suc === void 0) { suc = true; }
        var params = {
            level: this.data.chapter,
            score: this.score,
            stars: this.scoreProgress.starCount,
            isVisitSuccess: suc,
        };
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.gameOver, params, function (s, res) {
            ctrls_1.hideWaiting();
            if (s) {
                Tools_1.Tools.gameOver(Object.assign(res.data || {}, params));
            }
            else {
                if (res.data) {
                    ctrls_1.showToast("网络开小差了\n再次连接中");
                    ctrls_1.wait(function () { _this.submit(suc); }, 1300);
                }
                else {
                    ctrls_1.showToast(res.message || "活动太火爆了\n请稍后再来");
                    ctrls_1.wait(function () { ctrls_1.changeScene(MapScene_1.MapScene); }, 1300);
                }
            }
        }, true);
    };
    PlayScene.prototype.openRedBombPanel = function () {
        if (this.redBombPanelMark) {
            this.redBombPanelMark = false;
        }
    };
    PlayScene.prototype.returnPanels = function (panelName, data) {
        var panels = [], params = [];
        if (this.redBombPanelMark) {
            panels.push(redBombPanelName);
            params.push(null);
            this.redBombPanelMark = false;
        }
        panels.push(panelName);
        params.push(data);
        return [panels, params];
    };
    PlayScene.prototype.playAni = function (name, p) {
        var ani = Pool_1.Pool.takeOut(name);
        if (!ani) {
            ani = new aniClass[name]();
        }
        ani.x = p[0];
        ani.y = p[1];
        ani.play();
        if (name == RecoverName_1.RecoverName.MAGICLION_ANI) {
            this.addChildAt(ani, this.getChildIndex(this.map) + 1);
        }
        else {
            this.addChild(ani);
        }
        return ani;
    };
    PlayScene.prototype.iceBroken = function (lat) {
        if (lat && lat.ice) {
            var ice = lat.ice;
            ice.countNum--;
            if (ice.countNum == 0) {
                this.map.removeChild(ice);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.ICE, ice);
                lat.ice = null;
                this.goElementTarget(ElementType_1.ElementType.ICE, [ice.x, ice.y]);
            }
            else {
                ice.alpha = 0.6;
            }
            var p = Tool_1.Tool.getPositionByIndex(lat.index);
            this.playAni(RecoverName_1.RecoverName.ICE_ANI, p);
        }
    };
    PlayScene.prototype.goElementTarget = function (type, fromP) {
        var _this = this;
        if (!this.passElements)
            return;
        if (this.passElements[type] != undefined) {
            if (this.passElements[type] != 0) {
                this.passElements[type]--;
                var p = this.elementTargets.targets[type].localToGlobal({ x: 40 * 0.8, y: 40 * 0.8 });
                this.addChild(FlyTargetAni_1.FlyTargetAni(type, fromP, [p.x, p.y - layers_1.layers.stageOffsetY], function () {
                    _this.elementTargets.targets[type].count--;
                }));
            }
            this.hasEliminatedElements[type]++;
        }
    };
    PlayScene.prototype.checkNebEle = function (lat, checkFun) {
        var indexMy = lat.index;
        var indexs = [
            indexMy - Tool_1.Tool.colNum,
            indexMy + Tool_1.Tool.colNum,
        ];
        if (lat.column > 0) {
            indexs.push(indexMy - 1);
        }
        if (lat.column < Tool_1.Tool.colNum - 1) {
            indexs.push(indexMy + 1);
        }
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var lat_2 = this.lattices[index];
            if (lat_2 && lat_2.element && !lat_2.doorClosed && checkFun(lat_2)) {
                if (this.eliminatedElements.indexOf(index) == -1)
                    this.eliminatedElements.push(index);
            }
        }
    };
    PlayScene.prototype.checkNebAll = function (latttice) {
        this.iceBroken(latttice);
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.ROCK;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.JELLY;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.CHICKEN_EGG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLGREY);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_SMALL;
        });
    };
    PlayScene.prototype.removeRock = function (index) {
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.ROCK_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeJelly = function (index) {
        this.jellyBrokenMark = true;
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.JELLYDIS_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeFestivalEleSmall = function (index) {
        var _this = this;
        var ele = this.removeOperation(index);
        if (this.festivalTargetNum) {
            this.festivalTargetNum--;
            var p = this.festivalTarget.localToGlobal({ x: 40 * 0.8, y: 40 * 0.8 });
            this.addChild(FlyTargetAni_1.FlyTargetAni(ElementType_1.ElementType.FESTIVALELE_SMALL, [ele.x, ele.y], [p.x, p.y], function () {
                _this.festivalTarget.count--;
            }));
            if (!this.festivalTargetNum) {
            }
        }
    };
    PlayScene.prototype.removeOperation = function (index) {
        if (!this.lattices[index] || !this.lattices[index].element)
            return null;
        var ele = this.lattices[index].element;
        this.emptys.push(index);
        this.elementContainer.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        this.lattices[index].element = null;
        return ele;
    };
    PlayScene.prototype.redBombLightAni = function (index, callback) {
        callback();
    };
    return PlayScene;
}(Scene_1.Scene));
exports.PlayScene = PlayScene;
var isOn = true;
var SettingBtn = (function (_super) {
    __extends(SettingBtn, _super);
    function SettingBtn() {
        var _this = _super.call(this) || this;
        var bg = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("settingBg.png")));
        bg.position.set(6, 50);
        bg.visible = false;
        var musicBtn = _this.addChild(new (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var _this = this;
                var t = RES_1.RES.getRes("musicOn.png");
                _this = _super.call(this, t) || this;
                _this.addEventListener(FYGE.MouseEvent.CLICK, function () {
                    isOn = !isOn;
                    _this.texture = RES_1.RES.getRes(isOn ? "musicOn.png" : "musicOff.png");
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: isOn });
                }, _this);
                if (isOn)
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
                Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, _this.onShow, _this);
                return _this;
            }
            class_1.prototype.onShow = function () {
                if (isOn)
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
            };
            class_1.prototype.destroy = function () {
                Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.onShow, this);
                _super.prototype.destroy.call(this);
            };
            return class_1;
        }(FYGE.Sprite)));
        musicBtn.position.set(11, 97);
        musicBtn.visible = false;
        var btn = _this.addChild(new FYGE.Button(RES_1.RES.getRes("settingBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, function () {
            console.log(9999);
            musicBtn.visible = !musicBtn.visible;
            bg.visible = !bg.visible;
        }, _this);
        return _this;
    }
    SettingBtn.prototype.destroy = function () {
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: false });
        _super.prototype.destroy.call(this);
    };
    return SettingBtn;
}(FYGE.Container));


/***/ }),

/***/ "./src/scene/map/CheckBtn.ts":
/*!***********************************!*\
  !*** ./src/scene/map/CheckBtn.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Button = FYGE.Button;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Container = FYGE.Container;
var Sprite = FYGE.Sprite;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var MouseEvent = FYGE.MouseEvent;
var Point = FYGE.Point;
var FrameAni = FYGE.FrameAni;
var Tween = FYGE.Tween;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var StartPanel_1 = __webpack_require__(/*! ../../panels/StartPanel */ "./src/panels/StartPanel.ts");
var StartPanelPrize_1 = __webpack_require__(/*! ../../panels/StartPanelPrize */ "./src/panels/StartPanelPrize.ts");
var CHECK_TYPE;
(function (CHECK_TYPE) {
    CHECK_TYPE[CHECK_TYPE["COM"] = 0] = "COM";
    CHECK_TYPE[CHECK_TYPE["CUR"] = 1] = "CUR";
})(CHECK_TYPE = exports.CHECK_TYPE || (exports.CHECK_TYPE = {}));
var CheckBtn = (function (_super) {
    __extends(CheckBtn, _super);
    function CheckBtn(data) {
        var _this = _super.call(this) || this;
        _this.checkData = {
            level: 1,
            scores: 0,
            stars: 0,
            isPrizeLevel: false,
            isVisitSuccess: false,
            isPlayed: false,
        };
        _this.btn = null;
        _this.checkLabel = null;
        _this.star = null;
        _this.prizeAnim = null;
        _this.curAnim = null;
        _this.checkNum = null;
        _this.checkCurEffect = null;
        _this._data = null;
        _this._starCount = 0;
        _this._enabled = true;
        _this._isPrize = false;
        _this._type = CHECK_TYPE.COM;
        _this.initUi(data);
        _this.initEffect();
        return _this;
    }
    Object.defineProperty(CheckBtn.prototype, "data", {
        set: function (data) {
            this._data = data;
            this.checkData.isPlayed = true;
            if (!data)
                return;
            if (!data.isVisitSuccess)
                return;
            this.enabled = data.isVisitSuccess;
            this.starCount = data.stars;
            this.checkData = data;
            this.checkData.isPlayed = true;
            this._sendAwardType = data.sendAwardType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "sendAwardType", {
        get: function () {
            return this._sendAwardType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "starCount", {
        get: function () {
            return this._starCount;
        },
        set: function (count) {
            if (count > 3) {
                count = 3;
            }
            else if (count < 1) {
                count = 1;
            }
            if (this._starCount == count)
                return;
            this._starCount = count;
            this.star.forEach(function (value, index) {
                value.enabled = (index < count);
            });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "enabled", {
        set: function (enabled) {
            if (this._enabled == enabled)
                return;
            this._enabled = enabled;
            this.btn.enabled = enabled;
            this.star.forEach(function (v) { return v.visible = enabled; });
            this.checkLabel.visible = enabled;
            if (!enabled && this._isPrize) {
                !this.prizeAnim.parent && this.addChild(this.prizeAnim);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "isPrize", {
        set: function (isPrize) {
            if (isPrize == this._isPrize)
                return;
            this._isPrize = isPrize;
            if (this._isPrize && !this._enabled) {
                !this.prizeAnim.parent && this.addChild(this.prizeAnim);
            }
            else {
                this.prizeAnim.parent && this.prizeAnim.parent.removeChild(this.prizeAnim);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "type", {
        set: function (type) {
            if (this._type == type)
                return;
            this._type = type;
            switch (type) {
                case CHECK_TYPE.COM:
                    this.btn.changeTexture(RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_disable.png'));
                    this.checkLabel.strokeColor = '#316ec6';
                    this.checkCurEffect.visible = false;
                    this.checkCurEffect.stop();
                    break;
                case CHECK_TYPE.CUR:
                    this.btn.changeTexture(RES_1.RES.getRes('map_check_enable_cur.png'), RES_1.RES.getRes('map_check_enable_cur.png'), RES_1.RES.getRes('map_check_disable.png'));
                    this.checkLabel.strokeColor = '#a55507';
                    this.checkCurEffect.visible = true;
                    this.checkCurEffect.play();
                    break;
            }
        },
        enumerable: true,
        configurable: true
    });
    CheckBtn.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(), new Point());
        var bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp);
    };
    CheckBtn.prototype.initEffect = function () {
        var textures = [];
        for (var i = 0; i < 17; i++) {
            textures.push(RES_1.RES.getRes("prize_check_" + i + ".png"));
        }
        for (var i = 17; i < 60; i++) {
            textures.push(RES_1.RES.getRes('prize_check_0.png'));
        }
        this.prizeAnim = new FrameAni(textures);
        this.prizeAnim.play(-1);
        this.prizeAnim.position.set(54, 54);
    };
    CheckBtn.prototype.initUi = function (data) {
        this.btn = this.addChild(new Button(RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_disable.png')));
        var star1 = this.addChild(new CheckStar());
        star1.position.set(16.5, 83);
        var star2 = this.addChild(new CheckStar());
        star2.position.set(42.5, 90);
        var star3 = this.addChild(new CheckStar());
        star3.position.set(67.5, 83);
        this.star = [star1, star2, star3];
        this.checkNum = data.check;
        this.checkData.level = data.check;
        this.checkLabel = this.btn.addChild(Tools_1.Tools.getText(data.check, 30, '#ffffff', TEXT_ALIGN.CENTER, 90, 8, 33));
        this.checkLabel.stroke = 2;
        this.checkLabel.strokeColor = '#316ec6';
        this.checkCurEffect = this.addChild(new CheckCurEffect());
        this.checkCurEffect.visible = false;
        this.enabled = false;
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);
    };
    CheckBtn.prototype.clickStart = function () {
        console.log("\u5173\u5361:" + this.checkNum);
        console.log(this.checkData);
        this._isPrize
            ? ctrls_1.showPanel(StartPanelPrize_1.StartPanelPrize, this.checkData)
            : ctrls_1.showPanel(StartPanel_1.StartPanel, this.checkData);
    };
    return CheckBtn;
}(Container));
exports.default = CheckBtn;
var CheckStar = (function (_super) {
    __extends(CheckStar, _super);
    function CheckStar() {
        var _this = _super.call(this, RES_1.RES.getRes('map_star_disable.png')) || this;
        _this._enabled = false;
        CheckStar.starDisableTexture = RES_1.RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES_1.RES.getRes('map_star_enable.png');
        return _this;
    }
    Object.defineProperty(CheckStar.prototype, "enabled", {
        set: function (enabled) {
            this._enabled = enabled;
            this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
        },
        enumerable: true,
        configurable: true
    });
    CheckStar.starEnableTexture = null;
    CheckStar.starDisableTexture = null;
    return CheckStar;
}(Sprite));
var CheckCurEffect = (function (_super) {
    __extends(CheckCurEffect, _super);
    function CheckCurEffect() {
        var _this = _super.call(this) || this;
        _this.light1 = null;
        _this.light2 = null;
        _this.light1 = _this.addChild(Tools_1.Tools.getSprite('cur_light_1.png'));
        _this.light2 = _this.addChild(Tools_1.Tools.getSprite('cur_light_2.png'));
        _this.light1.anchorTexture.set(0.5, 0.5);
        _this.light2.anchorTexture.set(0.5, 0.5);
        _this.position.set(55, 50);
        _this.mouseEnable = _this.mouseChildren = false;
        return _this;
    }
    CheckCurEffect.prototype.play = function () {
        Tween.get(this.light1, { loop: true })
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1.5, scaleY: 1.5 }, 1300)
            .wait(700);
        Tween.get(this.light1, { loop: true })
            .set({ alpha: 1 })
            .wait(700)
            .to({ alpha: 0 }, 600)
            .wait(700);
        Tween.get(this.light2, { loop: true })
            .set({ scaleX: 0.8, scaleY: 0.8 })
            .to({ scaleX: 1.3, scaleY: 1.3 }, 1000)
            .wait(1000);
        Tween.get(this.light2, { loop: true })
            .set({ alpha: 0 })
            .to({ alpha: 1 }, 400)
            .to({ alpha: 0 }, 600)
            .wait(1000);
        return this;
    };
    CheckCurEffect.prototype.stop = function () {
        Tween.removeTweens(this.light1);
        Tween.removeTweens(this.light2);
        return this;
    };
    return CheckCurEffect;
}(Container));


/***/ }),

/***/ "./src/scene/map/MapBottom.ts":
/*!************************************!*\
  !*** ./src/scene/map/MapBottom.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var FrameAni = FYGE.FrameAni;
var MapBottom = (function (_super) {
    __extends(MapBottom, _super);
    function MapBottom(data) {
        var _this = _super.call(this, data) || this;
        _this.totalCount = 8;
        _this.crabAni = null;
        _this.btnPos = [
            [370, 930],
            [437, 761],
            [313, 669],
            [408, 522],
            [455, 375],
            [364, 216],
            [326, 62],
            [491, 3],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg1.jpg');
        _this.initIcon();
        _this.initEffect();
        return _this;
    }
    MapBottom.prototype.initEffect = function () {
        var crabTextures = new Array(31);
        for (var i = 0; i < 16; i++) {
            crabTextures[31 - i] = crabTextures[i] = RES_1.RES.getRes("map_crab_" + i + ".png");
        }
        this.crabAni = this.addChild(new FrameAni(crabTextures));
        this.crabAni.position.set(220, 50);
        this.crabAni.play(-1);
    };
    MapBottom.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    };
    MapBottom.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapBottom.HEIGHT = 1092;
    return MapBottom;
}(MapPart_1.default));
exports.default = MapBottom;


/***/ }),

/***/ "./src/scene/map/MapMid.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapMid.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var Sprite = FYGE.Sprite;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var Tween = FYGE.Tween;
var FrameAni = FYGE.FrameAni;
var MapMid = (function (_super) {
    __extends(MapMid, _super);
    function MapMid(data) {
        var _this = _super.call(this, data) || this;
        _this.totalCount = 10;
        _this.balloon = null;
        _this.water = null;
        _this.water1 = null;
        _this.water2 = null;
        _this.whaleAni = null;
        _this.owlAni = null;
        _this.btnPos = [
            [267, 1519],
            [211, 1325],
            [338, 1154],
            [237, 911],
            [145, 755],
            [225, 591],
            [349, 480],
            [214, 342],
            [193, 188],
            [392, 8],
        ];
        _this.waterIndex1 = true;
        _this.waterIndex = 0;
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg2.jpg');
        _this.water1 = RES_1.RES.getRes('water1.png');
        _this.water2 = RES_1.RES.getRes('water2.png');
        _this.initIcon();
        _this.initEffect();
        return _this;
    }
    MapMid.prototype.initEffect = function () {
        this.balloon = this.addChild(Tools_1.Tools.getSprite('map_狐狸气球.png', -216, 750));
        Tween.get(this.balloon, { loop: true })
            .set({ x: -216, y: 1170 })
            .to({ x: 750 + 100, y: 765 }, 20006);
        this.balloon.mouseEnable = this.balloon.mouseChildren = false;
        this.water = this.addChild(new Sprite(this.water1));
        this.water.position.set(544, 687);
        var whaleTextures = new Array(25);
        for (var i = 0; i < 13; i++) {
            whaleTextures[25 - i] = whaleTextures[i] = RES_1.RES.getRes("map_whale_" + i + ".png");
        }
        this.whaleAni = this.addChild(new FrameAni(whaleTextures));
        this.whaleAni.position.set(645, 575);
        this.whaleAni.play(-1);
        var owlTextures = new Array(31);
        for (var i = 0; i < 16; i++) {
            owlTextures[31 - i] = owlTextures[i] = RES_1.RES.getRes("map_owl_" + i + ".png");
        }
        this.owlAni = this.addChild(new FrameAni(owlTextures));
        this.owlAni.position.set(538, 1548);
        this.owlAni.play(-1);
    };
    MapMid.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
        if (this.waterIndex++ > 6) {
            this.waterIndex1 = !this.waterIndex1;
            this.water.texture = this.waterIndex1 ? this.water1 : this.water2;
            this.waterIndex = 0;
        }
    };
    MapMid.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapMid.HEIGHT = 1635;
    return MapMid;
}(MapPart_1.default));
exports.default = MapMid;


/***/ }),

/***/ "./src/scene/map/MapPart.ts":
/*!**********************************!*\
  !*** ./src/scene/map/MapPart.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Sprite = FYGE.Sprite;
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var MapScene_1 = __webpack_require__(/*! ./MapScene */ "./src/scene/map/MapScene.ts");
var Container = FYGE.Container;
var MapPart = (function (_super) {
    __extends(MapPart, _super);
    function MapPart(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.totalCount = 0;
        _this.btnPos = [];
        _this.bg = null;
        _this.bg = _this.addChild(new Sprite());
        _this.data = data;
        return _this;
    }
    MapPart.prototype.initIcon = function () {
        for (var i = this.data.length - 1; i >= 0; i--) {
            var value = this.data[i];
            var nBtn = this.addChild(new CheckBtn_1.default(value));
            nBtn.position.set(this.btnPos[i][0], this.btnPos[i][1]);
            MapScene_1.MapScene.checkArr[value.check] = nBtn;
        }
    };
    return MapPart;
}(Container));
exports.default = MapPart;


/***/ }),

/***/ "./src/scene/map/MapScene.ts":
/*!***********************************!*\
  !*** ./src/scene/map/MapScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var MapBottom_1 = __webpack_require__(/*! ./MapBottom */ "./src/scene/map/MapBottom.ts");
var MapTop_1 = __webpack_require__(/*! ./MapTop */ "./src/scene/map/MapTop.ts");
var MapUI_1 = __webpack_require__(/*! ./MapUI */ "./src/scene/map/MapUI.ts");
var MapMid_1 = __webpack_require__(/*! ./MapMid */ "./src/scene/map/MapMid.ts");
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ScrollPage = FYGE.ScrollPage;
var Container = FYGE.Container;
var Graphics = FYGE.Graphics;
var Sprite = FYGE.Sprite;
var Texture = FYGE.Texture;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var FreePowerPanel_1 = __webpack_require__(/*! ../../panels/FreePowerPanel */ "./src/panels/FreePowerPanel.ts");
var PrizePanel_1 = __webpack_require__(/*! ../../panels/PrizePanel */ "./src/panels/PrizePanel.ts");
var GTool_1 = __webpack_require__(/*! ../../../module/tools/GTool */ "./module/tools/GTool.ts");
var MapScene = (function (_super) {
    __extends(MapScene, _super);
    function MapScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.mapContainer = null;
        _this.scrollPage = null;
        _this.uiLayer = null;
        _this.mapAvatar = null;
        return _this;
    }
    MapScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(MapScene.prototype, "groupNames", {
        get: function () {
            return [
                'map',
                'mapCrabEffect',
                'mapOwlEffect',
                'mapWhaleEffect',
                'mapCheckPrizeEffect'
            ];
        },
        enumerable: true,
        configurable: true
    });
    MapScene.prototype.initUi = function () {
        _super.prototype.initUi.call(this);
        this.scrollPage = this.addChild(new ScrollPage(750, layers_1.layers.stageHeight, 888, true, true));
        this.mapContainer = this.scrollPage.view.addChild(new Container());
        this.initMap();
        this.updateMapCheck();
        if (Tools_1.Tools.gameData.loginAddPower && !Tools_1.Tools.gameData.isFristLogin) {
            ctrls_1.showPanel(FreePowerPanel_1.FreePowerPanel);
            Tools_1.Tools.gameData.loginAddPower = false;
        }
        var openPrize = GTool_1.GTool.readCache('openPrize');
        if (Tools_1.Tools.gameData.topAward && Tools_1.Tools.gameData.topAward.openPrizeStatus && openPrize !== 'true') {
            GTool_1.GTool.writeCache('openPrize', 'true');
            if (Tools_1.Tools.gameData.topAward.prize && Tools_1.Tools.gameData.topAward.prize._id) {
                ctrls_1.showPanel(PrizePanel_1.PrizePanel, JSON.parse(JSON.stringify(Tools_1.Tools.gameData.topAward.prize)));
            }
            else {
            }
            Tools_1.Tools.gameData.topAward = null;
        }
    };
    MapScene.prototype.updateMapCheck = function () {
        var _this = this;
        if (this.data && this.data.from == 'loading') {
            this.uiLayer = this.addChild(new MapUI_1.default());
            this.initMapByData(Tools_1.Tools.gameData);
            if (Tools_1.Tools.gameData.isFristLogin) {
                this.initGuide();
            }
        }
        else {
            Tools_1.Tools.getGameInfo().then(function (success) {
                if (success) {
                    _this.uiLayer = _this.addChild(new MapUI_1.default());
                    _this.initMapByData(Tools_1.Tools.gameData);
                }
            });
        }
    };
    MapScene.prototype.initGuide = function () {
        var guide = this.addChild(new Container());
        var g = guide.addChild(new Graphics());
        g.beginFill(0, 0.6);
        g.drawRect(0, 0, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        g.endFill();
        var guide_check = guide.addChild(new CheckBtn_1.default({ check: 1 }));
        guide_check.enabled = true;
        guide_check.type = CheckBtn_1.CHECK_TYPE.CUR;
        guide_check.position.set(MapScene.checkArr[1].x, layers_1.layers.stageHeight - 162);
        guide_check.addChild(new MapAvatar());
        var guide_hand = guide.addChild(Tools_1.Tools.getSprite('guide_hand.png'));
        guide_hand.position.set(guide_check.x + 90, guide_check.y + 40);
        guide_hand.mouseEnable = guide_hand.mouseChildren = false;
        var guide_light = guide.addChild(Tools_1.Tools.getSprite('guide_light.png'));
        guide_light.anchorTexture.set(0.5, 0.5);
        guide_light.position.set(guide_check.x + 95, guide_check.y + 45);
        guide_light.mouseEnable = guide_light.mouseChildren = false;
        var guide_fox = guide.addChild(Tools_1.Tools.getSprite('guide_fox.png'));
        guide_fox.position.set(45, guide_check.y - 200);
        guide_fox.alpha = 0;
        var guide_tip = guide.addChild(Tools_1.Tools.getSprite('guide_tip.png'));
        guide_tip.anchorTexture.set(0, 0.3);
        guide_tip.position.set(guide_fox.x + 215, guide_fox.y - 70);
        guide_tip.scale.set(0, 0);
        guide.alpha = 0;
        Tween.get(guide)
            .to({ alpha: 1 }, 600, Ease.quadInOut);
        Tween.get(guide_fox)
            .wait(300)
            .to({ y: guide_check.y - 345, alpha: 1 }, 300, Ease.quadInOut)
            .wait(100)
            .call(function () {
            Tween.get(guide_tip)
                .to({ scaleX: 1, scaleY: 1 }, 300, Ease.quadInOut);
        });
    };
    MapScene.prototype.initMapByData = function (data) {
        this.uiLayer.energyBox.count = data.power;
        var currentLevel = data.currentLevel;
        for (var i = 1; i < currentLevel; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = true;
        }
        if (currentLevel < 121 && currentLevel > 0) {
            MapScene.checkArr[currentLevel].type = CheckBtn_1.CHECK_TYPE.CUR;
            MapScene.checkArr[currentLevel].enabled = true;
            !this.mapAvatar && (this.mapAvatar = this.addChild(new MapAvatar()));
            this.mapAvatar.parent && this.mapAvatar.parent.removeChild(this.mapAvatar);
            MapScene.checkArr[currentLevel].addChild(this.mapAvatar);
        }
        for (var i = currentLevel + 1; i < 121; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = false;
        }
        data.visitors.forEach(function (v) {
            MapScene.checkArr[v.level].data = v;
        });
        Tools_1.Tools.baseInfo.prizeLevels.forEach(function (v) {
            MapScene.checkArr[v].isPrize = true;
        });
        if (this.data && this.data.level) {
            this.scrollToCheck(this.data.level);
            MapScene.checkArr[this.data.level].clickStart();
        }
        else {
            this.scrollToCheck(currentLevel);
        }
    };
    MapScene.prototype.initMap = function () {
        var arr = new Array(120);
        for (var i = 0; i < 120; i++) {
            arr[i] = {
                check: i + 1
            };
        }
        var topData = arr.splice(118, 2);
        var bottomData = arr.splice(0, 8);
        var midData = arr;
        var maxHeight = MapTop_1.default.HEIGHT;
        for (var i = midData.length / 10 - 1; i >= 0; i--) {
            var data = midData.splice(i * 10, 10);
            var nMid = new MapMid_1.default(data);
            this.mapContainer.addChild(nMid);
            nMid.y = maxHeight;
            maxHeight += MapMid_1.default.HEIGHT;
        }
        var bottom = new MapBottom_1.default(bottomData);
        this.mapContainer.addChild(bottom);
        bottom.y = maxHeight;
        maxHeight += MapBottom_1.default.HEIGHT;
        this.mapContainer.addChild(new MapTop_1.default(topData));
        this.scrollPage.maxDistance = maxHeight;
        this.scrollPage.scrollTo(maxHeight, 0);
        this.scrollToCheck(1);
    };
    MapScene.prototype.scrollToCheck = function (checkNum, time) {
        if (time === void 0) { time = 0; }
        if (checkNum < 1) {
            checkNum = 1;
        }
        else if (checkNum > 120) {
            checkNum = 120;
        }
        var check = MapScene.checkArr[checkNum];
        var checkY = check.y + check.parent.y - layers_1.layers.stageHeight / 2 + 50;
        this.scrollPage.scrollTo(checkY, time);
    };
    MapScene.prototype.updateScene = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                _super.prototype.updateScene.call(this);
                this.uiLayer.updateUI();
                return [2];
            });
        });
    };
    MapScene.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
    };
    MapScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    MapScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    MapScene.checkArr = [];
    return MapScene;
}(Scene_1.Scene));
exports.MapScene = MapScene;
var MapAvatar = (function (_super) {
    __extends(MapAvatar, _super);
    function MapAvatar() {
        var _this = _super.call(this) || this;
        _this.avatarImg = null;
        _this.addChild(Tools_1.Tools.getSprite('map_avatar_bg.png'))
            .anchorTexture.set(0.5, 1);
        _this.position.set(54, 28);
        _this.mouseChildren = _this.mouseEnable = false;
        var mask = _this.addChild(new Graphics());
        mask.drawCircle(0, -58, 38);
        _this.avatarImg = _this.addChild(new Sprite(Texture.fromUrl(Tools_1.Tools.globalData.avatar)));
        _this.avatarImg.width = _this.avatarImg.height = 76;
        _this.avatarImg.position.set(-38, -96);
        _this.avatarImg.mask = mask;
        return _this;
    }
    return MapAvatar;
}(Container));
exports.MapAvatar = MapAvatar;


/***/ }),

/***/ "./src/scene/map/MapTop.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapTop.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var MapTop = (function (_super) {
    __extends(MapTop, _super);
    function MapTop(data) {
        var _this = _super.call(this, data) || this;
        _this.totalCount = 2;
        _this.btnPos = [
            [207, 418],
            [149, 282],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg3.jpg');
        _this.initIcon();
        return _this;
    }
    MapTop.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapTop.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    };
    MapTop.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapTop.HEIGHT = 521;
    return MapTop;
}(MapPart_1.default));
exports.default = MapTop;


/***/ }),

/***/ "./src/scene/map/MapUI.ts":
/*!********************************!*\
  !*** ./src/scene/map/MapUI.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Container = FYGE.Container;
var Button = FYGE.Button;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var RulePanel_1 = __webpack_require__(/*! ../../panels/RulePanel */ "./src/panels/RulePanel.ts");
var BuyPowerPanel_1 = __webpack_require__(/*! ../../panels/BuyPowerPanel */ "./src/panels/BuyPowerPanel.ts");
var TaskPanel_1 = __webpack_require__(/*! ../../panels/TaskPanel */ "./src/panels/TaskPanel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Texture = FYGE.Texture;
var LotteryScene_1 = __webpack_require__(/*! ../LotteryScene */ "./src/scene/LotteryScene.ts");
var Main_1 = __webpack_require__(/*! ../../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../../common/G_EVENT */ "./src/common/G_EVENT.ts");
var Tween = FYGE.Tween;
var MapUI = (function (_super) {
    __extends(MapUI, _super);
    function MapUI() {
        var _this = _super.call(this) || this;
        _this.energyBox = null;
        _this.creditsBox = null;
        _this.prizeBox = null;
        _this.myPrizeBtn = null;
        _this.ruleBtn = null;
        _this.taskBtn = null;
        _this.initUi();
        _this.initEvent();
        return _this;
    }
    MapUI.prototype.initEvent = function () {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.prizeBox.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.removeEvent = function () {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.prizeBox.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.clickBtn = function (e) {
        switch (e.target) {
            case this.ruleBtn:
                console.log('规则');
                ctrls_1.showPanel(RulePanel_1.RulePanel);
                break;
            case this.myPrizeBtn:
                console.log('我的奖品');
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, { url: '/pages/myPrize/myPrize' }, function () {
                }, true);
                break;
            case this.prizeBox:
                console.log('奖励盒子');
                break;
            case this.taskBtn:
                console.log('任务');
                ctrls_1.showPanel(TaskPanel_1.TaskPanel);
                break;
        }
    };
    MapUI.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.removeEvent();
    };
    MapUI.prototype.initUi = function () {
        this.myPrizeBtn = this.addChild(new Button(RES_1.RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(0, 185);
        this.myPrizeBtn.anchorX = 0;
        this.ruleBtn = this.addChild(new Button(RES_1.RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(0, 104);
        this.ruleBtn.anchorX = 0;
        this.taskBtn = this.addChild(new Button(RES_1.RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(19, 280);
        this.energyBox = this.addChild(new EnergyBox({}));
        this.creditsBox = this.addChild(new CreditsBox({}));
        this.prizeBox = this.addChild(new PrizeBox({}));
    };
    MapUI.prototype.updateUI = function () {
        this.creditsBox.updateCredits();
        this.energyBox.count = Tools_1.Tools.gameData.power;
    };
    return MapUI;
}(Container));
exports.default = MapUI;
var EnergyBox = (function (_super) {
    __extends(EnergyBox, _super);
    function EnergyBox(data) {
        var _this = _super.call(this) || this;
        _this.addBtn = null;
        _this.countLabel = null;
        _this._count = 0;
        _this.initUi(data);
        _this.addBtn.addEventListener(MouseEvent.CLICK, _this.clickAdd, _this);
        return _this;
    }
    Object.defineProperty(EnergyBox.prototype, "count", {
        set: function (count) {
            this._count = count;
            this.countLabel.text = '' + count;
        },
        enumerable: true,
        configurable: true
    });
    EnergyBox.prototype.clickAdd = function () {
        console.log('增加按钮');
        ctrls_1.showPanel(BuyPowerPanel_1.BuyPowerPanel);
    };
    EnergyBox.prototype.initUi = function (data) {
        this.position.set(544, 105);
        this.addChild(Tools_1.Tools.getSprite('map_energyBg.png'));
        this.addBtn = this.addChild(new Button(RES_1.RES.getRes('map_energyAdd.png')));
        this.addBtn.position.set(135, 14);
        this.countLabel = this.addChild(Tools_1.Tools.getText('0', 20, '#ffffff', TEXT_ALIGN.CENTER, 80, 54, 21));
    };
    EnergyBox.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.addBtn.removeEventListener(MouseEvent.CLICK, this.clickAdd, this);
    };
    return EnergyBox;
}(Container));
var CreditsBox = (function (_super) {
    __extends(CreditsBox, _super);
    function CreditsBox(data) {
        var _this = _super.call(this) || this;
        _this.countLabel = null;
        _this._count = 0;
        _this.initUi(data);
        return _this;
    }
    Object.defineProperty(CreditsBox.prototype, "count", {
        set: function (count) {
            this._count = count;
            this.countLabel.text = "\u79EF\u5206:" + count;
        },
        enumerable: true,
        configurable: true
    });
    CreditsBox.prototype.initUi = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.position.set(544, 184);
                        this.addChild(Tools_1.Tools.getSprite('map_creditsBg.png'));
                        this.countLabel = this.addChild(Tools_1.Tools.getText('积分:0', 20, '#ffffff', TEXT_ALIGN.CENTER, 105, 58, 21));
                        return [4, this.updateCredits()];
                    case 1:
                        _a.sent();
                        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateCredits, this);
                        return [2];
                }
            });
        });
    };
    CreditsBox.prototype.updateCredits = function () {
        return __awaiter(this, void 0, void 0, function () {
            var creditsData, jfLabel;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.queryCredits, {}, function () {
                        }, true)];
                    case 1:
                        creditsData = _a.sent();
                        jfLabel = '积分:0';
                        if (creditsData.success && creditsData.data && creditsData.data.credits) {
                            jfLabel = "\u79EF\u5206:" + creditsData.data.credits;
                        }
                        this.countLabel.text = jfLabel;
                        return [2];
                }
            });
        });
    };
    CreditsBox.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateCredits, this);
    };
    return CreditsBox;
}(Container));
var PrizeBox = (function (_super) {
    __extends(PrizeBox, _super);
    function PrizeBox(data) {
        var _this = _super.call(this, RES_1.RES.getRes('map_prizeBox.png')) || this;
        _this.checkTip = null;
        _this.tip = null;
        _this.prizeImg = null;
        _this.initUi(data);
        _this.initEvent();
        return _this;
    }
    PrizeBox.prototype.initButton = function () {
        var s = this;
        s.mouseChildren = false;
        s.addEventListener("onMouseDown", s._mouseEvent, s);
        s.addEventListener("onMouseUp", s._mouseEvent, s);
        s.addEventListener("onMouseOut", s._mouseEvent, s);
        s.texture = s.textureUp;
    };
    PrizeBox.prototype._mouseEvent = function (e) {
        var s = this;
        if (!s._clicked) {
            if (e.type == MouseEvent.MOUSE_DOWN) {
                if (s.textureDown) {
                    s.texture = s.textureDown;
                }
                else {
                    this["frames"] = null;
                    Tween.removeTweens(this);
                    Tween.get(this).to({ scaleX: 1, scaleY: 1 }, 50);
                }
            }
            else {
                if (s.textureDown) {
                    s.texture = s.textureUp;
                }
                else {
                    this["frames"] = this["framesOri"];
                    Tween.removeTweens(this);
                    Tween.get(this).to({ scaleX: 1.2, scaleY: 1.2 }, 50);
                }
            }
        }
    };
    ;
    PrizeBox.prototype.initUi = function (data) {
        var _this = this;
        this.position.set(553, 289);
        this.scale.set(1.2, 1.2);
        this.checkTip = this.addChild(Tools_1.Tools.getText('再闯XXX关', 18, '#ffffff', TEXT_ALIGN.CENTER, 158, 0, 68));
        this.tip = this.addChild(Tools_1.Tools.getText('参与红包抽奖\n赢XXX优惠券', 17, '#ec5a5a', TEXT_ALIGN.CENTER, 158, 0, 116));
        this.tip.lineSpacing = 0;
        this.prizeImg = this.addChild(Tools_1.Tools.getSprite('map_star_enable.png', 39, 150));
        this.prizeImg.y -= 40;
        this.prizeImg.width = 204;
        this.prizeImg.height = 80;
        this.prizeImg.x = (this.width - 98) / 2 - 70;
        var prizes = Tools_1.Tools.gameData.prizes;
        if (prizes.length <= 0) {
            var curLevel_1 = Tools_1.Tools.gameData.currentLevel;
            var upLevel_1 = 120;
            var dLevel_1 = 120;
            Tools_1.Tools.baseInfo.prizeLevels.forEach(function (value, index) {
                var d = value - curLevel_1;
                if (curLevel_1 <= value && d >= 0 && d <= dLevel_1) {
                    upLevel_1 = value;
                    dLevel_1 = d + 1;
                }
            });
            console.log(upLevel_1, dLevel_1);
            this.checkTip.text = "\u518D\u95EF" + dLevel_1 + "\u5173\u53EF\u62BD";
            this.tip.text = '';
            this.prizeImg.texture = Texture.fromUrl(Tools_1.Tools.baseInfo.levelPrize["level_" + upLevel_1]);
            this.addEventListener(FYGE.MouseEvent.CLICK, function () {
                Tools_1.Tools.btnDelay(_this);
                ctrls_1.showToast("\u518D\u95EF" + dLevel_1 + "\u5173\u624D\u53EF\u4EE5\u62BD\u5956\u54E6");
            }, this);
        }
        else if (prizes.length == 1 && +prizes[0].level == 120) {
            var index_1 = TaoBaoNet_1.getTbData(TaoBaoNet_1.TbNetName.getIndex).data;
            this.checkTip.text = index_1.topAward.openPrizeStatus
                ? '已开奖' : '8月31日9点开奖';
            this.checkTip.size = 18;
            this.tip.text = "";
            this.prizeImg.texture = Texture.fromUrl(Tools_1.Tools.baseInfo.levelPrize['level_120']);
            this.addEventListener(FYGE.MouseEvent.CLICK, function () {
                Tools_1.Tools.btnDelay(_this);
                ctrls_1.showToast(index_1.topAward.openPrizeStatus
                    ? '已开奖' : '8月31日9点开奖');
            }, this);
        }
        else {
            var lowerLevel_1 = 120;
            prizes.forEach(function (value) {
                if (value.level < lowerLevel_1) {
                    lowerLevel_1 = value.level;
                }
            });
            this.checkTip.text = "\u70B9\u51FB\u62BD\u5956";
            this.tip.text = "";
            this.prizeImg.texture = Texture.fromUrl(Tools_1.Tools.baseInfo.levelPrize["level_" + lowerLevel_1]);
            this.addEventListener(FYGE.MouseEvent.CLICK, function () {
                Tools_1.Tools.btnDelay(_this);
                ctrls_1.changeScene(LotteryScene_1.LotteryScene, { level: lowerLevel_1 });
            }, this);
        }
    };
    PrizeBox.prototype.initEvent = function () {
    };
    return PrizeBox;
}(Button));


/***/ }),

/***/ "./src/something/Pool.ts":
/*!*******************************!*\
  !*** ./src/something/Pool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool = (function () {
    function Pool() {
    }
    Pool.takeOut = function (name) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return null;
    };
    Pool.recover = function (name, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    };
    Pool.pool = {};
    return Pool;
}());
exports.Pool = Pool;


/***/ }),

/***/ "./src/something/Tool.ts":
/*!*******************************!*\
  !*** ./src/something/Tool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Element_1 = __webpack_require__(/*! ./class/Element */ "./src/something/class/Element.ts");
var ElementType_1 = __webpack_require__(/*! ./enum/ElementType */ "./src/something/enum/ElementType.ts");
var EffectType_1 = __webpack_require__(/*! ./enum/EffectType */ "./src/something/enum/EffectType.ts");
var Pool_1 = __webpack_require__(/*! ./Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ./enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RectMask_1 = __webpack_require__(/*! ./class/RectMask */ "./src/something/class/RectMask.ts");
var FallAniData_1 = __webpack_require__(/*! ./interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var StateType_1 = __webpack_require__(/*! ./enum/StateType */ "./src/something/enum/StateType.ts");
var offsetYTwo = [];
var gameAreaHeightTwo = [];
function initClientScale() {
    var sysInfo;
    if (my)
        sysInfo = my.getSystemInfoSync();
    var stageHeight = sysInfo ? sysInfo.windowHeight / sysInfo.windowWidth * 750 :
        document.body.clientHeight / document.body.clientWidth * 750;
    var middleHeight = 80 * 9;
    var topHeight = 238;
    var botHeight = 140 + 20;
    var smallestHeight = topHeight + middleHeight + botHeight;
    if (stageHeight < smallestHeight) {
        offsetYTwo[0] = topHeight;
        offsetYTwo[1] = topHeight;
        gameAreaHeightTwo[0] = middleHeight;
        gameAreaHeightTwo[1] = middleHeight + 45;
    }
    else {
        offsetYTwo[0] = topHeight + (stageHeight - smallestHeight) / 2;
        offsetYTwo[1] = topHeight + (stageHeight - smallestHeight - 45) / 2;
        gameAreaHeightTwo[0] = stageHeight - topHeight - botHeight;
        ;
        gameAreaHeightTwo[1] = stageHeight - topHeight - botHeight;
    }
}
var Tool = (function () {
    function Tool() {
    }
    Tool.init = function (isTwo, hasLollipop) {
        if (isTwo === void 0) { isTwo = false; }
        if (hasLollipop === void 0) { hasLollipop = false; }
        if (!offsetYTwo.length)
            initClientScale();
        var ooox = isTwo ? 55 : 15;
        var oooy = hasLollipop ? offsetYTwo[1] : offsetYTwo[0];
        this.gameAreaHeight = hasLollipop ? gameAreaHeightTwo[1] : gameAreaHeightTwo[0];
        if (this.offsetX == ooox && this.offsetY == oooy)
            return;
        this.offsetX = ooox;
        this.offsetY = oooy;
        var spaceX = this.width, spaceY = this.height, offsetX = this.offsetX + this.width / 2, offsetY = this.offsetY + this.height / 2;
        for (var i = 0; i < this.rowNum; i++) {
            for (var j = 0; j < this.colNum; j++) {
                this.rcToIndexMap["" + i + j] = i * this.colNum + j;
                this.indexToRcMap[i * this.colNum + j] = [i, j];
                this.rowColPositions["" + i + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
                this.indexPositions[i * this.colNum + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
            }
        }
        var rowNum = Tool.rowNum + 1;
        var colNum = Tool.colNum + 1;
        var offsetX = Tool.offsetX;
        var offsetY = Tool.offsetY;
        for (var i = 0; i < rowNum; i++) {
            for (var j = 0; j < colNum; j++) {
                this.indexToRcMap10[i * colNum + j] = [i, j];
                this.indexPositions10[i * colNum + j] = [offsetX + j * Tool.width, offsetY + i * Tool.height];
            }
        }
    };
    Tool.rcToIndex = function (row, col) {
        var key = "" + row + col;
        return this.rcToIndexMap[key];
    };
    Tool.indexToRc = function (index) {
        return this.indexToRcMap[index];
    };
    Tool.getPositionByRc = function (row, col) {
        var key = "" + row + col;
        return this.rowColPositions[key];
    };
    Tool.getPositionByIndex = function (index) {
        return this.indexPositions[index];
    };
    Tool.indexToRc10 = function (index) {
        return this.indexToRcMap10[index];
    };
    Tool.getPositionByIndex10 = function (index) {
        return this.indexPositions10[index];
    };
    Tool.getColOddEven = function (lattices) {
        var left = 0;
        for (var i = 0; i < Tool.colNum; i++) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                left++;
            }
        }
        var right = 0;
        for (var i = Tool.colNum - 1; i >= 0; i--) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                right++;
            }
        }
        return (left + right) % 2 != 0;
    };
    Tool.checkNeb = function (a, b) {
        if (Math.abs(a.row - b.row) == 1 && Math.abs(a.column - b.column) == 0) {
            return true;
        }
        else if (Math.abs(a.row - b.row) == 0 && Math.abs(a.column - b.column) == 1) {
            return true;
        }
        return false;
    };
    Tool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    Tool.insertEX = function (num, arr) {
        for (var i = 0; i < arr.length; i++) {
            if (num > arr[i]) {
                arr.splice(i, 0, num);
                return;
            }
        }
        arr.push(num);
    };
    Tool.judgeFall = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.ROCK ||
            lat.element.hasState(StateType_1.StateType.LOCK) ||
            lat.element.type == ElementType_1.ElementType.JELLY ||
            lat.element.type == ElementType_1.ElementType.CHICKEN_EGG ||
            lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeMove = function (lat) {
        if (this.judgeFall(lat) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN) &&
            lat.element.type != ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return true;
        }
        return false;
    };
    Tool.judgeMatch = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeEliminate = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.LOLLIPOP ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeBaseEle = function (lat) {
        if (lat &&
            lat.element &&
            ElementType_1.FiveBaseElementTypes.indexOf(lat.element.type) >= 0) {
            return true;
        }
        return false;
    };
    Tool.judgeUpsetMove = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.LOCK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetFesEle = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetChicken = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            lat.element.type !== ElementType_1.ElementType.CHICKEN &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeMagicEliminate = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION) {
            return true;
        }
        return false;
    };
    Tool.judgeAiActionDirection = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeChosen = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN) ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return false;
        }
        return true;
    };
    Tool.judgeHasScore = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.LOLLIPOP ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.judgeMagicRotate = function (ele) {
        if (!ele ||
            ele.effectType != null ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.getExplosiveIndexes = function (curLat, lats) {
        var arr = [];
        Tool.ExplosiveMatchArr.forEach(function (e) {
            var col = curLat.column + e[0];
            var row = curLat.row + e[1];
            var index = Tool.rcToIndex(row, col);
            if (Tool.judgeEliminate(lats[index]))
                arr.push(index);
        });
        return arr;
    };
    Tool.dieMapCheck = function (lattices) {
        var judgeMatch = Tool.judgeMatch;
        var effectElements = [];
        var lat2, lat3;
        for (var i = Tool.colNum * Tool.rowNum - 1; i >= 0; i--) {
            var rc = Tool.indexToRc(i);
            var row = rc[0];
            var col = rc[1];
            var lat = lattices[i];
            if (!this.judgeMove(lat))
                continue;
            if (lat.element.effectType != null) {
                effectElements.push(lat.element);
            }
            var latDown = lattices[i + Tool.colNum];
            if (this.judgeMove(latDown) && lat.element.type != latDown.element.type) {
                lat2 = lattices[i + Tool.colNum * 2];
                lat3 = lattices[i + Tool.colNum * 3];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    lat.element.type == lat2.element.type &&
                    lat.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                lat2 = lattices[i - Tool.colNum];
                lat3 = lattices[i - Tool.colNum * 2];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    latDown.element.type == lat2.element.type &&
                    latDown.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                if (col > 1) {
                    lat2 = lattices[i + Tool.colNum - 1];
                    lat3 = lattices[i + Tool.colNum - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 1) {
                    lat2 = lattices[i - 1];
                    lat3 = lattices[i - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
            }
            if (col != Tool.colNum - 1) {
                var latRight = lattices[i + 1];
                if (this.judgeMove(latRight) && lat.element.type != latRight.element.type) {
                    if (col < Tool.colNum - 3) {
                        lat2 = lattices[i + 2];
                        lat3 = lattices[i + 3];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            lat.element.type == lat2.element.type &&
                            lat.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    if (col > 1) {
                        lat2 = lattices[i - 1];
                        lat3 = lattices[i - 2];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            latRight.element.type == lat2.element.type &&
                            latRight.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    lat2 = lattices[i + Tool.colNum * 1 + 1];
                    lat3 = lattices[i + Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1 + 1];
                    lat3 = lattices[i - Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i - Tool.colNum + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum * 1];
                    lat3 = lattices[i + Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1];
                    lat3 = lattices[i - Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum];
                    lat3 = lattices[i - Tool.colNum];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                }
            }
        }
        for (var i = 0; i < effectElements.length; i++) {
            var effectElement = effectElements[i];
            if (effectElement.effectType == EffectType_1.EffectType.MAGICLION) {
                var up = lattices[effectElement.index - Tool.colNum];
                if (this.judgeMove(up) && up.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, up.element];
                var down = lattices[effectElement.index + Tool.colNum];
                if (this.judgeMove(down) && down.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, down.element];
                var col = Tool.indexToRc(effectElement.index)[1];
                if (col != 0) {
                    var left = lattices[effectElement.index - 1];
                    if (this.judgeMove(left) && left.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, left.element];
                }
                if (col != Tool.colNum - 1) {
                    var right = lattices[effectElement.index + 1];
                    if (this.judgeMove(right) && right.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, right.element];
                }
                continue;
            }
            var up = lattices[effectElement.index - Tool.colNum];
            if (this.judgeMove(up) && up.element.effectType != null)
                return [effectElement, up.element];
            var down = lattices[effectElement.index + Tool.colNum];
            if (this.judgeMove(down) && down.element.effectType != null)
                return [effectElement, down.element];
            var col = Tool.indexToRc(effectElement.index)[1];
            if (col != 0) {
                var left = lattices[effectElement.index - 1];
                if (this.judgeMove(left) && left.element.effectType != null)
                    return [effectElement, left.element];
            }
            if (col != Tool.colNum) {
                var right = lattices[effectElement.index + 1];
                if (this.judgeMove(right) && right.element.effectType != null)
                    return [effectElement, right.element];
            }
        }
        return null;
    };
    Tool.alreadyDie = function (lattices) {
        var arr = {};
        var hasEffect = false;
        var effectCount = 0;
        var hasTwo = false;
        var hasThree = false;
        for (var i = 0; i < lattices.length; i++) {
            if (this.judgeBaseEle(lattices[i]) &&
                !lattices[i].element.hasState(StateType_1.StateType.LOCK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var type = lattices[i].element.type;
                if (!arr[type])
                    arr[type] = 0;
                arr[type]++;
                var ele = lattices[i].element;
                if (ele.effectType == EffectType_1.EffectType.MAGICLION) {
                    hasEffect = true;
                }
                if (ele.effectType != null) {
                    effectCount++;
                    if (effectCount >= 2) {
                        hasEffect = true;
                    }
                }
                var rc = Tool.indexToRc(i);
                if (rc[1] < Tool.colNum - 1) {
                    var latRight1 = lattices[i + 1];
                    if (Tool.judgeMove(latRight1) && latRight1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                        hasTwo = true;
                    }
                    if (rc[1] < Tool.colNum - 2) {
                        var latRight2 = lattices[i + 2];
                        if (Tool.judgeMove(latRight1) &&
                            latRight1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                            Tool.judgeMove(latRight2) &&
                            latRight2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                            hasThree = true;
                        }
                    }
                }
                var latDown1 = lattices[i + Tool.colNum];
                if (Tool.judgeMove(latDown1) && latDown1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasTwo = true;
                }
                if (hasTwo && hasEffect)
                    return false;
                var latDown2 = lattices[i + Tool.colNum * 2];
                if (Tool.judgeMove(latDown1) &&
                    latDown1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                    Tool.judgeMove(latDown2) &&
                    latDown2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasThree = true;
                }
                if (hasThree) {
                    for (var a in arr) {
                        if (arr[a] >= 3) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    };
    Tool.fn = function (arr, lattices) {
        var result = [], i = 0;
        result[i] = [arr[0]];
        arr.reduce(function (prev, cur) {
            var latP = lattices[prev];
            var latC = lattices[cur];
            if (Tool.judgeMatch(latP) &&
                Tool.judgeMatch(latC) &&
                latP.element.type == latC.element.type) {
                result[i].push(cur);
            }
            else {
                result[++i] = [cur];
            }
            return cur;
        });
        return result;
    };
    Tool.returnType = function (index, lattices, baseElementTypes) {
        var rc = Tool.indexToRc(index);
        var arr = baseElementTypes.slice();
        if (rc[1] > 1) {
            var lat1 = lattices[index - 1];
            var lat2 = lattices[index - 2];
            if (Tool.judgeMatch(lat1) &&
                Tool.judgeMatch(lat2) &&
                lat1.element.type == lat2.element.type) {
                Tool.removeEle(lat1.element.type, arr);
            }
        }
        var lat1 = lattices[index - Tool.colNum];
        var lat2 = lattices[index - Tool.colNum * 2];
        if (Tool.judgeMatch(lat1) &&
            Tool.judgeMatch(lat2) &&
            lat1.element.type == lat2.element.type) {
            Tool.removeEle(lat1.element.type, arr);
        }
        return Tool.randomT(arr);
    };
    Tool.setGenerateLats = function (lattices, generateLats) {
        var arr = [];
        for (var i = 0; i < generateLats.length; i++) {
            var generateLat = generateLats[i];
            generateLat.cus = generateLat.cus || [];
            var index = generateLat.index;
            if (!lattices[index])
                continue;
            lattices[index].isGenerate = true;
            var rc = this.indexToRc(index);
            var col = rc[1];
            if (!arr[col])
                arr[col] = [];
            arr[col].push({
                index: generateLat.index,
                type: generateLat.type || [],
                cus: generateLat.cus.slice(),
            });
        }
        for (var j = 0; j < arr.length; j++) {
            if (arr[j])
                arr[j].sort(function (a, b) { return a.index > b.index ? 1 : -1; });
        }
        return arr;
    };
    Tool.setNumber01 = function (nums) {
        var arr = [];
        for (var i = 0; i < nums.length; i++) {
            if (nums[i]) {
                arr[i] = 1;
            }
            else {
                arr[i] = 0;
            }
        }
        return arr;
    };
    Tool.findBottom = function (lattice, emptys, lattices) {
        var indexDown, lat;
        var connects = [];
        var isThrough = false;
        if (lattice.down != null) {
            indexDown = lattice.down;
            isThrough = true;
        }
        else {
            indexDown = lattice.index + this.colNum;
        }
        var lastEmptyIndex;
        var emptyIndex = emptys.indexOf(indexDown);
        while (emptyIndex > -1) {
            if (isThrough)
                connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
            lastEmptyIndex = emptyIndex;
            lat = lattices[indexDown];
            if (lat.down != null) {
                if (!isThrough)
                    connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                isThrough = true;
                indexDown = lat.down;
            }
            else {
                isThrough = false;
                indexDown = lat.index + this.colNum;
            }
            emptyIndex = emptys.indexOf(indexDown);
        }
        if (lastEmptyIndex != undefined) {
            if (isThrough) {
                return connects;
            }
            else {
                connects.push({ index: emptys[lastEmptyIndex], type: FallAniData_1.FallType.STRIGHT });
                return connects;
            }
        }
        else {
            return null;
        }
    };
    Tool.judgeOutOne = function (emptys, lattices) {
        for (var m = 0; m < Tool.colNum; m++) {
            for (var n = Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool.rcToIndex(n, m);
                var lat = lattices[index];
                if (Tool.judgeFall(lat)) {
                    var indexs = Tool.findBottom(lat, emptys, lattices);
                    if (indexs != null) {
                        if (indexs.length > 1) {
                            return true;
                        }
                        else {
                            var downIndex = indexs[0].index;
                            var type = indexs[0].type;
                            if (type == FallAniData_1.FallType.STRIGHT && (downIndex - index) / Tool.colNum > 1) {
                                return true;
                            }
                        }
                    }
                }
                else {
                    if (lat && !lat.element && lat.isGenerate) {
                        var arr = [];
                        var downIndex = index;
                        while (emptys.indexOf(downIndex) > -1) {
                            arr.push(downIndex);
                            if (lat.down != null) {
                                downIndex = lat.down;
                            }
                            else {
                                downIndex = lat.index + this.colNum;
                            }
                            lat = lattices[downIndex];
                        }
                        if (arr.length > 1)
                            return true;
                    }
                }
            }
        }
        return false;
    };
    Tool.praseEleNumber = function (num) {
        var arr = this.returnTO(num);
        var baseType = arr[1] ? arr[1] - 1 : null;
        if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1)
            baseType = null;
        var effectType = arr[0] ? arr[0] - 1 : null;
        return [baseType, effectType];
    };
    Tool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    Tool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    Tool.removeReapty = function (arr) {
        var obj = {};
        for (var i = arr.length - 1; i >= 0; i--) {
            if (obj[arr[i]]) {
                arr.splice(i, 1);
            }
            else {
                obj[arr[i]] = true;
            }
        }
    };
    Tool.getElement = function (type) {
        var obj = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ELEMENT);
        if (!obj) {
            obj = new Element_1.Element(type);
        }
        else {
            obj.reset(type);
        }
        return obj;
    };
    Tool.getRectMask = function () {
        var rect = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.RECT_MASK);
        if (!rect)
            rect = new RectMask_1.RectMask();
        return rect;
    };
    Tool.returnTO = function (num) {
        var length = num.toString().length;
        var arr = [];
        var a;
        for (var i = 0; i < length; i++) {
            a = (num % Math.pow(10, i + 1)) / Math.pow(10, i);
            arr.push(parseInt(a));
        }
        return arr;
    };
    Tool.getForwardRotation = function (fromPoint, toPoint) {
        var deltaX = toPoint[0] - fromPoint[0];
        var deltaY = toPoint[1] - fromPoint[1];
        var vec1 = [1, 0];
        var vec2 = [deltaX, deltaY];
        var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
        var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
        var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
        var cos = ab / (a * b);
        var r = Math.acos(cos);
        if (deltaY < 0) {
            r = Math.PI * 2 - r;
        }
        return r;
    };
    Tool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    Tool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    Tool.latDeltaTime = 90;
    Tool.rowNum = 9;
    Tool.colNum = 9;
    Tool.width = 80;
    Tool.height = 80;
    Tool.radius = 10;
    Tool.rcToIndexMap = {};
    Tool.indexToRcMap = [];
    Tool.rowColPositions = {};
    Tool.indexPositions = [];
    Tool.indexToRcMap10 = [];
    Tool.indexPositions10 = [];
    Tool.ExplosiveMatchArr = [
        [-1, -1], [0, -1], [1, -1],
        [-1, 0], [1, 0],
        [-1, 1], [0, 1], [1, 1],
    ];
    return Tool;
}());
exports.Tool = Tool;


/***/ }),

/***/ "./src/something/anis/BonusShootAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/BonusShootAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
exports.stepPosition = [375, 60];
var BonusShootAni = (function (_super) {
    __extends(BonusShootAni, _super);
    function BonusShootAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("bonusShoot.png");
        _this.shoot = new FYGE.Sprite(texture);
        _this.shoot.anchorTexture.set(78 / 95, 0.5);
        _this.addChild(_this.shoot);
        var arr = [];
        for (var i = 0; i <= 11; i++)
            arr.push(RES_1.RES.getRes("bonusFra" + i + ".png"));
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.addChild(_this.imageAni);
        _this.imageAni.visible = false;
        return _this;
    }
    BonusShootAni.prototype.reset = function () {
        this.shoot.visible = true;
        this.imageAni.visible = false;
        this.x = exports.stepPosition[0];
        this.y = exports.stepPosition[1];
    };
    BonusShootAni.prototype.play = function (p, callback) {
        var _this = this;
        this.reset();
        this.shoot.rotation = Tool_1.Tool.getForwardRotation(exports.stepPosition, p) * 180 / Math.PI;
        FYGE.Tween.get(this)
            .to({ x: p[0], y: p[1] }, 300)
            .call(function () {
            callback();
            _this.shoot.visible = false;
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.BONUSSHOOT_ANI, _this);
            });
        });
    };
    return BonusShootAni;
}(FYGE.Container));
exports.BonusShootAni = BonusShootAni;


/***/ }),

/***/ "./src/something/anis/BoomAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/BoomAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var BoomAni = (function (_super) {
    __extends(BoomAni, _super);
    function BoomAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.BOOM_ANI;
        var arr = [];
        for (var i = 0; i <= 20; i++) {
            arr.push(RES_1.RES.getRes("boom" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    BoomAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return BoomAni;
}(Ani_1.Ani));
exports.BoomAni = BoomAni;


/***/ }),

/***/ "./src/something/anis/BubbleAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/BubbleAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var baseEleWidth = 80;
var baseEleHeight = 80;
var time = 300;
var BubbleAni = (function (_super) {
    __extends(BubbleAni, _super);
    function BubbleAni() {
        var _this = _super.call(this) || this;
        _this.eleFrom = new FYGE.Sprite();
        _this.eleFrom.x = -baseEleWidth / 2;
        _this.eleFrom.y = -baseEleHeight / 2;
        _this.eleFrom.visible = false;
        _this.addChild(_this.eleFrom);
        _this.eleTarget = new FYGE.Sprite();
        _this.eleTarget.x = -baseEleWidth / 2;
        _this.eleTarget.y = -baseEleHeight / 2;
        _this.eleTarget.visible = false;
        _this.addChild(_this.eleTarget);
        var arr = [];
        for (var i = 1; i <= 19; i++) {
            arr.push(RES_1.RES.getRes("bubbleStar" + i + ".png"));
        }
        _this.bubbleAni = new FYGE.FrameAni(arr);
        _this.bubbleAni.visible = false;
        _this.addChild(_this.bubbleAni);
        return _this;
    }
    BubbleAni.prototype.play = function (fromType, targetType, callback) {
        var _this = this;
        this.eleFrom.texture = RES_1.RES.getRes("bubleEle" + fromType + ".png");
        this.eleFrom.visible = true;
        this.eleFrom.alpha = 1;
        this.eleTarget.texture = RES_1.RES.getRes("bubleEle" + targetType + ".png");
        this.eleTarget.visible = true;
        this.eleTarget.alpha = 0;
        FYGE.Tween.get(this)
            .to({ scaleX: 0.96, scaleY: 1.02 }, 100)
            .to({ scaleX: 1.02, scaleY: 0.98 }, 100)
            .to({ scaleX: 0.98, scaleY: 1.02 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100)
            .call(function () {
            _this.bubbleAni.visible = true;
            _this.bubbleAni.play(1, function () {
                _this.bubbleAni.visible = false;
            });
            FYGE.Tween.get(_this.eleTarget)
                .to({ alpha: 1 }, 600)
                .call(function () {
                FYGE.Tween.get(_this.eleFrom)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    if (_this.parent) {
                        _this.parent.removeChild(_this);
                    }
                    ;
                    Pool_1.Pool.recover(RecoverName_1.RecoverName.BUBBLE_ANI, _this);
                    callback();
                });
            });
        });
    };
    return BubbleAni;
}(FYGE.Container));
exports.BubbleAni = BubbleAni;


/***/ }),

/***/ "./src/something/anis/CrossAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/CrossAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var CrossAni = (function (_super) {
    __extends(CrossAni, _super);
    function CrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.CROSS_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage2 = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage2);
        _this.showImage2.anchorTexture.set(0.5, 0.5);
        _this.showImage2.scaleY = 0.1;
        _this.showImage2.rotation = 90;
        return _this;
    }
    CrossAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        this.showImage2.scaleY = 0.1;
        this.showImage2.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.showImage2)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return CrossAni;
}(Ani_1.Ani));
exports.CrossAni = CrossAni;


/***/ }),

/***/ "./src/something/anis/EggBrokenAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/EggBrokenAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var EggBrokenAni = (function (_super) {
    __extends(EggBrokenAni, _super);
    function EggBrokenAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.EGGBROKEN_ANI;
        var arr = ["yellowCircleDown.png", "yellowCircleUp.png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["downCircle", "upCircle", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    EggBrokenAni.prototype.play = function () {
        var _this = this;
        this.alpha = 1;
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140)
            .to({ alpha: 0 }, 160);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70)
            .to({ scaleX: 1, scaleY: 1 }, 160, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY })
            .to({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY })
            .to({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY })
            .to({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY })
            .to({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY })
            .to({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 }, 400);
        FYGE.Tween.get(this)
            .wait(250)
            .to({ alpha: 0 }, 150)
            .call(function () {
            _this.recover();
        });
    };
    return EggBrokenAni;
}(Ani_1.Ani));
exports.EggBrokenAni = EggBrokenAni;


/***/ }),

/***/ "./src/something/anis/EleDisAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/EleDisAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function EleDisAni(type) {
    var arr = [];
    for (var i = 0; i <= 14; i++) {
        arr.push(RES_1.RES.getRes("dis_" + "ele" + type + "_" + i + ".png"));
    }
    var frameAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FRAME_ANI);
    if (!frameAni) {
        frameAni = new FYGE.FrameAni(arr);
    }
    else {
        frameAni.resetTexturesAll(arr);
    }
    frameAni.play(1, function () {
        if (frameAni.parent) {
            frameAni.parent.removeChild(frameAni);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FRAME_ANI, frameAni);
        }
    });
    return frameAni;
}
exports.EleDisAni = EleDisAni;


/***/ }),

/***/ "./src/something/anis/EleDownAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleDownAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleDownAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        callback && callback();
    });
}
exports.EleDownAni = EleDownAni;


/***/ }),

/***/ "./src/something/anis/EleMaskAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleMaskAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleMaskAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    var mask = Tool_1.Tool.getRectMask();
    mask.x = p[0];
    mask.y = p[1];
    ele.mask = mask;
    con.addChild(mask);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        ele.mask = null;
        mask.recover();
        callback && callback();
    });
}
exports.EleMaskAni = EleMaskAni;


/***/ }),

/***/ "./src/something/anis/FlyTargetAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/FlyTargetAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function FlyTargetAni(type, fromP, targetP, callback) {
    var texture = RES_1.RES.getRes("ele" + type + ".png");
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = fromP[0];
    eleC.y = fromP[1];
    FYGE.Tween.get(eleC)
        .to({ x: targetP[0], y: targetP[1], scaleX: 0.7, scaleY: 0.7 }, 500 + (Math.random() * 100) >> 0)
        .call(function () {
        if (eleC.parent) {
            eleC.parent.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
        }
        callback();
    });
    return eleC;
}
exports.FlyTargetAni = FlyTargetAni;


/***/ }),

/***/ "./src/something/anis/HairballBrownDivideAni.ts":
/*!******************************************************!*\
  !*** ./src/something/anis/HairballBrownDivideAni.ts ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 80 / 2;
var offsetY = 80 / 2;
var HairballBrownDivideAni = (function (_super) {
    __extends(HairballBrownDivideAni, _super);
    function HairballBrownDivideAni() {
        var _this = _super.call(this) || this;
        _this.startHairball = new Hairball();
        _this.startHairball.brownFace.visible = false;
        _this.startHairball.x = -offsetX;
        _this.startHairball.y = -offsetY;
        _this.addChild(_this.startHairball);
        _this.endHairball = new Hairball();
        _this.endHairball.x = -offsetX;
        _this.endHairball.y = -offsetY;
        _this.addChild(_this.endHairball);
        return _this;
    }
    HairballBrownDivideAni.prototype.reset = function () {
        this.startHairball.eyesDown.scaleY = 1.5;
        this.startHairball.visible = false;
        this.endHairball.x = -offsetX;
        this.endHairball.y = -offsetY;
        this.endHairball.brownFace.visible = true;
        this.endHairball.greyFace.alpha = 0;
    };
    HairballBrownDivideAni.prototype.play = function (startP, endP, callback) {
        var _this = this;
        this.reset();
        var oriEyeX = 23;
        var oriEyeY = 33;
        var obj = { x: -offsetX, y: -offsetY };
        var eyeObj = { x: oriEyeX, y: oriEyeY };
        if (Math.abs(endP[0] - startP[0]) <= 0.001 && Math.abs(endP[1] - startP[1]) <= 0.001) {
        }
        else if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                obj.y += Tool_1.Tool.height;
                eyeObj.y += 4;
            }
            else {
                obj.y -= Tool_1.Tool.height;
                eyeObj.y -= 4;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                obj.x += Tool_1.Tool.width;
                eyeObj.x += 4;
            }
            else {
                obj.x -= Tool_1.Tool.width;
                eyeObj.x -= 4;
            }
        }
        this.x = startP[0];
        this.y = startP[1];
        var tweenPosAll = FYGE.Tween.get(this.endHairball);
        for (var i = 0; i < 5; i++) {
            tweenPosAll.to({ x: -offsetX - 1 }, 20)
                .to({ x: -offsetX + 2 }, 20)
                .to({ x: -offsetX }, 20);
        }
        tweenPosAll.call(function () {
            _this.startHairball.visible = true;
        });
        tweenPosAll.to(obj, 200);
        FYGE.Tween.get(this.endHairball.greyFace)
            .wait(100)
            .to({ alpha: 1 }, 100)
            .call(function () {
            _this.endHairball.brownFace.visible = false;
        });
        FYGE.Tween.get(this.endHairball.eyesDown)
            .wait(50)
            .to({ scaleY: 1.5 }, 50)
            .wait(420)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.startHairball.eyesDown)
            .wait(520)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.endHairball.eyes)
            .wait(200)
            .to(eyeObj, 30)
            .wait(290)
            .to({ x: oriEyeX, y: oriEyeY }, 30)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLBROWNDIVIDE_ANI, _this);
            callback();
        });
    };
    return HairballBrownDivideAni;
}(FYGE.Container));
exports.HairballBrownDivideAni = HairballBrownDivideAni;
var Hairball = (function (_super) {
    __extends(Hairball, _super);
    function Hairball() {
        var _this = _super.call(this) || this;
        _this.brownFace = new FYGE.Sprite(RES_1.RES.getRes("brownBallFace.png"));
        _this.addChild(_this.brownFace);
        _this.greyFace = new FYGE.Sprite(RES_1.RES.getRes("greyBallFace.png"));
        _this.addChild(_this.greyFace);
        _this.eyesDown = new EyesDown();
        _this.eyesDown.x = 16;
        _this.eyesDown.y = 29 + 29 / 2;
        _this.addChild(_this.eyesDown);
        _this.eyes = new Eyes();
        _this.eyes.x = 23;
        _this.eyes.y = 33;
        _this.addChild(_this.eyes);
        return _this;
    }
    return Hairball;
}(FYGE.Container));
var Eyes = (function (_super) {
    __extends(Eyes, _super);
    function Eyes() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("eyeSingle.png");
        _this.left = new FYGE.Sprite(texture);
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(texture);
        _this.right.x = 23;
        _this.addChild(_this.right);
        return _this;
    }
    return Eyes;
}(FYGE.Container));
var EyesDown = (function (_super) {
    __extends(EyesDown, _super);
    function EyesDown() {
        var _this = _super.call(this) || this;
        _this.left = new FYGE.Sprite(RES_1.RES.getRes("eyeDownLeft.png"));
        _this.left.y = -29 / 2;
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(RES_1.RES.getRes("eyeDownRight.png"));
        _this.right.x = 45 - 16;
        _this.right.y = -29 / 2;
        _this.addChild(_this.right);
        return _this;
    }
    return EyesDown;
}(FYGE.Container));


/***/ }),

/***/ "./src/something/anis/HairballGreyDisAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anis/HairballGreyDisAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 120 / 2;
var offsetY = 120 / 2;
var config = [
    {
        "name": "hairballPiece1",
        "x": 57,
        "y": 70,
    },
    {
        "name": "hairballPiece2",
        "x": 23,
        "y": 71,
    },
    {
        "name": "hairballPiece3",
        "x": 61,
        "y": 63,
    },
    {
        "name": "hairballPiece4",
        "x": 22,
        "y": 64,
    },
    {
        "name": "hairballPiece5",
        "x": 71,
        "y": 49,
    },
    {
        "name": "hairballPiece6",
        "x": 42,
        "y": 55,
    },
    {
        "name": "hairballPiece7",
        "x": 23,
        "y": 44,
    },
    {
        "name": "hairballPiece8",
        "x": 59,
        "y": 26,
    },
    {
        "name": "hairballPiece9",
        "x": 23,
        "y": 26,
    },
];
var HairballGreyDisAni = (function (_super) {
    __extends(HairballGreyDisAni, _super);
    function HairballGreyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI;
        _this.pieces = [];
        for (var i = 0; i < config.length; i++) {
            var bitmap = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes(config[i].name + ".png")));
            _this.pieces.push(bitmap);
        }
        _this.upBg = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("hairballDisBg.png")));
        _this.upBg.anchorTexture.set(0.5, 0.5);
        _this.reset();
        return _this;
    }
    HairballGreyDisAni.prototype.reset = function () {
        for (var i = 0; i < config.length; i++) {
            this.pieces[i].x = config[i].x - offsetX;
            this.pieces[i].y = config[i].y - offsetY;
            this.pieces[i].alpha = 1;
        }
        this.upBg.scaleX = this.upBg.scaleY = 1;
        this.upBg.alpha = 1;
    };
    HairballGreyDisAni.prototype.play = function () {
        var _this = this;
        this.reset();
        FYGE.Tween.get(this.upBg)
            .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
            .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 160)
            .call(function () {
            var _loop_1 = function (i) {
                var p = _this.pieces[i];
                var y = config[i].y;
                FYGE.Tween.get(p)
                    .wait(i * 30)
                    .to({ y: y + 6 }, 170);
                FYGE.Tween.get(p)
                    .wait(i * 30 + 100)
                    .to({ alpha: 0 }, 50)
                    .call(function () {
                    if (i == config.length - 1) {
                        _this.recover();
                    }
                });
            };
            for (var i = 0; i < config.length; i++) {
                _loop_1(i);
            }
        });
    };
    return HairballGreyDisAni;
}(Ani_1.Ani));
exports.HairballGreyDisAni = HairballGreyDisAni;


/***/ }),

/***/ "./src/something/anis/HairballJumpAni.ts":
/*!***********************************************!*\
  !*** ./src/something/anis/HairballJumpAni.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var StateType_1 = __webpack_require__(/*! ../enum/StateType */ "./src/something/enum/StateType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballJumpAni = (function (_super) {
    __extends(HairballJumpAni, _super);
    function HairballJumpAni() {
        return _super.call(this) || this;
    }
    HairballJumpAni.prototype.play = function (type, startP, endP, callback) {
        var _this = this;
        var source;
        switch (type) {
            case StateType_1.StateType.HAIRBALLBLACK:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBLACK + ".png";
                break;
            case StateType_1.StateType.HAIRBALLGREY:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
            case StateType_1.StateType.HAIRBALLBROWN:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBROWN + ".png";
                break;
            default:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
        }
        var texture = RES_1.RES.getRes(source);
        this.texture = texture;
        this.anchorTexture.set(0.5, 1);
        this.x = startP[0];
        this.y = startP[1] + texture.height / 2;
        FYGE.Tween.get(this)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLJUMP_ANI, _this);
            callback();
        });
        FYGE.Tween.get(this)
            .to({ x: endP[0], y: endP[1] + texture.height / 2 }, 300, FYGE.Ease.sineInOut);
    };
    return HairballJumpAni;
}(FYGE.Sprite));
exports.HairballJumpAni = HairballJumpAni;


/***/ }),

/***/ "./src/something/anis/HatchAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/HatchAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function HatchAni(startIndex, endIndexs, thisObj, callback) {
    var countAll = endIndexs.length;
    var count = 0;
    var startP = Tool_1.Tool.getPositionByIndex(startIndex);
    var _loop_1 = function (i) {
        var endIndex = endIndexs[i];
        var endP = Tool_1.Tool.getPositionByIndex(endIndex);
        texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.CHICKEN + ".png");
        var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
        if (!eleC) {
            eleC = new BitmapRecycle_1.BitmapRecycle(texture);
        }
        else {
            eleC.reset(texture);
        }
        eleC.x = startP[0];
        eleC.y = startP[1];
        eleC.scaleX = eleC.scaleY = 0.7;
        thisObj.addChild(eleC);
        paraCurveAni(eleC, startP, endP, function () {
            thisObj.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
            thisObj.lattices[endIndex].element.reset(ElementType_1.ElementType.CHICKEN);
            if (++count == countAll)
                callback();
        });
    };
    var texture;
    for (var i = 0; i < endIndexs.length; i++) {
        _loop_1(i);
    }
}
exports.HatchAni = HatchAni;
var deltaTime = 500;
var gravity = 0.003;
function paraCurveAni(ele, startP, endP, callback) {
    var deltaX = endP[0] - startP[0];
    var deltaY = endP[1] - startP[1];
    var vy0 = deltaY / deltaTime - gravity * deltaTime / 2;
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            ele.x = deltaX * a.t / deltaTime + startP[0];
            ele.y = vy0 * a.t + gravity * a.t * a.t / 2 + startP[1];
        }
    })
        .to({ t: deltaTime }, deltaTime)
        .call(function () {
        callback();
    });
    var rotation;
    if (deltaX > 0) {
        rotation = 360;
    }
    else if (deltaX < 0) {
        rotation = -360;
    }
    else {
        rotation = 0;
    }
    FYGE.Tween.get(ele)
        .set({ scaleX: 0.3, scaleY: 0.3, rotation: 0 })
        .to({ scaleX: 1, scaleY: 1, rotation: rotation }, deltaTime);
}


/***/ }),

/***/ "./src/something/anis/HorizontalAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/HorizontalAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var HorizontalAni = (function (_super) {
    __extends(HorizontalAni, _super);
    function HorizontalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HORIZONTAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage.rotation = 90;
        return _this;
    }
    HorizontalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return HorizontalAni;
}(Ani_1.Ani));
exports.HorizontalAni = HorizontalAni;


/***/ }),

/***/ "./src/something/anis/IceAni.ts":
/*!**************************************!*\
  !*** ./src/something/anis/IceAni.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var IceAni = (function (_super) {
    __extends(IceAni, _super);
    function IceAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ICE_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("ice" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    IceAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return IceAni;
}(Ani_1.Ani));
exports.IceAni = IceAni;


/***/ }),

/***/ "./src/something/anis/JellyDisAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/JellyDisAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var JellyDisAni = (function (_super) {
    __extends(JellyDisAni, _super);
    function JellyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.JELLYDIS_ANI;
        var arr = ["ele" + ElementType_1.ElementType.JELLY + ".png", "greenCircleDown.png", "greenCircleUp.png"];
        var objs = ["showImage", "downCircle", "upCircle"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    JellyDisAni.prototype.play = function () {
        var _this = this;
        FYGE.Tween.get(this.showImage)
            .set({ alpha: 1 })
            .to({ alpha: 0 }, 250 * 1.5);
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300 * 1.5, FYGE.Ease.cubicOut)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140 * 1.5)
            .to({ alpha: 0 }, 160 * 1.5);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70 * 1.5)
            .to({ scaleX: 1, scaleY: 1 }, 160 * 1.5, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170 * 1.5)
            .to({ alpha: 0 }, 100 * 1.5);
    };
    return JellyDisAni;
}(Ani_1.Ani));
exports.JellyDisAni = JellyDisAni;


/***/ }),

/***/ "./src/something/anis/JellySpreadAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/JellySpreadAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var JellySpreadAni = (function (_super) {
    __extends(JellySpreadAni, _super);
    function JellySpreadAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.JELLY + ".png");
        _this.targetImage = new FYGE.Sprite(texture);
        _this.targetImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.targetImage);
        _this.oriImage = new FYGE.Sprite(texture);
        _this.oriImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.oriImage);
        _this.shoot = new FYGE.Sprite(RES_1.RES.getRes("jellyArrow.png"));
        _this.shoot.anchorTexture.set(0, 0.5);
        _this.addChild(_this.shoot);
        return _this;
    }
    JellySpreadAni.prototype.play = function (startP, cloneEle, callback) {
        var _this = this;
        this.x = startP[0];
        this.y = startP[1];
        var endP = [cloneEle.x, cloneEle.y];
        this.addChildAt(cloneEle, 0);
        this.shoot.visible = true;
        this.shoot.x = 0;
        this.shoot.y = 0;
        this.shoot.scaleX = this.shoot.scaleY = 0.01;
        this.targetImage.visible = false;
        var obj = { scaleX: 0.01, scaleY: 0.01, x: 0, y: 0 };
        if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                this.shoot.rotation = 90;
                this.targetImage.x = 0;
                this.targetImage.y = Tool_1.Tool.height;
                obj.y = Tool_1.Tool.height;
            }
            else {
                this.shoot.rotation = 270;
                this.targetImage.x = 0;
                this.targetImage.y = -Tool_1.Tool.height;
                obj.y = -Tool_1.Tool.height;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                this.shoot.rotation = 0;
                this.targetImage.x = Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = Tool_1.Tool.width;
            }
            else {
                this.shoot.rotation = 180;
                this.targetImage.x = -Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = -Tool_1.Tool.width;
            }
        }
        cloneEle.x = this.targetImage.x;
        cloneEle.y = this.targetImage.y;
        FYGE.Tween.get(this.oriImage)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
            .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
            .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
            .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100);
        FYGE.Tween.get(this.shoot)
            .to({ scaleX: 2, scaleY: 1 }, 230)
            .to(obj, 50)
            .call(function () {
            _this.removeChild(cloneEle);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, cloneEle);
            callback();
            _this.shoot.visible = false;
            _this.targetImage.visible = true;
            FYGE.Tween.get(_this.targetImage)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
                .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
                .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
                .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
                .to({ scaleX: 1, scaleY: 1 }, 100)
                .call(function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.JELLYSPREAD_ANI, _this);
            });
        });
    };
    return JellySpreadAni;
}(FYGE.Container));
exports.JellySpreadAni = JellySpreadAni;


/***/ }),

/***/ "./src/something/anis/MagicLionAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/MagicLionAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var MagicLionAni = (function (_super) {
    __extends(MagicLionAni, _super);
    function MagicLionAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.MAGICLION_ANI;
        _this.downImage = new FYGE.Container();
        _this.addChild(_this.downImage);
        var texture = RES_1.RES.getRes("magicLionBg.png");
        var one = new FYGE.Sprite(texture);
        one.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(one);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            one.rotation -= 5;
        }, _this);
        var other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(other);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            other.rotation -= 5;
        }, _this);
        var texture = RES_1.RES.getRes("magicLion.png");
        _this.upImage = new FYGE.Sprite(texture);
        _this.upImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.upImage);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            _this.upImage.rotation += 2;
        }, _this);
        return _this;
    }
    MagicLionAni.prototype.play = function () {
        var _this = this;
        this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        FYGE.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 300)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 200)
            .wait(150)
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1, scaleY: 1 }, 300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 200);
    };
    return MagicLionAni;
}(Ani_1.Ani));
exports.MagicLionAni = MagicLionAni;


/***/ }),

/***/ "./src/something/anis/MagicRotateAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/MagicRotateAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var pi = Math.PI;
var pi2 = pi * 2;
function MagicRotateAni(ele, p, con) {
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    var texture = RES_1.RES.getRes("ele" + ele.type + ".png");
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = ele.x;
    eleC.y = ele.y;
    con.addChild(eleC);
    var tAll = 60;
    var deltaX = eleC.x - p[0];
    var deltaY = eleC.y - p[1];
    var dis = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    var vec0 = [1, 0];
    var vec1 = [deltaX, deltaY];
    var rotation = getRotByTwoVectors(vec0, vec1);
    if (deltaY > 0) {
        rotation = pi2 - rotation;
    }
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            var r = dis * (1 - a.t / tAll);
            var theta = a.t / tAll * pi;
            var x = r * Math.cos(theta);
            var y = r * Math.sin(theta);
            var xy = rotationAcodPoint([x, y], rotation);
            eleC.x = xy[0] + p[0];
            eleC.y = xy[1] + p[1];
            eleC.alpha = eleC.scaleX = eleC.scaleY = 1 - a.t / tAll;
        }
    })
        .to({ t: 60 }, 800, FYGE.Ease.quadIn)
        .call(function () {
        con.removeChild(eleC);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
    });
}
exports.MagicRotateAni = MagicRotateAni;
function rotationAcodPoint(p, rotation, point) {
    if (point === void 0) { point = [0, 0]; }
    var xp = p[0] - point[0];
    var yp = p[1] - point[1];
    var x = xp * Math.cos(rotation) + yp * Math.sin(rotation);
    var y = yp * Math.cos(rotation) - xp * Math.sin(rotation);
    return [x, y];
}
function getRotByTwoVectors(vec1, vec2) {
    var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
    var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
    var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
    var cos = ab / (a * b);
    return Math.acos(cos);
}
exports.getRotByTwoVectors = getRotByTwoVectors;


/***/ }),

/***/ "./src/something/anis/PieceToEggAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/PieceToEggAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var PieceToEggAni = (function (_super) {
    __extends(PieceToEggAni, _super);
    function PieceToEggAni() {
        var _this = _super.call(this) || this;
        var arr = ["ele" + ElementType_1.ElementType.CHICKEN_EGG + ".png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["showImage", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    PieceToEggAni.prototype.play = function (p, callback) {
        var _this = this;
        this.x = p[0];
        this.y = p[1];
        this.showImage.alpha = 0;
        FYGE.Tween.get(this.showImage)
            .wait(250)
            .to({ alpha: 1 }, 150);
        this.alpha = 0;
        FYGE.Tween.get(this)
            .to({ alpha: 1 }, 150);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 })
            .to({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 })
            .to({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 })
            .to({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 })
            .to({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 })
            .to({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY }, 400)
            .call(function () {
            callback();
            if (_this.parent) {
                _this.parent.removeChild(_this);
            }
            ;
            Pool_1.Pool.recover(RecoverName_1.RecoverName.PIECETOEGG_ANI, _this);
        });
    };
    return PieceToEggAni;
}(FYGE.Container));
exports.PieceToEggAni = PieceToEggAni;


/***/ }),

/***/ "./src/something/anis/RockAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/RockAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RockAni = (function (_super) {
    __extends(RockAni, _super);
    function RockAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ROCK_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ROCK + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("rock" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    RockAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return RockAni;
}(Ani_1.Ani));
exports.RockAni = RockAni;


/***/ }),

/***/ "./src/something/anis/ScoreAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/ScoreAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ScoreAni = (function (_super) {
    __extends(ScoreAni, _super);
    function ScoreAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.SCORE_ANI;
        _this.scoreNumber = new FYGE.BitmapText({});
        _this.addChild(_this.scoreNumber);
        return _this;
    }
    Object.defineProperty(ScoreAni.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (this._score == value)
                return;
            this._score = value;
            this.scoreNumber.text = "" + value;
        },
        enumerable: true,
        configurable: true
    });
    ScoreAni.prototype.play = function () {
        var _this = this;
        this.scoreNumber.y = 0;
        this.scoreNumber.alpha = 1;
        FYGE.Tween.get(this.scoreNumber)
            .to({ y: -50, alpha: 0 }, 1000)
            .call(function () {
            _this.recover();
        });
    };
    return ScoreAni;
}(Ani_1.Ani));
exports.ScoreAni = ScoreAni;


/***/ }),

/***/ "./src/something/anis/StepAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/StepAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var StepAni = (function (_super) {
    __extends(StepAni, _super);
    function StepAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.STEP_ANI;
        var arr = [];
        for (var i = 1; i <= 11; i++) {
            arr.push(RES_1.RES.getRes("stepAni" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    StepAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return StepAni;
}(Ani_1.Ani));
exports.StepAni = StepAni;


/***/ }),

/***/ "./src/something/anis/ThreeCrossAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/ThreeCrossAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ThreeCrossAni = (function (_super) {
    __extends(ThreeCrossAni, _super);
    function ThreeCrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.THREECROSS_ANI;
        for (var i = 1; i < 4; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.x = (i - 2) * Tool_1.Tool.height;
            showImage.scaleY = 0.1;
            _this["showImage" + i] = showImage;
        }
        for (var i = 4; i < 7; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.y = (i - 5) * Tool_1.Tool.width;
            showImage.scaleY = 0.1;
            showImage.rotation = 90;
            _this["showImage" + i] = showImage;
        }
        return _this;
    }
    ThreeCrossAni.prototype.play = function () {
        var _this = this;
        for (var i = 1; i < 7; i++) {
            this["showImage" + i].scaleY = 0.1;
            this["showImage" + i].alpha = 1;
            if (i == 6) {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    _this.recover();
                });
            }
            else {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100);
            }
        }
    };
    return ThreeCrossAni;
}(Ani_1.Ani));
exports.ThreeCrossAni = ThreeCrossAni;


/***/ }),

/***/ "./src/something/anis/VerticalAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/VerticalAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var VerticalAni = (function (_super) {
    __extends(VerticalAni, _super);
    function VerticalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.VERTICAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        return _this;
    }
    VerticalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return VerticalAni;
}(Ani_1.Ani));
exports.VerticalAni = VerticalAni;


/***/ }),

/***/ "./src/something/anisCall/DoorChangeAni.ts":
/*!*************************************************!*\
  !*** ./src/something/anisCall/DoorChangeAni.ts ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Door_1 = __webpack_require__(/*! ../class/Door */ "./src/something/class/Door.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var DoorChangeAni = (function (_super) {
    __extends(DoorChangeAni, _super);
    function DoorChangeAni(lat) {
        var _this = _super.call(this) || this;
        var door = lat.door;
        if (!door) { }
        var textureBg = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        _this.doorBg = new FYGE.Sprite(textureBg);
        _this.doorBg.x = -textureBg.width / 2;
        _this.doorBg.y = -textureBg.height / 2;
        _this.addChild(_this.doorBg);
        var textureDoor = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
        _this.door = new FYGE.Sprite(textureDoor);
        _this.door.x = -textureDoor.width / 2;
        _this.door.y = -textureDoor.height / 2;
        _this.addChild(_this.door);
        _this.addIce(lat.ice);
        _this.addEle(lat.element);
        return _this;
    }
    DoorChangeAni.prototype.reset = function (lat) {
        this.resetDoor(lat.door);
        this.addIce(lat.ice);
        this.addEle(lat.element);
    };
    DoorChangeAni.prototype.play = function (lat, callback) {
        var _this = this;
        var isClosed = lat.door.closed;
        this.reset(lat);
        var p = Tool_1.Tool.getPositionByIndex(lat.index);
        this.x = p[0];
        this.y = p[1];
        if (this.ice)
            this.ice.visible = isClosed ? false : true;
        if (this.ele)
            this.ele.visible = isClosed ? false : true;
        FYGE.Tween.get(this)
            .to({ scaleX: 0 }, 300)
            .call(function () {
            _this.door.texture = RES_1.RES.getRes(Door_1.doorImages[isClosed ? 1 : 0]);
            if (_this.ice)
                _this.ice.visible = isClosed ? true : false;
            if (_this.ele)
                _this.ele.visible = isClosed ? true : false;
            FYGE.Tween.get(_this)
                .to({ scaleX: 1 }, 300)
                .call(function () {
                callback();
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.DOORCHANGE_ANI, _this);
            });
        });
    };
    DoorChangeAni.prototype.resetDoor = function (door) {
        this.doorBg.texture = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        this.door.texture = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
    };
    DoorChangeAni.prototype.addIce = function (ice) {
        if (ice) {
            if (!this.ice) {
                var textureIce = RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png");
                this.ice = new FYGE.Sprite(textureIce);
                this.ice.x = -textureIce.width / 2;
                this.ice.y = -textureIce.height / 2;
                this.addChildAt(this.ice, 2);
            }
            this.ice.alpha = ice.countNum == 2 ? 1 : 0.6;
        }
        else if (this.ice) {
            this.removeChild(this.ice);
            this.ice = null;
        }
    };
    DoorChangeAni.prototype.addEle = function (ele) {
        if (ele) {
            if (!this.ele) {
                this.ele = Tool_1.Tool.getElement(ele.type);
                this.ele.x = 0;
                this.ele.y = 0;
                this.addChild(this.ele);
            }
            this.ele.copy(ele);
        }
        else if (this.ele) {
            this.removeChild(this.ele);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, this.ele);
            this.ele = null;
        }
    };
    return DoorChangeAni;
}(FYGE.Container));
exports.DoorChangeAni = DoorChangeAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedBombShowAni.ts":
/*!*****************************************************!*\
  !*** ./src/something/anisCall/FesRedBombShowAni.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedBombShowAni = (function (_super) {
    __extends(FesRedBombShowAni, _super);
    function FesRedBombShowAni() {
        var _this = _super.call(this) || this;
        var textureDown = RES_1.RES.getRes("fesRedBombSta1.png");
        var down = new FYGE.Sprite(textureDown);
        down.x = -textureDown.width / 2;
        down.y = -textureDown.height / 2;
        _this.addChild(down);
        var textureUp = RES_1.RES.getRes("xingxingbi.png");
        var up = new FYGE.Sprite(textureUp);
        up.x = -textureUp.width / 2;
        up.y = -100;
        _this.addChild(up);
        return _this;
    }
    FesRedBombShowAni.prototype.play = function (position, callback) {
        var _this = this;
        this.scaleX = this.scaleY = 0.29;
        this.x = position[0];
        this.y = position[1];
        FYGE.Tween.get(this)
            .wait(200)
            .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut)
            .wait(500)
            .to({ scaleX: 0.29, scaleY: 0.29 }, 500, FYGE.Ease.backInOut)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI, _this);
            callback();
        });
    };
    return FesRedBombShowAni;
}(FYGE.Container));
exports.FesRedBombShowAni = FesRedBombShowAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedShootAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anisCall/FesRedShootAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedShootAni = (function (_super) {
    __extends(FesRedShootAni, _super);
    function FesRedShootAni() {
        var _this = _super.call(this) || this;
        _this.light = new LightingAni();
        _this.addChild(_this.light);
        var arr = [];
        for (var i = 1; i <= 10; i++) {
            arr.push(RES_1.RES.getRes("fesEleSmallDis" + i + ".png"));
        }
        _this.imageAniCon = new FYGE.Container();
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.imageAniCon.addChild(_this.imageAni);
        _this.addChild(_this.imageAniCon);
        _this.imageAni.visible = false;
        return _this;
    }
    FesRedShootAni.prototype.reset = function () {
        this.light.visible = true;
        this.imageAni.visible = false;
        this.light.scaleX = 0.2;
    };
    FesRedShootAni.prototype.play = function (startP, ele, callback) {
        var _this = this;
        this.reset();
        var r = Tool_1.Tool.getForwardRotation(startP, [ele.x, ele.y]);
        this.light.rotation = r * 180 / Math.PI;
        this.light.x = startP[0];
        this.light.y = startP[1];
        this.imageAniCon.x = ele.x;
        this.imageAniCon.y = ele.y;
        var dis = Math.sqrt((startP[0] - ele.x) * (startP[0] - ele.x) +
            (startP[1] - ele.y) * (startP[1] - ele.y));
        var scaleX = dis / 247;
        FYGE.Tween.get(this.light)
            .to({ scaleX: scaleX, }, 400)
            .call(function () {
            ele.reset(ElementType_1.ElementType.FESTIVALELE_SMALL);
            ele.scaleX = ele.scaleY = 0.1;
            FYGE.Tween.get(ele)
                .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut);
            callback();
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDSHOOT_ANI, _this);
            });
            setTimeout(function () {
                _this.light.visible = false;
            }, 200);
        });
    };
    return FesRedShootAni;
}(FYGE.Container));
exports.FesRedShootAni = FesRedShootAni;
var LightingAni = (function (_super) {
    __extends(LightingAni, _super);
    function LightingAni() {
        var _this = _super.call(this) || this;
        var arr = [];
        for (var i = 1; i <= 13; i++) {
            arr.push(RES_1.RES.getRes("lineLight" + i + ".png"));
        }
        _this.anchorTexture.set(23 / 293, 27 / 58);
        _this.sourceAll = arr;
        _this.texture = RES_1.RES.getRes(_this.sourceAll[0]);
        _this.currentFrame = 0;
        _this.totalFrames = arr.length;
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
        _this.startTime = Date.now();
        _this.allTime = _this.sourceAll.length / 30 * 1000;
        return _this;
    }
    LightingAni.prototype.onEnterFrame = function () {
        if (!this.stage)
            return;
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now();
            this.currentFrame = 0;
        }
        else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
        }
        this.texture = RES_1.RES.getRes(this.sourceAll[this.currentFrame]);
    };
    return LightingAni;
}(FYGE.Sprite));


/***/ }),

/***/ "./src/something/anisCall/RectsWaveAni.ts":
/*!************************************************!*\
  !*** ./src/something/anisCall/RectsWaveAni.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var whiteRectPool = [];
function RectsWaveAni(lattices, container, callback, centerIndex) {
    if (centerIndex === void 0) { centerIndex = 40; }
    var loops = [];
    var rc = Tool_1.Tool.indexToRc(centerIndex);
    var num = 0;
    var maxNum = Math.max(rc[0], rc[1], Tool_1.Tool.rowNum - rc[0] - 1, Tool_1.Tool.colNum - rc[1] - 1);
    while (num <= maxNum) {
        var indexs = [];
        if (num) {
            var rowMax = rc[0] + num;
            var rowMin = rc[0] - num;
            var colMax = rc[1] + num;
            var colMin = rc[1] - num;
            var colIndexs = rangeIndexs(colMin >= 0 ? colMin : 0, colMax < Tool_1.Tool.colNum ? colMax : Tool_1.Tool.colNum - 1);
            var rowIndexs = rangeIndexs(rowMin >= 0 ? rowMin : 0, rowMax < Tool_1.Tool.rowNum ? rowMax : Tool_1.Tool.rowNum - 1, false);
            if (rowMin >= 0) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMin, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (rowMax < Tool_1.Tool.rowNum) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMax, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMin >= 0) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMin);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMax < Tool_1.Tool.colNum) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMax);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
        }
        else {
            indexs.push(centerIndex);
        }
        var loop = [];
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var rect = whiteRectPool.shift();
            if (!rect)
                rect = new WhiteRect();
            rect.alpha = 0;
            rect.x = p[0];
            rect.y = p[1];
            container.addChild(rect);
            loop.push(rect);
        }
        loops.push(loop);
        num++;
    }
    for (var m = loops.length - 1; m >= 0; m--) {
        if (!loops[m].length) {
            loops.pop();
        }
        else {
            break;
        }
    }
    var loopsLen = loops.length;
    var _loop_1 = function (m) {
        var loop_1 = loops[m];
        var wait = m * 100;
        var loopLen = loop_1.length;
        var _loop_2 = function (n) {
            var rect = loop_1[n];
            FYGE.Tween.get(rect)
                .wait(wait)
                .to({ alpha: 1 }, 150)
                .to({ alpha: 0 }, 150)
                .call(function () {
                if (rect.parent) {
                    rect.parent.removeChild(rect);
                    whiteRectPool.push(rect);
                }
                if (m == loopsLen - 1 && n == loopLen - 1 && callback)
                    callback();
            });
        };
        for (var n = 0; n < loop_1.length; n++) {
            _loop_2(n);
        }
    };
    for (var m = 0; m < loops.length; m++) {
        _loop_1(m);
    }
}
exports.RectsWaveAni = RectsWaveAni;
var WhiteRect = (function (_super) {
    __extends(WhiteRect, _super);
    function WhiteRect() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("rectLatWhite.png");
        _this.texture = texture;
        _this.anchorTexture.set(0.5, 0.5);
        return _this;
    }
    return WhiteRect;
}(FYGE.Sprite));
function rangeIndexs(min, max, include) {
    if (include === void 0) { include = true; }
    var nums = [];
    if (include)
        nums.push(min);
    var num = min;
    while (++num < max)
        nums.push(num);
    if (include)
        nums.push(max);
    return nums;
}


/***/ }),

/***/ "./src/something/chapters/Chapter1.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter1.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters1 = [
    null,
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 45,
                },
            ],
        },
        starScores: [1000, 5000, 10000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 11, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 20, 10, 20, 0, 20, 10, 20, 0,
                20, 10, 20, 10, 20, 10, 20, 10, 20,
                20, 10, 20, 20, 10, 20, 20, 10, 20,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 0, 20, 10, 20, 10, 20, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 6,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 26,
                },
            ],
        },
        starScores: [100, 500, 950],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 2, 2, 0, 0, 0, 1, 1, 0,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
                0, 2, 2, 0, 0, 0, 2, 2, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 10, 0, 0, 0, 10, 20, 0,
                20, 20, 10, 20, 0, 10, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 40, 30, 0, 0, 0, 10, 30, 0,
                10, 30, 40, 20, 0, 20, 30, 40, 10,
                0, 40, 30, 0, 0, 0, 40, 30, 0,
                20, 20, 10, 10, 0, 20, 40, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 19
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 1, 2, 1, 2, 0, 0,
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 10, 10, 20, 10, 10, 0, 0,
                0, 0, 30, 40, 10, 40, 40, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 10, 2, 2, 0, 0,
                0, 0, 2, 10, 2, 10, 2, 0, 0,
                0, 0, 10, 2, 10, 2, 10, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 10, 20, 10, 20, 10, 20, 10, 0,
                0, 20, 10, 20, 30, 20, 10, 20, 0,
                0, 10, 0, 10, 20, 30, 0, 10, 0,
                0, 20, 10, 20, 30, 1, 1, 1, 0,
                40, 50, 40, 50, 30, 40, 50, 40, 50,
                0, 20, 10, 20, 10, 30, 10, 20, 0,
                0, 10, 0, 10, 30, 10, 0, 10, 0,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 10, 20, 10, 20, 10, 20, 10, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 17
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 20, 0, 30, 30, 50, 0,
                0, 40, 30, 30, 40, 10, 10, 30, 0,
                0, 10, 30, 30, 40, 10, 10, 50, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 30, 20, 20, 40, 50, 50, 20, 0,
                0, 30, 20, 20, 40, 50, 50, 10, 0,
                0, 40, 40, 50, 0, 20, 40, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 10, 10, 40, 40, 10, 10,
                20, 10, 0, 10, 10, 40, 40, 10, 10,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [10, 20], cus: [] },
                { index: 10, type: [10, 20], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 2, 2, 2, 0, 0, 1, 1, 1,
                1, 2, 2, 2, 1, 0, 0, 1, 0,
                0, 2, 2, 2, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 1, 1, 1, 0, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 10, 0, 0, 0, 0, 10, 0,
                0, 20, 10, 20, 0, 0, 10, 30, 10,
                10, 10, 20, 10, 40, 0, 0, 10, 0,
                0, 10, 20, 10, 40, 40, 0, 10, 0,
                0, 0, 10, 40, 0, 40, 10, 20, 20,
                0, 0, 0, 40, 40, 30, 10, 10, 20,
                0, 10, 0, 0, 40, 10, 20, 10, 10,
                10, 30, 10, 10, 20, 10, 20, 30, 30,
                0, 10, 0, 0, 20, 20, 10, 30, 30,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [40, 40] },
                { index: 7, type: [0], cus: [] },
                { index: 10, type: [0], cus: [30] },
                { index: 12, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
                { index: 18, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 36
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 2, 0, 1, 1, 0, 0, 1, 1,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 2, 2, 2, 2, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
            ],
            elements: [
                1, 1, 0, 1, 1, 0, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
            ],
            baseElements: [
                10, 10, 0, 50, 50, 0, 0, 50, 50,
                10, 10, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 40, 40, 20, 20, 30, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 0, 10, 10, 0, 20, 20, 0, 30,
                33, 0, 10, 10, 0, 20, 20, 0, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 30, 20, 30, 20, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                20, 30, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 10, 10, 20, 20, 10, 10,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[3, 21], [4, 22], [5, 23], [6, 24], [7, 25]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 37
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 0, 0, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                2, 2, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 0, 0, 0, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                11, 0, 0, 0, 20, 20, 30, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 10, 20, 20, 10, 10,
                0, 0, 0, 40, 40, 50, 50, 40, 40,
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                11, 13, 0, 50, 50, 30, 30, 50, 50,
                0, 0, 0, 40, 40, 20, 20, 40, 40,
                0, 0, 0, 30, 30, 10, 10, 30, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 5, type: [0], cus: [14, 11, 14] },
                { index: 6, type: [0], cus: [11, 14, 11] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 14, 20, 0, 0, 0,
                0, 0, 0, 0, 21, 0, 0, 0, 0,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                40, 40, 30, 30, 40, 10, 10, 50, 50,
                40, 40, 30, 20, 30, 10, 10, 50, 50,
                0, 0, 0, 0, 30, 0, 0, 0, 0,
                0, 0, 10, 20, 10, 20, 10, 0, 0,
            ],
            generateLats: [
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
                { index: 75, type: [0], cus: [] },
                { index: 77, type: [0], cus: [] },
                { index: 78, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 1, 1, 2, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 2, 1, 1, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [0], cus: [] },
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 39
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
            ],
            baseElements: [
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 20, 10, 20, 2, 10, 20, 10, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 12, 20, 12, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 1, 3, 1, 3, 1, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                0, 10, 3, 10, 3, 10, 3, 10, 0,
                0, 20, 30, 20, 30, 20, 30, 20, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 20, 30, 40, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 2, 30, 2, 2, 2, 0,
                0, 2, 2, 40, 20, 30, 2, 2, 0,
                0, 0, 2, 2, 30, 2, 2, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
            recycles: [74, 75, 76, 77, 78, 70, 64]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 1, 3, 1, 3, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
            recycles: [54, 62, 73, 74, 75, 76, 77, 78, 79],
            connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 33
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
            ],
            elements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 1, 2, 1, 2, 1, 2, 0, 1,
                1, 2, 1, 2, 1, 2, 1, 0, 1,
            ],
            baseElements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 22, 2, 22, 2, 22, 2, 0, 13,
                22, 2, 22, 2, 22, 2, 22, 0, 11,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 77, 75, 76, 78]
        },
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter2.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter2.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters2 = [
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 56
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 0, 0, 0, 1, 1, 1,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 40
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 50
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                2, 2, 1, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 1, 2, 2
            ],
            baseElements: [
                0, 0, 31, 0, 24, 0, 31, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 31, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
                2, 2, 30, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 30, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 30, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 30, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 30, 2, 2
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[2, 21], [4, 22], [6, 23]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 12
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 10, 2, 30, 2, 20, 2, 10, 0,
                0, 30, 2, 30, 2, 20, 2, 10, 0,
                0, 20, 2, 20, 2, 10, 2, 30, 0,
                0, 10, 2, 20, 2, 10, 2, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                40, 40, 50, 40, 50, 40, 50, 40, 40,
                0, 50, 40, 50, 40, 50, 40, 50, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 67, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 70, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
            recycles: [46, 47, 48, 49, 50, 51, 52]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 31
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 2, 2, 1, 0, 3, 3, 3,
                2, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
            ],
            elements: [
                1, 0, 2, 2, 2, 0, 2, 0, 2,
                1, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            baseElements: [
                11, 0, 2, 2, 2, 0, 2, 0, 2,
                23, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [33] },
                { index: 3, type: [0], cus: [21] },
                { index: 4, type: [0], cus: [] },
            ],
            connectedLats: [[2, 29], [3, 30], [4, 31], [74, 6], [75, 7], [76, 8]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 42
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 42
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                4, 4, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
            ],
            baseElements: [
                12, 13, 20, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                33, 32, 0, 10, 20, 10, 20, 10, 20,
                32, 41, 0, 20, 10, 20, 10, 20, 10,
                42, 23, 0, 10, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 31, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
                { index: 49, type: [0], cus: [] },
                { index: 50, type: [0], cus: [] },
                { index: 51, type: [0], cus: [] },
                { index: 52, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 5,
                    count: 8
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 4, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 31, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 4, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 48
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 0, 1, 1, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 1, 3, 3, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
            ],
            elements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 1, 0, 0, 1, 0, 0, 1, 2,
                1, 2, 1, 0, 1, 0, 1, 2, 1,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 25
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 4, 4, 4, 4, 4, 4, 4, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 21
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 1, 1, 3, 1, 2, 1, 2, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 3, 1, 1, 1, 1, 1, 2, 1,
                1, 3, 3, 3, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 4, 1, 4, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 42, 0, 32, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 23, 0, 12, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 9, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 7
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 0, 1, 0, 1, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                3, 0, 3, 0, 3, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 75, 76, 77, 78, 79]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
            ],
            elements: [
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 4, 4, 1, 4, 4, 0, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                30, 20, 30, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 50, 50, 40, 50, 50, 0, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 2, 2, 2, 50, 2, 2, 2, 1,
                1, 1, 2, 2, 40, 2, 2, 1, 1,
                1, 1, 2, 2, 44, 2, 2, 1, 1,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 66
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 1, 0, 1, 0, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                50, 50, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                53, 42, 0, 32, 0, 32, 0, 32, 0,
            ],
            generateLats: [
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 6
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 1, 1, 1,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                3, 3, 3, 0, 4, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 20, 30, 50, 50, 20,
                0, 0, 0, 0, 30, 20, 30, 20, 30,
                3, 3, 3, 0, 20, 30, 20, 30, 20,
                21, 31, 42, 0, 52, 20, 30, 20, 30,
                20, 31, 41, 0, 51, 30, 20, 30, 20
            ],
            generateLats: [
                { index: 54, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
            ],
            recycles: [80, 76, 77, 78, 79],
            connectedLats: [[72, 5], [73, 6], [74, 7]]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 64
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
            ],
            elements: [
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                1, 1, 4, 1, 2, 2, 2, 2, 4,
                4, 1, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
            ],
            baseElements: [
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                40, 30, 41, 23, 2, 2, 2, 2, 0,
                4, 40, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 27,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 70 }]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 3, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 2, 2, 2, 2, 2, 2, 2, 1
            ],
            connectedLats: [[31, 49], [32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                1, 1, 1, 1, 4, 2, 4, 2, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 11, 30, 30, 22, 52, 51, 41, 12,
                20, 11, 30, 30, 0, 10, 0, 20, 0,
                11, 40, 0, 0, 30, 0, 30, 0, 30,
                40, 11, 0, 0, 0, 10, 0, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
            ],
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 16 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0],
            connectedLats: [[29, 47], [33, 51], [39, 46], [41, 52], [28, 57], [34, 59]],
            elements: [
                1, 4, 2, 3, 3, 3, 2, 4, 4,
                1, 4, 2, 3, 3, 3, 2, 4, 2,
                1, 4, 2, 3, 1, 3, 2, 4, 4,
                1, 4, 2, 1, 3, 1, 2, 4, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [20, 0, 30, 30, 22, 52, 51, 0, 12, 20, 0, 30, 30, 0, 10, 0, 0, 0, 11, 0, 0, 0, 10, 0, 30, 0, 30, 40, 0, 0, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null }
            ]
        }
    },
    {
        baseElementTypes: [2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 22 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1
            ],
            connectedLats: [[80, 3], [79, 2], [78, 1], [77, 0]],
            elements: [
                3, 3, 3, 3, 0, 0, 0, 0, 0,
                3, 3, 3, 3, 0, 0, 2, 2, 0,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 20, 30, 20, 0, 0, 0, 0, 11,
                20, 30, 20, 30, 0, 0, 0, 0, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 41,
                10, 40, 40, 10, 0, 0, 0, 0, 43,
                30, 50, 50, 30, 0, 0, 0, 0, 41,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [63, 64, 65, 66],
            generateLats: [{ index: 15, type: 0 }, { index: 16, type: 0 }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 5, count: 12 }]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                0, 0, 0, 2, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 30, 50, 20, 30,
                0, 0, 0, 0, 0, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 20, 50, 20, 50,
                0, 0, 0, 0, 0, 12, 30, 12, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 20, 50, 50, 0, 10, 50, 10, 50,
                0, 0, 0, 0, 0, 20, 30, 30, 10,
                10, 10, 20, 20, 0, 10, 20, 20, 10,
                0, 0, 0, 0, 0, 30, 20, 30, 30
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [3, 2, 1, 0, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 56 }]
        },
        starScores: [6000, 14000, 25000],
        map: {
            lattices: [2, 0, 2, 0, 2, 2, 0, 2, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 2],
            connectedLats: [],
            elements: [
                1, 0, 2, 0, 2, 1, 0, 1, 0,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                0, 0, 2, 0, 2, 4, 4, 4, 4,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                1, 0, 0, 0, 0, 0, 1, 0, 1
            ],
            baseElements: [
                41, 0, 0, 0, 0, 42, 0, 42, 0,
                0, 0, 40, 0, 40, 0, 0, 0, 0,
                0, 40, 0, 40, 0, 10, 10, 20, 20, 0, 0, 40, 0, 40, 50, 30, 30, 42, 0, 41, 0, 40, 0, 20, 20, 30, 10, 0, 0, 40, 0, 0, 30, 50, 50, 40, 0, 40, 0, 40, 0, 30, 50, 50, 40, 0, 0, 40, 0, 40, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 42, 0, 41
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 2, type: 0, cus: [14] },
                { index: 4, type: 0, cus: [14] },
                { index: 5, type: 0 },
                { index: 7, type: 0 },
                { index: 26, type: 0 },
                { index: 25, type: 0 },
                { index: 24, type: 0 },
                { index: 72, type: 0 },
                { index: 78, type: 0 },
                { index: 80, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 54 }]
        },
        starScores: [6000, 15000, 23000],
        map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 0],
            baseElements: [11, 22, 12, 22, 12, 22, 12, 22, 11, 12, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 10, 40, 0, 0, 0, 0, 0, 40, 10, 20, 40, 50, 0, 0, 0, 50, 40, 20, 20, 30, 50, 10, 0, 10, 50, 30, 20, 0, 30, 30, 10, 20, 10, 30, 30, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 20, type: 0, cus: [14, 14, 14, 14] },
                { index: 21, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 23, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 24, type: 0, cus: [14, 14, 14, 14] },
                { index: 28, type: 0, cus: [14, 14] },
                { index: 31, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 34, type: 0, cus: [14, 14] },
                { index: 36, type: 0 },
                { index: 44, type: 0 }
            ]
        }
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter3.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter3.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters3 = [
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 2, 2, 2, 2, 2, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 5, 2, 2, 0, 0,
                0, 0, 5, 1, 1, 1, 5, 0, 0,
                0, 2, 2, 2, 5, 2, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 10, 0, 0, 0, 0,
                0, 0, 0, 40, 20, 40, 0, 0, 0,
                0, 0, 20, 20, 30, 40, 20, 0, 0,
                0, 20, 40, 30, 20, 30, 30, 10, 0,
                0, 0, 10, 20, 10, 20, 30, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 40, 40, 20, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 13, type: 0 },
                { index: 21, type: 0 },
                { index: 23, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 37, type: 0 },
                { index: 43, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 57 }] },
        starScores: [6000, 15000, 21000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 20, 0, 0, 0, 0, 0, 0, 20, 30, 10, 0, 0, 0, 0, 0, 0, 20, 20, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 13, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 19, type: 0 },
                { index: 20, type: 0 },
                { index: 21, type: 0 },
                { index: 22, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 22, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 15000, 22000], map: { lattices: [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 1, 1, 4, 5, 4, 1, 1, 0, 1, 1, 4, 5, 5, 5, 4, 1, 1, 0, 1, 1, 4, 5, 4, 1, 1, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: 0 }, { index: 12, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 36, type: 0 }, { index: 44, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 39 }] },
        starScores: [8000, 15000, 31000],
        map: {
            lattices: [
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 2, 3,
                1, 1, 1, 0, 0, 0, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                4, 4, 4, 0, 0, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 0, 0, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 0, 23, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 40, type: [13, 12, 11, 23, 22, 21] }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 5, count: 39 }] },
        starScores: [6000, 14000, 24000],
        map: {
            lattices: [1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2],
            baseElements: [
                40, 0, 0, 0, 0, 0, 0, 0, 40,
                0, 40, 0, 0, 0, 0, 0, 40, 0,
                0, 0, 40, 0, 0, 0, 40, 0, 0,
                0, 0, 0, 40, 0, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 0, 0, 0, 0, 43,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 40, 0, 0, 0, 43,
                0, 0, 0, 0, 24, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 8, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 48, type: 0 },
                { index: 49, type: 0 },
                { index: 50, type: 0 },
                { index: 57, type: 0 },
                { index: 58, type: 0, cus: [40, 44] },
                { index: 59, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 50 }] }, starScores: [6000, 14000, 25000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1], connectedLats: [], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4, 4, 2, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 45, type: 0 }, { index: 53, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 6, count: 23 }] },
        starScores: [6000, 12000, 18000],
        map: {
            lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            connectedLats: [[63, 14], [64, 15], [65, 16], [66, 17]],
            elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 3, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            baseElements: [
                0, 0, 0, 0, 0, 10, 40, 40, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 10, 10, 30, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 30, 30, 10, 10,
                0, 0, 0, 0, 0, 40, 40, 20, 20,
                0, 0, 0, 0, 0, 20, 30, 40, 30,
                0, 0, 0, 0, 0, 11, 12, 21, 22,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [68, 69, 70, 71],
            generateLats: [
                { index: 9, type: 0 },
                { index: 10, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 30, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 45, type: 0 },
                { index: 46, type: 0 },
                { index: 47, type: 0 },
                { index: 48, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 },
                { index: 63, type: 0 },
                { index: 64, type: 0 },
                { index: 65, type: 0 },
                { index: 66, type: 0 },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 5, count: 34 }, { type: 9, count: 7 }] }, starScores: [5000, 12000, 24000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 2], connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 5, 5, 2, 2, 0, 0, 1, 1, 2, 5, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 5, 5, 2, 2, 1, 1, 2, 2, 2, 5, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 5], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 43, type: 0 }, { index: 44, type: 0 }]
        }
    },
    {
        baseElementTypes: [1, 2, 0, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 5, count: 16 }] }, starScores: [6000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
           