
import { StepAni } from "../anis/StepAni";
import { Element } from "../class/Element";
import { Tool } from "../Tool";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";
import { PlayScene, baseScore, effectBaseTimes } from "../../scene/PlayScene";
import { PropType } from "../enum/PropType";
import { GTool } from "../../../module/tools/GTool";
import { Tools } from "../../Tools";



const msgs = {
    2: ["点击尝试使用炸弹吧", "选择并点击任意一个小\n动物进行十字消除"],
    3: ["点击尝试使用锤子吧", "选择并点击任意一个小\n动物可将他消除哦"],
    4: ["点击道具，为本局额外\n增加5步游戏步数吧"],
}


/**
 * 动态道具引导  ui已改，暂时去掉了道具引导，到时需要加回来重新调整位置和动效
 */
export class PropGuideInt extends FYGE.Container {

    /**
     * 手势的循环动画
     */
    handAni: HandAni;

    boomAni: BoomAni;
    hammerAni: HammerAni;
    shoeANi: ShoeAni;
    /**
     * 背景面板的动画，一次
     */
    msgPanelAni: BgAni;
    /**
     * MainScene的指向，为了拿方法
     */
    thisObj: PlayScene

    propType: PropType;
    /**
     * 
     * @param thisObj 
     */
    constructor(thisObj: PlayScene) {
        super();
        this.thisObj = thisObj;
        //背景蒙层
        var bg: FYGE.Shape = new FYGE.Shape();
        bg.beginFill(0x000000, 0.7);
        bg.drawRect(0, 0, 750, 1624);
        bg.endFill();
        this.addChild(bg);
        //信息板
        this.msgPanelAni = new BgAni();
        this.msgPanelAni.x = 80
        this.addChild(this.msgPanelAni)

        this.boomAni = new BoomAni();
        this.boomAni.visible = false;
        this.boomAni.x = 193;
        this.boomAni.y = 1100;
        this.addChild(this.boomAni)
        this.hammerAni = new HammerAni();
        this.hammerAni.visible = false;
        this.hammerAni.x = 380 + 24;
        this.hammerAni.y = 1110 + 36;
        this.addChild(this.hammerAni)
        this.shoeANi = new ShoeAni();
        this.shoeANi.visible = false;
        this.shoeANi.x = 570;
        this.shoeANi.y = 1100;
        this.addChild(this.shoeANi)
        // console.log(this.boomAni, this.hammerAni, this.shoeANi)

        //手势
        this.handAni = new HandAni();

        this.handAni.visible = false;
        this.addChild(this.handAni)
    }
    init(propType: PropType) {
        this.propType = propType;
        switch (propType) {
            //炸弹的引导
            case PropType.BOOMS:
            //锤子的引导
            case PropType.HAMMERS:
                let obj: FYGE.Sprite;
                if (propType == PropType.BOOMS) {
                    obj = this.boomAni
                } else {
                    obj = this.hammerAni
                }
                obj.visible = true;
                this.msgPanelAni.y = 465;
                this.msgPanelAni.msg.y = 175
                this.msgPanelAni.play(msgs[propType][0], () => {
                    //显示手势
                    this.handAni.visible = true;
                    this.handAni.play();
                    this.handAni.x = propType == PropType.BOOMS ? 240 : 440;
                    this.handAni.y = 1150;
                    obj["play"]();
                    obj.once(FYGE.MouseEvent.CLICK, () => {
                        obj["stop"]();
                        //文案
                        this.msgPanelAni.y = 665;
                        this.msgPanelAni.msg.y = 160
                        this.msgPanelAni.play(msgs[propType][1], () => { })
                        this.showElement(propType);
                        this.handAni.x = 510;
                        this.handAni.y = 700;
                        this.addChild(this.handAni)

                    }, this)
                })
                break;
            //步数的引导
            case PropType.STEPS:
                this.shoeANi.visible = true;
                this.msgPanelAni.y = 465;
                this.msgPanelAni.msg.y = 160
                this.msgPanelAni.play(msgs[propType][0], () => {
                    //显示手势
                    this.handAni.visible = true;
                    this.handAni.play();
                    this.handAni.x = 640;
                    this.handAni.y = 1150;
                    this.shoeANi.play();
                    this.shoeANi.once(FYGE.MouseEvent.CLICK, () => {
                        //移除
                        this.thisObj.removeChild(this);
                       GTool. writeCache(Tools.cacheKey + this.thisObj.chapter + "prop");
                        //动效
                        var stepAni = new StepAni();
                        stepAni.play();
                        stepAni.x = 50;
                        stepAni.y = 100;
                        this.thisObj.addChild(stepAni);
                        setTimeout(() => {
                            //加步数
                            this.thisObj.steps += 5;
                        }, 333)
                        this.thisObj["enableMouseEvt"](true);
                    }, this)
                })
                break;
        }
    }
    private showElement(propType: PropType) {
        //固定显示第4*9+5 41个元素
        var index = 41
        var eleC = this.thisObj.lattices[41].element;
        //点完后显示一个元素，元素上加事件
        var element = new Element(eleC.type)
        element.effectType = eleC.effectType;
        element.x = eleC.x;
        element.y = eleC.y;
        this.addChild(element);
        element.once(FYGE.MouseEvent.MOUSE_DOWN, () => {
            this.thisObj.removeChild(this);
           GTool. writeCache(Tools.cacheKey + this.thisObj.chapter + "prop");
            switch (propType) {
                case PropType.BOOMS:
                    // playSound(SoundType.line)
                    var rc = Tool.indexToRc(index);
                    var p = Tool.getPositionByIndex(index);
                    this.thisObj.playAni(RecoverName.CROSS_ANI, p);
                    for (var i = 0; i < this.thisObj.lattices.length; i++) {
                        var lat = this.thisObj.lattices[i];
                        if (Tool.judgeEliminate(lat) && (lat.row == rc[0] || lat.column == rc[1])) {
                            if (this.thisObj.eliminatedElements.indexOf(i) == -1) {
                                this.thisObj.eliminatedElements.push(i);
                                if (Tool.judgeHasScore(lat.element)) {
                                    //算直线+直线LL
                                    this.thisObj.pushScoreAni(baseScore * 1 * effectBaseTimes.LL, Tool.getPositionByIndex(i))
                                }
                            }
                        }
                    }
                    setTimeout(() => {
                        this.thisObj.eliminate();
                    }, 200)
                    break;
                case PropType.HAMMERS:
                    this.thisObj.eliminatedElements.push(index);
                    this.thisObj.pushScoreAni(
                        baseScore * 1 * (effectBaseTimes[this.thisObj.lattices[index].element.effectType] || 1),
                        Tool.getPositionByIndex(index)
                    )
                    this.thisObj.eliminate();
                    break;
            }
        }, this)
    }

}

/**
 * 背景面板
 */
class BgAni extends FYGE.Container {
    cow: FYGE.Sprite;
    bg: FYGE.Sprite;
    msg: GuideShowWord;
    constructor() {
        super();

        this.bg = new FYGE.Sprite(RES.getRes("guidePropMsgPanel.png"));
        this.bg.x = 120;
        this.bg.y = 95;
        this.addChild(this.bg);
        this.cow = new FYGE.Sprite(RES.getRes("guidePropCow.png"));
        this.addChild(this.cow);

        this.msg = new GuideShowWord();
        this.msg.x = 250
        this.msg.y = 100;
        this.addChild(this.msg);
        this.cow.alpha = 0;
        this.bg.alpha = 0;
    }
    play(msg: string, callback: Function) {
        //重置
        this.cow.alpha = 0;
        this.bg.alpha = 0;
        this.cow.y = -200;
        this.msg.text = "";
        //动画
        FYGE.Tween.get(this.cow)
            .to({ y: 0, alpha: 1 }, 500, FYGE.Ease.backOut)
            .call(() => {
                //bg的透明度
                FYGE.Tween.get(this.bg)
                    .to({ alpha: 1 }, 300)
                    .call(() => {
                        //文字的播放
                        this.msg.play(msg, callback)
                    })
            })
    }
}

/**
 * 手势动效
 */
class HandAni extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("guidePropHand.png");
        this.anchorTexture.set()
        // this.anchorOffsetX = 60;
        // this.anchorOffsetY = 60;
        this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, () => {
            FYGE.Tween.removeTweens(this);
        }, this)
    }
    play() {
        this.rotation = 0;
        FYGE.Tween.removeTweens(this);
        FYGE.Tween.get(this, { loop: true })
            .to({ rotation: 30 }, 500)
            .to({ rotation: 0 }, 500)
            .wait(500)
    }
}

/**
 * 炸弹动效
 */
class BoomAni extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("guidePropBoom.png");
        this.anchorTexture.set()
        // this.anchorOffsetX = 60;
        // this.anchorOffsetY = 60;
        // this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, () => {
        //     FYGE.Tween.removeTweens(this);
        // }, this)
    }
    play() {
        this.scaleX = 1;
        this.scaleY = 1;
        FYGE.Tween.removeTweens(this);
        FYGE.Tween.get(this, { loop: true })
            .to({ scaleX: 0.91, scaleY: 0.91 }, 300)
            .to({ scaleX: 1.06, scaleY: 1.06 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .wait(150)
    }
    stop() {
        this.scaleX = 1;
        this.scaleY = 1;
        FYGE.Tween.removeTweens(this);
    }
}

/**
 * 锤子动效
 */
class HammerAni extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("guidePropHammer.png");
        this.anchorTexture.set()
        // this.anchorOffsetX = 60 + 24;
        // this.anchorOffsetY = 60 + 36;
        // this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, () => {
        //     FYGE.Tween.removeTweens(this);
        // }, this)
    }
    play() {
        this.x = 404;
        this.y = 1146;
        this.rotation = 0;
        FYGE.Tween.removeTweens(this);
        FYGE.Tween.get(this, { loop: true })
            .to({ x: 404 - 6, y: 1146 - 12 }, 100)
            .to({ x: 404, y: 1146 }, 100)
            .wait(300)
        FYGE.Tween.get(this, { loop: true })
            .to({ rotation: 17 }, 100)
            .to({ rotation: -21 }, 100)
            .to({ rotation: 4 }, 50)
            .wait(250)
    }
    stop() {
        this.rotation = 0;
        FYGE.Tween.removeTweens(this);
    }
}

/**
 * 鞋子动效
 */
class ShoeAni extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("guidePropShoe.png");
        this.anchorTexture.set(0.5, 50 / 109);
        // this.anchorOffsetX = 102 / 2;
        // this.anchorOffsetY = 100 / 2;
        this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, () => {
            FYGE.Tween.removeTweens(this);
        }, this)
    }
    play() {
        this.rotation = 0;
        this.x = 570;
        this.y = 1100;
        FYGE.Tween.removeTweens(this);
        FYGE.Tween.get(this, { loop: true })
            .set({ rotation: 0 })
            .to({ rotation: 11 }, 200)
            .to({ rotation: -3 }, 100)
            .to({ rotation: -8 }, 50)
            .wait(600)

        FYGE.Tween.get(this, { loop: true })
            .to({ x: 570 + 9, y: 1100 - 18 }, 200)
            .to({ x: 570, y: 1100 }, 100)
            .wait(650)

    }
}

/**
 * 文字一个一个出现
 */
class GuideShowWord extends FYGE.TextField {
    constructor() {
        super();
        this.size = 28;
        this.fillColor = "#c33700";
        this.width = 302;
        this.textAlign = FYGE.TEXT_ALIGN.LEFT;
        this.lineSpacing = 10;
        // this.verticalAlign = FYGE.VerticalAlign.MIDDLE;
        // this.height = 157;
    }
    /**
     * 这里是生命值，闯关失败后\n都会扣除一点生命值
     * @param text 
     */
    play(text: string, callback: Function) {
        var spiltStrs = text.split("\n");
        //拆分文本
        let strs: string[] = []
        for (var i = 0; i < spiltStrs.length; i++) {
            var spiltStr: string = spiltStrs[i];
            var ori: string = "";
            var index = 0;
            while (index < i) {
                ori += spiltStrs[index];
                ori += "\n";
                index++;
            }
            for (var j = 0; j < spiltStr.length; j++) {
                var str = "" + ori;
                str += spiltStr.substring(0, j + 1)
                strs.push(str)
            }
        }
        // console.log(strs)
        //轮流替换文本
        for (let m = 0; m < strs.length; m++) {
            let str = strs[m];
            setTimeout(() => {
                this.text = str;
                if (m == strs.length - 1) {
                    callback();
                }
            }, 100 * m)
        }
    }
}

