
import { Tool } from "../Tool";
import { RES } from "../../../module/RES";
import { PropType } from "../enum/PropType";
import { stepPosition } from "../anis/BonusShootAni";

/**
 * 道具使用引导，初始化一次，然后用init初始化
 * 185.58-67，1100-60
 * 375.5-67.5
 * 568.46-67.5
 */
export class PropGuide extends FYGE.Container {
    bg: FYGE.Shape;
    boomBtn: FYGE.Sprite;
    hammerBtn: FYGE.Sprite;
    stepBtn: FYGE.Sprite;
    msgTxt: FYGE.TextField;
    constructor(offsetY: number) {
        super()
        this.bg = new FYGE.Shape();
        this.addChild(this.bg);
        this.boomBtn = new FYGE.Sprite(RES.getRes("boomBtn.png"));
        this.boomBtn.x = 311;
        this.boomBtn.y = offsetY;
        this.addChild(this.boomBtn);
        this.hammerBtn = new FYGE.Sprite(RES.getRes("hammerBtn.png"));
        this.hammerBtn.x = 488;
        this.hammerBtn.y = offsetY;
        this.addChild(this.hammerBtn);
        this.stepBtn = new FYGE.Sprite(RES.getRes("stepBtn.png"));
        this.stepBtn.x = 100;
        this.stepBtn.y = offsetY;
        this.addChild(this.stepBtn);
        //再调
        var text: FYGE.TextField = new FYGE.TextField();
        text.text = "为本次增加额外5次步数";
        text.fillColor = "#ffffff";
        text.size = 20;
        text.x = (750 - 500) / 2;
        text.y = offsetY - 30;
        text.textAlign = FYGE.TEXT_ALIGN.CENTER;
        text.textWidth = 500;
        this.addChild(text);
        this.msgTxt = text;
    }
    init(prop: PropType) {
        if (prop == PropType.BOOMS) {
            this.boomBtn.visible = true;
            this.hammerBtn.visible = false;
            this.stepBtn.visible = false;
            this.setRect();
            this.msgTxt.text = "选择任意一个元素，它的横竖各一排消除";
            // this.msgTxt.x = (750-500)/2;
        }
        else if (prop == PropType.HAMMERS) {
            this.boomBtn.visible = false;
            this.hammerBtn.visible = true;
            this.stepBtn.visible = false;
            this.setRect();
            this.msgTxt.text = "选择任意一个元素即可消除";
            // this.msgTxt.x = (750-500)/2;
        }
        else {
            this.boomBtn.visible = false;
            this.hammerBtn.visible = false;
            this.stepBtn.visible = true;
            this.bg.clear();
            this.bg.beginFill(0x000000, 0.7)
            this.bg.moveTo(0, 0);
            this.bg.lineTo(0, 1624);
            this.bg.lineTo(750, 1624);
            this.bg.lineTo(750, 0);
            this.bg.lineTo(0, 0);
            this.bg.moveTo(stepPosition[0] + 50, stepPosition[1])
            this.bg.drawCircle(stepPosition[0], stepPosition[1], 50, false)
            this.bg.endFill();
            this.msgTxt.text = "点击上方步数，可为闯关时增加额外5次步数";
            // this.msgTxt.x = 320;
        }
    }

    setRect() {
        this.bg.clear();
        this.bg.beginFill(0x000000, 0.7)
        this.bg.moveTo(0, 0);
        this.bg.lineTo(750, 0);
        this.bg.lineTo(750, 1624);
        this.bg.lineTo(0, 1624);
        this.bg.lineTo(0, 0);
        this.bg.moveTo(Tool.offsetX, Tool.offsetY);
        this.bg.lineTo(Tool.offsetX, Tool.offsetY + Tool.height * Tool.rowNum);
        this.bg.lineTo(750 - Tool.offsetX, Tool.offsetY + Tool.height * Tool.rowNum);
        this.bg.lineTo(750 - Tool.offsetX, Tool.offsetY);
        this.bg.lineTo(Tool.offsetX, Tool.offsetY);
        this.bg.endFill();
    }
}