import { RES } from "../../../module/RES";

export class GameToast extends FYGE.Sprite {
    constructor(resName: string) {
        super(RES.getRes(resName));
        this.anchorTexture.set(0.5, 0.5);
    }
    /**
     * 
     * @param a 为了和lottie封的方法一致
     * @param callback 
     */
    play(a, callback: Function) {
        FYGE.Tween.removeTweens(this)
        this.scaleX = 0.1;
        this.scaleY = 0.1;
        this.alpha = 1;
        FYGE.Tween.get(this)
            .to({ scaleX: 1.1, scaleY: 1.1 }, 200/2)
            .to({ scaleX: 1, scaleY: 1 }, 200/2)
            .wait(700/2)
            .to({ alpha: 0 }, 200/2)
            .call(() => {
                callback();
            })
    }
}