import { ElementType } from "../enum/ElementType";

import { RES } from "../../../module/RES";

/**
 * 节日目标
 * 
 */
export class FestivalTarget extends FYGE.Container {
    /**
     * 打勾完成
     */
    zeroMark: FYGE.Sprite;
    /**
     * 数量文案
     */
    private countNum: FYGE.BitmapText;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            this.countNum.visible = false;
            this.zeroMark.visible = true;
        }
        this._count = value;
        this.countNum.text = "" + value;
    }
    constructor(count: number = 6) {
        super()
        var texture: FYGE.Texture = RES.getRes("festivalTargetBg.png");
        var showImage = new FYGE.Sprite(texture);
        this.addChild(showImage);
        var texture: FYGE.Texture = RES.getRes("rightMark.png");
        this.zeroMark = new FYGE.Sprite(texture);
        this.zeroMark.x = 23;
        this.zeroMark.y = 50;
        this.zeroMark.visible = false;
        this.addChild(this.zeroMark);
        this.countNum = new FYGE.BitmapText({});//文本待定
        this.countNum.x = 40;
        this.countNum.y = 60;
        this.addChild(this.countNum);

        this.count = count;
    }
}