import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";


/**
 * 通关目标是多个元素时的ui
 * 
 */
export class ElementTargets extends FYGE.Container {
    targets: ElementTarget[];
    constructor(passElement: number[]) {
        super()
        this.targets = [];
        for (var i = 0; i < passElement.length; i++) {
            if (passElement[i]) {
                var eleTar: ElementTarget = new ElementTarget(i);
                eleTar.count = passElement[i];
                this.addChild(eleTar);
                this.targets[i] = eleTar;
            }
        }
        this.center()
    }

    center() {
        //按顺序排，从右到左，
        var len = this.children.length;
        var w = 80 * 0.8;
        var space = 25
        var right = len / 2 * w - w + (len - 1) / 2 * space;
        for (var i = this.children.length - 1; i >= 0; i--) {
            this.children[i].x = right - w * i - space * i;
        }
    }
}


/**
 * 通关目标是元素时的单个元素的ui
 * 
 */
class ElementTarget extends FYGE.Container {
    /**
     * 元素类型
     */
    type: ElementType;
    /**
     * 打勾完成
     */
    zeroMark: FYGE.Sprite;
    /**
     * 数量文案
     */
    private countNum: FYGE.BitmapText;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            this.countNum.visible = false;
            this.zeroMark.visible = true;
        }
        this._count = value;
        this.countNum.text = "" + value;
    }
    constructor(type: ElementType) {
        super()
        var texture: FYGE.Texture = RES.getRes("ele" + type + ".png");
        var showImage = new FYGE.Sprite(texture);
        showImage.scaleX = showImage.scaleY = 0.7
        this.addChild(showImage);
        var texture: FYGE.Texture = RES.getRes("rightMark.png");
        this.zeroMark = new FYGE.Sprite(texture);
        this.zeroMark.x = 35-10;
        this.zeroMark.y = 35-10;
        this.zeroMark.visible = false;
        this.addChild(this.zeroMark);
        this.countNum = new FYGE.BitmapText(Tools.getNumTextures("tarNum"));//文字待定
        this.countNum.x = 55-10;
        this.countNum.y = 45-10;
        this.addChild(this.countNum);
    }
}