
import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";

/**
 * 褐色帽绣毛球状态
 * 分裂动画都在外面单独掉
 */
export class HairballBrownState extends State {
    private showImage: FYGE.Sprite;
    /**
     * 是否激活
     */
    isActive: boolean;
    constructor() {
        super();
        var texture: FYGE.Texture = RES.getRes("ele" + ElementType.HAIRBALLBROWN + ".png")
        this.showImage = new FYGE.Sprite(texture);
        this.addChild(this.showImage);
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2;
        this.isActive = false;
    }
    reset() {
        this.isActive = false;
    }
    recover() {
        if (this.parent) this.parent.removeChild(this);
        Pool.recover(RecoverName.HAIRBALLBROWN_STATE, this);
    }

    private changeSource(source: string) {
        var texture: FYGE.Texture = RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2
    }
}
