

import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";

/**
 * 变色气泡状态
 * 变色动画放外面
 */
export class BubbleState extends State {
    /**
     * 显示图片
     */
    private showImage: FYGE.Sprite;

    constructor(type: ElementType) {
        super();
        this.showImage = new FYGE.Sprite();
        this.changeSource("bubleEle" + type + ".png");
        this.addChild(this.showImage);
    }

    //重置为指定的类型，直接设置。没有过度动效
    reset(type: ElementType) {
        this.changeSource("bubleEle" + type + ".png");
    }
    //直接回收
    recover() {
        if (this.parent) this.parent.removeChild(this);
        Pool.recover(RecoverName.BUBBLE_STATE, this);
    }

    private changeSource(source: string) {
        var texture: FYGE.Texture = RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2
    }
}
