import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 21到40关数据
 */
export const Chapters2: ChapterData[] = [
    //21
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 56
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 0, 0, 0, 1, 1, 1,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    //22
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ROCK,
                    count: 40
                },
                {
                    type: ElementType.CHICKEN,
                    count: 50
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                2, 2, 1, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 1, 2, 2
            ],
            baseElements: [
                0, 0, 31, 0, 24, 0, 31, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 31, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
                2, 2, 30, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 30, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 30, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 30, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 30, 2, 2
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[2, 21], [4, 22], [6, 23]]
        },
    },
    //23
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.LOLLIPOP,
                    count: 12
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 10, 2, 30, 2, 20, 2, 10, 0,
                0, 30, 2, 30, 2, 20, 2, 10, 0,
                0, 20, 2, 20, 2, 10, 2, 30, 0,
                0, 10, 2, 20, 2, 10, 2, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                40, 40, 50, 40, 50, 40, 50, 40, 40,
                0, 50, 40, 50, 40, 50, 40, 50, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 67, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 70, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
            recycles: [46, 47, 48, 49, 50, 51, 52]
        },
    },
    //24
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 31
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 2, 2, 1, 0, 3, 3, 3,
                2, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
            ],
            elements: [
                1, 0, 2, 2, 2, 0, 2, 0, 2,
                1, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            baseElements: [
                11, 0, 2, 2, 2, 0, 2, 0, 2,
                23, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [33] },
                { index: 3, type: [0], cus: [21] },
                { index: 4, type: [0], cus: [] },
            ],
            connectedLats: [[2, 29], [3, 30], [4, 31], [74, 6], [75, 7], [76, 8]]
        },
    },
    //25
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.RABBIT,
                    count: 42
                },
                {
                    type: ElementType.CHICKEN,
                    count: 42
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                4, 4, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
            ],
            baseElements: [
                12, 13, 20, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                33, 32, 0, 10, 20, 10, 20, 10, 20,
                32, 41, 0, 20, 10, 20, 10, 20, 10,
                42, 23, 0, 10, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },

                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },

                { index: 30, type: [0], cus: [] },
                { index: 31, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },

                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },

                { index: 48, type: [0], cus: [] },
                { index: 49, type: [0], cus: [] },
                { index: 50, type: [0], cus: [] },
                { index: 51, type: [0], cus: [] },
                { index: 52, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    //26
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 5,
                    count: 8
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 4, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 31, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 4, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    //27
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 48
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 0, 1, 1, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 1, 3, 3, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
            ],
            elements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 1, 0, 0, 1, 0, 0, 1, 2,
                1, 2, 1, 0, 1, 0, 1, 2, 1,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    //28
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 25
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 4, 4, 4, 4, 4, 4, 4, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    //29
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 21
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 1, 1, 3, 1, 2, 1, 2, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 3, 1, 1, 1, 1, 1, 2, 1,
                1, 3, 3, 3, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 4, 1, 4, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 42, 0, 32, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 23, 0, 12, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 9, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    //30
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 7
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 0, 1, 0, 1, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                3, 0, 3, 0, 3, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 75, 76, 77, 78, 79]
        },
    },
    //31
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
            ],
            elements: [
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 4, 4, 1, 4, 4, 0, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                30, 20, 30, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 50, 50, 40, 50, 50, 0, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 2, 2, 2, 50, 2, 2, 2, 1,
                1, 1, 2, 2, 40, 2, 2, 1, 1,
                1, 1, 2, 2, 44, 2, 2, 1, 1,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //32
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 66
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 1, 0, 1, 0, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                50, 50, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                53, 42, 0, 32, 0, 32, 0, 32, 0,
            ],
            generateLats: [
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //33
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 6
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 1, 1, 1,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                3, 3, 3, 0, 4, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 20, 30, 50, 50, 20,
                0, 0, 0, 0, 30, 20, 30, 20, 30,
                3, 3, 3, 0, 20, 30, 20, 30, 20,
                21, 31, 42, 0, 52, 20, 30, 20, 30,
                20, 31, 41, 0, 51, 30, 20, 30, 20
            ],
            generateLats: [
                { index: 54, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
            ],
            recycles: [80, 76, 77, 78, 79],
            connectedLats: [[72, 5], [73, 6], [74, 7]]
        },

    },
    //34
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 64
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
            ],
            elements: [
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                1, 1, 4, 1, 2, 2, 2, 2, 4,
                4, 1, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
            ],
            baseElements: [
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                40, 30, 41, 23, 2, 2, 2, 2, 0,
                4, 40, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
            ],
        },
    },
    //35
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 27,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 70 }]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 3, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 2, 2, 2, 2, 2, 2, 2, 1
            ],
            connectedLats: [[31, 49], [32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                1, 1, 1, 1, 4, 2, 4, 2, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 11, 30, 30, 22, 52, 51, 41, 12,
                20, 11, 30, 30, 0, 10, 0, 20, 0,
                11, 40, 0, 0, 30, 0, 30, 0, 30,
                40, 11, 0, 0, 0, 10, 0, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
            ],
        }
    },
    //36
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 16 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0],
            connectedLats: [[29, 47], [33, 51], [39, 46], [41, 52], [28, 57], [34, 59]],
            elements: [
                1, 4, 2, 3, 3, 3, 2, 4, 4,
                1, 4, 2, 3, 3, 3, 2, 4, 2,
                1, 4, 2, 3, 1, 3, 2, 4, 4,
                1, 4, 2, 1, 3, 1, 2, 4, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [20, 0, 30, 30, 22, 52, 51, 0, 12, 20, 0, 30, 30, 0, 10, 0, 0, 0, 11, 0, 0, 0, 10, 0, 30, 0, 30, 40, 0, 0, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null }
            ]
        }
    },
    //37
    {
        baseElementTypes: [2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 22 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1
            ],
            connectedLats: [[80, 3], [79, 2], [78, 1], [77, 0]],
            elements: [
                3, 3, 3, 3, 0, 0, 0, 0, 0,
                3, 3, 3, 3, 0, 0, 2, 2, 0,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 20, 30, 20, 0, 0, 0, 0, 11,
                20, 30, 20, 30, 0, 0, 0, 0, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 41,
                10, 40, 40, 10, 0, 0, 0, 0, 43,
                30, 50, 50, 30, 0, 0, 0, 0, 41,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [63, 64, 65, 66],
            generateLats: [{ index: 15, type: 0 }, { index: 16, type: 0 }]
        }
    },
    //38
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 5, count: 12 }]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                0, 0, 0, 2, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 30, 50, 20, 30,
                0, 0, 0, 0, 0, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 20, 50, 20, 50,
                0, 0, 0, 0, 0, 12, 30, 12, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 20, 50, 50, 0, 10, 50, 10, 50,
                0, 0, 0, 0, 0, 20, 30, 30, 10,
                10, 10, 20, 20, 0, 10, 20, 20, 10,
                0, 0, 0, 0, 0, 30, 20, 30, 30
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 }
            ]
        }
    },
    //39
    {
        baseElementTypes: [3, 2, 1, 0, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 56 }]
        },
        starScores: [6000, 14000, 25000],
        map: {
            lattices: [2, 0, 2, 0, 2, 2, 0, 2, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 2],
            connectedLats: [],
            elements: [
                1, 0, 2, 0, 2, 1, 0, 1, 0,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                0, 0, 2, 0, 2, 4, 4, 4, 4,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                1, 0, 0, 0, 0, 0, 1, 0, 1
            ],
            baseElements: [
                41, 0, 0, 0, 0, 42, 0, 42, 0,
                0, 0, 40, 0, 40, 0, 0, 0, 0,
                0, 40, 0, 40, 0, 10, 10, 20, 20, 0, 0, 40, 0, 40, 50, 30, 30, 42, 0, 41, 0, 40, 0, 20, 20, 30, 10, 0, 0, 40, 0, 0, 30, 50, 50, 40, 0, 40, 0, 40, 0, 30, 50, 50, 40, 0, 0, 40, 0, 40, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 42, 0, 41],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 2, type: 0, cus: [14] },
                { index: 4, type: 0, cus: [14] },
                { index: 5, type: 0 },
                { index: 7, type: 0 },
                { index: 26, type: 0 },
                { index: 25, type: 0 },
                { index: 24, type: 0 },
                { index: 72, type: 0 },
                { index: 78, type: 0 },
                { index: 80, type: 0 }]
        }
    },
    //40
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 54 }]
        },
        starScores: [6000, 15000, 23000],
        map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 0],
            baseElements: [11, 22, 12, 22, 12, 22, 12, 22, 11, 12, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 10, 40, 0, 0, 0, 0, 0, 40, 10, 20, 40, 50, 0, 0, 0, 50, 40, 20, 20, 30, 50, 10, 0, 10, 50, 30, 20, 0, 30, 30, 10, 20, 10, 30, 30, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 20, type: 0, cus: [14, 14, 14, 14] },
                { index: 21, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 23, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 24, type: 0, cus: [14, 14, 14, 14] },
                { index: 28, type: 0, cus: [14, 14] },
                { index: 31, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 34, type: 0, cus: [14, 14] },
                { index: 36, type: 0 },
                { index: 44, type: 0 }
            ]
        }
    },
]