import { Lattice } from "../class/Lattice";
import { Tool } from "../Tool";
import { RES } from "../../../module/RES";


const whiteRectPool: WhiteRect[] = []
/**
 * 格子波纹的动画
 * @param lattices 
 * @param container 
 * @param callback 
 */
export function RectsWaveAni(
    lattices: Lattice[],
    container: FYGE.Container,
    callback?: Function,
    centerIndex: number = 40,
) {
    var loops: WhiteRect[][] = [];
    var rc = Tool.indexToRc(centerIndex);
    //格子间距  0到最大的格子
    var num = 0;
    var maxNum = Math.max(rc[0], rc[1], Tool.rowNum - rc[0] - 1, Tool.colNum - rc[1] - 1)
    //所有格子都填上
    while (num <= maxNum) {
        //每一圈所有格子索引
        var indexs: number[] = [];

        if (num) {

            var rowMax = rc[0] + num;
            var rowMin = rc[0] - num;
            var colMax = rc[1] + num;
            var colMin = rc[1] - num;



            var colIndexs = rangeIndexs(
                colMin >= 0 ? colMin : 0,
                colMax < Tool.colNum ? colMax : Tool.colNum - 1
            )
            var rowIndexs = rangeIndexs(
                rowMin >= 0 ? rowMin : 0,
                rowMax < Tool.rowNum ? rowMax : Tool.rowNum - 1,
                false
            )
            //上排，行数一致，列数在之内
            if (rowMin >= 0) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool.rcToIndex(rowMin, colIndexs[i]);
                    if (lattices[index]) indexs.push(index)
                }
            }
            //下排
            if (rowMax < Tool.rowNum) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool.rcToIndex(rowMax, colIndexs[i]);
                    if (lattices[index]) indexs.push(index)
                }
            }
            //左边
            if (colMin >= 0) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool.rcToIndex(rowIndexs[i], colMin);
                    if (lattices[index]) indexs.push(index)
                }
            }
            //右边
            if (colMax < Tool.colNum) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool.rcToIndex(rowIndexs[i], colMax);
                    if (lattices[index]) indexs.push(index)
                }
            }
        } else {
            indexs.push(centerIndex)
        }
        var loop = []
        //根据索引
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var p = Tool.getPositionByIndex(index);
            let rect = whiteRectPool.shift();
            if (!rect) rect = new WhiteRect();
            rect.alpha = 0;
            rect.x = p[0];
            rect.y = p[1];
            container.addChild(rect);
            loop.push(rect);
        }
        //总
        loops.push(loop);
        // console.log(indexs)

        num++;
    }
    //删除外层空loop
    for (let m = loops.length - 1; m >= 0; m--) {
        if (!loops[m].length) {
            loops.pop();
        } else {
            break
        }
    }
    //动画
    let loopsLen = loops.length
    for (let m = 0; m < loops.length; m++) {
        let loop = loops[m];
        let wait = m * 100;
        let loopLen = loop.length;
        for (let n = 0; n < loop.length; n++) {
            let rect = loop[n];
            FYGE.Tween.get(rect)
                .wait(wait)
                .to({ alpha: 1 }, 150)
                .to({ alpha: 0 }, 150)
                .call(() => {
                    //回收
                    if (rect.parent) {
                        rect.parent.removeChild(rect);
                        whiteRectPool.push(rect);
                    }
                    if (m == loopsLen - 1 && n == loopLen - 1 && callback) callback();
                })
        }
    }
}

class WhiteRect extends FYGE.Sprite {
    constructor() {
        super();
        var texture: FYGE.Texture = RES.getRes("rectLatWhite.png");
        this.texture = texture;
        this.anchorTexture.set(0.5, 0.5);
        // this.anchorOffsetX = texture.textureWidth / 2;
        // this.anchorOffsetY = texture.textureHeight / 2;
    }
}


function rangeIndexs(min: number, max: number, include: boolean = true) {
    var nums = [];
    if (include) nums.push(min);
    var num: number = min;
    while (++num < max) nums.push(num);
    if (include) nums.push(max);
    return nums
}
