import { Ani } from "../class/Ani";
import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

export class VerticalAni extends Ani {


    showImage: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.VERTICAL_ANI// "VerticalAni";
        this.showImage = new FYGE.Sprite(RES.getRes("lineLight.png"));
        this.addChild(this.showImage);
        this.showImage.anchorTexture.set(0.5, 0.5);
        // this.showImage.anchorOffsetX = 147 / 2;
        // this.showImage.anchorOffsetY = 690;
        // this.showImage.x = -147 / 2;
        // this.showImage.y = -690;
        this.showImage.scaleY = 0.1;
        // this.showImage.rotation = 90;
    }

    play() {
        // this.reset();
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(() => {
                this.recover();
            })
    }


}