import { Ani } from "../class/Ani";
import { Tool } from "../Tool";
import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

export class ThreeCrossAni extends Ani {


    //横
    showImage1: FYGE.Sprite;
    showImage2: FYGE.Sprite;
    showImage3: FYGE.Sprite;

    //竖
    showImage4: FYGE.Sprite;
    showImage5: FYGE.Sprite;
    showImage6: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.THREECROSS_ANI//"ThreeCrossAni";
        for (var i = 1; i < 4; i++) {
            var showImage = new FYGE.Sprite(RES.getRes("lineLight.png"));
            this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            // showImage.anchorOffsetX = 147 / 2;
            // showImage.anchorOffsetY = 690;
            showImage.x = (i - 2) * Tool.height;
            showImage.scaleY = 0.1;
            this["showImage" + i] = showImage
        }
        for (var i = 4; i < 7; i++) {
            var showImage = new FYGE.Sprite(RES.getRes("lineLight.png"));
            this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            // showImage.anchorOffsetX = 147 / 2;
            // showImage.anchorOffsetY = 690;
            showImage.y = (i - 5) * Tool.width;
            showImage.scaleY = 0.1;
            showImage.rotation = 90;
            this["showImage" + i] = showImage;
        }
    }

    play() {
        // this.reset();
        for (var i = 1; i < 7; i++) {
            this["showImage" + i].scaleY = 0.1;
            this["showImage" + i].alpha = 1;
            if (i == 6) {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100)
                    .call(() => {
                        this.recover();
                    })
            } else {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100)
            }

        }
    }

    //去掉边缘的，考虑在哪写


}