import { Ani } from "../class/Ani";
import { RecoverName } from "../enum/RecoverName";
/**
 * 分数的动效，
 * 但是这里面需要记录分数
 */
export class ScoreAni extends Ani {
    scoreNumber: FYGE.BitmapText;
    private _score: number;
    get score(): number {
        return this._score
    }
    set score(value: number) {
        if (this._score == value) return;
        this._score = value;
        this.scoreNumber.text =""+ value;
    }
    constructor() {
        super();
        this.aniName = RecoverName.SCORE_ANI//"ScoreAni";
        this.scoreNumber = new FYGE.BitmapText({});
        this.addChild(this.scoreNumber)
    }
    play() {
        // this.reset();
        this.scoreNumber.y = 0;
        this.scoreNumber.alpha = 1;
        FYGE.Tween.get(this.scoreNumber)
            .to({ y: -50, alpha: 0 }, 1000)
            .call(() => {
                this.recover();
            })
    }
}