import { Ani } from "../class/Ani";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

export class JellyDisAni extends Ani {
    showImage: FYGE.Sprite;
    downCircle: FYGE.Sprite;
    upCircle: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.JELLYDIS_ANI// "JellyDisAni";

        var arr = ["ele" + ElementType.JELLY + ".png", "greenCircleDown.png", "greenCircleUp.png"];
        var objs = ["showImage", "downCircle", "upCircle"];

        for (var i = 0; i < arr.length; i++) {
            var texture: FYGE.Texture = RES.getRes(arr[i])
            var obj = new FYGE.Sprite(texture);
            this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            // obj.anchorOffsetX = texture.textureWidth / 2;
            // obj.anchorOffsetY = texture.textureHeight / 2;
            this[objs[i]] = obj;
        }
    }

    play() {

        FYGE.Tween.get(this.showImage)
            .set({ alpha: 1 })
            .to({ alpha: 0 }, 250 * 1.5)

        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300 * 1.5, FYGE.Ease.cubicOut)
            .call(() => {
                this.recover();
            })

        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140 * 1.5)
            .to({ alpha: 0 }, 160 * 1.5);

        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70 * 1.5)
            .to({ scaleX: 1, scaleY: 1 }, 160 * 1.5, FYGE.Ease.cubicOut);

        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170 * 1.5)
            .to({ alpha: 0 }, 100 * 1.5);

    }


}