
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { Element } from "../class/Element";
import { StateType } from "../enum/StateType";
import { RES } from "../../../module/RES";



/**
 * 需要回调的
 * 
 */
export class HairballJumpAni extends FYGE.Sprite {
    constructor() {
        super()
    }

    play(type: StateType, startP: number[], endP: number[], callback: Function) {
        var source: string;
        switch (type) {
            case StateType.HAIRBALLBLACK:
                source = "ele" + ElementType.HAIRBALLBLACK + ".png";
                break;
            case StateType.HAIRBALLGREY:
                source = "ele" + ElementType.HAIRBALLGREY + ".png";
                break;
            case StateType.HAIRBALLBROWN:
                source = "ele" + ElementType.HAIRBALLBROWN + ".png";
                break;
            default:
                source = "ele" + ElementType.HAIRBALLGREY + ".png";
                break
        }
        var texture: FYGE.Texture = RES.getRes(source)
        this.texture = texture;
        this.anchorTexture.set(0.5, 1)
        // this.anchorOffsetX = texture.textureWidth / 2;
        // this.anchorOffsetY = texture.textureHeight;

        this.x = startP[0];
        this.y = startP[1] + texture.height / 2;

        FYGE.Tween.get(this)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .call(() => {
                //回收元素
                if (this.parent) this.parent.removeChild(this);
                Pool.recover(RecoverName.HAIRBALLJUMP_ANI, this)
                //回调
                callback();
            })
        FYGE.Tween.get(this)
            .to({ x: endP[0], y: endP[1] + texture.height / 2 }, 300, FYGE.Ease.sineInOut)
    }
}