import { Ani } from "../class/Ani";
import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

const offsetX = 91 / 2;
const offsetY = 62 / 2;

export class EggBrokenAni extends Ani {

    downCircle: FYGE.Sprite;
    upCircle: FYGE.Sprite;
    eggPiece1: FYGE.Sprite;
    eggPiece2: FYGE.Sprite;
    eggPiece3: FYGE.Sprite;
    eggPiece4: FYGE.Sprite;
    eggPiece5: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.EGGBROKEN_ANI;

        var arr = ["yellowCircleDown.png", "yellowCircleUp.png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["downCircle", "upCircle", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];

        for (var i = 0; i < arr.length; i++) {
            var texture: FYGE.Texture = RES.getRes(arr[i])
            var obj = new FYGE.Sprite(texture);
            this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            this[objs[i]] = obj;
        }
    }

    play() {
        this.alpha = 1;
        //黄色圈下
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300, FYGE.Ease.cubicOut)
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140)
            .to({ alpha: 0 }, 160);
        //黄色圈上
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70)
            .to({ scaleX: 1, scaleY: 1 }, 160, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170)
            .to({ alpha: 0 }, 100);
        //下面所有的蛋壳碎片
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY })
            .to({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY })
            .to({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY })
            .to({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY })
            .to({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY })
            .to({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 }, 400);

        //整体透明度
        FYGE.Tween.get(this)
            .wait(250)
            .to({ alpha: 0 }, 150)
            .call(() => {
                this.recover();
            })


    }


}