import { Ani } from "../class/Ani";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";

export class CrossAni extends Ani {


    showImage: FYGE.Sprite;
    showImage2: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.CROSS_ANI;
        this.showImage = new FYGE.Sprite(RES.getRes("lineLight.png"));
        this.addChild(this.showImage);
        this.showImage.anchorTexture.set(0.5, 0.5);
        this.showImage.scaleY = 0.1;

        this.showImage2 = new FYGE.Sprite(RES.getRes("lineLight.png"));
        this.addChild(this.showImage2);
        this.showImage2.anchorTexture.set(0.5, 0.5);
        this.showImage2.scaleY = 0.1;
        this.showImage2.rotation = 90;
    }

    play() {
        // this.reset();
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        this.showImage2.scaleY = 0.1;
        this.showImage2.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)

        FYGE.Tween.get(this.showImage2)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(() => {
                this.recover();
            })
    }


}