import { RecoverName } from "./enum/RecoverName";

/**
 * 其实有地方做过，但是算了，原来逻辑不想改
 * name只用枚举过的取
 */
export class Pool {
    private static pool = {};

    /**
     * 取出
     * @param name 
     */
    public static takeOut(name: RecoverName) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return null;
    }

    /**
     * 回收
     * @param name 
     * @param obj 
     */
    public static recover(name: RecoverName, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    }
}