import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;
import FrameAni = FYGE.FrameAni;
import Texture = FYGE.Texture;

export default class MapBottom extends MapPart {

    public static HEIGHT = 1092;

    protected totalCount = 8;

    private crabAni: FrameAni = null;

    protected btnPos = [
        [370, 930],
        [437, 761],
        [313, 669],
        [408, 522],
        [455, 375],
        [364, 216],
        [326, 62],
        [491, 3],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg1.jpg');
        this.initIcon();
        this.initEffect();
    }

    private initEffect() {
        // 螃蟹
        const crabTextures: Texture[] = new Array(31);
        for (let i = 0; i < 16; i++) {
            crabTextures[31 - i] = crabTextures[i] = RES.getRes(`map_crab_${i}.png`);
        }

        this.crabAni = this.addChild(new FrameAni(crabTextures));
        this.crabAni.position.set(220, 50);
        this.crabAni.play(-1);
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    }

    public destroy() {
        super.destroy();
    }

}
