import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";

const msgData: LoopMsgData[] = [
    {
        "name": "熊祉妍",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8xbXm84vHkuOHRIvmIGvCZevmvLvkZevkQYPH*-MFHT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "cyh1256197578",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MmvLOmgSXmkYMmNuv8RIPCxWPm--MkcbMmvGXmkyMH8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "柠檬爱帮鱼洗21",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MkQGvHxLM0kGMkQWPFQ4vmcbOFMIvFlhOFkuMmHuvHkT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "libing199155",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8RhvGH0vmk0vFIWvmQGO8xYMm-IMCvYvFQGvCHyXFIT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "依然missing",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyPGRePHRIXmcSvH7IvCZ-vCkT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "tb_8100956",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyPGNyPHlHMHlIvFQWMmHGMF8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "jl19980921",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MFkSM88LP88WM8kSvFPhXF9zX8cYPm*hMkQGvk8uv8gT&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "tb5790247",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8cYPG*IXmkLPk7zPCNLPCxWO8kuPGMzXmQ0PF9IXmQT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "justlove佳佳",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyP08bPkZzPGgLXmk4XFvGPHcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "shenxiaoyu00",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyP0xyMG*IvFPHXmkWMFHWXFgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "台风雨飘摇sos哀",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vCNbP8kYM8xLXmMevkQbvmhzO8kyXHRHPmQWMHcbPmHT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "mwj051213",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8RhvGH0vmk0vFIWvmQGO8QyXHc0MGNLPHQWPH84vmQT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "一米阳光4233",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MmHGMk8uPFP-OmHbvCv4MG80XFRHPFlHMmQYvC7ePmkT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "z梦城堡",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Pm7HM0ZHvG80vGZ-vFIbMk7IPCcWMmcGvCZeMC-IMC8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "青清妍",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vmN4MC7zMkPHMmQSPk8WO8RhvHcbPFx4MmxLM0QuMkxT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "黄露露12322",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8cSXF9hXm9hXFMhvC9IPG8bM8gGv8cYvkk4PHPHPmkT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "空城空心空记忆0722",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Pk*eP8RHMCNLMGgyMk*hMHPzXFx0MmNLP8RHO8x4XFgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "薄言采薇草",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PChhvGkbOmRzvC84OmHLXHxSPCI4vkQSOmkuXmkyvmcT&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "猪猪猪妹222",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P0gYv8QuPCRHMmN4OFZeMmR-M88uvFgGvGcLXFcyvCgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "zoexuqian",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyPGI4P8cLvG7-vCRhM8lHOm8T&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "春暖花开loveing",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8l-vC7-PGkGXmkLPGxLvkx0vmv4PFMeXFcuPm8YMm8T&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "雨季kk3",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8lIM8lHMG7-v07Ivm*hOFHuX8k4vkkbMCvuMm9hvmgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "tb25358321",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8*Hv0Q0vmgyMkkYMFhhvCxSXmkLM0cGMmv0XFxGPH8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "李小贱259758",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Mk8WMmZzvFcYv8c0Pk*-P0Z-XHR-PCk4O8xWM0kYMH8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "布偶傻妞",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OH7zX8QSvHQSOmlevFQYPkQbPCguMH84M0P-MFQYPGNT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "不变的承诺3344",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PCQuMkPIXmx4vCv4vkZzO8xGX88LO88yX8gbM0cuMmcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "justlove佳佳",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGH0XmQGOFNWMCQyP08bPkZzPGgLXmk4XFvGPHcT&width=80&height=80&type=sns",
        "prize": "玩具礼包"
    },
    {
        "name": "tb537244358",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFvSvGcLM0PzP8RHMGZhMG-eMHR-v8*-P8xyOFPevFcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "凤小高的高小凤",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OFhhPCIYMFleO8*IXHQbvG*hX8gSXmIGvHc0XmQyvCgT&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "qingli13",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFZ-vmvuMk8SvCvGPmZIvGNGMkZ-OFQSvCIyPFQyXHgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "陈格7788",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Pm7HM0ZHvG80vGZ-vFIbMkkGvmlIMkkuv8gLXFguvCNT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "miss糖玥玥",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Mmk4vCQSvm7IOHRHPHcLvGgyMH8bP0R-v0gGvkxLMmvT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "柠檬爱帮鱼洗21",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MkQGvHxLM0kGMkQWPFQ4vmcbOFMIvFlhOFkuMmHuvHkT&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "李丹920623",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vH7HXF9Hv0gGvFP-MkZePFH4PFvGvmQyvHQLOHx0vCkT&width=80&height=80&type=sns",
        "prize": "云柔巾108抽*6包"
    },
    {
        "name": "b15071094383",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vCHSO8kLvCQSOHg4vGIuvCISv0guOm9HvFlHvm-HvFvT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "tb76435252",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OFHyvH7ePG8yOFxyMH8GPGcLvGgSvCcbvkP-MmNYMmHT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "xuan14740553370",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8*Hv0Q0vmgyMkkYMFhhvCMzOmQGPCgWM0QyvGNYv0cT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "么么碗",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Pk84PFvuOm*zv8QuPHkYX88YOF8bOHkLOF8bXFQSPmcT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "浅浅一笑暖人心1",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=XFRHPCg0XmkWOmP-vk*zvHxYOHc0O8lzPFQLPGkuOHQT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "lixiang_201212345",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P0gYv8QuPCRHMmN4OFZeMmMhPChePH8GPmHYOFP-XmcT&width=80&height=80&type=sns",
        "prize": "玩具礼包"
    },
    {
        "name": "ever夏夜",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PChhvGkbOmRzvC84OmHLXmILMmQGMGNyMFZePmQuvFvT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "silentme000",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8RhvGH0vmk0vFIWvmQGOF7hPFlIMCQ0MFguvC-IPC8T&width=80&height=80&type=sns",
        "prize": "云柔巾108抽*6包"
    },
    {
        "name": "zhaoyujing20",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8xbXm84vHkuOHRIvmIGvC7-PF-eOm-hvC9Hv0gLP08T&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "lixiaoling3100",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vFHbMm8SPFPHPFRHPG7HPmQYvCvbXFhHvmPHvCcLvFcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*1包"
    },
    {
        "name": "爱格轩",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OFhhPCIYMFleO8*IXHQbvGcWO87hvF*HPGPHOmhzXm8T&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "7766dan",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MGgyPF*HXmlePmQ4PCHuvmlHX8ZhPFIWPCQWvF7zMmkT&width=80&height=80&type=sns",
        "prize": "洗护礼包"
    },
    {
        "name": "叶鹏0503",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=M0RHOmMHv8xbMFguvFRIP0QYMkcYPCxyMG7-X8xLMHxT&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "潘妤婷t",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MkxGPFl-MCIbP0*eM8xyvHPIXHZhXHg4vG--PFHbPGNT&width=80&height=80&type=sns",
        "prize": "玩具礼包"
    },
    {
        "name": "tb502707_00",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MCMHXHk0MCgLMC7-v87HPC-ePG*IPFheM8cWMGvWMF8T&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "synran",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8cYPG*IXmkLPk7zPCNLPCxYMFHuO8k4OFkLO8l-vFgT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "ever夏夜",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PChhvGkbOmRzvC84OmHLXmILMmQGMGNyMFZePmQuvFvT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "zyf20080701",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vH8LMGQyOH80OmxSvGNGMCgYOF7Hv8ZIXF8uPCPhM08T&width=80&height=80&type=sns",
        "prize": "出行礼包"
    },
    {
        "name": "还是如此60586804",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MGgyPF*HXmlePmQ4PCHuvmhIvFMIPmHuMC-zMG-HPCQT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "不二兔子33",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vCgbPkx0MHg0XHgSOmIWMmvLMHRhvGhHXFQLM0RzMCvT&width=80&height=80&type=sns",
        "prize": "玩具礼包"
    },
    {
        "name": "tb3882885",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=O8xbXm84vHkuOHRIvmIGvCN0XFI4vFgGMHxyMmgbPmkT&width=80&height=80&type=sns",
        "prize": "云柔巾108抽*6包"
    },
    {
        "name": "yan昕瑶",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MkxGPFl-MCIbP0*eM8xyvmQ0XHxGMCQyPFkYPGI0P0gT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "越多多",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MmxWXFRhP0levCvbvkQSvWTT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "五弦务虚",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PH84XHxGvm7zM0xLMGlHPGvuOHlHMGIWvGk0MH7ePkcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "44cmpxbm",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Mmk4vCQSvm7IOHRHPHcLv0P-MkQSPm7hvF*hv0ZIMHQT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "dandan丹崽",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OmNuMm9evkgGvkkGvkk0PCQbPGQbv0kSvk7zMmQGOFgT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "jiandiwen",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vGZhv8*-vkk0MGZHMmvbvkc4XmvWPmPzMFQWPCv4MmgT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "meizi052",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8cYPG*IXmkLPk7zPCNLPCHLPmxGMkQLMG*HvmlzOH8T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "梓昕刘",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=Pk*HOFxSPCNGOHgyX8R-M0gSXm8WMF8bOF9zvGN0vCQT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "侯晓宇59025",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=OmNuMm9evkgGvkkGvkk0Pk*-MGgSMCgWXHPhPFHbMCcT&width=80&height=80&type=sns",
        "prize": "玩具礼包"
    },
    {
        "name": "zhangjinxue99",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MCleXFvGM8ZIMm7HX8RHvFcbMGk4O8cYPkRhP8*hPmHT&width=80&height=80&type=sns",
        "prize": "棉柔巾100抽*6包"
    },
    {
        "name": "toug凯凯",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=PCPIXH7evC7ePm9hMG*IP0ZePFZ-MF8bvF9ePFcWPkcT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "新晨的雨",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8cYPG*IXmkLPk7zPCNLPCHGPGkLMFHGPFk4P8gyv08T&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "采aini",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=vF8WOmIuOHZzvCMePCl-OFxuvHlePGgLPGxSvFkyvCgT&width=80&height=80&type=sns",
        "prize": "紫盖湿巾80抽*3包"
    },
    {
        "name": "遛遛看看16",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P8cYPG*IXmkLPk7zPCNLPC7zPFPzMCHWv8ZIXHgyPFvT&width=80&height=80&type=sns",
        "prize": "云柔巾108抽*6包"
    },
    {
        "name": "零星一念",
        "img": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=P0x4vFcWvH*eMCQuvFcuMWTT&width=80&height=80&type=sns",
        "prize": "云柔巾108抽*6包"
    }
]

interface LoopMsgData {
    img: string,
    name: string,
    prize: string
}

export class LoopMsg extends FYGE.Container {
    private item: LoopMsgItem
    constructor() {
        super();
        let count = 0;
        this.item = this.addChild(new LoopMsgItem(msgData[count++]));
        this.item.alpha = 0;
        //循环起来
        FYGE.Tween.get(this.item, { loop: true })
            .set({ alpha: 1, x: -370, y: 0 })
            .to({ x: -65 }, 700, FYGE.Ease.backOut)
            .wait(1000)
            .to({ alpha: 0, y: -100 }, 400)
            .wait(500)
            .call(() => {
                this.item.reset(msgData[count++] || msgData[count = 0])
            })
    }
    destroy() {
        FYGE.Tween.removeTweens(this.item);
        this.item = null;
        super.destroy()
    }

}


/**
 * 循环的中奖轮播
 */
class LoopMsgItem extends FYGE.Sprite {
    private img: FYGE.Sprite;
    private txt: FYGE.TextField;
    private limit = 12;
    constructor(data: LoopMsgData) {
        super(RES.getRes("loopMsgBg.png"))
        //头像
        var img = this.addChild(FYGE.Sprite.fromUrl(data.img));
        img.width = img.height = 66;
        img.position.set(75, (87 - 66) / 2);
        this.img = img;
        //圆形遮罩
        var mask = this.addChild(new FYGE.Shape());
        mask.beginFill(0x000000);
        mask.drawCircle(33, 33, 33)
        mask.endFill();
        mask.position.copy(img.position);
        img.mask = mask;

        var name = this.getRealLength(data.name) > this.limit ? this.cutString(data.name, this.limit) + "..." : data.name;
        var prize = this.getRealLength(data.prize) > this.limit ? this.cutString(data.prize, this.limit) + "..." : data.prize;
        //文字信息
        var txt = this.addChild(Tools.getText(
            `恭喜${name}\n抽中${prize}`,
            22,
            "#fefefe",
        ))
        txt.position.set(150, 16);
        txt.lineSpacing = 13;
        this.txt = txt;
    }
    private getRealLength(str: string) {
        var realLength = 0, len = str.length, charCode = -1;
        for (var i = 0; i < len; i++) {
            charCode = str.charCodeAt(i);
            if (charCode >= 0 && charCode <= 128) realLength += 1;
            else realLength += 2;
        }
        return realLength;
    }

    private cutString(str: string, realLength: number) {
        let length = 0;
        let out = "";
        for (let i of str) {
            let charCode = i.charCodeAt(0);
            if (charCode >= 0 && charCode <= 128) length += 1;
            else length += 2;

            if (length <= realLength)
                out = out.concat(i);
            if (length >= realLength)
                break;
        }
        return out;
    }

    reset(data: LoopMsgData) {
        this.img.texture = FYGE.Texture.fromUrl(data.img);
        var name = this.getRealLength(data.name) > this.limit ? this.cutString(data.name, this.limit) + "..." : data.name;
        var prize = this.getRealLength(data.prize) > this.limit ? this.cutString(data.prize, this.limit) + "..." : data.prize;
        this.txt.text = `恭喜${name}\n抽中${prize}`;
    }
}

// class A {
//     constructor() {
//         this.init()
//     }
//     init() {
//     }
// }
// class B extends A {
//     private a = 1;
//     init() {
//         this.a = 2
//     }
// }
// console.log(new B())