import { Scene } from "../../module/views/Scene";
import { Tools } from "../Tools";
import { ProgressBarS } from "../common/ProgressBarS";
import { RES } from "../../module/RES";
import { sendTbNet, TbNetName, getTbData } from "../TaoBaoNet";
import { changeScene } from "../../module/ctrls";
import { MapScene } from "./map/MapScene";
import { layers } from "../../module/views/layers";
import { GTool } from "../../module/tools/GTool";
import { Lottie } from "../Lottie";
import { loading_animal } from "../lotties/loading_animal";
import { LotteryScene } from "./LotteryScene";

export class LoadingScene extends Scene {
    get groupNames() {
        return ["loadingScene"]
    }

    progressBar: ProgressBarS;

    initUi() {
        //适配
        this.y = -layers.stageOffsetY
        //背景
        this.addChild(FYGE.Sprite.fromFrame("loadingBg.jpg"))

        //光
        var l1 = this.addChild(FYGE.Sprite.fromFrame("lighting_1.png"))
        l1.position.set(543, 765)
        var l2 = this.addChild(FYGE.Sprite.fromFrame("lighting_2.png"))
        l2.position.set(545, 765)
        l2.visible = false;
        FYGE.Tween.get(l1, {loop: true})
            .wait(500)
            .call(() => {
                l1.visible = !l1.visible
            })
        FYGE.Tween.get(l2, {loop: true})
            .wait(500)
            .call(() => {
                l2.visible = !l2.visible
            })
        // console.log(a.position,b.position)
        //摩天轮
        var wheel = this.addChild(FYGE.Sprite.fromFrame("wheel.png"))
            .addEventListener(FYGE.Event.ENTER_FRAME, () => {
                wheel.rotation += 0.3
            })
        wheel.anchorTexture.set(0.5, 0.5);
        wheel.position.set(50, 780)
        wheel.alpha = 0.3;
        //背景2
        this.addChild(FYGE.Sprite.fromFrame("loadingBg2.png"))
        //进度条底图
        this.addChild(FYGE.Sprite.fromFrame("proDown.png"))
            .position.set((750 - 577) / 2, 1288 - 24)
        //进度条帧动画
        var arr = [];
        for (var i = 0; i <= 11; i++) arr.push(RES.getRes("loadingPro" + i + ".png"))
        var pro = this.addChild(new FYGE.FrameAni(arr));
        pro.play(0)
        pro.position.set(375, 1288)//位置按正常满条的位置
        //@ts-ignore 进度条托管
        this.progressBar = new ProgressBarS(pro);
        //动画
        var l = this.addChild(new Lottie(loading_animal))
        l.play(0)
        //尾巴
        var foxTail = new FYGE.FrameAni((() => {
            var arrFox = [];
            var count = -1;
            while (++count <= 14) arrFox.push(RES.getRes("fox_tail" + count + ".png"))
            return arrFox
        })())
        foxTail.play(0);
        l.getChildByName("fox_body.png", true, true)
            .addChildAt(foxTail, 0)
            .position.set(250, 0)

        //标题
        this.addChild(new Title())
        //提示文案，随机文案待定
        this.addChild(Tools.getText(
            GTool.randomT([
                "提示：固定关卡可抽取通关奖励哟！",
                "开心趣消消，烦恼全抛掉！",
                "解锁120关最高可得TF彩妆礼盒"
            ]),
            28,
            "#ae3830",
            FYGE.TEXT_ALIGN.CENTER,
            500,
            (750 - 500) / 2,
            1288 - 24 + 18 + 48
        ))
    }

    async start() {
        super.start()

        // 访问页面埋点
        sendTbNet(TbNetName.reportAnalytics, {logkey: 'visit'});

        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2)

        //获取app数据
        const {data} = await sendTbNet(TbNetName.getAppData);
        Tools.globalData = data;
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3)
        //询问读取权限，不阻止进程
        // Tools.checkPermission();//这个需要吗？
        //获取首页数据
        var getIndexSuccesss = await Tools.getIndex()
        //失败不进入
        if (!getIndexSuccesss) return;
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);

        //赋值openId，取getIndex里的数据
        Tools.globalData.openId = getTbData(TbNetName.getIndex).data.openId;

        // 游戏基本信息
        const baseInfo = await sendTbNet(TbNetName.getActivityBaseInfoById);
        Tools.baseInfo = baseInfo.data;
        Tools.baseInfo.prizeLevels = [];
        for (let k in Tools.baseInfo.levelPrize) {
            Tools.baseInfo.prizeLevels.push(+k.split('_')[1]);
        }

        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);
        //首次进入，地图页面需要引导
        // if (Tools.gameData.isFristLogin) {

        // }
        //加载地图资源
        // await Promise.all([
        //     'map',
        //     'mapCrabEffect',
        //     'mapOwlEffect',
        //     'mapWhaleEffect',
        //     'mapCheckPrizeEffect'
        // ].map((e) => {
        //     return RES.loadGroup(e)
        // }))
        await RES.loadGroup("map")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
        await RES.loadGroup("mapCrabEffect")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
        await RES.loadGroup("mapOwlEffect")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
        await RES.loadGroup("mapWhaleEffect")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.9);
        await RES.loadGroup("mapCheckPrizeEffect")


        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
    }

    // private lastP=0
    progressEvent(e: FYGE.Event) {
        let pro = e.data;
        FYGE.Tween.get(this.progressBar, null, null, true)
            .to({value: pro}, 2000/**(p-this.lastP)*/)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(MapScene, {from: "loading"})
                    // changeScene(LotteryScene,{level:1});
                }
            })
        // this.lastP=p
    }

    destroy() {
        //动效要去掉
        // FYGE.Tween.removeTweens()
        super.destroy()
        //到时如果内存炸了，考虑销毁用过的贴图缓存，待测试，在RES里写个根据销毁组内贴图的方法
    }
}

const lingConfig = [
    {
        "name": "img_line1",
        "x": 0,
        "y": 70,
    },
    {
        "name": "img_line2",
        "x": 85,
        "y": 50,
    },
    {
        "name": "img_line3",
        "x": 195,
        "y": 0,
    },
    {
        "name": "img_line4",
        "x": 322,
        "y": 50,
    },
    {
        "name": "img_line5",
        "x": 402,
        "y": 70,
    }
]

class Title extends FYGE.Container {
    constructor() {
        super();
        //线
        var line = this.addChild(new FYGE.Container());
        for (var i = 0; i < lingConfig.length; i++) {
            var c = lingConfig[i]
            line.addChild(FYGE.Sprite.fromFrame(c.name + ".png"))
                .position.set(c.x, c.y);
        }
        line.anchor.set(433 / 2, 0);
        line.scaleY = 0.18
        //标题
        var title = line.addChild(FYGE.Sprite.fromFrame("loadingTitle.png"))
        title.position.set(-33, 313)
        title.anchor.set(494 / 2, 40);
        this.x = 160//待调整
        var targetY = -80
        this.y = -560;//待调整
        //新建就动画出现吧，
        FYGE.Tween.get(this)
            .to({y: targetY + 25}, 300)
            .to({y: targetY - 30}, 100)
            .to({y: targetY}, 100);
        [line, title].forEach((e) => {
            FYGE.Tween.get(e)
                .to({rotation: 1.5}, 300)
                .to({rotation: -0.5}, 100)
                .to({rotation: 0}, 100)
            if (e === line) {
                FYGE.Tween.get(e)
                    .to({scaleY: 1.05}, 300)
                    .to({scaleY: 0.96}, 100)
                    .to({scaleY: 1}, 100)
            }
        })

    }
}


