import { Panel } from "../../module/views/Panel";
import { PropType } from "../something/enum/PropType";
import { getTbData, TbNetName } from "../TaoBaoNet";
import { Tools } from "../Tools";
import { showWaiting, hideWaiting, getCurrentScene, showPanel, showToast } from "../../module/ctrls";
import { JoinPanel } from "./JoinPanel";
import { ExchangeSucPanel } from "./ExchangeSucPanel";

export class ToolsOutPanel extends Panel {
    get groupNames() {
        return ["ToolsOutPanel"]
    }

    get skinName() {
        return "ToolsOutPanel"
    }
    get closeBtns() {
        return [this.consideBtn, this.closeBtn]
    }

    consideBtn: FYGE.Button;
    sureBtn: FYGE.Button;
    closeBtn: FYGE.Button;
    msgTxt: FYGE.TextField;

    data: { type: PropType, showSucPanel: boolean }

    initUi() {
        // 文案居中
        Tools.changeTextAlign(this.msgTxt, FYGE.TEXT_ALIGN.CENTER, 500)
    }

    start(data) {
        super.start();

        //文案按接口返回的来
        this.msgTxt.text = "要消耗" +
            getTbData(TbNetName.getActivityBaseInfoById).data.buyCredits[data.type] +
            "积分兑换吗？"
    }

    initEvents() {
        super.initEvents();
        this.sureBtn.addEventListener(FYGE.MouseEvent.CLICK, async () => {
            //购买道具
            showWaiting();
            var res = await Tools.exchange(this.data.type);
            hideWaiting();
            //如果是链接，弹出加入会员弹框
            if (typeof res == "string") {
                showPanel(JoinPanel, { url: res })
            }
            //成功了，关闭弹框，修改道具信息
            else if (res) {
                // showToast("兑换成功")
                if (this.data.showSucPanel) showPanel(ExchangeSucPanel)
                this.hidePanel();
                getCurrentScene().updateScene()
            }

        }, this)
    }

    removeEvents() {
        super.removeEvents();
    }
}
