import { Panel } from "../../module/views/Panel";
import { layers } from "../../module/views/layers";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;
import { Tools } from "../Tools";
import { GDispatcher } from "../Main";
import { G_EVENT } from "../common/G_EVENT";
import { RES } from "../../module/RES";
import { showWaiting, hideWaiting, showToast, getCurrentScene } from "../../module/ctrls";
//任务类型(member/invites/browseGoods/follow)
export enum TaskType {
    member = "member",
    invites = "invites",
    browseGoods = "browseGoods",
    follow = "follow"
}

interface TaskData {
    /**
     * 任务类型
     */
    taskType: TaskType,
    /**
     * 加入会员的链接
     */
    value?: string,
    /**
     * 奖励的体力值
     */
    rewards: number
    /**
     * 当前完成次数
     */
    todayCompleteTimes: number
    /**
     * 需要完成次数	
     */
    times: number
    /**
     * 待领取体力值
     */
    waitReceive: number
}


export class TaskPanel extends Panel {
    get groupNames() {
        return ["TaskPanel"]
    }

    get skinName() {
        return "TaskPanel"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        let oriY = 1624 - this.height - layers.stageOffsetY - 580;
        this.y = layers.stageHeight + this.height;
        Tween.get(this)
            .to({ y: oriY }, 500, Ease.quartOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: Button;
    taskBtn1: Button;   // 浏览商品
    taskBtn2: Button;   // 邀请
    taskBtn3: Button;   // 关注
    taskBtn4: Button;   // 加入会员

    [TaskType.browseGoods]: CusButton;
    [TaskType.invites]: CusButton;
    [TaskType.follow]: CusButton;
    [TaskType.member]: CusButton;

    initUi() {
        //移除了吧，只需要位置
        this.removeChild(this.taskBtn1)
        this.removeChild(this.taskBtn2)
        this.removeChild(this.taskBtn3)
        this.removeChild(this.taskBtn4);
        //四个按钮，先默认状态，然后start里刷任务接口
        var ps = [this.taskBtn1, this.taskBtn2, this.taskBtn3, this.taskBtn4];
        [TaskType.browseGoods, TaskType.invites, TaskType.follow, TaskType.member].forEach((e, i) => {
            this[e] = this.addChild(new CusButton(e))
            this[e].position.copy(ps[i].position);
            this[e].visible = false;
        })
    }

    start(data) {
        super.start();
        this.updateTask();
    }

    public updateTask() {
        showWaiting();
        sendTbNet(TbNetName.getTaskList, null,
            (success, res) => {
                hideWaiting();
                if (!success) return;
                var data: TaskData[] = res.data;
                data.forEach((d) => {
                    this[d.taskType].visible = true;
                    //如果有入会链接
                    if (d.value) this[d.taskType].memberUrl = d.value;
                    //如果有待领取的
                    if (d.waitReceive) {
                        this[d.taskType].canGetStatus = true;
                        this[d.taskType].enabled = true;
                    }
                    //如果已全部完成
                    else if (d.todayCompleteTimes == d.times) {
                        this[d.taskType].canGetStatus = false;
                        this[d.taskType].enabled = false;
                    }
                    //去完成状态
                    else {
                        this[d.taskType].canGetStatus = false;
                        this[d.taskType].enabled = true;
                    }
                })
            }
        );
    }

    initEvents() {
        super.initEvents();
        GDispatcher.addEventListener(G_EVENT.UPDATE_TASK, this.updateTask, this);
    }

    removeEvents() {
        super.removeEvents();
        GDispatcher.removeEventListener(G_EVENT.UPDATE_TASK, this.updateTask, this);
    }
}



class CusButton extends Button {
    private type: TaskType
    private _canGetStatus: boolean;
    get canGetStatus() {
        return this._canGetStatus
    }
    set canGetStatus(value) {
        this._canGetStatus = value;
        var t: [FYGE.Texture, FYGE.Texture]
        if (value) {//能领取时换图
            t = [
                RES.getRes("待领取.png"),
                RES.getRes("待领取.png"),
            ]
        } else {
            t = [
                RES.getRes("去完成.png"),
                RES.getRes("去完成灰.png"),
            ]
        }
        this.changeTexture(t[0], t[0], t[1])
    }
    //外部自行赋值
    memberUrl: string
    constructor(type: TaskType) {
        var t = [
            RES.getRes("去完成.png"),
            RES.getRes("去完成灰.png"),
        ]
        super(t[0], t[0], t[1])
        this.type = type;
        //事件统一写吧
        this.addEventListener(MouseEvent.CLICK, this.onClick, this)
    }

    onClick() {
        if (this.canGetStatus) {//能领取，发接口
            showWaiting();
            sendTbNet(
                TbNetName.receiveTaskRewards,
                { taskType: this.type },
                (s, res) => {
                    hideWaiting();
                    if (s) {
                        //领取成功,TODO显示啥toast
                        showToast("领取成功");
                        //刷新任务列表
                        GDispatcher.dispatchEvent(G_EVENT.UPDATE_TASK);
                        //刷新体力
                        Tools.gameData.power = res.data.power;
                        getCurrentScene().updateScene()
                    }
                }
            )
        } else {//发对应任务方法
            //都弄个延时
            Tools.btnDelay(this)
            switch (this.type) {
                case TaskType.follow:
                    GDispatcher.removeAllEventListenerByType(TbNetName.favorShop);
                    sendTbNet(TbNetName.favorShop, {},
                        (success, res) => {
                            if (!success) return;
                            //关注成功了，发完成接口，注意小程序那边就不用发接口了
                            sendTbNet(
                                TbNetName.completeTask,
                                { taskType: TaskType.follow },
                                (success, res) => {
                                    if (!success) return;
                                    GDispatcher.dispatchEvent(G_EVENT.UPDATE_TASK);
                                }
                            );
                        }, true
                    );
                    break;
                case TaskType.browseGoods:
                    sendTbNet(
                        TbNetName.navigateTo,
                        { url: '/pages/browseProductList/browseProductList' },
                        () => { },
                        true
                    );
                    break;
                case TaskType.invites:
                    sendTbNet(
                        TbNetName.showSharePanel,
                        { openId: Tools.globalData.openId },//注意小程序那边处理参数
                        () => { },
                        true
                    );
                    break;
                case TaskType.member:
                    sendTbNet(
                        TbNetName.navigateToOutside,
                        { url: this.memberUrl },//下单页面路径待写
                        () => { },
                        true
                    );
                    break;
            }
            if (this.type == TaskType.browseGoods || this.type == TaskType.member) {
                //都需要添加事件，回来时，派发事件刷任务接口
                GDispatcher.once(G_EVENT.ON_SHOW, () => {
                    GDispatcher.dispatchEvent(G_EVENT.UPDATE_TASK)
                }, this)
            }
        }
    }



}