import { Panel } from "../../module/views/Panel";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Container = FYGE.Container;
import { Tools } from "../Tools";
import Sprite = FYGE.Sprite;
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import FrameAni = FYGE.FrameAni;
import Texture = FYGE.Texture;
import { RES } from "../../module/RES";
import MouseEvent = FYGE.MouseEvent;
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";

export class SuccessNoPrizePanel extends Panel {
    get groupNames() {
        return ['SuccessPanel', 'starLight']
    }

    get skinName() {
        return "SuccessNoPrizePanel"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    tipsTex: FYGE.TextField;
    checkTex: FYGE.TextField;
    againBtn: FYGE.Button;
    continueBtn: FYGE.Button;
    totalContinueBtn: FYGE.Button;
    light1: Sprite;
    light2: Sprite;

    private starGroup: SuccessStarGroup = null;

    initUi() {
        this.checkTex.text = `第\t${this.data.level}\t关`;
        this.checkTex.textWidth = 750;
        this.checkTex.x = 0;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;

        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;

        this.starGroup = this.addChild(new SuccessStarGroup());
        this.starGroup.position.set(373, 680);

        this.lightEffect();

        this.starGroup.play(this.data.stars);

        if (this.data.stars >= 3) { // 达到三星
            this.againBtn.visible = false;
            this.continueBtn.visible = false;
        } else {    // 未达到三星
            this.totalContinueBtn.visible = false;
        }

        // if(MapScene.checkArr && MapScene.checkArr[120] && MapScene.checkArr[120])

        if (Tools.gameData.currentLevel == 120
            && MapScene.checkArr && MapScene.checkArr[120]
            && MapScene.checkArr[120].checkData.isVisitSuccess) {
            this.tipsTex.text = '';
        } else if (MapScene.checkArr && MapScene.checkArr[this.data.level] && MapScene.checkArr[this.data.level].sendAwardType) {
            // 到过三星，领过奖
            const curLevel: number = Tools.gameData.currentLevel;
            let upLevel: number = 120;
            let dLevel: number = 120;
            Tools.baseInfo.prizeLevels.forEach((value, index) => {
                const d: number = value - curLevel;
                if (curLevel <= value && d >= 0 && d <= dLevel) {
                    upLevel = value;
                    if (curLevel == this.data.level) {
                        dLevel = d;
                    } else {
                        dLevel = d + 1;
                    }
                }
            });
            this.tipsTex.text = `\t\t\t太厉害了！\n再解锁${dLevel}关可以抽奖了`;
            this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
            this.tipsTex.textWidth = 750;
            this.tipsTex.x = 0;
        } else {
            // 没到三星，没领过奖
            if (this.data.isPrizeLevel) {
                this.tipsTex.text = '闯关成功！挑战满星通关\n获得抽大奖机会！';
            } else {
                this.tipsTex.text = '闯关成功！挑战满星通关\n有概率获得随机道具一个';
            }
        }

    }

    private lightEffect() {
        Tween.get(this.light1, {loop: true})
            .set({anchorX: 219.5, anchorY: 219.5})
            .to({rotation: 360}, 12000);

        Tween.get(this.light2, {loop: true})
            .set({anchorX: 219.5, anchorY: 219.5})
            .to({rotation: -360}, 12000);
    }

    start(data) {
        super.start();
    }

    initEvents() {
        super.initEvents();
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
    }

    /**
     * 挑战满星
     */
    private again() {
        changeScene(MapScene, {level: this.data.level});
        super.hidePanel();
    }

    /**
     * 继续闯关
     */
    private continue() {
        if (this.data.level == 120) {
            changeScene(MapScene);
        } else {
            changeScene(MapScene, {level: this.data.level + 1});
        }
        super.hidePanel();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    removeEvents() {
        super.removeEvents();
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
    }
}

export class SuccessStarGroup extends Container {

    private leftStarDis: Sprite = null;
    private midStarDis: Sprite = null;
    private rightStarDis: Sprite = null;

    private leftStarEn: Sprite = null;
    private midStarEn: Sprite = null;
    private rightStarEn: Sprite = null;

    private leftStarAni: FrameAni = null;
    private midStarAni: FrameAni = null;
    private rightStarAni: FrameAni = null;

    constructor() {
        super();

        this.leftStarDis = this.addChild(Tools.getSprite('star_dis.png'));
        this.midStarDis = this.addChild(Tools.getSprite('star_dis.png'));
        this.rightStarDis = this.addChild(Tools.getSprite('star_dis.png'));

        this.leftStarEn = this.addChild(Tools.getSprite('star_en.png'));
        this.midStarEn = this.addChild(Tools.getSprite('star_en.png'));
        this.rightStarEn = this.addChild(Tools.getSprite('star_en.png'));

        this.leftStarDis.anchorTexture.set(0.5, 0.5);
        this.midStarDis.anchorTexture.set(0.5, 0.5);
        this.rightStarDis.anchorTexture.set(0.5, 0.5);

        this.leftStarEn.anchorTexture.set(0.5, 0.5);
        this.midStarEn.anchorTexture.set(0.5, 0.5);
        this.rightStarEn.anchorTexture.set(0.5, 0.5);

        this.leftStarDis.position.set(-158, 36);
        this.leftStarDis.rotation = -25;
        this.leftStarDis.scale.set(0.81, 0.81);

        this.leftStarEn.position.set(-157, 41);
        this.leftStarEn.rotation = -25;
        this.leftStarEn.scale.set(0.81, 0.81);

        this.midStarEn.y = 5;

        this.rightStarDis.position.set(157, 37);
        this.rightStarDis.rotation = 25;
        this.rightStarDis.scale.set(0.81, 0.81);

        this.rightStarEn.position.set(156, 41);
        this.rightStarEn.rotation = 25;
        this.rightStarEn.scale.set(0.81, 0.81);

        this.leftStarEn.scale.set(0, 0);
        this.midStarEn.scale.set(0, 0);
        this.rightStarEn.scale.set(0, 0);

        const starAniFrame: Texture[] = new Array(16);
        for (let i = 0; i < 15; i++) {
            starAniFrame[i] = RES.getRes(`star_light_${i}.png`);
        }
        starAniFrame[15] = null;

        this.leftStarAni = this.addChild(new FrameAni(starAniFrame));
        this.leftStarAni.visible = false;
        this.leftStarAni.position.set(-158, 44);

        this.midStarAni = this.addChild(new FrameAni(starAniFrame));
        this.midStarAni.visible = false;
        this.midStarAni.y = 8;

        this.rightStarAni = this.addChild(new FrameAni(starAniFrame));
        this.rightStarAni.visible = false;
        this.rightStarAni.position.set(158, 42);
    }

    public play(count: number, wait: number = 600) {
        const time1 = 200;
        const time2 = 100;
        const max = 3;
        const interval = 100;

        if (count < 1) return;
        Tween.get(this.leftStarEn)
            .wait(wait)
            .set({scaleX: max, scaleY: max})
            .to({scaleX: 0.648, scaleY: 0.648}, time1, Ease.quadOut)
            .call(() => {
                this.leftStarAni.visible = true;
                this.leftStarAni.play(1);
            })
            .to({scaleX: 0.81, scaleY: 0.81}, time2, Ease.quadOut)
            .wait(interval)
            .call(() => {
                if (count <= 1) return;
                Tween.get(this.midStarEn)
                    .set({scaleX: max, scaleY: max})
                    .to({scaleX: 0.8, scaleY: 0.8}, time1, Ease.quadOut)
                    .call(() => {
                        this.midStarAni.visible = true;
                        this.midStarAni.play(1);
                    })
                    .to({scaleX: 1, scaleY: 1}, time2, Ease.quadOut)
                    .wait(interval)
                    .call(() => {
                        if (count <= 2) return;
                        Tween.get(this.rightStarEn)
                            .set({scaleX: max, scaleY: max})
                            .to({scaleX: 0.648, scaleY: 0.648}, time1, Ease.quadOut)
                            .call(() => {
                                this.rightStarAni.visible = true;
                                this.rightStarAni.play(1);
                            })
                            .to({scaleX: 0.81, scaleY: 0.81}, time2, Ease.quadOut)
                    });
            });
    }
}

// export class SuccessStar extends Container {
//     private starEn: Sprite = null;
//     private starDis: Sprite = null;
//
//     constructor() {
//         super();
//         this.starDis = this.addChild(Tools.getSprite('star_dis.png'));
//         this.starDis.anchorTexture.set(0.5, 0.5);
//         this.starEn = this.addChild(Tools.getSprite('star_en.png'));
//         this.starEn.anchorTexture.set(0.5, 0.5);
//         this.starEn.scale.set(0, 0);
//         this.starEn.y = 3;
//     }
//
//     public play(wait: number = 0, time: number = 400) {
//         Tween.get(this.starEn)
//             .wait(wait)
//             .set({scaleX: 3, scaleY: 3})
//             .to({scaleX: 1, scaleY: 1}, time, Ease.quadInOut);
//
//     }
//
// }
