import { Panel } from "../../module/views/Panel";
import TextField = FYGE.TextField;
import TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
import ScrollPage = FYGE.ScrollPage;
import { Tools } from "../Tools";

export class RulePanel extends Panel {
    get groupNames() {
        return ["RulePanel"]
    }

    get skinName() {
        return "RulePanel"
    }

    closeBtn: FYGE.Button;
    ruleTex: TextField;
    scroll: ScrollPage;

    initUi() {

    }

    start(data) {
        super.start();

        const rule = Tools.baseInfo.rule;
        this.ruleTex = this.addChild(Tools.getText(
            rule, 26, '#892a1a',
            FYGE.TEXT_ALIGN.LEFT, 570
        ));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;

        this.scroll = this.addChild(new ScrollPage(
            570, 600, this.ruleTex.textHeight + 30
        ));
        this.scroll.position.set(96, 549);
        this.scroll.view.addChild(this.ruleTex);

    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
