import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { getCurrentScene, showPanel } from "../../module/ctrls";
import { ToolsOutPanel } from "./ToolsOutPanel";
import { PropType } from "../something/enum/PropType";
export class NoStepPanel extends Panel {
	get groupNames() { return ["NoStepPanel"] }
	get skinName() { return "NoStepPanel" }
	overBtn: FYGE.Button;
	liveBtn: FYGE.Button;
	closeBtn: FYGE.Button;
	tipsTex: FYGE.TextField;

	data: {
		reviveFun: () => void
	}

	initUi() {
		// Tools.changeTextAlign(this.tipsTex, FYGE.TEXT_ALIGN.CENTER, 500)
		this.tipsTex.textAlign = FYGE.TEXT_ALIGN.CENTER;
		this.tipsTex.textWidth = 500;
		this.tipsTex.x = (750 - 500) / 2;
		this.tipsTex.text = "是否使用步数道具\n增加5次步数"
	}
	initEvents() {
		//结束
		[this.closeBtn, this.overBtn].forEach((e) => {
			e.addEventListener(FYGE.MouseEvent.CLICK, () => {
				getCurrentScene().submit(false);
				this.hidePanel();
			}, this)
		})
		//复活
		this.liveBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
			//无步数道具，弹出积分兑换
			if (!Tools.gameData.tools.STEPS) {
				showPanel(ToolsOutPanel, { type: PropType.STEPS, showSucPanel: false })
			} else {
				this.data.reviveFun();
				this.hidePanel();
			}
		}, this)
	}
	removeEvents() {

	}
}
